/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register.input;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.mobsp.plugin.form.scp.register.input.AbstractItemInput;
import kd.scm.mobsp.plugin.form.scp.register.input.BasicInfoItemInput;
import kd.scm.mobsp.plugin.form.scp.register.input.FinancialInfoItemInput;
import kd.scm.mobsp.plugin.form.scp.register.input.IntroductionItemInput;
import kd.scmc.msmob.common.utils.FormUtils;

public class SupplierRegisterInformationPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private static final String INPUT_ITEM_ENTRY = "entryentity";
    private static final String SUBMIT_PREVIEW = "submit_preview";
    private static final String HAS_ANY_INPUT_TEXT = "hasanyinput";
    private static final String HAS_ANY_INPUT = "has_any_input";
    private static final String FIELD_REQUIRED = "field_required";
    public static final String INPUT_INDEX = "inputIndex";
    public static final List<AbstractItemInput> ITEM_INPUTS = new ArrayList<AbstractItemInput>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addClickListener((AbstractFormPlugin)this, (String[])new String[]{SUBMIT_PREVIEW});
        EntryGrid entryGrid = (EntryGrid)this.getControl(INPUT_ITEM_ENTRY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "submit_preview": {
                this.submitPreview();
                break;
            }
        }
    }

    private void submitPreview() {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("mobsp_register_preview");
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCustomParam("number", this.getNumber());
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private Object getNumber() {
        return this.getModel().getValue("number");
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        this.goToInputPage(rowIndex);
    }

    private void goToInputPage(int inputIndex) {
        if (inputIndex != 0) {
            DynamicObjectCollection inputEntryList = this.getView().getModel().getEntryEntity(INPUT_ITEM_ENTRY);
            for (int i = 0; i < inputIndex; ++i) {
                DynamicObject dynamicObject = (DynamicObject)inputEntryList.get(i);
                boolean hasAnyInput = dynamicObject.getBoolean(HAS_ANY_INPUT);
                boolean fieldRequired = dynamicObject.getBoolean(FIELD_REQUIRED);
                if (!fieldRequired || hasAnyInput) continue;
                String errorMessage = ResManager.loadResFormat((String)"\u8bf7\u5148\u586b\u5199\u5c06\u201c%1\u201d\u4e2d\u7684\u4fe1\u606f\u586b\u5199\u5b8c\u6574\u3002", (String)"SupplierRegisterInformationPlugin_2", (String)"scm-mobsp-form", (Object[])new Object[]{dynamicObject.getString("textfield")});
                this.getView().showErrorNotification(errorMessage);
                return;
            }
        }
        AbstractItemInput inputEntry = ITEM_INPUTS.get(inputIndex);
        String targetPage = inputEntry.getTargetPage();
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId(targetPage);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCustomParam("number", this.getNumber());
        formShowParameter.setCustomParam(INPUT_INDEX, (Object)inputIndex);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, targetPage);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.setHasAnyInput();
    }

    private void setHasAnyInput() {
        int size = ITEM_INPUTS.size();
        DynamicObject supplier = this.getSupplier();
        for (int i = 0; i < size; ++i) {
            AbstractItemInput inputEntry = ITEM_INPUTS.get(i);
            IDataModel model = this.getModel();
            this.setHasAnyInput(supplier, model, i, inputEntry);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject supplier = this.getSupplier();
        IDataModel model = this.getModel();
        model.setValue("number", supplier.get("number"));
        int size = ITEM_INPUTS.size();
        model.deleteEntryData(INPUT_ITEM_ENTRY);
        model.batchCreateNewEntryRow(INPUT_ITEM_ENTRY, size);
        for (int i = 0; i < size; ++i) {
            AbstractItemInput inputEntry = ITEM_INPUTS.get(i);
            model.setValue("textfield", (Object)inputEntry.getItemTitle(), i);
            model.setValue(FIELD_REQUIRED, (Object)inputEntry.isFieldRequired(), i);
            this.setHasAnyInput(supplier, model, i, inputEntry);
        }
    }

    private void setHasAnyInput(DynamicObject supplier, IDataModel model, int i, AbstractItemInput inputEntry) {
        boolean hasAnyInput = inputEntry.hasAnyInput(supplier);
        String text = hasAnyInput ? ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"SupplierRegisterInformationPlugin_0", (String)"scm-mobsp-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u586b\u5199", (String)"SupplierRegisterInformationPlugin_1", (String)"scm-mobsp-form", (Object[])new Object[0]);
        model.setValue(HAS_ANY_INPUT_TEXT, (Object)text, i);
        model.setValue(HAS_ANY_INPUT, (Object)hasAnyInput, i);
    }

    private DynamicObject getSupplier() {
        Object number = this.getView().getFormShowParameter().getCustomParam("number");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"adm_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", number)});
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)"adm_supplier");
        return supplier;
    }

    static {
        ITEM_INPUTS.add(new BasicInfoItemInput());
        ITEM_INPUTS.add(new IntroductionItemInput());
        ITEM_INPUTS.add(new FinancialInfoItemInput());
    }
}

