/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register.input.anonymous;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.mobsp.plugin.form.scp.register.input.anonymous.AnonymousDeclare;
import kd.scm.mobsp.plugin.form.scp.register.input.anonymous.AnonymousPageHandler;

public class AnonymousParentPageInterceptor<P extends AbstractFormPlugin>
implements BeforeF7SelectListener {
    private final P plugin;
    private final AnonymousDeclare anonymousDeclare;

    public static <T extends AbstractFormPlugin> void registerF7Interceptor(T plugin, AnonymousDeclare anonymousDeclare) {
        Map<String, Class<? extends AnonymousPageHandler>> anonymousPageHandler = anonymousDeclare.getAnonymousPageHandlers();
        for (String f7Field : anonymousPageHandler.keySet()) {
            Control fieldEdit = plugin.getView().getControl(f7Field);
            BasedataEdit basedataEdit = (BasedataEdit)fieldEdit;
            basedataEdit.addBeforeF7SelectListener(new AnonymousParentPageInterceptor<T>(plugin, anonymousDeclare));
        }
    }

    public AnonymousParentPageInterceptor(P plugin, AnonymousDeclare anonymousDeclare) {
        this.plugin = plugin;
        this.anonymousDeclare = anonymousDeclare;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        Map<String, Class<? extends AnonymousPageHandler>> anonymousPageHandler = this.anonymousDeclare.getAnonymousPageHandlers();
        if (anonymousPageHandler.containsKey(key = beforeF7SelectEvent.getProperty().getName())) {
            beforeF7SelectEvent.setCancel(true);
            this.goToF7Page(key);
        }
    }

    protected void goToF7Page(String key) {
        Map<String, Class<? extends AnonymousPageHandler>> anonymousPageHandler = this.anonymousDeclare.getAnonymousPageHandlers();
        MobileFormShowParameter f7PageParameter = new MobileFormShowParameter();
        f7PageParameter.setFormId("mobsp_adm_f7");
        f7PageParameter.getOpenStyle().setShowType(ShowType.Floating);
        f7PageParameter.setCustomParam("ANONYMOUS_PAGE_HANDLER_CLASS", (Object)anonymousPageHandler.get(key).getName());
        f7PageParameter.setCustomParam("ANONYMOUS_FIELD_ID", (Object)key);
        DynamicObject selectedValue = (DynamicObject)this.plugin.getView().getModel().getValue(key);
        if (selectedValue != null) {
            f7PageParameter.setCustomParam("ANONYMOUS_PAGE_SELECTED_ID", (Object)Long.valueOf(selectedValue.getPkValue().toString()));
        }
        CloseCallBack closeCallBack = new CloseCallBack(this.plugin, "F7_CLOSED_EVENT");
        f7PageParameter.setCloseCallBack(closeCallBack);
        this.plugin.getView().showForm((FormShowParameter)f7PageParameter);
    }
}

