/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register.portal;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.permission.util.PhoneValidator;
import kd.scm.adm.common.utils.SrmSupplierRegisterInfo;
import kd.scm.adm.common.utils.SrmUser;
import kd.scm.adm.common.utils.SupplierRegisterUtils;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.mobsp.business.helper.RegisterHelper;
import kd.scm.mobsp.business.helper.RegisterValidateCodeResult;
import kd.scm.mobsp.plugin.form.scp.register.RegisterPlugin;
import kd.scm.mobsp.plugin.form.scp.register.RegisterPluginHelper;
import kd.scm.mobsp.plugin.form.scp.register.ValidateCodeSupportHelper;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.common.utils.PropertyValueUtils;

public class RegisterCheckLoginPagePlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    protected static final String REGISTER_BUTTON = "register_button";
    protected static final String SEARCH_BUTTON = "btn_submit";
    private static final String LOGIN_BUTTON = "login_btn";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addClickListener((AbstractFormPlugin)this, (String[])new String[]{REGISTER_BUTTON, SEARCH_BUTTON, LOGIN_BUTTON});
        ValidateCodeSupportHelper.registerCaptchaButtonListener((AbstractFormPlugin)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RegisterPluginHelper.setLogoImage((AbstractFormPlugin)this);
        ValidateCodeSupportHelper.setInvisibleOnPageInit((AbstractFormPlugin)this);
        this.setSubmitEnable();
        ValidateCodeSupportHelper.setGetMsgEnable((AbstractFormPlugin)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        block8: for (int i = 0; i < valueSet.length; ++i) {
            if (!PropertyValueUtils.isValueChanged((PropertyChangedArgs)e, (int)0)) continue;
            switch (propName) {
                case "number": {
                    this.setSubmitEnable();
                    ValidateCodeSupportHelper.setGetMsgEnable((AbstractFormPlugin)this);
                    continue block8;
                }
                case "validatecode": {
                    this.setSubmitEnable();
                    continue block8;
                }
            }
        }
    }

    private void setSubmitEnable() {
        Object code;
        IDataModel model = this.getModel();
        boolean isEnable = true;
        Object num = model.getValue("number");
        if (num == null || StringUtils.isEmpty((CharSequence)String.valueOf(num).trim())) {
            isEnable = false;
        }
        if ((code = model.getValue("validatecode")) == null || StringUtils.isEmpty((CharSequence)String.valueOf(code).trim())) {
            isEnable = false;
        }
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{SEARCH_BUTTON});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "getmsg": {
                this.getCode();
                break;
            }
            case "register_button": {
                this.getView().close();
                break;
            }
            case "btn_submit": {
                this.login();
                break;
            }
            case "login_btn": {
                RegisterPlugin.goToLoginPage(this);
                break;
            }
        }
    }

    private void getCode() {
        HashMap<String, String> param = this.assemblyParam();
        try {
            PhoneValidator phoneValidator = new PhoneValidator(param.get("number"), true);
            phoneValidator.check();
        }
        catch (KDBizException e) {
            MessageBoxOptions none = MessageBoxOptions.None;
            ConfirmTypes fail = ConfirmTypes.Fail;
            this.getView().showConfirm(this.getTipsTitle(), ResManager.loadKDString((String)"\u201c\u8d26\u53f7\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RegisterCheckLoginPagePlugin_6", (String)"scm-mobsp-form", (Object[])new Object[0]), none, fail, null);
            return;
        }
        RegisterValidateCodeResult result = RegisterHelper.getRegisterProgressCheckLoginCode(param);
        ValidateCodeSupportHelper.handleCaptchaCode(param.get("number"), (AbstractFormPlugin)this, result, ResManager.loadKDString((String)"\u4e1a\u52a1\u63d0\u793a", (String)"RegisterCheckLoginPagePlugin_5", (String)"scm-mobsp-form", (Object[])new Object[0]));
    }

    private HashMap<String, String> assemblyParam() {
        HashMap<String, String> param = new HashMap<String, String>(8);
        IDataModel model = this.getModel();
        Object num = model.getValue("number");
        param.put("number", String.valueOf(num));
        return param;
    }

    private void login() {
        if (!ValidateCodeSupportHelper.checkValidateCode((AbstractFormPlugin)this)) {
            return;
        }
        IFormView view = this.getView();
        String number = (String)this.getModel().getValue("number");
        Long formalUserId = SupplierRegisterUtils.getFormalUserId((String)number);
        MessageBoxOptions none = MessageBoxOptions.None;
        ConfirmTypes fail = ConfirmTypes.Fail;
        String tipsTitle = this.getTipsTitle();
        if (formalUserId != null) {
            view.showConfirm(tipsTitle, ResManager.loadKDString((String)"\u6b64\u8d26\u53f7\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u70b9\u51fb\u201c\u767b\u5f55\u201d\u6309\u94ae\u8fdb\u5165\u7cfb\u7edf\u3002", (String)"RegisterCheckLoginPagePlugin_0", (String)"scm-mobsp-form", (Object[])new Object[0]), none, fail, null);
            return;
        }
        SrmUser srmUser = SupplierRegisterUtils.getSrmUserByNumber((String)number);
        if (srmUser == null) {
            view.showConfirm(tipsTitle, ResManager.loadKDString((String)"\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"RegisterCheckLoginPagePlugin_1", (String)"scm-mobsp-form", (Object[])new Object[0]), none, fail, null);
            return;
        }
        if (!srmUser.isEnabled()) {
            view.showConfirm(tipsTitle, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u518d\u767b\u5f55\u3002", (String)"RegisterCheckLoginPagePlugin_2", (String)"scm-mobsp-form", (Object[])new Object[0]), none, fail, null);
            return;
        }
        if (BillStatusEnum.AUDIT != srmUser.getBillStatus()) {
            view.showConfirm(tipsTitle, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u8fd8\u672a\u7ecf\u8fc7\u91c7\u8d2d\u65b9\u5ba1\u6838\uff0c\u6682\u65f6\u4e0d\u80fd\u767b\u5f55\u3002", (String)"RegisterCheckLoginPagePlugin_3", (String)"scm-mobsp-form", (Object[])new Object[0]), none, fail, null);
            return;
        }
        SrmSupplierRegisterInfo registerInfo = SupplierRegisterUtils.getSupplierRegisterInfo((String)number);
        if (registerInfo == null) {
            view.showConfirm(tipsTitle, ResManager.loadResFormat((String)"\u6ca1\u6709\u627e\u5230\u624b\u673a\u53f7/\u90ae\u7bb1\u53f7\u4e3a\u201c%1\u201d\u4e14\u672a\u88ab\u7981\u7528\u7684\u4f01\u4e1a\u6ce8\u518c\u8d44\u6599\u3002", (String)"RegisterCheckLoginPagePlugin_4", (String)"scm-mobsp-form", (Object[])new Object[]{number}), none, fail, null);
            return;
        }
        RegisterPluginHelper.goToRegisterProgressPage(this, registerInfo.getNumber(), true);
    }

    private String getTipsTitle() {
        String tipsTitle = ResManager.loadKDString((String)"\u4e1a\u52a1\u63d0\u793a", (String)"RegisterCheckLoginPagePlugin_5", (String)"scm-mobsp-form", (Object[])new Object[0]);
        return tipsTitle;
    }
}

