/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.reject;

import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.msmob.business.helper.AttachmentHelper;

public class ConfirmRejectPlugin
extends AbstractMobBillPlugIn
implements UploadListener {
    private static final String BTN_REJECT = "buttonreject";
    private static final String PC_ENTITY = "pcentity";
    private static final String REASON = "reason";
    private static final String REASON_ATT = "reasonatt";
    private static final String REJECT_REASON_ATT = "rejectreasonatt";
    private static final String BASEDATA_ID = "fbasedataid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_REJECT});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        boolean isNotSave = AttachmentHelper.checkAttachmentSaveOrNot((IFormView)this.getView());
        if (isNotSave) {
            args.setCancel(true);
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        String operateKey = formOperate.getOperateKey();
        if ("rejectreason".equals(operateKey)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String id = (String)formShowParameter.getCustomParam("id");
            String pcEntity = (String)formShowParameter.getCustomParam(PC_ENTITY);
            String reason = this.getModel().getValue(REASON).toString();
            option.setVariableValue("id", id);
            option.setVariableValue(PC_ENTITY, pcEntity);
            option.setVariableValue(REASON, reason);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("rejectreason".equals(operateKey) && operationResult.isSuccess()) {
            this.saveAttacheFile();
            this.getView().returnDataToParent((Object)"reject");
            this.getView().close();
        }
    }

    private void saveAttacheFile() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pcId = (String)formShowParameter.getCustomParam("id");
        String pcEntityKey = (String)formShowParameter.getCustomParam(PC_ENTITY);
        DynamicObjectCollection reasonAtt = (DynamicObjectCollection)this.getModel().getValue(REASON_ATT);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)pcEntityKey, (String)REJECT_REASON_ATT, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(pcId))});
        DynamicObjectCollection rejectReasonAtt = bill.getDynamicObjectCollection(REJECT_REASON_ATT);
        rejectReasonAtt.clear();
        for (DynamicObject attData : reasonAtt) {
            DynamicObject addNew = rejectReasonAtt.addNew();
            addNew.set(BASEDATA_ID, (Object)attData.getDynamicObject(BASEDATA_ID));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
    }
}

