/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.sourcingproject.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.scm.mobsp.common.helper.PermissionHelper;
import kd.scm.mobsp.plugin.form.scp.invitation.enumration.ReplyStatusEnum;
import kd.scm.mobsp.plugin.form.scp.invitation.vo.InvitationDetailVo;
import kd.scm.mobsp.plugin.form.scp.notice.vo.NoticeDetailVo;
import kd.scm.mobsp.plugin.form.scp.quote.enumeration.BillStatusEnum;
import kd.scm.mobsp.plugin.form.scp.quote.vo.QuoteBillDetailVo;
import kd.scm.mobsp.plugin.form.scp.sourcingproject.vo.SourcingDetailVo;
import kd.scm.mobsp.plugin.form.scp.sourcingproject.vo.task.GetTaskQueryResult;
import kd.scm.mobsp.plugin.form.scp.tender.vo.TenderDetailVo;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import org.apache.commons.lang3.StringUtils;

public class SourcingDetailEntryClickListener
implements RowClickEventListener {
    private final AbstractMobBillPlugIn plugIn;
    private static final Map<String, String> targetPageMap = new HashMap<String, String>();
    private IFormView view;

    public SourcingDetailEntryClickListener(IFormView view, AbstractMobBillPlugIn plugIn) {
        this.view = view;
        this.plugIn = plugIn;
    }

    public void entryRowClick(RowClickEvent evt) {
        SourcingDetailVo cachedObject = (SourcingDetailVo)((Object)MobileApiRendererUtils.getCachedObject((IFormView)this.view));
        List<GetTaskQueryResult> taskList = cachedObject.getTaskList();
        GetTaskQueryResult task = taskList.get(evt.getRow());
        String entityName = task.getEntityName();
        String targetPageId = targetPageMap.get(entityName);
        if (StringUtils.isEmpty((CharSequence)targetPageId)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u6682\u672a\u652f\u6301\u201c%s\u201d\u529f\u80fd\uff0c\u5982\u9700\u67e5\u770b\u5355\u636e\u8be6\u60c5\uff0c\u8bf7\u524d\u5f80PC\u7aef\u5904\u7406\u3002", (String)"SourcingDetailEntryClickListener_0", (String)"scm-mobsp-form", (Object[])new Object[0]), task.getNodeName());
            this.view.showErrorNotification(errMsg);
            return;
        }
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        long billId = task.getBillId();
        boolean check = this.checkModifyAndMutex(billId, entityName);
        if (!check) {
            this.view.getPageCache().put("cached_bill_id", String.valueOf(billId));
            this.view.getPageCache().put("page_identifier", targetPageId);
            return;
        }
        mobileFormShowParameter.setCustomParam("id", (Object)billId);
        mobileFormShowParameter.setFormId(targetPageId);
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.view.showForm((FormShowParameter)mobileFormShowParameter);
    }

    private boolean checkModifyAndMutex(long billId, String pcEntity) {
        switch (pcEntity) {
            case "tnd_quotebill": {
                return PermissionHelper.checkModifyAndMutex(this.plugIn, billId, new QuoteBillDetailVo(), BillStatusEnum.SAVE, "/v2/tnd/tnd_quotebill/getDetail", "billstatus", "org_id", pcEntity);
            }
            case "tnd_inviteletter": {
                return PermissionHelper.checkModifyAndMutex(this.plugIn, billId, new InvitationDetailVo(), ReplyStatusEnum.A, "/v2/tnd/tnd_inviteletter/getDetail", "replyStatus", "purOrg", pcEntity);
            }
            case "tnd_winnotice": {
                return PermissionHelper.checkModifyAndMutex(this.plugIn, billId, new NoticeDetailVo(), ReplyStatusEnum.A, "/v2/tnd/tnd_winnotice/getDetail", "replyStatus", "purOrg", pcEntity);
            }
            case "tnd_tenderbill": {
                return PermissionHelper.checkModifyAndMutex(this.plugIn, billId, new TenderDetailVo(), BillStatusEnum.SAVE, "/v2/tnd/tnd_tenderbill/getDetail", "billStatus", "purOrgId", pcEntity);
            }
        }
        return true;
    }

    static {
        targetPageMap.put("tnd_apply", "mobsp_sourcing_enrollbill");
        targetPageMap.put("tnd_quotebill", "mobsp_sourcing_quotebill");
        targetPageMap.put("tnd_inviteletter", "mobsp_sourcing_invi_bill");
        targetPageMap.put("tnd_winnotice", "mobsp_sourcing_noticebill");
        targetPageMap.put("tnd_tenderbill", "mobsp_sourcing_tenderbill");
    }
}

