/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.tender;

import java.util.EventObject;
import java.util.function.Consumer;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.mobsp.common.entity.componentvo.SrcPurListStandEntryResult;
import kd.scm.mobsp.common.handler.PreviousAndNextClickHandler;
import kd.scm.mobsp.common.helper.ConfigHelper;
import kd.scm.mobsp.common.helper.SourcingFileHelper;
import kd.scm.mobsp.plugin.form.scp.tender.enumeration.BidStatusEnum;
import kd.scm.mobsp.plugin.form.scp.tender.enumeration.BillStatusEnum;
import kd.scm.mobsp.plugin.form.scp.tender.handler.QuoteEntryPropertyChangedHandler;
import kd.scm.mobsp.plugin.form.scp.tender.vo.TenderDetailVo;
import kd.scmc.msmob.business.helper.AttachmentHelper;
import kd.scmc.msmob.mvccore.IMobileApiEntryPage;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import kd.scmc.msmob.mvccore.MobileViewModelUtils;

public class QuoteEntryPlugin
extends AbstractMobBillPlugIn
implements IMobileApiEntryPage<TenderDetailVo, SrcPurListStandEntryResult, SrcPurListStandEntryResult> {
    private static final String PREVIOUS_BTN = "previous";
    private static final String NEXT_BTN = "next";
    private static final String[] DISABLED_FIELDS = new String[]{"amount", "locamount", "taxamount"};
    private static final String[] ENTRY_FIELDS = new String[]{"turns", "qty", "unit_id", "price", "taxitem_id", "currency_id", "taxprice", "amount", "taxamount", "sup_attach", "brand"};
    private static final String CLOSE_BTN = "close";
    private static final String RETURN_BTN = "retun_btn";
    private static final String CURRENCY_FIELD = "currency_id";

    public void initialize() {
        super.initialize();
        MobileApiRendererUtils.addDataModelChangeListener((AbstractFormPlugin)this);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        model.addDataModelChangeListener((IDataModelChangeListener)new QuoteEntryPropertyChangedHandler(view, this.getCachedObjectStorageView()));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PREVIOUS_BTN, NEXT_BTN, CLOSE_BTN});
        MobileViewModelUtils.addPreviousAndNextListener((AbstractFormPlugin)this, (String)PREVIOUS_BTN, (String)NEXT_BTN);
        Button previousBtn = (Button)this.getControl(PREVIOUS_BTN);
        Button nextBtn = (Button)this.getControl(NEXT_BTN);
        QuoteEntryPlugin plugin = this;
        Consumer<Object> operation = detailVo -> {
            if (!(detailVo instanceof TenderDetailVo)) {
                return;
            }
            plugin.setEditable((TenderDetailVo)((Object)((Object)detailVo)));
            plugin.setButtonVisible((TenderDetailVo)((Object)((Object)detailVo)));
            plugin.setNewTargetLabelVisible((TenderDetailVo)((Object)((Object)detailVo)));
        };
        previousBtn.addClickListener((ClickListener)new PreviousAndNextClickHandler(this.getView(), operation));
        nextBtn.addClickListener((ClickListener)new PreviousAndNextClickHandler(this.getView(), operation));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TenderDetailVo detailVo = (TenderDetailVo)((Object)MobileApiRendererUtils.renderEntryPage((AbstractFormPlugin)this));
        this.setEditable(detailVo);
        this.setButtonVisible(detailVo);
        this.setNewTargetLabelVisible(detailVo);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (SourcingFileHelper.checkFileExpire(this.getView(), "sup_attach", "tnd_tenderbill")) {
            return;
        }
        e.setCancel(true);
        this.getView().updateView();
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (AttachmentHelper.checkAttachmentSaveOrNot((IFormView)this.getView())) {
            evt.setCancel(true);
        }
    }

    private void setEditable(TenderDetailVo detailVo) {
        String entryDisplayMode;
        IFormView view = this.getView();
        ConfigHelper.beginSetByConfig(view).setMulti(detailVo.getQuoteComponentEntries(), detailVo.getId(), "tnd_tenderbill").setPrice(detailVo.getTaxType(), detailVo.getDecisionType()).setDiscard(detailVo.getQuoteComponentEntries(), this.getCurrentEntryIndex()).finishSet();
        String bidStatus = detailVo.getBidStatus();
        if (BidStatusEnum.STATUS5.getFieldValue().equals(bidStatus)) {
            view.setEnable(Boolean.valueOf(false), new String[]{CURRENCY_FIELD});
        }
        if ((entryDisplayMode = (String)view.getFormShowParameter().getCustomParam("entry_display_mode")).equals("view")) {
            view.setEnable(Boolean.valueOf(false), ENTRY_FIELDS);
            view.setEnable(Boolean.valueOf(false), new String[]{"materialnane", "materialmodel", "brand", "sup_attachment"});
        } else {
            SrcPurListStandEntryResult entryData = this.getCurrentEntryData(detailVo);
            if (entryData.getIsnew().booleanValue()) {
                view.setEnable(Boolean.valueOf(true), new String[]{"materialnane", "materialmodel", "brand", "sup_attachment"});
            } else {
                view.setEnable(Boolean.valueOf(false), new String[]{"brand"});
            }
        }
    }

    private void setButtonVisible(TenderDetailVo detailVo) {
        String billStatus = detailVo.getBillStatus();
        if (BillStatusEnum.AUDIT.getFieldValue().equals(billStatus) || BillStatusEnum.SUBMIT.getFieldValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CLOSE_BTN});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{RETURN_BTN});
        }
    }

    private void setNewTargetLabelVisible(TenderDetailVo tenderDetailVo) {
        SrcPurListStandEntryResult entryData = this.getCurrentEntryData(tenderDetailVo);
        this.getView().setVisible(entryData.getIsnew(), new String[]{"new_target_label"});
    }

    private SrcPurListStandEntryResult getCurrentEntryData(TenderDetailVo quoteBillDetailVo) {
        int currentRowIndex = this.getCurrentEntryIndex();
        return quoteBillDetailVo.getQuoteComponentEntries().get(currentRowIndex);
    }
}

