/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.tender;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.mobsp.common.helper.PermissionHelper;
import kd.scm.mobsp.common.helper.SourcingAPIQueryParamHelper;
import kd.scm.mobsp.common.helper.StatusConsistencyHelper;
import kd.scm.mobsp.plugin.form.scp.tender.enumeration.BillStatusEnum;
import kd.scm.mobsp.plugin.form.scp.tender.vo.TenderDetailVo;
import kd.scm.mobsp.plugin.form.scp.tender.vo.TenderListVo;
import kd.scmc.msmob.mvccore.IMobileApiPage;
import kd.scmc.msmob.mvccore.IMobileApiSearch;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import kd.scmc.msmob.mvccore.MobileOpenApiPluginHelper;
import kd.scmc.msmob.mvccore.MobileSearchParameter;
import kd.scmc.msmob.mvccore.MobileViewModelUtils;
import kd.scmc.msmob.mvccore.OpenApiDataSource;

public class TenderListPlugin
extends AbstractMobBillPlugIn
implements IMobileApiSearch<TenderListVo>,
IMobileApiPage {
    private static final String BILL_STATUS_FILTER = "statusfilter";
    private static final String BID_STATUS_FILTER = "bidstatusfilter";
    private static final String TIME_FILTER_START_TIME = "daterange_start";
    private static final String TIME_FILTER_END_TIME = "daterange_end";
    private static final String MODIFY = "modify";

    public OpenApiDataSource<TenderListVo> getDatasourceConfig() {
        return new OpenApiDataSource("/v2/tnd/tnd_query/getList", TenderListVo.class, false);
    }

    public MobileSearchParameter getApiSearchParameters(MobileSearchParameter parameter) {
        String selectedBillStatus = (String)this.getModel().getValue(BILL_STATUS_FILTER);
        String selectedBidStatus = (String)this.getModel().getValue(BID_STATUS_FILTER);
        Date dateRangeStart = (Date)this.getModel().getValue(TIME_FILTER_START_TIME);
        Date dateRangeEnd = (Date)this.getModel().getValue(TIME_FILTER_END_TIME);
        return new SourcingAPIQueryParamHelper((AbstractFormPlugin)this).setSearchParameter().setBillStatus(selectedBillStatus).setOpenStatus(selectedBidStatus).setTenderEndDateRange(dateRangeStart, dateRangeEnd).setFormId(this.getPcEntity()).buildWrap();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IFormView view = this.getView();
        MobileOpenApiPluginHelper.addEntryPageListener((AbstractFormPlugin)this);
        MobileOpenApiPluginHelper.addMobileSearchTextListener((AbstractFormPlugin)this);
        MobileOpenApiPluginHelper.addRowClickListener((AbstractFormPlugin)this, (value, mobileFormShowParameter) -> {
            boolean checkMutex;
            boolean consistency = StatusConsistencyHelper.checkConsistency(this, view, value, new TenderDetailVo(), "/v2/tnd/tnd_tenderbill/getDetail", "billStatus");
            if (!consistency) {
                return null;
            }
            String billStatus = value.getBillStatus();
            if (BillStatusEnum.SAVE.getFieldValue().equals(billStatus) && !(checkMutex = PermissionHelper.checkMutex(this, this.getPcEntity(), billStatus, BillStatusEnum.SAVE, value.getId(), value.getPurOrg()))) {
                this.getView().getPageCache().put("cachedId", String.valueOf(value.getId()));
                return null;
            }
            mobileFormShowParameter.setFormId("mobsp_sourcing_tenderbill");
            mobileFormShowParameter.setCustomParam("id", (Object)value.getId());
            return mobileFormShowParameter;
        });
        this.addPullRefreshListener();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        MobileApiRendererUtils.renderListPage((AbstractFormPlugin)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (TIME_FILTER_START_TIME.equals(propName) || TIME_FILTER_END_TIME.equals(propName) || BILL_STATUS_FILTER.equals(propName) || BID_STATUS_FILTER.equals(propName)) {
            MobileApiRendererUtils.renderListPage((AbstractFormPlugin)this);
        }
    }

    public String getPcEntity() {
        return "tnd_tenderbill";
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        PermissionHelper.mutexConfirmCallBack(this.getView(), messageBoxClosedEvent, () -> {
            String id = this.getView().getPageCache().get("cachedId");
            MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
            mobileFormShowParameter.setFormId("mobsp_sourcing_tenderbill");
            mobileFormShowParameter.setCustomParam("id", (Object)Long.valueOf(id));
            mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
        });
    }

    private void addPullRefreshListener() {
        CardEntry card = (CardEntry)this.getView().getControl(MobileViewModelUtils.getFirstEntryName((AbstractFormPlugin)this));
        TenderListPlugin plugin = this;
        card.addPullRefreshlisteners(evt -> MobileApiRendererUtils.renderListPage((AbstractFormPlugin)plugin));
    }
}

