/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.tender.vo;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.mobsp.common.entity.componentvo.SrcPurListStandEntryResult;
import kd.scm.mobsp.common.entity.componentvo.SupFileEntryResult;
import kd.scm.mobsp.plugin.form.scp.tender.vo.QuoteSaveEntry;
import kd.scm.mobsp.plugin.form.scp.tender.vo.SupFileSaveEntry;
import kd.scm.mobsp.plugin.form.scp.tender.vo.TenderDetailVo;
import kd.scm.mobsp.plugin.form.scp.tender.vo.TndTenderModel;
import kd.scmc.msmob.mvccore.ReservedFieldVo;

public class TenderSaveVo {
    private TndTenderModel tenderModel = new TndTenderModel();

    public TndTenderModel getTenderModel() {
        return this.tenderModel;
    }

    public void setTenderModel(TndTenderModel tndTenderModel) {
        this.tenderModel = tndTenderModel;
    }

    public TenderSaveVo(TenderDetailVo detailVo) {
        List<SrcPurListStandEntryResult> quoteEntries = detailVo.getQuoteComponentEntries();
        List<SupFileEntryResult> supFileEntries = detailVo.getSupFileComponentEntries();
        if (quoteEntries != null) {
            List<QuoteSaveEntry> quoteSaveEntries = quoteEntries.stream().map(entry -> {
                QuoteSaveEntry quoteSaveEntry = new QuoteSaveEntry();
                quoteSaveEntry.setId(entry.getId());
                quoteSaveEntry.setPrice(entry.getPrice());
                quoteSaveEntry.setTaxprice(entry.getTaxprice());
                quoteSaveEntry.setAmount(entry.getAmount());
                quoteSaveEntry.setCurrencyId(entry.getCurrency_id());
                quoteSaveEntry.setTaxItemId(entry.getTaxitem_id());
                quoteSaveEntry.setNote(entry.getNote());
                quoteSaveEntry.setQty(entry.getQty());
                if (entry.getTaxitem_id() != null && entry.getTaxitem_id() > 0L) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)entry.getTaxitem_id(), (String)"bd_taxrate");
                    quoteSaveEntry.setTaxRate(dynamicObject.getBigDecimal("taxrate"));
                } else {
                    quoteSaveEntry.setTaxRate(BigDecimal.ZERO);
                    quoteSaveEntry.setTaxItemId(null);
                }
                quoteSaveEntry.setReservedFieldsFromAnother((ReservedFieldVo)entry);
                quoteSaveEntry.setIsnew(entry.getIsnew());
                quoteSaveEntry.setMaterialname(entry.getMaterialnane());
                quoteSaveEntry.setDescription(entry.getDescription());
                quoteSaveEntry.setModel(entry.getMaterialmodel());
                quoteSaveEntry.setBrand(entry.getBrand());
                quoteSaveEntry.setSupAttchId(entry.getPurlistentry_supfj_ids());
                if (entry.getIsnew().booleanValue()) {
                    quoteSaveEntry.setPurlistid(entry.getPurlist_id());
                    HashMap<String, String> fieldMap = new HashMap<String, String>();
                    fieldMap.put("srcentryid", String.valueOf(entry.getCopy_id()));
                    quoteSaveEntry.setCustomPro(JSON.toJSONString(fieldMap));
                }
                return quoteSaveEntry;
            }).collect(Collectors.toList());
            this.tenderModel.setPurListEntry(quoteSaveEntries);
        }
        if (supFileEntries != null) {
            List<SupFileSaveEntry> supFileSaveEntries = supFileEntries.stream().map(entry -> {
                SupFileSaveEntry supFileSaveEntry = new SupFileSaveEntry();
                supFileSaveEntry.setId(entry.getId());
                supFileSaveEntry.setFiletype(entry.getFileType());
                supFileSaveEntry.setFilename(entry.getFileName());
                supFileSaveEntry.setIsSupMustUpload(entry.getIsSupMustUpload());
                supFileSaveEntry.setNote(entry.getNote());
                ArrayList<Long> attachIdList = new ArrayList<Long>(5);
                for (Map map : entry.getAttachment()) {
                    Long attachId = (Long)map.get("id");
                    attachIdList.add(attachId);
                }
                supFileSaveEntry.setBidDocAttchId(attachIdList);
                supFileSaveEntry.setReservedFieldsFromAnother((ReservedFieldVo)entry);
                return supFileSaveEntry;
            }).collect(Collectors.toList());
            this.tenderModel.setBidDocAttEntry(supFileSaveEntries);
        }
        this.tenderModel.setId(detailVo.getId());
    }
}

