/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.tpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.mobsp.common.utils.ThreeMonthsDateUtils;
import kd.scmc.msmob.common.consts.DateRange;
import kd.scmc.msmob.common.consts.FilterConstructor;
import kd.scmc.msmob.common.enums.BillSortType;
import kd.scmc.msmob.common.utils.ConverterUtils;
import kd.scmc.msmob.common.utils.DateUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillListTplPlugin;
import kd.scmc.msmob.pojo.FilterCondition;

public class MobScpQuoNoticeListTplPlugin
extends MobBillListTplPlugin {
    private static Log LOG = LogFactory.getLog(MobScpQuoNoticeListTplPlugin.class);
    private static final String START_DATE = "daterangefield_startdate";
    private static final String END_DATE = "daterangefield_enddate";
    private static final String BILL_DATE = "billdate";
    private static final String BIZ_TYPE = "biztype";
    private static final String IS_TOP = "istop";
    public static final String IS_FROM_SUPPLIER_PORTAL = "isFromSupplierPortal";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultDate();
        this.setModelValue();
    }

    public void setDefaultDate() {
        this.getModel().setValue(START_DATE, (Object)ThreeMonthsDateUtils.getStartDate());
        this.getModel().setValue(END_DATE, (Object)ThreeMonthsDateUtils.getEndDate());
    }

    public void afterBindData(EventObject e) {
        this.setFilterKeyPrompt(BIZ_TYPE, ResManager.loadKDString((String)"\u516c\u544a\u7c7b\u578b", (String)"MobScpQuoNoticeListTplPlugin_0", (String)"scm-mobsp-form", (Object[])new Object[0]));
        this.setFilterKeyPrompt(BILL_DATE, ResManager.loadKDString((String)"\u53d1\u5e03\u65e5\u671f", (String)"MobScpQuoNoticeListTplPlugin_1", (String)"scm-mobsp-form", (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "biztype": 
            case "billdate": {
                this.getModel().beginInit();
                this.updateData();
                this.getModel().endInit();
                break;
            }
        }
    }

    public FilterConstructor getFilterConstructor(FilterConstructor evt) {
        FilterConstructor filterConstructor = super.getFilterConstructor(evt);
        filterConstructor.setLoadWithPermission(false);
        return filterConstructor;
    }

    public List<FilterCondition> getFilters() {
        String logStatus;
        String logStatusValue;
        ArrayList<FilterCondition> filters = new ArrayList<FilterCondition>(10);
        Date bizBeginTimeValue = (Date)this.getModel().getValue(START_DATE);
        Date bizEndTimeValue = (Date)this.getModel().getValue(END_DATE);
        Date date = bizEndTimeValue = bizEndTimeValue == null ? null : DateUtils.getDayEndTime((Date)bizEndTimeValue);
        if (bizBeginTimeValue != null && bizEndTimeValue != null) {
            DateRange dateRange = new DateRange();
            dateRange.setStartDate(bizBeginTimeValue);
            dateRange.setEndDate(bizEndTimeValue);
            FilterCondition condition = new FilterCondition("biztime", (Object)dateRange);
            filters.add(condition);
        }
        if (StringUtils.isNotEmpty((CharSequence)(logStatusValue = (String)this.getModel().getValue(BIZ_TYPE))) && StringUtils.isNotEmpty((CharSequence)(logStatus = logStatusValue.replace(",", "").replace(" ", "")))) {
            String[] split = logStatusValue.split(",");
            FilterCondition condition = new FilterCondition("quobiztype", (Object)split);
            filters.add(condition);
        }
        this.addScpCoreFilters(filters);
        return filters;
    }

    public void addScpCoreFilters(List<FilterCondition> superFilters) {
        if (superFilters == null) {
            return;
        }
        List quoFilter = (List)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoFilterService", (String)"getNoticeListFilter", (Object[])new Object[0]);
        LOG.info(ResManager.loadKDString((String)"\u8c03\u7528\u670d\u52a1\u534f\u540c\u516c\u544a\u670d\u52a1\uff1a\u3010{}\u3011", (String)"MobScpQuoNoticeListTplPlugin_2", (String)"scm-mobsp-form", (Object[])new Object[0]), (Object)quoFilter);
        List filterConditionList = ConverterUtils.getFilterConditionList((List)quoFilter);
        superFilters.addAll(filterConditionList);
        boolean isFromSupplierPortal = this.isFromSupplierPortal();
        if (isFromSupplierPortal) {
            FilterCondition mainOrgFilter = new FilterCondition("supscope", "=", (Object)"1");
            superFilters.add(mainOrgFilter);
        }
    }

    private boolean isFromSupplierPortal() {
        Object customParam;
        boolean isFromSupplierPortal = false;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null && (customParam = formShowParameter.getCustomParam(IS_FROM_SUPPLIER_PORTAL)) != null) {
            isFromSupplierPortal = (Boolean)customParam;
        }
        return isFromSupplierPortal;
    }

    protected Map<String, BillSortType> getSortMap() {
        Map sortMap = super.getSortMap();
        sortMap.put(IS_TOP, BillSortType.DESC);
        sortMap.put(BILL_DATE, BillSortType.DESC);
        return sortMap;
    }
}

