/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.business;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pbd.common.entity.AddressTreeNode;
import kd.scm.pbd.service.address.AddressMatchFactory;
import kd.scm.pbd.service.address.AddressRelationUpdater;
import kd.scm.pbd.service.address.IAddressMatcher;

public class AddressServiceHelper {
    public Map<String, Integer> matchAddressByEcType(String currentNodeId, String ecType) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(8);
        if (StringUtils.isEmpty((CharSequence)currentNodeId) || StringUtils.isEmpty((CharSequence)ecType)) {
            return result;
        }
        IAddressMatcher matcher = AddressMatchFactory.getFactory(ecType);
        DynamicObjectCollection admindivisionObjList = matcher.getBdAdmindivisionCol(currentNodeId);
        DynamicObjectCollection emalAddressObjList = matcher.getEcAddressDyoCol(currentNodeId, ecType);
        List<AddressTreeNode> bdAddressTreeNodeList = matcher.parseAddressTreeNodeList(admindivisionObjList, true);
        List<AddressTreeNode> ecAddressTreeNodeList = matcher.parseAddressTreeNodeList(emalAddressObjList, false);
        int successNum = matcher.matchBdAddressWithEcAddress(bdAddressTreeNodeList, ecAddressTreeNodeList);
        AddressRelationUpdater.updateAddressRelation(bdAddressTreeNodeList, ecType);
        result.put("successCnt", successNum);
        result.put("failCnt", admindivisionObjList.size() - successNum < 0 ? 0 : admindivisionObjList.size() - successNum);
        result.put("sumCnt", admindivisionObjList.size());
        return result;
    }
}

