/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.business;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.businesstracking.SRMLinkBillNodeHelper;
import kd.scm.common.helper.businesstracking.domain.BillBotpRelationParam;
import kd.scm.common.helper.businesstracking.domain.BillLinkRelationParam;
import kd.scm.common.helper.businesstracking.domain.BillRelationParam;

public final class PbdBusinessTrackingDataHelper {
    public static Map<String, String> parseLinkBillConfigMap(String linkConfigId) {
        HashMap<String, String> linkBillNodeConfigMap = new HashMap<String, String>(64);
        DynamicObject linkBillNodeCache = PbdBusinessTrackingDataHelper.loadLinkBillConfigCache(linkConfigId);
        if (linkBillNodeCache != null) {
            linkBillNodeConfigMap.putAll(PbdBusinessTrackingDataHelper.parseLinkBillConfigMap(linkBillNodeCache));
        }
        return linkBillNodeConfigMap;
    }

    public static Map<String, String> parseLinkBillConfigMap(DynamicObject linkBillConfigCache) {
        HashMap<String, String> linkBillNodeConfigMap = new HashMap<String, String>(64);
        linkBillNodeConfigMap.put("id", linkBillConfigCache.getString("id"));
        linkBillNodeConfigMap.put("number", linkBillConfigCache.getString("id"));
        String sourceEntityNumber = linkBillConfigCache.getString("sourceentity.id");
        MainEntityType sourceEntityType = EntityMetadataCache.getDataEntityType((String)sourceEntityNumber);
        linkBillNodeConfigMap.put("sourceentity", sourceEntityNumber);
        String targetEntityNumber = linkBillConfigCache.getString("targetentity.id");
        MainEntityType targetEntityType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
        linkBillNodeConfigMap.put("targetentity", targetEntityNumber);
        linkBillNodeConfigMap.put("definelink", linkBillConfigCache.getString("definelink.id"));
        DynamicObject definelink = linkBillConfigCache.getDynamicObject("definelink");
        String executelinkconfig = linkBillConfigCache.getString("name");
        String paramTypeClass = definelink.getString("paramtypeclass");
        Class billRelationParamClass = TypesContainer.getOrRegister((String)paramTypeClass);
        BillRelationParam billRelationParam = (BillRelationParam)SerializationUtils.fromJsonString((String)executelinkconfig, (Class)billRelationParamClass);
        if (billRelationParam instanceof BillLinkRelationParam) {
            String originLinkFiledKey = ((BillLinkRelationParam)billRelationParam).getOriginLinkFiledKey();
            linkBillNodeConfigMap.put("sourceFiledKey", originLinkFiledKey);
            String targetLinkFiledKey = ((BillLinkRelationParam)billRelationParam).getTargetLinkFiledKey();
            linkBillNodeConfigMap.put("targetLinkFiledKey", targetLinkFiledKey);
            String fullOriginFiledKey = SRMLinkBillNodeHelper.getFullFiledKey((MainEntityType)sourceEntityType, (String)originLinkFiledKey);
            String fullTargetFiledKey = SRMLinkBillNodeHelper.getFullFiledKey((MainEntityType)targetEntityType, (String)targetLinkFiledKey);
            linkBillNodeConfigMap.put("fullSourceKey", fullOriginFiledKey);
            linkBillNodeConfigMap.put("fullTargetKey", fullTargetFiledKey);
        } else if (billRelationParam instanceof BillBotpRelationParam) {
            linkBillNodeConfigMap.put("sourceFiledKey", "id");
            linkBillNodeConfigMap.put("targetLinkFiledKey", "id");
            linkBillNodeConfigMap.put("fullSourceKey", "id");
            linkBillNodeConfigMap.put("fullTargetKey", "id");
        }
        return linkBillNodeConfigMap;
    }

    public static DynamicObject loadLinkBillConfigCache(String linkConfigId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)linkConfigId, (String)"pbd_linkbillnode");
    }
}

