/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.business;

import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;

public final class PbdLogSupplierInfoHelper {
    public static Long saveLogisticsSupplierInfo(Map<String, String> paramMap) {
        Long LogisticsSupplierId = null;
        String number = paramMap.get("number");
        String name = paramMap.get("name");
        DynamicObject logsupplier = BusinessDataServiceHelper.newDynamicObject((String)"pur_logsupplier");
        logsupplier.set("number", (Object)number);
        logsupplier.set("name", (Object)new LocaleString(Lang.zh_CN.toString(), name));
        logsupplier.set("remark", (Object)"auto import");
        logsupplier.set("status", (Object)"A");
        logsupplier.set("enable", (Object)"1");
        logsupplier.set("creator", (Object)1L);
        logsupplier.set("modifier", (Object)1L);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        OperationResult saveOperate = SaveServiceHelper.saveOperate((String)"pur_logsupplier", (DynamicObject[])new DynamicObject[]{logsupplier}, (OperateOption)operateOption);
        if (saveOperate.isSuccess()) {
            LogisticsSupplierId = Long.parseLong(saveOperate.getSuccessPkIds().get(0).toString());
            OperationServiceHelper.executeOperate((String)"submit", (String)"pur_logsupplier", (Object[])new Object[]{LogisticsSupplierId}, (OperateOption)operateOption.copy());
            OperationServiceHelper.executeOperate((String)"audit", (String)"pur_logsupplier", (Object[])new Object[]{LogisticsSupplierId}, (OperateOption)operateOption.copy());
        }
        return LogisticsSupplierId;
    }

    public static void updateLogisticsSupplierInfo(Long logisticsSupplierId, String name) {
        DynamicObject logsupplier = BusinessDataServiceHelper.loadSingle((Object)logisticsSupplierId, (String)"pur_logsupplier");
        if (!name.equalsIgnoreCase(logsupplier.getLocaleString("name").getLocaleValue_zh_CN())) {
            logsupplier.set("name", (Object)new LocaleString(Lang.zh_CN.toString(), name));
            logsupplier.set("modifier", (Object)1L);
            logsupplier.set("modifytime", (Object)TimeServiceHelper.now());
            logsupplier.set("remark", (Object)"auto update");
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{logsupplier});
        }
    }

    public static Long getLogisticsSupplierIdForNumber(String LogisticsNum) {
        Long LogisticsSupplierId = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_logsupplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)LogisticsNum)}, (String)"id", (int)1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                LogisticsSupplierId = row.getLong("id");
            }
        }
        return LogisticsSupplierId;
    }

    public static Long getLogisticsSupplierIdForName(String LogisticsName) {
        Long LogisticsSupplierId = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_logsupplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)LogisticsName)}, (String)"id", (int)1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                LogisticsSupplierId = row.getLong("id");
            }
        }
        return LogisticsSupplierId;
    }
}

