/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.business;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.scm.common.service.botp.BotpService;
import kd.scm.common.service.botp.impl.EasBotpServiceImpl;
import kd.scm.common.service.botp.impl.RepcBotpServiceImpl;
import kd.scm.common.service.botp.impl.XhBotpServiceImpl;
import kd.scm.common.service.botp.impl.XkBotpServiceImpl;

public final class PbdSystemJointBotpServiceHelper {
    private static final Map<String, BotpService> servicesMap = new ConcurrentHashMap<String, BotpService>(16);

    public static BotpService getJointSystemBotpService(String jointSystemType) {
        BotpService botpService = null;
        botpService = servicesMap.get(jointSystemType);
        if (botpService != null) {
            return botpService;
        }
        switch (jointSystemType) {
            case "self": {
                botpService = new XhBotpServiceImpl();
                break;
            }
            case "eas": {
                botpService = new EasBotpServiceImpl();
                break;
            }
            case "xkcloud": {
                botpService = new XkBotpServiceImpl();
                break;
            }
        }
        if (botpService != null) {
            servicesMap.put(jointSystemType, botpService);
        }
        return botpService;
    }

    public static BotpService getJointSystemBotpService(String jointSystemType, Boolean isRepcSource) {
        if (isRepcSource.booleanValue()) {
            return new RepcBotpServiceImpl();
        }
        return PbdSystemJointBotpServiceHelper.getJointSystemBotpService(jointSystemType);
    }
}

