/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.business.bdcontrol.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pbd.business.bdcontrol.IBasedataControl;

public class AptitudeExpireControl
implements IBasedataControl {
    private static Log log = LogFactory.getLog(AptitudeExpireControl.class);

    @Override
    public Map process(DynamicObject scheme, String billname, Set billidSet, DynamicObjectCollection objcol) {
        String messageType = "error";
        String controlmode = scheme.getString("controlmode");
        if ("1".equals(controlmode)) {
            messageType = "warning";
        }
        String tooltips = scheme.getString("tooltips");
        Long billentityid = scheme.getLong("billentity.id");
        DynamicObject billentity = BusinessDataServiceHelper.loadSingle((Object)billentityid, (String)"pbd_billregister");
        log.info("\u83b7\u53d6pbd_billregister");
        DynamicObjectCollection entrys = billentity.getDynamicObjectCollection("entryentity");
        String supplierstr = null;
        String orgstr = null;
        for (DynamicObject row : entrys) {
            DynamicObject dimension = row.getDynamicObject("dimension");
            DynamicObject basedatatype = dimension.getDynamicObject("basedatatype");
            if (basedatatype != null && "bd_supplier".equals(basedatatype.getString("number"))) {
                supplierstr = row.getString("billfield");
                continue;
            }
            if (basedatatype == null || !"bos_org".equals(basedatatype.getString("number"))) continue;
            orgstr = row.getString("billfield");
        }
        HashMap<String, String> supplieridMap = new HashMap<String, String>(64);
        HashSet<Long> supplieridSet = new HashSet<Long>(64);
        List<QFilter> qFilters = this.getFitler(scheme, billname, billidSet);
        Object pkid = billidSet.iterator().next();
        boolean exists = QueryServiceHelper.exists((String)billname, pkid);
        if (pkid != null && !pkid.toString().equals("0") && exists) {
            StringBuilder billselector = new StringBuilder();
            billselector.append("id,billno,").append(supplierstr).append(",").append(orgstr);
            DynamicObjectCollection billdatas = QueryServiceHelper.query((String)billname, (String)billselector.toString(), (QFilter[])qFilters.toArray(new QFilter[0]));
            for (DynamicObject bill : billdatas) {
                supplieridSet.add(bill.getLong(supplierstr));
                supplieridMap.put(bill.getString("billno"), bill.getString(supplierstr));
            }
        } else {
            String[] supplierstrs = StringUtils.split((String)supplierstr, (String)".");
            int size = supplierstrs.length;
            for (DynamicObject bill : objcol) {
                DynamicObjectCollection rows;
                if (size == 1) {
                    DynamicObject supplier = bill.getDynamicObject(supplierstrs[0]);
                    if (supplier == null) continue;
                    supplieridSet.add(Long.parseLong(supplier.getPkValue().toString()));
                    supplieridMap.put(bill.getString("billno"), supplier.getPkValue().toString());
                    continue;
                }
                if (size == 2) {
                    rows = bill.getDynamicObjectCollection(supplierstrs[0]);
                    for (DynamicObject row : rows) {
                        DynamicObject supplier = row.getDynamicObject(supplierstrs[1]);
                        if (supplier == null) continue;
                        supplieridSet.add(Long.parseLong(supplier.getPkValue().toString()));
                        supplieridMap.put(bill.getString("billno"), supplier.getPkValue().toString());
                    }
                    continue;
                }
                if (size != 3) continue;
                rows = bill.getDynamicObjectCollection(supplierstrs[0]);
                for (DynamicObject row : rows) {
                    DynamicObjectCollection crows = row.getDynamicObjectCollection(supplierstrs[1]);
                    for (DynamicObject crow : crows) {
                        DynamicObject supplier = crow.getDynamicObject(supplierstrs[2]);
                        if (supplier == null) continue;
                        supplieridSet.add(Long.parseLong(supplier.getPkValue().toString()));
                        supplieridMap.put(bill.getString("billno"), supplier.getPkValue().toString());
                    }
                }
            }
        }
        Map<String, String> suppliererrorMap = this.checkAptitude(tooltips, supplieridSet);
        HashMap results = new HashMap(64);
        Set entrySet = supplieridMap.entrySet();
        for (Map.Entry entry : entrySet) {
            HashMap<String, Object> result = new HashMap<String, Object>(32);
            result.put("success", true);
            if (suppliererrorMap.get(entry.getValue()) != null) {
                result.put("success", false);
                result.put("messageType", messageType);
                result.put("message", suppliererrorMap.get(entry.getValue()));
            }
            results.put((String)entry.getKey(), result);
        }
        return results;
    }

    protected Map<String, String> checkAptitude(String tooltips, Set<Long> supplieridSet) {
        QFilter supplieridfilter = new QFilter("supplier.id", "in", supplieridSet);
        String selector = "id,supplier.id,name,entry_aptitude,entry_aptitude.id,entry_aptitude.dateto,entry_aptitude.aptitudename";
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"srm_supplier", (String)selector, (QFilter[])new QFilter[]{supplieridfilter});
        StringBuilder error = new StringBuilder();
        Date curDate = TimeServiceHelper.now();
        HashMap<String, String> suppliererrorMap = new HashMap<String, String>(64);
        for (DynamicObject supplier : suppliers) {
            Date dateto = supplier.getDate("entry_aptitude.dateto");
            error.setLength(0);
            if (dateto == null || !dateto.before(curDate)) continue;
            error.append(tooltips);
            log.info("\u8f93\u51fa\u63d0\u793a\u4fe1\u606f" + tooltips);
            String supplierid = supplier.getString("supplier.id");
            suppliererrorMap.put(supplierid, error.toString());
        }
        return suppliererrorMap;
    }

    private List<QFilter> getFitler(DynamicObject scheme, String billname, Set billidSet) {
        FilterCondition condition;
        QFilter idfilter = new QFilter("id", "in", (Object)billidSet);
        List<Object> qFilters = null;
        String filterStr = scheme.getString("filtergridtext_tag");
        FilterCondition filterCondition = condition = StringUtils.isEmpty((CharSequence)filterStr) ? null : (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        if (condition != null) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billname);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
            filterBuilder.buildFilter();
            qFilters = filterBuilder.getQFilters();
            log.info("\u5355\u636e\u7684\u8fc7\u6ee4\u6761\u4ef6\u662f:" + qFilters);
        }
        if (qFilters == null) {
            qFilters = new ArrayList<QFilter>();
        }
        qFilters.add(idfilter);
        return qFilters;
    }
}

