/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig;

import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.param.ParameterUtils;
import kd.bos.util.StringUtils;
import kd.scm.common.es.storage.EsResultVo;
import kd.scm.common.es.storage.EsSearchParam;
import kd.scm.pbd.domain.model.esconfig.EsConvertField;
import kd.scm.pbd.domain.model.esconfig.EsTargetDynConverter;

public class DefaultEsTargetDynConverter
implements EsTargetDynConverter {
    private final DynamicObject esOutputDyn;
    private final Map<String, DynamicObjectType> keyDtMap = new HashMap<String, DynamicObjectType>();

    public DefaultEsTargetDynConverter(DynamicObject esOutputDyn) {
        this.esOutputDyn = esOutputDyn;
    }

    private List<EsConvertField> getEsConvertFields() {
        LinkedHashMap<Long, EsConvertField> resMap = new LinkedHashMap<Long, EsConvertField>();
        HashSet<Long> subFeildIdSet = new HashSet<Long>();
        DynamicObjectCollection outputEntryCol = this.esOutputDyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject outputEntry : outputEntryCol) {
            String outputFieldKey = outputEntry.getString("fieldkey");
            String outputFieldType = outputEntry.getString("fieldtype");
            boolean isArray = outputEntry.getBoolean("isarray");
            String fixedValue = outputEntry.getString("fixedvalue");
            String evalPath = outputEntry.getString("evalpath");
            long id = outputEntry.getLong("id");
            long pid = outputEntry.getLong("pid");
            boolean candidateKey = outputEntry.getBoolean("candidateKey");
            ArrayList<EsConvertField> subEsConvertFields = new ArrayList<EsConvertField>();
            EsConvertField esConvertField = new EsConvertField(outputFieldKey, isArray, fixedValue, evalPath, outputFieldType, subEsConvertFields, candidateKey);
            DynamicObject esMappingDyn = outputEntry.getDynamicObject("esmapping");
            if (esMappingDyn != null) {
                esConvertField.setMappingField(esMappingDyn.getString("number"));
            }
            if (StringUtils.isEmpty((String)esConvertField.getFixedValue()) && StringUtils.isEmpty((String)esConvertField.getEvalPath()) && StringUtils.isEmpty((String)esConvertField.getMappingField())) continue;
            resMap.put(id, esConvertField);
            if (pid == 0L) continue;
            EsConvertField parentEsAggOutPutField = (EsConvertField)resMap.get(pid);
            if (parentEsAggOutPutField != null) {
                parentEsAggOutPutField.getSubEsConvertFields().add(esConvertField);
            }
            subFeildIdSet.add(id);
        }
        subFeildIdSet.forEach(resMap::remove);
        ArrayList esConvertFields = new ArrayList(resMap.values());
        for (EsConvertField esConvertField : esConvertFields) {
            if (esConvertField.getSubEsConvertFields().isEmpty()) continue;
            esConvertField.getSubEsConvertFields().sort((a, b) -> b.isCandidateKey().compareTo(a.isCandidateKey()));
        }
        return new ArrayList<EsConvertField>(resMap.values());
    }

    @Override
    public DynamicObject convert(EsResultVo input, EsSearchParam searchParam) {
        List<EsConvertField> esConvertFields = this.getEsConvertFields();
        return this.resolveInput(input, esConvertFields, searchParam, null, null);
    }

    private DynamicObject resolveInput(Object input, List<EsConvertField> esConvertFields, EsSearchParam searchParam, EsConvertField parentEsConvertField, Map<String, DynamicObject> candicateValueToEntryMap) {
        DynamicObject res;
        if (parentEsConvertField == null) {
            if (ObjectUtils.isEmpty((Object)searchParam.getTargetDyn())) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.esOutputDyn.getDynamicObject("targetentity").getString("number"));
                res = ParameterUtils.createDefaultEntity((MainEntityType)entityType, (DynamicObject)((DynamicObject)entityType.createInstance()));
            } else {
                res = searchParam.getTargetDyn();
            }
        } else {
            res = new DynamicObject(this.keyDtMap.get(parentEsConvertField.getFieldKey()));
        }
        for (EsConvertField esConvertField : esConvertFields) {
            DynamicObject needUpdateEntry;
            Object value;
            if (StringUtils.isNotEmpty((String)esConvertField.getFixedValue())) {
                res.set(esConvertField.getFieldKey(), (Object)esConvertField.getFixedValue());
                continue;
            }
            if (StringUtils.isNotEmpty((String)esConvertField.getMappingField())) {
                value = JSONPath.eval((Object)input, (String)("$." + esConvertField.getMappingField()));
                if (esConvertField.isCandidateKey().booleanValue() && (needUpdateEntry = candicateValueToEntryMap.get(String.valueOf(value))) != null) {
                    res = needUpdateEntry;
                }
                if (res.getDynamicObjectType().getProperty(esConvertField.getFieldKey()) instanceof BasedataProp) {
                    res.set(esConvertField.getFieldKey() + "_id", value);
                    continue;
                }
                res.set(esConvertField.getFieldKey(), value);
                continue;
            }
            if (!StringUtils.isNotEmpty((String)esConvertField.getEvalPath())) continue;
            value = JSONPath.eval((Object)input, (String)esConvertField.getEvalPath());
            if (value == null) {
                res.set(esConvertField.getFieldKey(), null);
                return res;
            }
            if (!esConvertField.isArray() && value instanceof List) {
                throw new KDBizException(esConvertField.getFieldKey() + " require list but find object" + System.lineSeparator() + "input:" + input + System.lineSeparator() + "value:" + value + System.lineSeparator() + "fieldInfo:" + esConvertField);
            }
            if (esConvertField.isArray() && !(value instanceof List)) {
                throw new KDBizException(esConvertField.getFieldKey() + " require object but find list" + System.lineSeparator() + "input:" + input + System.lineSeparator() + "value:" + value + System.lineSeparator() + "fieldInfo:" + esConvertField);
            }
            if (!"STRUCT".equals(esConvertField.getFieldType())) {
                if (esConvertField.isCandidateKey().booleanValue() && (needUpdateEntry = candicateValueToEntryMap.get(String.valueOf(value))) != null) {
                    res = needUpdateEntry;
                }
                if (res.getDynamicObjectType().getProperty(esConvertField.getFieldKey()) instanceof BasedataProp) {
                    res.set(esConvertField.getFieldKey() + "_id", value);
                    continue;
                }
                res.set(esConvertField.getFieldKey(), value);
                continue;
            }
            DynamicObjectCollection entryCol = res.getDynamicObjectCollection(esConvertField.getFieldKey());
            candicateValueToEntryMap = new HashMap<String, DynamicObject>();
            String candicateKeyField = "";
            if (!entryCol.isEmpty() && !StringUtils.isEmpty((String)(candicateKeyField = this.getCandicateKeyField(esConvertField)))) {
                for (DynamicObject entry : entryCol) {
                    candicateValueToEntryMap.put(entry.getString(candicateKeyField), entry);
                }
            }
            this.keyDtMap.put(esConvertField.getFieldKey(), entryCol.getDynamicObjectType());
            for (int i = 0; i < ((List)value).size(); ++i) {
                DynamicObject entry;
                entry = this.resolveInput(((List)value).get(i), esConvertField.getSubEsConvertFields(), searchParam, esConvertField, candicateValueToEntryMap);
                if (!StringUtils.isEmpty((String)candicateKeyField) && candicateValueToEntryMap.containsKey(entry.getString(candicateKeyField))) continue;
                entryCol.add((Object)entry);
            }
        }
        return res;
    }

    private String getCandicateKeyField(EsConvertField esConvertField) {
        String res = "";
        for (EsConvertField subEsConvertField : esConvertField.getSubEsConvertFields()) {
            if (!subEsConvertField.isCandidateKey().booleanValue()) continue;
            return subEsConvertField.getFieldKey();
        }
        return res;
    }
}

