/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scm.common.es.storage.EsDataType;
import kd.scm.common.es.storage.EsMappingProperty;
import kd.scm.common.es.storage.EsStorage;
import kd.scm.common.es.storage.EsStorageFactory;
import kd.scm.common.es.storage.EsTokenizerType;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pbd.domain.model.esconfig.DefaultEsAggResultConverter;
import kd.scm.pbd.domain.model.esconfig.DefaultEsTargetDynConverter;
import kd.scm.pbd.domain.model.esconfig.EsAggHandler;
import kd.scm.pbd.domain.model.esconfig.EsAggResultConverter;
import kd.scm.pbd.domain.model.esconfig.EsTargetDynConverter;
import org.elasticsearch.search.aggregations.AggregationBuilder;

public class EsConfig {
    private static final Log log = LogFactory.getLog((String)EsConfig.class.getName());
    public static final String SUFFIX_NAME = "_name";
    public static final String SUFFIX_PY = "_py";
    private DynamicObject dyn;
    private Map<Long, EsAggHandler> aggDynIdHandlerCacheMap;
    private Map<String, EsAggHandler> typeNameAggHanlderCacheMap;
    private Map<String, EsAggResultConverter> aggKeyResultConverterMap;
    private EsTargetDynConverter esTargetDynConverter;
    private String primaryKeyField;
    private String esPrimaryKeyField;
    private final Map<String, Map<String, String>> fieldKeyToEnumMap = new HashMap<String, Map<String, String>>();

    public EsConfig() {
    }

    public EsConfig(Long id) {
        this.dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"pbd_esconfig");
    }

    public EsConfig(DynamicObject dyn) {
        this.dyn = dyn;
    }

    public boolean isHandleByParent() {
        return this.dyn.getBoolean("ishandlebyparent");
    }

    public String getPrimaryKeyField() {
        if (StringUtils.isBlank((CharSequence)this.primaryKeyField)) {
            List<EsMappingProperty> esMappingProperties = this.getEsMappingPropertys();
            for (EsMappingProperty esMappingProperty : esMappingProperties) {
                if (!esMappingProperty.isPrimaryKey()) continue;
                this.primaryKeyField = esMappingProperty.getMappingField();
                return this.primaryKeyField;
            }
            this.primaryKeyField = "id";
        }
        return this.primaryKeyField;
    }

    public String getEsPrimaryKeyField() {
        if (StringUtils.isBlank((CharSequence)this.esPrimaryKeyField)) {
            List<EsMappingProperty> esMappingProperties = this.getEsMappingPropertys();
            for (EsMappingProperty esMappingProperty : esMappingProperties) {
                if (!esMappingProperty.isPrimaryKey()) continue;
                this.esPrimaryKeyField = esMappingProperty.getPropertyName();
                return this.esPrimaryKeyField;
            }
            this.esPrimaryKeyField = "id";
        }
        return this.esPrimaryKeyField;
    }

    public Map<Long, EsAggHandler> getAggDynIdHandlerCacheMap() {
        if (ObjectUtils.isEmpty(this.aggDynIdHandlerCacheMap)) {
            this.initAggHandlerCacheMap();
        }
        return this.aggDynIdHandlerCacheMap;
    }

    public Map<String, EsAggHandler> getTypeNameAggHanlderCacheMap() {
        if (ObjectUtils.isEmpty(this.aggDynIdHandlerCacheMap)) {
            this.initAggHandlerCacheMap();
        }
        return this.typeNameAggHanlderCacheMap;
    }

    public EsTargetDynConverter getEsTargetDynConverter() {
        DynamicObject esOutputDyn;
        if (this.esTargetDynConverter == null && (esOutputDyn = this.dyn.getDynamicObject("esoutput")) != null) {
            esOutputDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)esOutputDyn.getPkValue(), (String)"pbd_esoutput");
            this.esTargetDynConverter = new DefaultEsTargetDynConverter(esOutputDyn);
        }
        return this.esTargetDynConverter;
    }

    public void setEsTargetDynConverter(EsTargetDynConverter esTargetDynConverter) {
        this.esTargetDynConverter = esTargetDynConverter;
    }

    public Long getConfigId() {
        return this.dyn.getLong("id");
    }

    public String getRegion() {
        return this.dyn.getString("region");
    }

    public String getIndexEntityNumber() {
        return this.dyn.getString("indexentity.number");
    }

    public String getNumber() {
        return this.dyn.getString("number");
    }

    public String getIndexKey() {
        DynamicObject parentEsconfig = this.dyn.getDynamicObject("parentesconfig");
        if (parentEsconfig != null) {
            return parentEsconfig.getString("indexkey");
        }
        return this.dyn.getString("indexkey");
    }

    public boolean isUpdate() {
        return this.dyn.getDynamicObject("parentesconfig") != null;
    }

    public List<QFilter> getFilter() {
        String filterConditonJson = this.dyn.getString("filtercondition");
        if (StringUtils.isBlank((CharSequence)filterConditonJson)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditonJson, FilterCondition.class);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.getIndexEntityNumber());
        FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilters();
    }

    public List<EsMappingProperty> getEsMappingPropertys() {
        DynamicObjectCollection entryentityCol = this.dyn.getDynamicObjectCollection("entryentity");
        ArrayList<EsMappingProperty> esMappingProperties = new ArrayList<EsMappingProperty>(entryentityCol.size());
        for (DynamicObject entry : entryentityCol) {
            String analyzer = entry.getString("esmapping.estokenizertype");
            EsMappingProperty esMappingProperty = new EsMappingProperty(entry.getString("esmapping.number"), this.getDataType(entry), EsTokenizerType.fromVal((String)analyzer), entry.getBoolean("esmapping.withpinyin"));
            esMappingProperty.setBoost(entry.getBigDecimal("esmapping.boost"));
            esMappingProperty.setIndexEntityNumber(this.getIndexEntityNumber());
            esMappingProperty.setMappingField(entry.getString("esmapping.mappingfield"));
            esMappingProperty.setPrimaryKey(entry.getBoolean("isprimarykey"));
            esMappingProperty.setDefaultValue(entry.getString("esmapping.defaultvalue"));
            HashSet<Object> nestsPropIdSet = new HashSet<Object>();
            if (esMappingProperty.getDataType() == EsDataType.COMBO) {
                EsMappingProperty comboNameProperty = new EsMappingProperty(entry.getString("esmapping.number") + SUFFIX_NAME, EsDataType.KEYWORD, EsTokenizerType.STANDARD, entry.getBoolean("esmapping.withpinyin"));
                esMappingProperties.add(comboNameProperty);
            }
            if (esMappingProperty.isWithPinyin()) {
                EsMappingProperty pyProperty = new EsMappingProperty(entry.getString("esmapping.number") + SUFFIX_PY, EsDataType.KEYWORD, EsTokenizerType.STANDARD, entry.getBoolean("esmapping.withpinyin"));
                esMappingProperties.add(pyProperty);
            }
            if (esMappingProperty.getDataType() == EsDataType.NESTED) {
                DynamicObjectCollection nestedCol = entry.getDynamicObjectCollection("esmapping.nests");
                for (DynamicObject nested : nestedCol) {
                    nestsPropIdSet.add(nested.getDynamicObject("fbasedataid").getPkValue());
                }
                Map esNestMappingPropertyMap = BusinessDataServiceHelper.loadFromCache((String)"pbd_esmapping_property", (QFilter[])new QFilter[]{new QFilter("id", "in", nestsPropIdSet)});
                this.buildNests(esMappingProperty, esNestMappingPropertyMap);
            }
            esMappingProperties.add(esMappingProperty);
        }
        return esMappingProperties;
    }

    public Map<String, EsAggResultConverter> getAggKeyResultConverterMap() {
        if (ObjectUtils.isEmpty(this.aggKeyResultConverterMap)) {
            this.initAggKeyResultCoverterMap();
        }
        return this.aggKeyResultConverterMap;
    }

    private void initAggKeyResultCoverterMap() {
        this.aggKeyResultConverterMap = new LinkedHashMap<String, EsAggResultConverter>(16);
        DynamicObjectCollection aggEntryCol = this.dyn.getDynamicObjectCollection("aggentry");
        LinkedHashSet<Long> aggIdSet = new LinkedHashSet<Long>(aggEntryCol.size());
        for (DynamicObject aggEntry : aggEntryCol) {
            DynamicObject aggDyn = aggEntry.getDynamicObject("esaggregation");
            aggIdSet.add(aggDyn.getLong("id"));
        }
        Map aggDynMap = BusinessDataServiceHelper.loadFromCache((Object[])aggIdSet.toArray(), (String)"pbd_esaggregation");
        for (DynamicObject aggDyn : aggDynMap.values()) {
            this.aggKeyResultConverterMap.put(aggDyn.getString("number"), new DefaultEsAggResultConverter(aggDyn));
        }
    }

    private EsDataType getDataType(DynamicObject entry) {
        return EsDataType.fromVal((String)entry.getString("esmapping.datatype"));
    }

    private void buildNests(EsMappingProperty esMappingProperty, Map<Object, DynamicObject> esNestMappingPropertyMap) {
        for (Map.Entry<Object, DynamicObject> esNestMappingPropertyEntry : esNestMappingPropertyMap.entrySet()) {
            DynamicObject esNestMappingPropertyDyn = esNestMappingPropertyEntry.getValue();
            EsMappingProperty esNestMappingProperty = new EsMappingProperty(esNestMappingPropertyDyn.getString("number"), EsDataType.fromVal((String)esNestMappingPropertyDyn.getString("datatype")), EsTokenizerType.fromVal((String)esNestMappingPropertyDyn.getString("estokenizertype")), esNestMappingPropertyDyn.getBoolean("withpinyin"));
            esNestMappingProperty.setBoost(esNestMappingPropertyDyn.getBigDecimal("boost"));
            esNestMappingProperty.setIndexEntityNumber(this.getIndexEntityNumber());
            esNestMappingProperty.setMappingField(this.getNestMappingField(esMappingProperty, esNestMappingPropertyDyn));
            if (esNestMappingProperty.getDataType() == EsDataType.NESTED) {
                DynamicObjectCollection nestedCol = esNestMappingPropertyDyn.getDynamicObjectCollection("nests");
                HashSet<Object> nestsPropIdSet = new HashSet<Object>();
                for (DynamicObject nested : nestedCol) {
                    nestsPropIdSet.add(nested.getDynamicObject("fbasedataid").getPkValue());
                }
                Map innerEsNestMappingPropertyMap = BusinessDataServiceHelper.loadFromCache((String)"pbd_esmapping_property", (QFilter[])new QFilter[]{new QFilter("id", "in", nestsPropIdSet)});
                this.buildNests(esNestMappingProperty, innerEsNestMappingPropertyMap);
            }
            esMappingProperty.addNest(esNestMappingProperty);
        }
    }

    private String getNestMappingField(EsMappingProperty esMappingProperty, DynamicObject esNestMappingPropertyDyn) {
        return esMappingProperty.getMappingField().split("\\.")[0] + "." + esNestMappingPropertyDyn.getString("mappingfield");
    }

    public String getIndexName() {
        return CommonUtil.getIndexNamePrefix((String)this.getRegion()) + "_" + this.getIndexKey();
    }

    public EsStorage getEsStorage() {
        return EsStorageFactory.getStorage((String)this.getRegion());
    }

    public String[] getDefaultSearchFields() {
        List<EsMappingProperty> esMappingProperties = this.getEsMappingPropertys();
        String[] res = new String[esMappingProperties.size()];
        int i = 0;
        for (EsMappingProperty pmmEsMappingProperty : esMappingProperties) {
            res[i++] = pmmEsMappingProperty.getPropertyName();
        }
        return res;
    }

    public String getSelectFields() {
        StringBuilder resStrBuilder = new StringBuilder();
        List<EsMappingProperty> esMappingProperties = this.getEsMappingPropertys();
        boolean hasIdField = false;
        for (EsMappingProperty esMappingProperty : esMappingProperties) {
            if (StringUtils.isBlank((CharSequence)esMappingProperty.getMappingField())) continue;
            if ("id".equals(esMappingProperty.getMappingField())) {
                hasIdField = true;
            }
            resStrBuilder.append(esMappingProperty.getMappingField()).append(",");
            if (!esMappingProperty.getDataType().equals((Object)EsDataType.NESTED)) continue;
            for (EsMappingProperty esNestMappingProperty : esMappingProperty.getNests()) {
                if (StringUtils.isBlank((CharSequence)esNestMappingProperty.getMappingField())) continue;
                resStrBuilder.append(esNestMappingProperty.getMappingField()).append(",");
            }
        }
        if (!hasIdField) {
            resStrBuilder.append("id,");
        }
        resStrBuilder.delete(resStrBuilder.length() - 1, resStrBuilder.length());
        return resStrBuilder.toString();
    }

    public List<AggregationBuilder> getAggregationBuilders() {
        ArrayList<AggregationBuilder> res = new ArrayList<AggregationBuilder>();
        DynamicObjectCollection aggEntryCol = this.dyn.getDynamicObjectCollection("aggentry");
        for (DynamicObject aggEntry : aggEntryCol) {
            AggregationBuilder subAgg;
            EsAggHandler esAggHandler;
            DynamicObject esAggDyn = aggEntry.getDynamicObject("esaggregation");
            if (esAggDyn == null || (esAggHandler = this.getAggDynIdHandlerCacheMap().get(esAggDyn.getLong("id"))) == null || (subAgg = esAggHandler.generateBuilder()) == null) continue;
            res.add(subAgg);
        }
        log.info("kd.scm.pmm.domain.model.esconfig.PmmEsConfig.getAggregationBuilders.res:" + ((Object)res).toString());
        return res;
    }

    private void initAggHandlerCacheMap() {
        this.aggDynIdHandlerCacheMap = new LinkedHashMap<Long, EsAggHandler>();
        this.typeNameAggHanlderCacheMap = new LinkedHashMap<String, EsAggHandler>();
        Map aggDynsMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"pbd_esaggregation").getDynamicObjectType(), (QFilter[])new QFilter[]{new QFilter("indexentity.number", "in", (Object)this.getIndexEntityNumber())});
        for (DynamicObject subAggDyn : aggDynsMap.values()) {
            String aggTypeHandler;
            DynamicObject esSubAggTypeDyn = subAggDyn.getDynamicObject("esaggtype");
            if (esSubAggTypeDyn == null || !kd.bos.util.StringUtils.isNotEmpty((String)(aggTypeHandler = esSubAggTypeDyn.getString("aggtypehandler")))) continue;
            try {
                EsAggHandler esAggHandler = (EsAggHandler)ReflectionUtils.accessibleConstructor(Class.forName(aggTypeHandler), (Class[])new Class[]{DynamicObject.class, EsConfig.class}).newInstance(subAggDyn, this);
                this.aggDynIdHandlerCacheMap.put(subAggDyn.getLong("id"), esAggHandler);
                this.typeNameAggHanlderCacheMap.put(esSubAggTypeDyn.getString("number"), esAggHandler);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
        log.info("kd.scm.pbd.domain.model.esconfig.EsConfig.initAggHandlerCacheMap.aggDynIdHandlerCacheMap:" + this.aggDynIdHandlerCacheMap);
        log.info("kd.scm.pbd.domain.model.esconfig.EsConfig.initAggHandlerCacheMap.typeNameAggHanlderCacheMap:" + this.typeNameAggHanlderCacheMap);
    }

    public String getComboName(String mappingField, String value) {
        Map<String, String> comboMap = this.fieldKeyToEnumMap.get(mappingField);
        if (ObjectUtils.isEmpty(comboMap)) {
            comboMap = new HashMap<String, String>();
            Field field = null;
            EntityMetadata entityMetadata = EsConfig.getEntityMetaData(this.getIndexEntityNumber());
            if (mappingField.split("\\.").length == 2) {
                Field basField = entityMetadata.getFieldByKey(mappingField.split("\\.")[0]);
                if (basField instanceof BasedataField) {
                    String baseEntityId = ((BasedataField)basField).getBaseEntityId();
                    EntityMetadata basEntityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)baseEntityId, (MetaCategory)MetaCategory.Entity);
                    field = basEntityMetadata.getFieldByKey(mappingField.split("\\.")[1]);
                }
            } else {
                field = entityMetadata.getFieldByKey(mappingField);
            }
            if (field instanceof ComboField) {
                List items = ((ComboField)field).getItems();
                for (ComboItem comboItem : items) {
                    comboMap.put(comboItem.getValue(), comboItem.getCaption().getLocaleValue());
                }
            }
            this.fieldKeyToEnumMap.put(mappingField, comboMap);
        }
        return comboMap.get(value);
    }

    private static EntityMetadata getEntityMetaData(String entityId) {
        return (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
    }
}

