/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig.agghandler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.common.es.storage.BaseEsStorage;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.pbd.domain.model.esconfig.EsAggHandler;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import kd.scm.pbd.domain.model.esconfig.agghandler.AbstractEsAggHandler;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.filter.Filters;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilters;

public class FiltersEsAggHandler
extends AbstractEsAggHandler {
    public FiltersEsAggHandler(DynamicObject esAggregationsDyn, EsConfig esConfig) {
        super(esAggregationsDyn, esConfig);
    }

    @Override
    public AggregationBuilder doGenerate() {
        String filters = this.esAggregationsDyn.getString("filters");
        JSONArray ja = JSON.parseArray((String)filters);
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>(ja.size());
        for (Object o : ja) {
            EsFilterField esFilterField = (EsFilterField)JSON.parseObject((String)o.toString(), EsFilterField.class);
            esFilterFields.add(esFilterField);
        }
        QueryBuilder queryBuilder = new BaseEsStorage().buidQueryBuilder(esFilterFields);
        return AggregationBuilders.filters((String)this.esAggregationsDyn.getString("number"), (QueryBuilder[])new QueryBuilder[]{queryBuilder});
    }

    @Override
    public Map<String, Object> resolveAggResult(Aggregation aggregation) {
        ParsedFilters parsedFilters = (ParsedFilters)aggregation;
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(parsedFilters.getMetaData());
        List buckets = parsedFilters.getBuckets();
        ArrayList bucketMapList = new ArrayList(buckets.size());
        for (Filters.Bucket bucket : buckets) {
            LinkedHashMap<String, Object> bucketInMap = new LinkedHashMap<String, Object>();
            bucketInMap.put("key", bucket.getKeyAsString());
            bucketInMap.put("doc_count", bucket.getDocCount());
            Aggregations aggregations = bucket.getAggregations();
            for (Aggregation subAgg : aggregations) {
                EsAggHandler subEsAggHandler = this.esConfig.getTypeNameAggHanlderCacheMap().get(subAgg.getType());
                if (subEsAggHandler == null) continue;
                Map<String, Object> subRes = subEsAggHandler.resolveAggResult(subAgg);
                bucketInMap.put(subAgg.getName(), subRes);
            }
            bucketMapList.add(bucketInMap);
        }
        res.put("buckets", bucketMapList);
        return res;
    }
}

