/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig.agghandler;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.pbd.domain.model.esconfig.EsAggHandler;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import kd.scm.pbd.domain.model.esconfig.agghandler.AbstractEsAggHandler;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

public class TermsEsAggHandler
extends AbstractEsAggHandler {
    public TermsEsAggHandler(DynamicObject esAggregationsDyn, EsConfig esConfig) {
        super(esAggregationsDyn, esConfig);
    }

    @Override
    public AggregationBuilder doGenerate() {
        String field = this.getField(this.esAggregationsDyn);
        return ((TermsAggregationBuilder)AggregationBuilders.terms((String)this.esAggregationsDyn.getString("number")).field(field)).size(this.esAggregationsDyn.getInt("size"));
    }

    @Override
    public Map<String, Object> resolveAggResult(Aggregation aggregation) {
        ParsedTerms parsedTerms = (ParsedTerms)aggregation;
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(parsedTerms.getMetaData());
        List buckets = parsedTerms.getBuckets();
        ArrayList bucketMapList = new ArrayList(buckets.size());
        for (Terms.Bucket bucket : buckets) {
            LinkedHashMap<String, Object> bucketInMap = new LinkedHashMap<String, Object>();
            bucketInMap.put("key", bucket.getKeyAsString());
            bucketInMap.put("doc_count", bucket.getDocCount());
            Aggregations aggregations = bucket.getAggregations();
            for (Aggregation subAgg : aggregations) {
                EsAggHandler subEsAggHandler = this.esConfig.getTypeNameAggHanlderCacheMap().get(subAgg.getType());
                if (subEsAggHandler == null) continue;
                Map<String, Object> subRes = subEsAggHandler.resolveAggResult(subAgg);
                bucketInMap.put(subAgg.getName(), subRes);
            }
            bucketMapList.add(bucketInMap);
        }
        res.put("buckets", bucketMapList);
        return res;
    }
}

