/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.scm.pbd.domain.service.EsConfigService;
import kd.scm.pbd.domain.service.EsMappingIndexsBuilderService;
import kd.scm.pbd.domain.service.EsSearchService;
import kd.scm.pbd.domain.service.impl.DefaultEsMappingIndexBuilderServiceImpl;
import kd.scm.pbd.domain.service.impl.EsConfigServiceImpl;
import kd.scm.pbd.domain.service.impl.EsSearchServiceImpl;

public class PbdDomainServiceFactory {
    private static final Map<Class<?>, Object> serviceMap = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, Object>> serviceMapWithKey = new ConcurrentHashMap();
    private static final String REGION_PUR = "pur";

    public static <T> T serviceOf(Class<T> serviceClass) {
        return (T)serviceMap.get(serviceClass);
    }

    public static <T> T serviceOf(Class<T> serviceClass, String key) {
        return (T)((Map)serviceMapWithKey.getOrDefault(serviceClass, new HashMap())).get(key);
    }

    static {
        HashMap<String, EsConfigServiceImpl> esConfigServiceMap = new HashMap<String, EsConfigServiceImpl>();
        esConfigServiceMap.put(REGION_PUR, new EsConfigServiceImpl());
        serviceMapWithKey.put(EsConfigService.class, esConfigServiceMap);
        HashMap<String, DefaultEsMappingIndexBuilderServiceImpl> esMappingIndexBuilderMap = new HashMap<String, DefaultEsMappingIndexBuilderServiceImpl>();
        esMappingIndexBuilderMap.put(REGION_PUR, new DefaultEsMappingIndexBuilderServiceImpl());
        serviceMapWithKey.put(EsMappingIndexsBuilderService.class, esMappingIndexBuilderMap);
        HashMap<String, EsSearchServiceImpl> esSearchServiceMap = new HashMap<String, EsSearchServiceImpl>();
        esSearchServiceMap.put(REGION_PUR, new EsSearchServiceImpl());
        serviceMapWithKey.put(EsSearchService.class, esSearchServiceMap);
    }
}

