/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.service.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.es.storage.EsResultVo;
import kd.scm.common.es.storage.EsSearchParam;
import kd.scm.common.es.storage.EsSuggestParam;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pbd.domain.model.esconfig.EsAggHandler;
import kd.scm.pbd.domain.model.esconfig.EsAggResultConverter;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import kd.scm.pbd.domain.model.esconfig.EsTargetDynConverter;
import kd.scm.pbd.domain.service.EsSearchService;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;

public class EsSearchServiceImpl
implements EsSearchService {
    private final Log log = LogFactory.getLog((String)EsSearchServiceImpl.class.getName());

    @Override
    public EsResultVo search(EsSearchParam searchParam, EsConfig esConfig) {
        this.log.info("\u6267\u884c\u641c\u7d22");
        List<AggregationBuilder> aggregationBuilders = esConfig.getAggregationBuilders();
        try {
            SearchResponse searchResponse = esConfig.getEsStorage().queryWithAggs(esConfig.getIndexName(), "_doc", esConfig.getDefaultSearchFields(), searchParam.getEsFilterFields(), searchParam.getEsSortFields(), aggregationBuilders, searchParam.getPageNum() * searchParam.getPageSize(), searchParam.getPageSize());
            SearchHit[] hits = searchResponse.getHits().getHits();
            EsResultVo esResultVo = new EsResultVo();
            esResultVo.setTotalHits(searchResponse.getHits().getTotalHits());
            esResultVo.setResultData(this.getResultData(hits));
            esResultVo.setAggsData(this.getAggsData(searchResponse, esConfig));
            esResultVo.setConvertedAggResult(this.convertAggs(esResultVo.getAggsData(), esConfig));
            esResultVo.setObjSortValues(this.getSortValuesResults(hits));
            esResultVo.setTargetDyn(this.convertTargetDyn(esResultVo, esConfig, searchParam));
            return esResultVo;
        }
        catch (Exception e) {
            this.log.error(ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
    }

    @Override
    public List<String> suggest(EsSuggestParam suggestParam, EsConfig esConfig) {
        return esConfig.getEsStorage().suggest(esConfig.getIndexName(), "_doc", suggestParam);
    }

    private DynamicObject convertTargetDyn(EsResultVo esResultVo, EsConfig esConfig, EsSearchParam searchParam) {
        EsTargetDynConverter esTargetDynConverter = esConfig.getEsTargetDynConverter();
        if (esTargetDynConverter != null) {
            return esTargetDynConverter.convert(esResultVo, searchParam);
        }
        return null;
    }

    private Map<String, Map<String, Object>> convertAggs(Map<String, Map<String, Object>> aggsData, EsConfig esConfig) {
        LinkedHashMap<String, Map<String, Object>> res = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, EsAggResultConverter> entry : esConfig.getAggKeyResultConverterMap().entrySet()) {
            Map<String, Object> input = aggsData.get(entry.getKey());
            if (ObjectUtils.isEmpty(input)) continue;
            res.put(entry.getKey(), entry.getValue().convert(input));
        }
        return res;
    }

    private Map<String, Map<String, Object>> getAggsData(SearchResponse searchResponse, EsConfig esConfig) {
        LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>(16);
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return result;
        }
        for (Aggregation aggregation : aggregations) {
            EsAggHandler esAggHandler = esConfig.getTypeNameAggHanlderCacheMap().get(aggregation.getType());
            if (esAggHandler != null) {
                result.put(aggregation.getName(), esAggHandler.resolveAggResult(aggregation));
                continue;
            }
            this.log.warn("\u805a\u5408\u7c7b\u578b\u5904\u7406\u5668\u4e0d\u5339\u914d\uff0c\u83b7\u53d6\u805a\u5408\u7684\u7c7b\u578b\u4e3a" + aggregation.getType() + "\uff0c\u914d\u7f6e\u7684\u7c7b\u578b\u4e3a" + esConfig.getTypeNameAggHanlderCacheMap());
        }
        return result;
    }

    private List<Map<String, Object>> getResultData(SearchHit[] hits) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        if (hits != null) {
            for (SearchHit hit : hits) {
                result.add(hit.getSourceAsMap());
            }
        }
        return result;
    }

    private Object[] getSortValuesResults(SearchHit[] hits) {
        Object[] objSortValuesResult = null;
        if (hits != null && hits.length > 0) {
            objSortValuesResult = hits[hits.length - 1].getSortValues();
        }
        return objSortValuesResult;
    }
}

