/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.address;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pbd.common.entity.AddressRelationResult;
import kd.scm.pbd.common.entity.AddressTreeNode;

public class AddressRelationUpdater {
    public static void updateAddressRelation(List<AddressTreeNode> bdAddressTreeNodeList, String ecType) {
        for (AddressTreeNode address : bdAddressTreeNodeList) {
            HashMap<Long, AddressRelationResult> matchResultMap = new HashMap<Long, AddressRelationResult>(512);
            AddressRelationUpdater.handleAddressMatchResult(address, matchResultMap);
            DynamicObject[] addressRel = AddressRelationUpdater.getAddressRelDyos(ecType, matchResultMap.keySet());
            AddressRelationUpdater.doUpdate(addressRel, matchResultMap);
        }
    }

    private static void doUpdate(DynamicObject[] addressRel, Map<Long, AddressRelationResult> matchResultMap) {
        Date now = TimeServiceHelper.now();
        for (DynamicObject dyo : addressRel) {
            Long addressId = dyo.getLong("addressid.id");
            AddressRelationResult res = matchResultMap.get(addressId);
            if (null == res) continue;
            dyo.set("longnumber", (Object)res.getLongNumber());
            dyo.set("matchstatus", (Object)res.getMatchStatus());
            dyo.set("emaladdress", (Object)res.getMatchAddressId());
            dyo.set("createtime", (Object)now);
            dyo.set("modifytime", (Object)now);
        }
        if (null != addressRel && addressRel.length > 0) {
            SaveServiceHelper.save((DynamicObject[])addressRel);
        }
    }

    public static void handleAddressMatchResult(AddressTreeNode bdAddressTreeNode, Map<Long, AddressRelationResult> matchResultMap) {
        if (null != bdAddressTreeNode) {
            AddressRelationResult res = new AddressRelationResult(bdAddressTreeNode.getId(), bdAddressTreeNode.getMatchStatus(), bdAddressTreeNode.getMatchAddressId(), bdAddressTreeNode.isSpecialAddress() ? AddressRelationUpdater.getSpecialLongNumber(bdAddressTreeNode.getMatchLongnumber()) : bdAddressTreeNode.getMatchLongnumber());
            matchResultMap.putIfAbsent(bdAddressTreeNode.getId(), res);
            if (bdAddressTreeNode.hasChilds()) {
                for (AddressTreeNode node : bdAddressTreeNode.getChildAddressList()) {
                    AddressRelationUpdater.handleAddressMatchResult(node, matchResultMap);
                }
            }
        }
    }

    private static String getSpecialLongNumber(String number) {
        String res = "";
        if (StringUtils.isNotBlank((CharSequence)number)) {
            String[] strs = number.split("\\.");
            if (strs.length > 1) {
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i < strs.length; ++i) {
                    sb.append(strs[i]).append(i < strs.length - 1 ? "." : "");
                }
                return sb.toString();
            }
            return number;
        }
        return res;
    }

    private static DynamicObject[] getAddressRelDyos(String ecType, Set<Long> addressIds) {
        QFilter filter = new QFilter("emaltype", "=", (Object)ecType).and(new QFilter("addressid", "in", addressIds));
        filter.and(new QFilter("matchstatus", "in", Arrays.asList("1", "3")));
        return BusinessDataServiceHelper.load((String)"pbd_maladdressrel", (String)"id,matchstatus,longnumber,emaladdress,emaltype,addressid,createtime,modifytime", (QFilter[])new QFilter[]{filter});
    }
}

