/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.address.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.scm.pbd.common.entity.AddressTreeNode;
import kd.scm.pbd.service.address.AbstractAddressMatcher;

public class JdAddressMatcher
extends AbstractAddressMatcher {
    private static final long WU_JIA_QU = 3302L;
    private static final long TU_MU_SHU = 3291L;
    private static final long A_LA_ER = 3272L;
    private static final long SHI_HE_ZI = 3264L;
    private static final long WEN_SHU_ZHEN = 288L;
    private static final long YU_QUAN_ZHEN = 287L;
    private static final long XIN_CHEN_ZHEN = 286L;
    private static final long EC_WU_JIA_QU = 1204303859741149184L;
    private static final long EC_TU_MU_SHU = 1204303845967054848L;
    private static final long EC_A_LA_ER = 1204303857904044032L;
    private static final long EC_SHI_HE_ZI = 1204303853793627136L;
    private static final long EC_JIA_YU_GUAN = 1204303816816643072L;
    private static final Map<Long, Long> HLJ_YI_CHUN_MAP = new HashMap<Long, Long>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(1069363945153770496L, 1204303333632822272L);
            this.put(1069363944650455040L, 1204303332944956416L);
            this.put(1069363945229268992L, 1204303332970122240L);
            this.put(1069363945380263936L, 1204303331862825984L);
            this.put(1146L, 1204303225965038592L);
            this.put(17L, 1204303439882930176L);
        }
    };
    public static final List<Long> CHONG_QING_ID_LIST = Arrays.asList(171L, 172L, 173L, 174L);

    @Override
    public int matchBdAddressWithEcAddress(List<AddressTreeNode> bdAddressTreeNodeList, List<AddressTreeNode> ecAddressTreeNodeList) {
        AtomicInteger cnt = new AtomicInteger();
        boolean bdAddrVersion = this.getValidAddrCount() <= 3500;
        this.match(bdAddressTreeNodeList, ecAddressTreeNodeList, cnt, bdAddrVersion);
        return cnt.get();
    }

    private boolean startCharMatch(String str1, String str2) {
        if (str1.length() >= 2 && str2.length() >= 2) {
            return str1.charAt(0) == str2.charAt(0) && str1.charAt(1) == str2.charAt(1);
        }
        return false;
    }

    @Override
    public boolean specialRuleMatch(AddressTreeNode bdNode, AddressTreeNode ecNode, boolean bdAddrVersion) {
        long ecAddressId = ecNode.getId();
        long bdAddressId = bdNode.getId();
        if (CHONG_QING_ID_LIST.contains(bdNode.getId()) && this.startCharMatch(bdNode.getName(), ecNode.getName())) {
            return true;
        }
        if (HLJ_YI_CHUN_MAP.containsKey(bdAddressId) && ecAddressId == HLJ_YI_CHUN_MAP.get(bdAddressId)) {
            return true;
        }
        if (bdNode.getParentId() == 3302L && ecAddressId == 1204303859741149184L || bdNode.getParentId() == 3291L && ecAddressId == 1204303845967054848L || bdNode.getParentId() == 3272L && ecAddressId == 1204303857904044032L || bdNode.getParentId() == 3264L && ecAddressId == 1204303853793627136L) {
            return true;
        }
        return bdNode.getParentId() == 288L && ecAddressId == 1204303816816643072L || bdNode.getParentId() == 287L && ecAddressId == 1204303816816643072L || bdNode.getParentId() == 286L && ecAddressId == 1204303816816643072L;
    }

    @Override
    public void handleAfterBuildNodeResult(List<AddressTreeNode> resultList, boolean isMatchSource) {
        if (this.getValidAddrCount() <= 3500 && isMatchSource) {
            for (AddressTreeNode node : resultList) {
                if (!DIRECT_PROVINCE_ID_LIST.contains(node.getId())) continue;
                this.fillToFourthLevel(node);
            }
        }
    }

    @Override
    public void handleSpecialAddress(AddressTreeNode node, DynamicObject dyo, boolean isMatchSource) {
        if (isMatchSource && DIRECT_PROVINCE_NUM_LIST.contains(node.getLongnumber().split("\\.")[0])) {
            node.setSpecialAddress(true);
        }
    }

    @Override
    public QFilter getBdAddrFilter() {
        return new QFilter("enable", "=", (Object)"1");
    }

    @Override
    protected void resetNode(List<AddressTreeNode> nodes, String rootNodeLongNumber) {
        for (AddressTreeNode node : nodes) {
            node.setLevel(node.getLevel() + 1);
            node.setLongnumber(rootNodeLongNumber + "." + node.getLongnumber());
            if (!node.hasChilds()) continue;
            this.resetNode(node.getChildAddressList(), rootNodeLongNumber);
        }
    }
}

