/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.address.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.scm.pbd.common.entity.AddressTreeNode;
import kd.scm.pbd.service.address.AbstractAddressMatcher;

public class XfsAddressMatcher
extends AbstractAddressMatcher {
    private static final Map<Long, Long> SPECIAL_MAP = new HashMap<Long, Long>(){};

    @Override
    public int matchBdAddressWithEcAddress(List<AddressTreeNode> bdAddressTreeNodeList, List<AddressTreeNode> ecAddressTreeNodeList) {
        AtomicInteger cnt = new AtomicInteger();
        boolean bdAddrVersion = this.getValidAddrCount() <= 3500;
        this.match(bdAddressTreeNodeList, ecAddressTreeNodeList, cnt, bdAddrVersion);
        return cnt.get();
    }

    @Override
    public boolean specialRuleMatch(AddressTreeNode bdNode, AddressTreeNode ecNode, boolean bdAddrVersion) {
        long ecAddressId = ecNode.getId();
        return SPECIAL_MAP.containsKey(bdNode.getId()) && ecAddressId == SPECIAL_MAP.get(bdNode.getId());
    }

    @Override
    public void handleAfterBuildNodeResult(List<AddressTreeNode> resultList, boolean isMatchSource) {
    }

    @Override
    public void handleSpecialAddress(AddressTreeNode node, DynamicObject dyo, boolean isMatchSource) {
        if (isMatchSource && DIRECT_PROVINCE_NUM_LIST.contains(node.getLongnumber().split("\\.")[0])) {
            node.setSpecialAddress(true);
        }
    }

    @Override
    public QFilter getBdAddrFilter() {
        QFilter levelFilter = new QFilter("level", "in", (Object)new ArrayList<Integer>(){
            {
                this.add(1);
                this.add(2);
                this.add(3);
            }
        });
        QFilter filter = new QFilter("issystem", "=", (Object)"1");
        return new QFilter("enable", "=", (Object)"1").and(levelFilter).and(filter);
    }

    @Override
    protected void resetNode(List<AddressTreeNode> nodes, String rootNodeLongNumber) {
        for (AddressTreeNode node : nodes) {
            node.setLevel(node.getLevel() + 1);
            node.setLongnumber(rootNodeLongNumber + "." + node.getLongnumber());
            if (!node.hasChilds()) continue;
            this.resetNode(node.getChildAddressList(), rootNodeLongNumber);
        }
    }

    static {
        SPECIAL_MAP.put(3121L, 1493476244166110208L);
        SPECIAL_MAP.put(1428L, 1493468977484123136L);
        SPECIAL_MAP.put(1420L, 1493468975848344576L);
        SPECIAL_MAP.put(1850L, 1493471394124622848L);
        SPECIAL_MAP.put(1880L, 1493471399979895808L);
        SPECIAL_MAP.put(244L, 1493465906750254080L);
        SPECIAL_MAP.put(239L, 1493465905735257088L);
        SPECIAL_MAP.put(2923L, 1493480892855839744L);
        SPECIAL_MAP.put(2839L, 1493480876305116160L);
        SPECIAL_MAP.put(3480L, 1493479292284292096L);
        SPECIAL_MAP.put(3420L, 1493479280842206208L);
        SPECIAL_MAP.put(600L, 1493474049605594112L);
        SPECIAL_MAP.put(775L, 1493478349832547328L);
    }
}

