/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.datahandle;

import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.helper.datahandle.IPurDataHandleAction;
import kd.scm.common.helper.datahandle.PurDataHandleArgs;
import kd.scm.common.helper.datahandle.PurDataHandleContext;
import kd.scm.common.helper.datahandle.PurDataHandleResult;
import kd.scm.common.helper.datahandle.PurDataHandleResultManager;
import kd.scm.common.helper.datahandle.TaskStatusEnum;
import kd.scm.common.helper.datahandle.utils.TimeUtils;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ExceptionUtil;

public class PurDataHandleEngine {
    private static final Log log = LogFactory.getLog(PurDataHandleEngine.class);
    private PurDataHandleContext context;
    private PurDataHandleResultManager resultManager;

    public void doPurDataHandle(PurDataHandleArgs purDataHandleArgs) {
        String message = ResManager.loadKDString((String)"\u4efb\u52a1\u5f00\u59cb,\u53c2\u6570:", (String)"PurDataHandleEngine_0", (String)"scm-pbd-business", (Object[])new Object[0]);
        log.info("PurDataHandleEngine.doPurDataHandle:" + message + purDataHandleArgs);
        this.context = new PurDataHandleContext();
        this.context.setInputArgs(purDataHandleArgs);
        Long taskConfigId = purDataHandleArgs.getTaskConfigId();
        this.context.setTaskConfigId(taskConfigId);
        DynamicObject config = BusinessDataServiceHelper.loadSingle((Object)taskConfigId, (String)"pbd_srmdatasetting");
        if (config == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PurDataHandleEngine_1", (String)"scm-pbd-business", (Object[])new Object[0]));
        }
        this.context.setTaskConfig(config);
        this.resultManager = new PurDataHandleResultManager();
        this.handleTask(this.context, this.resultManager);
        log.info("PurDataHandleEngine.doPurDataHandle:\u6267\u884c\u7ed3\u675f");
    }

    private void innerDoTask(PurDataHandleContext context, DynamicObject config, PurDataHandleResultManager resultManager) throws Exception {
        LinkedHashMap<Object, Object> actionsMap = new LinkedHashMap(16);
        LinkedHashMap<Long, Long> actionsPercentMap = new LinkedHashMap<Long, Long>(16);
        if (CollectionUtils.isEmpty((Map)context.getActionsToBeRunMap())) {
            actionsMap = this.getActions(config, context, actionsPercentMap);
            context.getActionsToBeRunMap().putAll(actionsMap);
            context.getActionsPercentMap().putAll(actionsPercentMap);
        } else {
            boolean skip = context.isSkip();
            if (skip) {
                LinkedHashMap actionsToBeRunMap = context.getActionsToBeRunMap();
                Set entries = actionsToBeRunMap.entrySet();
                Iterator iterator = entries.iterator();
                Map.Entry next = iterator.next();
                actionsToBeRunMap.remove(next.getKey());
                actionsMap.putAll(actionsToBeRunMap);
                LinkedHashMap percentMap = context.getActionsPercentMap();
                Set entries1 = percentMap.entrySet();
                Iterator iterator1 = entries1.iterator();
                Map.Entry next1 = iterator1.next();
                percentMap.remove(next1.getKey());
                actionsPercentMap.putAll(percentMap);
            } else {
                actionsMap.putAll(context.getActionsToBeRunMap());
                actionsPercentMap.putAll(context.getActionsPercentMap());
            }
        }
        if (CollectionUtils.isEmpty(actionsMap)) {
            throw new KDException(new ErrorCode("PurDataHandleEngine init faild", ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u5f15\u64ce\u5931\u8d25\u3002", (String)"PurDataHandleEngine_3", (String)"scm-pbd-business", (Object[])new Object[0])), new Object[0]);
        }
        this.updateSourceBillResultStatus(context, TaskStatusEnum.TASK_DOING.getValue());
        int step = 1;
        for (Map.Entry<Object, Object> entry : actionsMap.entrySet()) {
            String className = (String)entry.getValue();
            Long percent = actionsPercentMap.get(entry.getKey());
            IPurDataHandleAction action = this.getClass(className);
            context.setCurSubTaskStartTime(TimeServiceHelper.now());
            context.setCurSubTaskId((Long)entry.getKey());
            action.setSubTaskId((Long)entry.getKey());
            action.setContext(context);
            action.setResultManager(resultManager);
            action.execute();
            context.getActionsToBeRunMap().remove(entry.getKey());
            context.setProgress(percent);
            this.saveContext(context);
            log.info("QWBLOG SAVE CONTEXT SUCCESS. step:" + step++);
        }
    }

    private void updateSourceBillResultStatus(PurDataHandleContext context, String status) {
        PurDataHandleArgs inputArgs = context.getInputArgs();
        String sourceBillkey = inputArgs.getSourceBillkey();
        String sourceBillId = inputArgs.getSourceBillId();
        String sourceBillResultFiled = inputArgs.getSourceBillResultFiled();
        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sourceBillId), (String)sourceBillkey);
        sourceBill.set(sourceBillResultFiled, (Object)status);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceBill});
    }

    public void retryPurDataHandle(Long dataHandleResultId) {
        log.info("PurDataHandleEngine.retryPurDataHandle\u5f00\u59cb");
        DynamicObject dataHandleResult = BusinessDataServiceHelper.loadSingle((Object)dataHandleResultId, (String)"pbd_schandleresult", (String)"id,context");
        String contextStr = dataHandleResult.getString("context");
        log.info("\u91cd\u8bd5\u83b7\u53d6\u4e0a\u4e0b\u6587: " + contextStr);
        PurDataHandleContext context = this.deSerializeConetext(contextStr);
        context.setRetry(true);
        context.setSkip(false);
        PurDataHandleResultManager resultManager = new PurDataHandleResultManager();
        resultManager.create(context);
        this.handleTask(context, resultManager);
        log.info("PurDataHandleEngine.retryPurDataHandle:\u91cd\u8bd5\u7ed3\u675f");
    }

    public void skipPurDataHandle(Long dataHandleResultId) {
        log.info("PurDataHandleEngine.retryPurDataHandle\u5f00\u59cb");
        DynamicObject dataHandleResult = BusinessDataServiceHelper.loadSingle((Object)dataHandleResultId, (String)"pbd_schandleresult", (String)"id,context");
        String contextStr = dataHandleResult.getString("context");
        log.info("\u91cd\u8bd5\u83b7\u53d6\u4e0a\u4e0b\u6587: " + contextStr);
        PurDataHandleContext context = this.deSerializeConetext(contextStr);
        context.setRetry(true);
        context.setSkip(true);
        PurDataHandleResultManager resultManager = new PurDataHandleResultManager();
        resultManager.create(context);
        this.handleTask(context, resultManager);
        log.info("PurDataHandleEngine.retryPurDataHandle:\u91cd\u8bd5\u7ed3\u675f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTask(PurDataHandleContext context, PurDataHandleResultManager resultManager) {
        StringBuilder errMsg = new StringBuilder();
        StringBuilder lockBillId = new StringBuilder(context.getInputArgs().getSourceBillId());
        if (MutexHelper.require((String)"pbd_schandleresult", (Object)lockBillId, (String)"do", (StringBuilder)errMsg)) {
            try {
                if (!context.isRetry()) {
                    String sourceBillId = context.getInputArgs().getSourceBillId();
                    String sourceBillType = context.getInputArgs().getSourceBillType();
                    if (this.existSourceBillResult(sourceBillId)) {
                        boolean inProgress = this.isInProgress(sourceBillId, sourceBillType);
                        if (inProgress) {
                            return;
                        }
                        boolean unCompleted = this.isUnCompleted(sourceBillId);
                        if (unCompleted) {
                            return;
                        }
                    }
                    PurDataHandleResult result = resultManager.getPurDataHandleResult();
                    result.loadOrCreateResult(context);
                }
                this.innerDoTask(context, context.getTaskConfig(), resultManager);
                resultManager.getPurDataHandleResult().upatePurDataHandleResult(100, TaskStatusEnum.TASK_SUCCESS.getValue());
                this.updateSourceBillResultStatus(context, TaskStatusEnum.TASK_SUCCESS.getValue());
            }
            catch (Throwable e) {
                log.info("\u6ce8\u518c\u8d44\u6599\u5ba1\u6279\u6d41\u7a0b\u6355\u83b7\u5230\u5f02\u5e38\uff1a " + e);
                this.writeErroToPurDataHandleResult(context.getInputArgs().getHandleDataResultId(), e, context);
            }
            finally {
                MutexHelper.release((String)"pbd_schandleresult", (String)"do", (String)lockBillId.toString());
            }
        }
    }

    private boolean existSourceBillResult(String sourceBillId) {
        return QueryServiceHelper.exists((String)"pbd_schandleresult", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)sourceBillId)});
    }

    private boolean isInProgress(String sourceBillId, String curSourceBillType) {
        DynamicObjectCollection result = QueryServiceHelper.query((String)"pbd_schandleresult", (String)"sourcebilltype", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)sourceBillId)}, (String)"createtime desc", (int)1);
        String sourceBillType = ((DynamicObject)result.get(0)).getString("sourcebilltype");
        if (StringUtils.isNotBlank((CharSequence)sourceBillType)) {
            return curSourceBillType.equals(sourceBillType);
        }
        log.info("PBD_HANDLERESULT sourceBillType is null");
        return true;
    }

    private boolean isUnCompleted(String sourceBillId) {
        DynamicObjectCollection result = QueryServiceHelper.query((String)"pbd_schandleresult", (String)"status", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)sourceBillId)}, (String)"createtime desc", (int)1);
        String status = ((DynamicObject)result.get(0)).getString("status");
        if (StringUtils.isNotBlank((CharSequence)status)) {
            return !status.equals("4");
        }
        log.info("PBD_HANDLERESULT status is null");
        return true;
    }

    private LinkedHashMap<Long, String> getActions(DynamicObject configObj, PurDataHandleContext context, LinkedHashMap<Long, Long> actionsPercentMap) {
        LinkedHashMap<Long, String> actions = new LinkedHashMap<Long, String>(16);
        if (null != configObj) {
            DynamicObjectCollection col = configObj.getDynamicObjectCollection("entryentity");
            col.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    return o1.getInt("subsort") - o2.getInt("subsort");
                }
            });
            for (DynamicObject entry : col) {
                String className = entry.getString("task.classname");
                if (StringUtils.isBlank((CharSequence)className) || !entry.getBoolean("valid")) continue;
                actions.putIfAbsent(entry.getLong("task.id"), className);
                actionsPercentMap.putIfAbsent(entry.getLong("task.id"), entry.getLong("percent"));
            }
        }
        return actions;
    }

    private IPurDataHandleAction getClass(String className) throws InterruptedException {
        try {
            Class<?> clazz = Class.forName(className);
            return (IPurDataHandleAction)clazz.newInstance();
        }
        catch (Exception e) {
            log.error("Action NewInstance Fail: " + e.getMessage() + e.getStackTrace());
            String message = ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u5f15\u64ce\u6267\u884c\u5668\u5931\u8d25\uff1a", (String)"PurDataHandleEngine_4", (String)"scm-pbd-business", (Object[])new Object[0]);
            throw new KDException(new ErrorCode("Action NewInstance error", message + className + e.getMessage()), new Object[0]);
        }
    }

    public void saveContext(PurDataHandleContext context) throws InterruptedException {
        Long resultId = context.getInputArgs().getHandleDataResultId();
        QFilter filter = new QFilter("id", "=", (Object)resultId);
        filter.and("entryentity.subtask.id", "=", (Object)context.getCurSubTaskId());
        DynamicObject[] resultDyos = BusinessDataServiceHelper.load((String)"pbd_schandleresult", (String)"id,billno,context,progress,status,entryentity.substarttime,entryentity.subtime,entryentity.substatus,entryentity.detail,sourcebillid,sourcebilltype", (QFilter[])new QFilter[]{filter}, (String)"starttime desc", (int)1);
        if (resultDyos == null || resultDyos.length == 0) {
            return;
        }
        DynamicObject resultDyo = resultDyos[0];
        context.updatePreProgress();
        PurDataHandleContext copyContext = new PurDataHandleContext();
        copyContext.setActionsToBeRunMap(context.getActionsToBeRunMap());
        copyContext.setIgnoreException(context.isIgnoreException());
        copyContext.setInputArgs(context.getInputArgs());
        copyContext.setTaskConfigId(context.getTaskConfigId());
        copyContext.setPreProgress(context.getPreProgress());
        resultDyo.set("context", (Object)this.serializeContext(copyContext));
        resultDyo.set("progress", (Object)context.getProgress());
        DynamicObjectCollection entry = resultDyo.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryRow : entry) {
            String substatus = entryRow.getString("substatus");
            if (substatus.equals(TaskStatusEnum.TASK_SUCCESS.getValue()) || substatus.equals("5")) continue;
            entryRow.set("subtime", (Object)(TimeServiceHelper.now().getTime() - context.getCurSubTaskStartTime().getTime()));
            entryRow.set("substatus", (Object)TaskStatusEnum.TASK_SUCCESS.getValue());
            entryRow.set("detail", (Object)"");
            break;
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{resultDyo});
    }

    private void writeErroToPurDataHandleResult(Long purDataHandleResult, Throwable ex, PurDataHandleContext context) {
        log.info("\u5f02\u5e38\u5199\u56de\u5165\u53c2\uff1a purDataHandleResult:" + purDataHandleResult + "\u3001ex: " + ex + "\u3001context: " + context);
        if (StringUtils.isBlank((Object)purDataHandleResult)) {
            return;
        }
        if (ex == null) {
            return;
        }
        String message = ex.getMessage();
        String errInfo = ExceptionUtil.wrapExceptionErrorInfo((Throwable)ex);
        QFilter filter = new QFilter("id", "=", (Object)purDataHandleResult);
        DynamicObject[] resultDyos = BusinessDataServiceHelper.load((String)"pbd_schandleresult", (String)"id,progress,time,starttime,status,context,sourcebillid,sourcebilltype,entryentity.subtask,entryentity.substarttime,entryentity.subtime,entryentity.substatus,entryentity.detail,entryentity.errinfo", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (resultDyos == null || resultDyos.length == 0) {
            log.info("\u7ed3\u679c\u5355\u67e5\u8be2\u4e3a\u7a7a: " + resultDyos);
            return;
        }
        DynamicObject resultDyo = resultDyos[0];
        resultDyo.set("progress", (Object)100);
        resultDyo.set("time", (Object)TimeUtils.getSecond((Date)resultDyo.getDate("starttime"), (Date)TimeServiceHelper.now()));
        resultDyo.set("status", (Object)TaskStatusEnum.TASK_FAIL.getValue());
        resultDyo.set("context", (Object)this.serializeContext(context));
        resultDyo.set("sourcebillid", (Object)context.getInputArgs().getSourceBillId());
        resultDyo.set("sourcebilltype", (Object)context.getInputArgs().getSourceBillType());
        DynamicObjectCollection entrys = resultDyo.getDynamicObjectCollection("entryentity");
        DynamicObject doingEntry = null;
        for (DynamicObject entry : entrys) {
            String status = entry.getString("substatus");
            if (TaskStatusEnum.TASK_DOING.getValue().equals(status) || TaskStatusEnum.TASK_FAIL.getValue().equals(status)) {
                doingEntry = entry;
                break;
            }
            if (doingEntry != null || !TaskStatusEnum.TASK_NOSTART.getValue().equals(entry.getString("substatus"))) continue;
            doingEntry = entry;
        }
        if (doingEntry == null && !entrys.isEmpty()) {
            doingEntry = (DynamicObject)entrys.get(entrys.size() - 1);
        }
        log.info("\u6267\u884c\u4efb\u52a1\u8be6\u7ec6\u5806\u6808\uff1a " + errInfo);
        if (StringUtils.isNotBlank((CharSequence)errInfo) && errInfo.length() > 2000) {
            log.info("errInfo\u957f\u5ea6\uff1a" + errInfo.length());
            errInfo = errInfo.substring(0, 2000);
        }
        if (StringUtils.isNotBlank((CharSequence)message) && message.length() > 2000) {
            log.info("message\u957f\u5ea6\uff1a" + message.length());
            message = message.substring(0, 2000);
        }
        if (doingEntry != null) {
            log.info("\u6267\u884c\u53cd\u5199\u9519\u8bef\u8bb0\u5f55\u5f00\u59cb");
            if (doingEntry.getInt("subtime") == 0) {
                doingEntry.set("substarttime", (Object)TimeServiceHelper.now());
                doingEntry.set("subtime", (Object)"1");
            }
            doingEntry.set("substatus", (Object)"3");
            doingEntry.set("errinfo", (Object)errInfo);
            doingEntry.set("detail", (Object)message);
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{resultDyo});
        this.updateSourceBillResultStatus(context, TaskStatusEnum.TASK_FAIL.getValue());
    }

    private String serializeContext(PurDataHandleContext context) {
        context.setTaskConfig(null);
        context.getSubTaskMapConfig().clear();
        context.setCurSubTaskId(null);
        context.setCurSubTaskStartTime(null);
        return SerializationUtils.toJsonString((Object)context);
    }

    private PurDataHandleContext deSerializeConetext(String contextStr) {
        if (StringUtils.isBlank((CharSequence)contextStr)) {
            return new PurDataHandleContext();
        }
        PurDataHandleContext context = (PurDataHandleContext)SerializationUtils.fromJsonString((String)contextStr, PurDataHandleContext.class);
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)context.getTaskConfigId(), (String)"pbd_srmdatasetting");
        context.setTaskConfig(taskConfig);
        return context;
    }
}

