/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppWriter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.FeatureCheckUtil;

public class PbdBidAppDisableService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(PbdBidAppDisableService.class);
    private static final String BID_APP_ID = "101/HIPCXLPU";
    private static final String TEN_APP_ID = "101/NKY=9OLA";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder resultMsg = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u62db\u6295\u6807\u5e94\u7528\u7981\u7528\u529f\u80fd", (String)"PbdBidAppDisableService_0", (String)"scm-pbd-mservice", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(dbKey, resultMsg);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(resultMsg.toString());
            }
            result.setLog(resultMsg.append(ResManager.loadKDString((String)"\u6267\u884c\u62db\u6295\u6807\u5e94\u7528\u7981\u7528\u529f\u80fd\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"PbdBidAppDisableService_1", (String)"scm-pbd-mservice", (Object[])new Object[0])).toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(resultMsg.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u6267\u884c\u62db\u6295\u6807\u5e94\u7528\u7981\u7528\u529f\u80fd\u6267\u884c\u5f02\u5e38", (String)"PbdBidAppDisableService_2", (String)"scm-pbd-mservice", (Object[])new Object[0]);
            logger.error(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    public boolean upgrade(String dbKey, StringBuilder pProcessInfo) {
        Set licenseModules = LicenseServiceHelper.getLicenseModules();
        Map checkRes = FeatureCheckUtil.checkTenFeature();
        if (!CollectionUtils.isEmpty((Collection)licenseModules) && (licenseModules.contains("BID") || licenseModules.contains("bid") || ((Boolean)checkRes.get("hasLicense")).booleanValue())) {
            pProcessInfo.append(ResManager.loadKDString((String)"\u5305\u542b\u62db\u6295\u6807\u76f8\u5173\u8bb8\u53ef\uff0c\u65e0\u9700\u6267\u884c\u7981\u7528", (String)"PbdBidAppDisableService_3", (String)"scm-pbd-mservice", (Object[])new Object[0]));
            return true;
        }
        if (this.hasBidData(dbKey)) {
            pProcessInfo.append(ResManager.loadKDString((String)"\u62db\u6807\u7acb\u9879\u5b58\u5728\u4f7f\u7528\u6570\u636e\uff0c\u65e0\u9700\u6267\u884c\u7981\u7528", (String)"PbdBidAppDisableService_4", (String)"scm-pbd-mservice", (Object[])new Object[0]));
            return true;
        }
        this.disableApp(BID_APP_ID, pProcessInfo, "BID");
        this.disableApp(TEN_APP_ID, pProcessInfo, "TEN");
        return true;
    }

    private boolean hasBidData(String dbKey) {
        String bidSql = "select fid from t_bid_project";
        DBRoute dbRoute = new DBRoute(dbKey);
        try (DataSet ds = DB.queryDataSet((String)"PbdBidAppDisableService.beforeExecuteUnEqulesSqlWithResult", (DBRoute)dbRoute, (String)bidSql, null);){
            boolean bl = !ds.isEmpty();
            return bl;
        }
    }

    private void disableApp(String bizAppId, StringBuilder pProcessInfo, String appNumber) {
        try {
            AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
            metadata.getAppElement().setDeployStatus("1");
            AppWriter appWrite = new AppWriter();
            Map result = appWrite.save(metadata);
            if ("true".equalsIgnoreCase(result.get("success").toString())) {
                PermissionServiceHelper.clearAllUserAppCache();
            }
        }
        catch (Exception e) {
            pProcessInfo.append(ResManager.loadKDString((String)"\u5e94\u7528", (String)"PbdBidAppDisableService_5", (String)"scm-pbd-mservice", (Object[])new Object[0])).append(appNumber).append(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (String)"PbdBidAppDisableService_6", (String)"scm-pbd-mservice", (Object[])new Object[0])).append(ExceptionUtil.wrapExceptionErrorInfo((Throwable)e));
        }
        pProcessInfo.append(ResManager.loadKDString((String)"\u5e94\u7528", (String)"PbdBidAppDisableService_5", (String)"scm-pbd-mservice", (Object[])new Object[0])).append(appNumber).append(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"PbdBidAppDisableService_7", (String)"scm-pbd-mservice", (Object[])new Object[0]));
    }
}

