/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.product.ICoreProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class PbdSwParamUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(PbdSwParamUpgradeService.class);
    private static final String[] LICGROUP = new String[]{"PRO_SC", "PRO_SRM", "PRO_PMAL", "PRO_ADM", "PRO_QUO", "PRO_TND"};
    private static final String PARAM_KEY = "enable_sw";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder resultMsg = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u5347\u7ea7\u542f\u7528\u4f9b\u5e94\u5546\u5de5\u4f5c\u53f0\u53c2\u6570", (String)"PbdSwParamUpgradeService_0", (String)"scm-pbd-mservice", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(dbKey, resultMsg);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(resultMsg.toString());
            }
            result.setLog(resultMsg.append(ResManager.loadKDString((String)"\u5347\u7ea7\u542f\u7528\u4f9b\u5e94\u5546\u5de5\u4f5c\u53f0\u53c2\u6570\u5b8c\u6bd5", (String)"PbdSwParamUpgradeService_1", (String)"scm-pbd-mservice", (Object[])new Object[0])).toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(resultMsg.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u5347\u7ea7\u542f\u7528\u4f9b\u5e94\u5546\u5de5\u4f5c\u53f0\u53c2\u6570\u6267\u884c\u5f02\u5e38", (String)"PbdSwParamUpgradeService_2", (String)"scm-pbd-mservice", (Object[])new Object[0]);
            logger.error(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    public boolean upgrade(String dbKey, StringBuilder pProcessInfo) {
        boolean hasLic = false;
        for (String licKey : LICGROUP) {
            if (!LicenseServiceHelper.checkGroup((String)licKey).getHasLicense().booleanValue()) continue;
            hasLic = true;
            break;
        }
        if (!hasLic) {
            pProcessInfo.append(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u4f9b\u5e94\u5546\u534f\u540c\u4e91\u76f8\u5173\u8bb8\u53ef\uff0c\u65e0\u9700\u6267\u884c\u53c2\u6570\u5347\u7ea7", (String)"PbdSwParamUpgradeService_3", (String)"scm-pbd-mservice", (Object[])new Object[0]));
            return true;
        }
        if (this.hasSupplierUserData("sys")) {
            pProcessInfo.append(ResManager.loadKDString((String)"\u5b58\u5728\u4f9b\u5e94\u5546\u7528\u6237\uff0c\u65e0\u9700\u6267\u884c\u53c2\u6570\u5347\u7ea7", (String)"PbdSwParamUpgradeService_4", (String)"scm-pbd-mservice", (Object[])new Object[0]));
            return true;
        }
        Long orgId = 100000L;
        try {
            orgId = OrgUnitServiceHelper.getRootOrgId();
        }
        catch (Exception e) {
            pProcessInfo.append(ResManager.loadKDString((String)"\u83b7\u53d6\u6839\u7ec4\u7ec7\u5931\u8d25\uff0c\u9ed8\u8ba4\u8bbe\u7f6e\u4e3aID\u4e3a100000\u7684\u6839\u7ec4\u7ec7", (String)"PbdSwParamUpgradeService_5", (String)"scm-pbd-mservice", (Object[])new Object[0]));
        }
        try {
            this.updateByService(pProcessInfo, orgId);
        }
        catch (Exception e) {
            pProcessInfo.append(ResManager.loadKDString((String)"\u901a\u8fc7\u670d\u52a1\u5347\u7ea7\u4f9b\u5e94\u5546\u5de5\u4f5c\u53f0\u53c2\u6570\u5931\u8d25\uff0c\u5f00\u59cb\u6267\u884c\u811a\u672c\u5347\u7ea7", (String)"PbdSwParamUpgradeService_6", (String)"scm-pbd-mservice", (Object[])new Object[0]));
            this.updateBySql(orgId);
        }
        return true;
    }

    private void updateByService(StringBuilder pProcessInfo, Long orgId) {
        AppParam appParam = new AppParam();
        appParam.setViewType("15");
        appParam.setOrgId(orgId);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"pbd");
        appParam.setAppId(appInfo.getId());
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(2);
        params.put(PARAM_KEY, true);
        SystemParamServiceHelper.saveAppParameter((AppParam)appParam, params);
    }

    private void updateBySql(Long orgId) {
        DBRoute dbRoute = new DBRoute("sys");
        String sql = "SELECT fid,FDATA FROM T_BAS_SYSPARAMETER WHERE  FORGID = ? AND FPARAMID= '3R9L2XHTHUAZ' AND FVIEWTYPEID = '15' ";
        try (DataSet ds = DB.queryDataSet((String)"PbdSwParamUpgradeService.updateBySql", (DBRoute)dbRoute, (String)sql, (Object[])new Object[]{orgId});){
            if (ds.hasNext()) {
                Row row = ds.next();
                String id = row.getString("fid");
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)row.getString("FDATA"), Map.class);
                dataMap.put(PARAM_KEY, true);
                String updatesql = "UPDATE T_BAS_SYSPARAMETER SET FDATA = ? WHERE  FID = ? ";
                DB.execute((DBRoute)dbRoute, (String)updatesql, (Object[])new Object[]{SerializationUtils.toJsonString((Object)dataMap), id});
                ICoreProductSettingService settingService = (ICoreProductSettingService)ServiceFactory.getService(ICoreProductSettingService.class);
                settingService.clearAllCache();
            }
        }
    }

    private boolean hasSupplierUserData(String dbKey) {
        String sql = "SELECT 1 FROM T_SEC_BIZPARTNERUSER WHERE FUSERTYPE = '3'";
        DBRoute dbRoute = new DBRoute(dbKey);
        try (DataSet ds = DB.queryDataSet((String)"PbdSwParamUpgradeService.hasSupplierUserData", (DBRoute)dbRoute, (String)sql, null);){
            boolean bl = !ds.isEmpty();
            return bl;
        }
    }
}

