/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.credit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scm.pbd.common.entity.PbdServiceCalllogEntity;
import kd.scm.pbd.common.entity.ProgrammeParserModel;
import kd.scm.pbd.common.entity.TycMonitorDto;
import kd.scm.pbd.common.helper.PbdProgrammeParserHelper;
import kd.scm.pbd.common.helper.PbdServiceHandlerHelper;
import kd.scm.pbd.common.helper.PbdServiceRuleMappingHelper;
import kd.scm.pbd.common.helper.PbdStandardApiMapperHelper;
import kd.scm.pbd.common.utils.PbdBussinessInfoUtils;
import kd.scm.pbd.common.utils.PbdServiceCalllogUtils;
import kd.scm.pbd.service.IBusinessRulesService;
import kd.scm.pbd.service.credit.CallBackApiServiceHelper;
import kd.scm.pbd.service.credit.StandardApiService;

public class BusinessRulesServiceImpl
implements IBusinessRulesService {
    private static final ThreadPool workerThreadPool;
    private static Log log;

    public Object process(Long orgId, String billname, String operator, DynamicObject dy) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        try {
            Map parseMap = PbdProgrammeParserHelper.parse((Long)orgId, (String)billname, (String)operator, (String)"A");
            if (CollectionUtils.isEmpty((Map)parseMap)) {
                String message = ResManager.loadKDString((String)"\u672a\u542f\u7528\u4e1a\u52a1\u8c03\u7528\u65b9\u6848\u6216\u65b9\u6848\u4e2d\u672a\u914d\u7f6e\u6821\u9a8c\u7c7b\u63a5\u53e3\uff0c\u8bf7\u901a\u8fc7\u5916\u90e8\u6570\u636e\u5bf9\u63a5\u914d\u7f6e\u6a21\u5757\u914d\u7f6e\u540e\u67e5\u8be2\u3002", (String)"BusinessRulesServiceImpl_4", (String)"scm-pbd-mservice", (Object[])new Object[0]);
                this.setResult(result, false, 0, message);
                return result;
            }
            log.info("\u8c03\u7528\u98ce\u9669\u5927\u6570\u636e\u63a5\u53e3,\u8c03\u7528\u6821\u9a8c\u7c7b\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u8fd4\u56deparseMap={}", (Object)SerializationUtils.toJsonString((Object)parseMap));
            if (dy == null) {
                this.setResult(result, false, null, "params error");
                return result;
            }
            List<Object> doExeResults = this.doExeBusinessRules(orgId, dy, parseMap);
            this.buildResult(result, doExeResults);
            return result;
        }
        catch (Exception e) {
            this.setResult(result, false, 0, e.getMessage());
            return result;
        }
    }

    public Object query(Long orgId, String billname, String operator, DynamicObject dy) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        try {
            Map parseMap = PbdProgrammeParserHelper.parse((Long)orgId, (String)billname, (String)operator, (String)"E");
            if (CollectionUtils.isEmpty((Map)parseMap)) {
                String message = ResManager.loadKDString((String)"\u672a\u542f\u7528\u4e1a\u52a1\u8c03\u7528\u65b9\u6848\u6216\u65b9\u6848\u4e2d\u672a\u914d\u7f6e\u67e5\u8be2\u7c7b\u63a5\u53e3\uff0c\u8bf7\u901a\u8fc7\u5916\u90e8\u6570\u636e\u5bf9\u63a5\u914d\u7f6e\u6a21\u5757\u914d\u7f6e\u540e\u67e5\u8be2\u3002", (String)"BusinessRulesServiceImpl_5", (String)"scm-pbd-mservice", (Object[])new Object[0]);
                this.setResult(result, false, 0, message);
                return result;
            }
            log.info("\u8c03\u7528\u98ce\u9669\u5927\u6570\u636e\u63a5\u53e3,\u8c03\u7528\u67e5\u8be2\u65b9\u6848\u914d\u7f6e\u8fd4\u56deparseMap={}", (Object)SerializationUtils.toJsonString((Object)parseMap));
            if (dy == null) {
                this.setResult(result, false, null, "params error");
                return result;
            }
            List<Object> doExeResults = this.doExeBusinessRules(orgId, dy, parseMap);
            this.buildResult(result, doExeResults);
            return result;
        }
        catch (Exception e) {
            this.setResult(result, false, 0, e.getMessage());
            return result;
        }
    }

    public Object input(Long orgId, String billname, String operator, DynamicObject dy) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        try {
            Map parseMap = PbdProgrammeParserHelper.parse((Long)orgId, (String)billname, (String)operator, (String)"B");
            if (CollectionUtils.isEmpty((Map)parseMap)) {
                String message = ResManager.loadKDString((String)"\u672a\u542f\u7528\u4e1a\u52a1\u8c03\u7528\u65b9\u6848\u6216\u65b9\u6848\u4e2d\u672a\u914d\u7f6e\u586b\u5145\u7c7b\u63a5\u53e3\uff0c\u8bf7\u901a\u8fc7\u5916\u90e8\u6570\u636e\u5bf9\u63a5\u914d\u7f6e\u6a21\u5757\u914d\u7f6e\u540e\u67e5\u8be2\u3002", (String)"BusinessRulesServiceImpl_3", (String)"scm-pbd-mservice", (Object[])new Object[0]);
                this.setResult(result, false, 0, message);
                return result;
            }
            log.info("\u8c03\u7528\u98ce\u9669\u5927\u6570\u636e\u63a5\u53e3,\u8c03\u7528\u586b\u5145\u7c7b\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u8fd4\u56deparseMap={}", (Object)SerializationUtils.toJsonString((Object)parseMap));
            if (dy == null) {
                this.setResult(result, false, null, "params error");
                return result;
            }
            List<Object> doExeResults = this.doExeBusinessRules(orgId, dy, parseMap);
            this.buildResult(result, doExeResults);
            if (result.containsKey("data")) {
                result.remove("data");
            }
            result.put("data", dy);
            return result;
        }
        catch (Exception e) {
            this.setResult(result, false, 0, e.getMessage());
            return result;
        }
    }

    private void buildResult(Map<String, Object> result, List<Object> doExeResults) {
        Boolean isSuccess = true;
        String message = "OK";
        ArrayList listData = new ArrayList();
        for (Object doExeResult : doExeResults) {
            Map subResult = (Map)doExeResult;
            Object success = subResult.get("success");
            if (success == null || success.equals(false)) {
                isSuccess = false;
                message = subResult.get("message");
                break;
            }
            Object data = subResult.get("data");
            listData.add(data);
            result.put("data", data);
            Object sysnumber = subResult.get("sysnumber");
            if (sysnumber == null) continue;
            result.put("sysnumber", sysnumber);
        }
        if (doExeResults != null && doExeResults.size() > 1) {
            result.put("data", listData);
        }
        this.setResult(result, isSuccess, null, String.valueOf(message));
    }

    public Object load(Long orgId, String billname, String operator, DynamicObject dy) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        HashSet entityKeys = new HashSet(8);
        HashMap dataResult = new HashMap(8);
        Boolean isBillView = false;
        Boolean isSuccess = true;
        String message = "OK";
        try {
            Map parseMap = PbdProgrammeParserHelper.parse((Long)orgId, (String)billname, (String)operator, (String)"C");
            if (CollectionUtils.isEmpty((Map)parseMap)) {
                String msg = ResManager.loadKDString((String)"\u672a\u542f\u7528\u4e1a\u52a1\u8c03\u7528\u65b9\u6848\u6216\u65b9\u6848\u4e2d\u672a\u914d\u7f6e\u5c55\u793a\u7c7b\u63a5\u53e3\uff0c\u8bf7\u901a\u8fc7\u5916\u90e8\u6570\u636e\u5bf9\u63a5\u914d\u7f6e\u6a21\u5757\u914d\u7f6e\u540e\u67e5\u8be2\u3002", (String)"BusinessRulesServiceImpl_2", (String)"scm-pbd-mservice", (Object[])new Object[0]);
                this.setResult(result, false, 0, msg);
                return result;
            }
            log.info("\u8c03\u7528\u98ce\u9669\u5927\u6570\u636e\u63a5\u53e3,\u8c03\u7528\u5c55\u793a\u7c7b\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u8fd4\u56deparseMap={}", (Object)SerializationUtils.toJsonString((Object)parseMap));
            if (dy == null) {
                String msg = ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\u3002", (String)"BusinessRulesServiceImpl_1", (String)"scm-pbd-mservice", (Object[])new Object[0]);
                this.setResult(result, false, 0, msg);
                return result;
            }
            Object data = null;
            List<Object> doExeResults = this.doExeBusinessRules(orgId, dy, parseMap);
            HashMap pkidMaps = new HashMap(8);
            HashMap<String, Set> entitykeyMaps = new HashMap<String, Set>(8);
            for (Object doExeResult : doExeResults) {
                Object entityKeys0;
                Object standardBillKeyObj;
                Map subResult = (Map)doExeResult;
                Object success = subResult.get("success");
                if (success == null || success.equals(false)) {
                    isSuccess = false;
                    message = subResult.get("message");
                    break;
                }
                data = subResult.get("data");
                if (data == null) continue;
                Map map = data;
                Object pkidObj = map.get("pkid");
                if (pkidObj != null) {
                    dataResult.put("pkid", pkidObj);
                }
                if ((standardBillKeyObj = map.get("standardBillKey")) != null && pkidObj != null) {
                    pkidMaps.put(standardBillKeyObj.toString(), pkidObj);
                }
                if ((entityKeys0 = map.get("entityKeys")) != null) {
                    Object isBillViewObj;
                    List subEntityKeys = (List)entityKeys0;
                    entityKeys.addAll(subEntityKeys);
                    String billKey = (String)subEntityKeys.get(0);
                    if (subEntityKeys.size() == 1 && "bill".equals(billKey)) {
                        isBillView = true;
                    }
                    if ((isBillViewObj = map.get("isBillView")) != null && isBillViewObj.equals(true)) {
                        isBillView = true;
                    }
                }
                if (standardBillKeyObj == null || entityKeys0 == null) continue;
                String standardBillKey = standardBillKeyObj.toString();
                Object entityKeyList = entitykeyMaps.get(standardBillKey);
                List subEntityKeys = (List)entityKeys0;
                if (entityKeyList != null) {
                    Set entityKeyOld = (Set)entityKeyList;
                    entityKeyOld.addAll(subEntityKeys);
                    entitykeyMaps.put(standardBillKey, entityKeyOld);
                    continue;
                }
                HashSet entityKeyNew = new HashSet(8);
                entityKeyNew.addAll(subEntityKeys);
                entitykeyMaps.put(standardBillKey, entityKeyNew);
            }
            HashMap<String, Boolean> isBillViewMaps = new HashMap<String, Boolean>(8);
            for (Map.Entry entry : entitykeyMaps.entrySet()) {
                Boolean isBillViewNew = false;
                Set subEntityKeys = (Set)entry.getValue();
                String key = (String)entry.getKey();
                String billKey = (String)subEntityKeys.iterator().next();
                if (subEntityKeys.size() == 1 && "bill".equals(billKey)) {
                    isBillViewNew = true;
                }
                isBillViewMaps.put(key, isBillViewNew);
            }
            dataResult.put("isBillViewMap", isBillViewMaps);
            dataResult.put("billkeyMap", pkidMaps);
            dataResult.put("entitykeyMap", entitykeyMaps);
        }
        catch (Exception e) {
            this.setResult(result, false, 0, e.getMessage());
            return result;
        }
        dataResult.put("entityKeys", entityKeys);
        dataResult.put("isBillView", isBillView);
        result.put("data", dataResult);
        this.setResult(result, isSuccess, null, String.valueOf(message));
        log.info("\u8c03\u7528\u98ce\u9669\u5927\u6570\u636e\u63a5\u53e3,\u8fd4\u56deresult={}", (Object)SerializationUtils.toJsonString(result));
        return result;
    }

    public Object loadBusinessInfos(Long orgId, List<String> billnames, String operator, DynamicObject dy) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        try {
            String billname;
            Map parseMap = new HashMap(8);
            Iterator<String> iterator = billnames.iterator();
            while (iterator.hasNext() && CollectionUtils.isEmpty(parseMap = PbdProgrammeParserHelper.parse((Long)orgId, (String)(billname = iterator.next()), (String)operator, (String)"B"))) {
            }
            if (CollectionUtils.isEmpty(parseMap)) {
                String msg = ResManager.loadKDString((String)"\u672a\u542f\u7528\u4e1a\u52a1\u8c03\u7528\u65b9\u6848\u6216\u65b9\u6848\u4e2d\u672a\u914d\u7f6e\u586b\u5145\u7c7b\u63a5\u53e3\uff0c\u8bf7\u901a\u8fc7\u5916\u90e8\u6570\u636e\u5bf9\u63a5\u914d\u7f6e\u6a21\u5757\u914d\u7f6e\u540e\u67e5\u8be2\u3002", (String)"BusinessRulesServiceImpl_3", (String)"scm-pbd-mservice", (Object[])new Object[0]);
                this.setResult(result, false, 0, msg);
                return result;
            }
            Set entrySet = parseMap.entrySet();
            Map.Entry next = entrySet.iterator().next();
            ProgrammeParserModel model0 = (ProgrammeParserModel)next.getValue();
            DynamicObject standardDy = model0.getLoadSingleStandardapi();
            Long entryEntityId = model0.getStandardEntryEntityId();
            List inputMapping = PbdServiceRuleMappingHelper.inputMapping((DynamicObject)dy, (ProgrammeParserModel)model0, (DynamicObject)standardDy, (Long)entryEntityId);
            log.info("inputMapping={}", (Object)SerializationUtils.toJsonString((Object)inputMapping));
            String standardBillKey = model0.getStandardBillKey();
            List entityKeys = model0.getStandardEntityKeys();
            DynamicObject load = PbdBussinessInfoUtils.loadByDB((List)inputMapping, (Integer)-1, (String)standardBillKey, (List)entityKeys);
            if (load == null) {
                this.setResult(result, false, 0, "query no data");
                return result;
            }
            HashMap data = new HashMap(8);
            for (Map.Entry entry : entrySet) {
                Long key = (Long)entry.getKey();
                TraceSpan create = Tracer.create((String)"BusinessRulesServiceImpl.doExeBusinessRules", (String)String.valueOf(key));
                Throwable throwable = null;
                try {
                    ProgrammeParserModel model = (ProgrammeParserModel)entry.getValue();
                    standardDy = model.getLoadSingleStandardapi();
                    entryEntityId = model.getStandardEntryEntityId();
                    List outputMapping = PbdServiceRuleMappingHelper.outputMapping((DynamicObject)dy, (ProgrammeParserModel)model, (DynamicObject)standardDy, (Long)entryEntityId);
                    log.info("outputMapping={}", (Object)SerializationUtils.toJsonString((Object)outputMapping));
                    Map standardResult = PbdStandardApiMapperHelper.parseDyToObjectResult((DynamicObject)load, (ProgrammeParserModel)model, (List)outputMapping);
                    Map targetResult = PbdServiceHandlerHelper.parseResultToTargetBillKey((List)outputMapping, (Object)standardResult);
                    data.putAll(targetResult);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (create == null) continue;
                    if (throwable != null) {
                        try {
                            create.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    create.close();
                }
            }
            this.setResult(result, true, null, null);
            result.put("data", data);
            return result;
        }
        catch (Exception e) {
            this.setResult(result, false, 0, e.getMessage());
            return result;
        }
    }

    private void setResult(Map<String, Object> result, Boolean isSuccess, Integer code, String msg) {
        result.put("success", isSuccess);
        result.put("code", code);
        result.put("message", msg);
    }

    private List<Object> doExeBusinessRules(Long orgId, DynamicObject dy, Map<Long, ProgrammeParserModel> parseMap) throws Exception {
        Long key;
        ArrayList<Object> doExeResults = new ArrayList<Object>(8);
        Set<Map.Entry<Long, ProgrammeParserModel>> entrySet = parseMap.entrySet();
        ProgrammeParserModel model0 = null;
        Long entityKey = null;
        Optional<Map.Entry> findAny = entrySet.stream().filter(t -> ((ProgrammeParserModel)t.getValue()).getSyssourceNumber().contains("KD_KingdeeCloud") && ((ProgrammeParserModel)t.getValue()).getPlatformApiNumber().equalsIgnoreCase("SRM_KD_CLOUD_GETCOMPANYINFO")).findFirst();
        if (findAny.isPresent()) {
            model0 = (ProgrammeParserModel)findAny.get().getValue();
            entityKey = (Long)findAny.get().getKey();
        } else {
            Map.Entry<Long, ProgrammeParserModel> next = entrySet.iterator().next();
            model0 = next.getValue();
            entityKey = next.getKey();
        }
        HashMap<Long, DynamicObject> callLogMap = new HashMap<Long, DynamicObject>(8);
        TraceSpan create = Tracer.create((String)"BusinessRulesServiceImpl.doExeBusinessRules", (String)String.valueOf(entityKey));
        Iterator iterator = null;
        try {
            StandardApiService standardApiService = new StandardApiService(model0, dy, orgId);
            Object doExeResult0 = standardApiService.doExeBusinessRules();
            log.info("entityId={},doExeResult0={}", (Object)entityKey, doExeResult0);
            doExeResults.add(doExeResult0);
            this.setCallLogMap(model0, callLogMap, doExeResult0);
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (create != null) {
                if (iterator != null) {
                    try {
                        create.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    create.close();
                }
            }
        }
        HashMap<Long, Future> resultMap = new HashMap<Long, Future>(8);
        for (Map.Entry entry : entrySet) {
            key = (Long)entry.getKey();
            if (key.equals(entityKey)) continue;
            TraceSpan create2 = Tracer.create((String)"BusinessRulesServiceImpl.doExeBusinessRules", (String)String.valueOf(entityKey));
            Throwable throwable = null;
            try {
                ProgrammeParserModel model = (ProgrammeParserModel)entry.getValue();
                StandardApiService standardApiService = new StandardApiService(model, dy, orgId);
                Future submit = workerThreadPool.submit((Callable)standardApiService);
                resultMap.put(key, submit);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (create2 == null) continue;
                if (throwable != null) {
                    try {
                        create2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                create2.close();
            }
        }
        for (Map.Entry entry : resultMap.entrySet()) {
            key = (Long)entry.getKey();
            ProgrammeParserModel model = parseMap.get(key);
            Object standardResult = ((Future)entry.getValue()).get();
            log.info("entityId={},doExeResult0={}", (Object)entityKey, standardResult);
            doExeResults.add(standardResult);
            this.setCallLogMap(model, callLogMap, standardResult);
        }
        if (!CollectionUtils.isEmpty(callLogMap)) {
            DynamicObject[] dys = callLogMap.values().toArray(new DynamicObject[callLogMap.size()]);
            SaveServiceHelper.save((DynamicObject[])dys);
        }
        return doExeResults;
    }

    private void setCallLogMap(ProgrammeParserModel model, Map<Long, DynamicObject> callLogMap, Object doExeResult) {
        try {
            Long id = model.getId();
            Map subResult = (Map)doExeResult;
            PbdServiceCalllogEntity calllogEntity0 = (PbdServiceCalllogEntity)subResult.get("calllogEntity");
            DynamicObject callLog = callLogMap.get(id);
            DynamicObject buildCallLog = PbdServiceCalllogUtils.buildCallLog((ProgrammeParserModel)model, (DynamicObject)callLog, (PbdServiceCalllogEntity)calllogEntity0);
            callLogMap.put(id, buildCallLog);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callback(Long orgId, String billname, String operator, String monitorStr) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        HashMap<Long, DynamicObject> callLogMap = new HashMap<Long, DynamicObject>(8);
        try {
            Map parseMap = PbdProgrammeParserHelper.parse((Long)orgId, (String)billname, (String)operator, (String)"D");
            String msg = ResManager.loadKDString((String)"\u672a\u542f\u7528\u4e1a\u52a1\u8c03\u7528\u65b9\u6848\u6216\u65b9\u6848\u4e2d\u672a\u914d\u7f6e\u56de\u8c03\u7c7b\u63a5\u53e3\uff0c\u8bf7\u901a\u8fc7\u5916\u90e8\u6570\u636e\u5bf9\u63a5\u914d\u7f6e\u6a21\u5757\u914d\u7f6e\u540e\u8c03\u7528\u3002", (String)"BusinessRulesServiceImpl_6", (String)"scm-pbd-mservice", (Object[])new Object[0]);
            if (CollectionUtils.isEmpty((Map)parseMap)) {
                this.setResult(result, false, 0, msg);
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            log.info("\u8c03\u7528\u98ce\u9669\u5927\u6570\u636e\u63a5\u53e3,\u8c03\u7528\u56de\u8c03\u7c7b\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u8fd4\u56deparseMap={}", (Object)SerializationUtils.toJsonString((Object)parseMap));
            if (StringUtils.isBlank((String)monitorStr)) {
                this.setResult(result, false, 0, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\u3002", (String)"BusinessRulesServiceImpl_1", (String)"scm-pbd-mservice", (Object[])new Object[0]));
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            ProgrammeParserModel model = null;
            TycMonitorDto dto = (TycMonitorDto)SerializationUtils.fromJsonString((String)monitorStr, TycMonitorDto.class);
            Integer type = dto.getType();
            String changeTablename = dto.getTypeName();
            model = this.matchProgrammeParseModelByApiType(parseMap, changeTablename, type);
            if (model == null || dto == null) {
                this.setResult(result, false, 0, msg);
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            HashMap<String, PbdServiceCalllogEntity> subResult = new HashMap<String, PbdServiceCalllogEntity>(8);
            PbdServiceCalllogEntity calllogEntity = PbdServiceCalllogUtils.buildPbdServiceCalllogEntity((Long)model.getStandardapi(), (Long)model.getPlatformapi(), (String)"A", null, (Object)dto);
            subResult.put("calllogEntity", calllogEntity);
            this.setCallLogMap(model, callLogMap, subResult);
            CallBackApiServiceHelper.saveCallBackData(orgId, dto, model);
            this.setResult(result, true, null, null);
        }
        finally {
            if (!CollectionUtils.isEmpty(callLogMap)) {
                DynamicObject[] dys = callLogMap.values().toArray(new DynamicObject[callLogMap.size()]);
                SaveServiceHelper.save((DynamicObject[])dys);
            }
        }
        return result;
    }

    private ProgrammeParserModel matchProgrammeParseModelByApiType(Map<Long, ProgrammeParserModel> parseMap, String changeTablename, Integer type) {
        ProgrammeParserModel model = null;
        for (Map.Entry<Long, ProgrammeParserModel> entry : parseMap.entrySet()) {
            Integer parseplatformApiFullNameInt;
            ProgrammeParserModel value = entry.getValue();
            if (StringUtils.isNotEmpty((String)changeTablename)) {
                String platformApiName = value.getPlatformApiName();
                if (StringUtils.isBlank((String)platformApiName) || !changeTablename.equals(platformApiName)) continue;
                model = value;
                break;
            }
            String platformApiFullName = value.getPlatformApiFullName();
            if (StringUtils.isBlank((String)platformApiFullName) || !type.equals(parseplatformApiFullNameInt = this.getPlatformApiType(platformApiFullName))) continue;
            model = value;
            break;
        }
        return model;
    }

    private Integer getPlatformApiType(String platformApiFullName) {
        Integer parseplatformApiFullNameInt = -1;
        try {
            parseplatformApiFullNameInt = Integer.parseInt(platformApiFullName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parseplatformApiFullNameInt;
    }

    static {
        int count;
        log = LogFactory.getLog(BusinessRulesServiceImpl.class);
        try {
            count = Integer.parseInt(System.getProperty("SCM_CREDIT_QEURY_TASK_THREADS"));
            if (count <= 0) {
                count = 32;
            }
        }
        catch (Exception var2) {
            count = 32;
        }
        workerThreadPool = ThreadPools.newCachedThreadPool((String)"SCM_CREDIT_QEURY_TASK_WORKER", (int)0, (int)count);
    }
}

