/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.credit;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.scm.common.util.CodeRuleUtil;
import kd.scm.pbd.common.entity.FieldProp;
import kd.scm.pbd.common.entity.ParseFieldMapping;
import kd.scm.pbd.common.entity.PluginModel;
import kd.scm.pbd.common.entity.ProgrammeParserModel;
import kd.scm.pbd.common.entity.TycMonitorDto;
import kd.scm.pbd.common.helper.PbdServiceHandlerHelper;
import kd.scm.pbd.common.helper.PbdServiceRuleMappingHelper;
import kd.scm.pbd.common.helper.PbdStandardApiMapperHelper;
import kd.scm.pbd.common.utils.PbdBussinessInfoUtils;
import kd.sdk.scm.pbd.extpoint.IBusinessRulesCallBackService;

public class CallBackApiServiceHelper {
    private static Log log = LogFactory.getLog(CallBackApiServiceHelper.class);
    private static final String TARGET = "target";
    private static final String SOURCE = "source";

    public static void saveCallBackData(Long orgId, TycMonitorDto dto, ProgrammeParserModel model) {
        DynamicObject standardDy = model.getLoadSingleStandardapi();
        Long entryEntityId = model.getStandardEntryEntityId();
        if (standardDy == null || entryEntityId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u6807\u51c6\u63a5\u53e3\u3002", (String)"CallBackApiServiceHelper_1", (String)"scm-pbd-mservice", (Object[])new Object[0]));
        }
        List inputMapping = PbdServiceRuleMappingHelper.inputMapping(null, (ProgrammeParserModel)model, (DynamicObject)standardDy, (Long)entryEntityId);
        log.info("inputMapping={}", (Object)SerializationUtils.toJsonString((Object)inputMapping));
        List outputMapping = PbdServiceRuleMappingHelper.outputMapping(null, (ProgrammeParserModel)model, (DynamicObject)standardDy, (Long)entryEntityId);
        log.info("outputMapping={}", (Object)SerializationUtils.toJsonString((Object)outputMapping));
        Map<String, List<Map<String, Object>>> groupbyCompanyName = CallBackApiServiceHelper.groupbyCompanyName(dto.getItems());
        for (Map.Entry<String, List<Map<String, Object>>> entry : groupbyCompanyName.entrySet()) {
            String companyName = entry.getKey();
            String standardBillKey = model.getStandardBillKey();
            CallBackApiServiceHelper.buildInputMappingValue(inputMapping, companyName);
            QFilter qf = CallBackApiServiceHelper.buildQFilter(inputMapping, SOURCE);
            qf.and("monitorstatus", "=", (Object)"B");
            DynamicObject load = BusinessDataServiceHelper.loadSingle((String)standardBillKey, (QFilter[])new QFilter[]{qf});
            if (load == null) continue;
            List<Map<String, Object>> value = entry.getValue();
            CallBackApiServiceHelper.setTotal(model, load, value, dto);
            Object standardObject = PbdStandardApiMapperHelper.parseResultToStandardBillKey((ProgrammeParserModel)model, (List)outputMapping, value);
            ArrayList plugins = new ArrayList(8);
            List pluginPolicyField = model.getPluginPolicyField();
            if (!CollectionUtils.isEmpty((Collection)pluginPolicyField)) {
                plugins.addAll(pluginPolicyField);
            }
            for (PluginModel plugin : plugins) {
                IBusinessRulesCallBackService requestPlugin = null;
                try {
                    Class<?> pluginClass = CallBackApiServiceHelper.getPluginClass(plugin);
                    Object newInstance = pluginClass.newInstance();
                    if (!(newInstance instanceof IBusinessRulesCallBackService)) continue;
                    requestPlugin = (IBusinessRulesCallBackService)newInstance;
                    standardObject = requestPlugin.adapterByResult(standardObject);
                }
                catch (Exception e) {
                    log.warn((Throwable)e);
                    throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8c03\u7528\u63d2\u4ef6\u5f02\u5e38\uff1a%s\u3002", (String)"StandardApiService_7", (String)"scm-pbd-mservice", (Object[])new Object[0]), (String)"StandardApiService_7", (String)"scm-pbd-mservice", (Object[])new Object[]{e.getMessage()}));
                }
            }
            List entityKeyList = model.getStandardEntityKeys();
            CallBackApiServiceHelper.triggerEventSubscribe(companyName, standardObject, entityKeyList, model, dto);
            load = PbdStandardApiMapperHelper.parseResultToStandardDy((DynamicObject)load, (ProgrammeParserModel)model, (List)inputMapping, (List)outputMapping, (Object)standardObject, (Long)orgId);
            DynamicObject dy = CallBackApiServiceHelper.createBillEntity(orgId, model, inputMapping, companyName);
            if (dy == null) continue;
            PbdServiceHandlerHelper.fieldMappingToDy((DynamicObject)dy, (Object)standardObject, (List)outputMapping, (String)model.getApipurpose());
            PbdBussinessInfoUtils.save((DynamicObject)dy);
        }
    }

    private static void triggerEventSubscribe(String companyName, Object standardObject, List<String> entityKeyList, ProgrammeParserModel model, TycMonitorDto dto) {
        try {
            DynamicObject standardDy = model.getLoadSingleStandardapi();
            Long entryEntityId = model.getStandardEntryEntityId();
            DynamicObjectCollection entityDys = standardDy.getDynamicObjectCollection("outputsentity");
            List fieldList = PbdStandardApiMapperHelper.transforOutputDyToObject((Long)entryEntityId, (DynamicObjectCollection)entityDys);
            HashMap<String, Object> param = new HashMap<String, Object>(8);
            param.put("suppliername", companyName);
            param.put("changeType", dto.getChangeType());
            param.put("changeFields", dto.getChangeFields());
            if (standardObject instanceof Map) {
                Map map = (Map)standardObject;
                Set entrySet = map.entrySet();
                for (Map.Entry entry1 : entrySet) {
                    String key = (String)entry1.getKey();
                    if (!entityKeyList.contains(key)) continue;
                    Object entryValues = map.get(key);
                    if (entryValues instanceof Map) {
                        Map entryValue = (Map)entryValues;
                        Map<String, Object> resultMap = CallBackApiServiceHelper.parseStandardObjectRemoveOtherKey(fieldList, entryValue);
                        param.put(key, resultMap);
                    } else if (entryValues instanceof List) {
                        ArrayList<Map<String, Object>> resultValue = new ArrayList<Map<String, Object>>(8);
                        List listEntryValue = (List)entryValues;
                        for (Map entryValue : listEntryValue) {
                            Map<String, Object> resultMap = CallBackApiServiceHelper.parseStandardObjectRemoveOtherKey(fieldList, entryValue);
                            resultValue.add(resultMap);
                        }
                        param.put(key, resultValue);
                    }
                    param.put("changeTableCode", key);
                }
            }
            EventServiceHelper.triggerEventSubscribe((String)"srm_pbd_monitor_callback_msg_after_handler", (String)JSON.toJSONString(param));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private static Map<String, Object> parseStandardObjectRemoveOtherKey(List<FieldProp> outputMapping, Map<String, Object> entryValue) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        for (Map.Entry<String, Object> entryMapEntry : entryValue.entrySet()) {
            String propKey = entryMapEntry.getKey();
            Optional<FieldProp> findFirst = outputMapping.stream().filter(out -> propKey.equals(out.getKey())).findFirst();
            if (!findFirst.isPresent()) continue;
            resultMap.put(propKey, entryMapEntry.getValue());
        }
        return resultMap;
    }

    private static Class<?> getPluginClass(PluginModel plugin) {
        String pluginName = plugin.getPlclassname();
        Class<?> pluginClass = null;
        try {
            pluginClass = Class.forName(pluginName);
        }
        catch (ClassNotFoundException e) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u63d2\u4ef6%s\u4e0d\u5b58\u5728\u3002", (String)"StandardApiService_8", (String)"scm-pbd-mservice", (Object[])new Object[0]), (String)"StandardApiService_8", (String)"scm-pbd-mservice", (Object[])new Object[]{pluginName}));
        }
        return pluginClass;
    }

    private static void setTotal(ProgrammeParserModel model, DynamicObject load, List<Map<String, Object>> value, TycMonitorDto dto) {
        List standardEntityKeys = model.getStandardEntityKeys();
        Integer total = dto.getTotal();
        String sysnumber = model.getSyssourceNumber();
        if (sysnumber.contains("QiXinBao")) {
            for (String string : standardEntityKeys) {
                if ("bill".equals(string)) continue;
                if (load.containsProperty(string + "total")) {
                    total = total + load.getInt(string + "total");
                }
                if (!"basicinfo".equals(string)) continue;
                total = total + load.getInt("companytotal");
            }
        }
        for (Object object : value) {
            if (!(object instanceof Map)) continue;
            Map mapApi = (Map)object;
            mapApi.put("total", total);
        }
    }

    private static DynamicObject createBillEntity(Long orgId, ProgrammeParserModel model, List<ParseFieldMapping> inputMapping, String companyName) {
        List outputsfieldmap = model.getOutputsfieldmap();
        List pluginPolicyField = model.getPluginPolicyField();
        if (CollectionUtils.isEmpty((Collection)outputsfieldmap) && CollectionUtils.isEmpty((Collection)pluginPolicyField)) {
            return null;
        }
        QFilter qfTarget = CallBackApiServiceHelper.buildQFilter(inputMapping, TARGET);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)model.getBillentity(), (QFilter[])new QFilter[]{qfTarget});
        if (dy == null) {
            dy = BusinessDataServiceHelper.newDynamicObject((String)model.getBillentity());
            if (dy.containsProperty("org")) {
                dy.set("org", (Object)orgId);
            }
            Long genGlobalLongId = DBServiceHelper.genGlobalLongId();
            dy.set("id", (Object)genGlobalLongId);
            String codeRule = CodeRuleUtil.getCodeRule((String)model.getBillentity());
            dy.set("billno", (Object)codeRule);
            dy.set("billstatus", (Object)"C");
            if (dy.containsProperty("suppliername")) {
                dy.set("suppliername", (Object)companyName);
            }
        }
        return dy;
    }

    private static void buildInputMappingValue(List<ParseFieldMapping> inputMapping, String companyName) {
        for (ParseFieldMapping inputField : inputMapping) {
            inputField.setSourceValue((Object)companyName);
            inputField.setTargetValue((Object)companyName);
        }
    }

    private static QFilter buildQFilter(List<ParseFieldMapping> inputMapping, String type) {
        QFilter qf = new QFilter("billstatus", "=", (Object)"C");
        for (ParseFieldMapping inputField : inputMapping) {
            String fieldtype = inputField.getFieldtype();
            if ("0".equals(fieldtype)) {
                if (SOURCE.equals(type)) {
                    qf.and(inputField.getSourceField(), "=", inputField.getSourceValue());
                    continue;
                }
                qf.and(inputField.getTargetField(), "=", inputField.getTargetValue());
                continue;
            }
            if (!"3".equals(fieldtype)) continue;
            qf.and(inputField.getSourceField(), "=", (Object)inputField.getTargetconstant());
        }
        return qf;
    }

    private static Map<String, List<Map<String, Object>>> groupbyCompanyName(List<Object> items) {
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>(8);
        for (Object obj : items) {
            if (!(obj instanceof Map)) continue;
            Map mapApi = (Map)obj;
            String companyName = (String)mapApi.get("companyName");
            ArrayList<Map> list = (ArrayList<Map>)map.get(companyName);
            if (CollectionUtils.isEmpty((Collection)list)) {
                list = new ArrayList<Map>(8);
            }
            list.add(mapApi);
            map.put(companyName, list);
        }
        return map;
    }
}

