/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.credit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.scm.pbd.common.entity.ParseFieldMapping;
import kd.scm.pbd.common.entity.PbdServiceCalllogEntity;
import kd.scm.pbd.common.entity.PluginModel;
import kd.scm.pbd.common.entity.ProgrammeParserModel;
import kd.scm.pbd.common.helper.PbdApiCallHelper;
import kd.scm.pbd.common.helper.PbdServiceHandlerHelper;
import kd.scm.pbd.common.helper.PbdServiceRuleMappingHelper;
import kd.scm.pbd.common.helper.PbdStandardApiMapperHelper;
import kd.scm.pbd.common.utils.PbdBussinessInfoUtils;
import kd.scm.pbd.common.utils.PbdServiceCalllogUtils;
import kd.sdk.scm.pbd.extpoint.IBusinessRulesCheckParseService;
import kd.sdk.scm.pbd.extpoint.IBusinessRulesFillParseService;
import kd.sdk.scm.pbd.extpoint.IBusinessRulesRequestParseService;

public class StandardApiService
implements Callable<Object> {
    private static final List<String> BaseInfo = Arrays.asList("SCM_QICHACHA_GETINFO", "SRM_TYC_BASEINFO_NORMAL", "SRM_KD_CLOUD_GETCOMPANYINFO", "SCM_QIXINBAO_GETONLINEINFO");
    private static final String LINK_OPENING = "2";
    private static Log log = LogFactory.getLog(StandardApiService.class);
    private ProgrammeParserModel model;
    private DynamicObject dy;
    private Long orgId;

    public StandardApiService(ProgrammeParserModel model, DynamicObject dy, Long orgId) {
        this.model = model;
        this.dy = dy;
        this.orgId = orgId;
    }

    @Override
    public Object call() {
        return this.doExeBusinessRules();
    }

    public Object doExeBusinessRules() {
        try {
            log.info("model={}", (Object)SerializationUtils.toJsonString((Object)this.model));
            String apipurpose = this.model.getApipurpose();
            DynamicObject standardDy = this.model.getLoadSingleStandardapi();
            if (standardDy == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u6807\u51c6\u63a5\u53e3\u3002", (String)"StandardApiService_6", (String)"scm-pbd-mservice", (Object[])new Object[0]));
            }
            Long entryEntityId = this.model.getStandardEntryEntityId();
            if (entryEntityId == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u6807\u51c6\u63a5\u53e3\u3002", (String)"StandardApiService_6", (String)"scm-pbd-mservice", (Object[])new Object[0]));
            }
            List inputMapping = PbdServiceRuleMappingHelper.inputMapping((DynamicObject)this.dy, (ProgrammeParserModel)this.model, (DynamicObject)standardDy, (Long)entryEntityId);
            log.info("inputMapping={}", (Object)SerializationUtils.toJsonString((Object)inputMapping));
            List outputMapping = PbdServiceRuleMappingHelper.outputMapping((DynamicObject)this.dy, (ProgrammeParserModel)this.model, (DynamicObject)standardDy, (Long)entryEntityId);
            log.info("outputMapping={}", (Object)SerializationUtils.toJsonString((Object)outputMapping));
            Integer effectiveness = this.model.getEffectiveness();
            String standardBillKey = this.model.getStandardBillKey();
            List entityKeys = this.model.getStandardEntityKeys();
            DynamicObject load = null;
            if (effectiveness != 0) {
                load = PbdBussinessInfoUtils.loadByDB((List)inputMapping, (Integer)effectiveness, (String)standardBillKey, (List)entityKeys);
            }
            Map<String, Object> params = this.buildCallParams(apipurpose, inputMapping);
            Object standardResult = null;
            String isFree = "A";
            if (load != null) {
                standardResult = PbdStandardApiMapperHelper.parseDyToObjectResult((DynamicObject)load, (ProgrammeParserModel)this.model, (List)outputMapping);
                isFree = "B";
                Object reduceResult = this.reduceResult(apipurpose, outputMapping, load, standardResult, params, isFree);
                return reduceResult;
            }
            String openStatusLink = this.model.getOpenStatusLink();
            if (!LINK_OPENING.equals(openStatusLink)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8fde\u63a5\u7b2c\u4e09\u65b9\u6570\u636e\u5e73\u53f0\uff0c\u8bf7\u901a\u8fc7\u5916\u90e8\u6570\u636e\u5bf9\u63a5\u914d\u7f6e\u6a21\u5757\u914d\u7f6e\u540e\u67e5\u8be2\u3002", (String)"StandardApiService_1", (String)"scm-pbd-mservice", (Object[])new Object[0]));
            }
            log.info("\u8c03\u7528\u96c6\u6210\u4e91\u53c2\u6570SyssourceNumber={},PlatformApiNumber={},params={}", new Object[]{this.model.getSyssourceNumber(), this.model.getPlatformApiNumber(), SerializationUtils.toJsonString(params)});
            Object result = PbdApiCallHelper.call((String)this.model.getContype(), (String)this.model.getSyssourceNumber(), (String)this.model.getPlatformApiNumber(), params);
            log.info("\u8c03\u7528\u96c6\u6210\u4e91\u8fd4\u56deresult={}", (Object)SerializationUtils.toJsonString((Object)result));
            if (result != null) {
                Object standardObject = PbdStandardApiMapperHelper.parseResultToStandardBillKey((ProgrammeParserModel)this.model, (List)outputMapping, (Object)result);
                DynamicObject load0 = PbdBussinessInfoUtils.loadByDB((List)inputMapping, (Integer)-1, (String)standardBillKey, (List)entityKeys);
                load = PbdStandardApiMapperHelper.parseResultToStandardDy((DynamicObject)load0, (ProgrammeParserModel)this.model, (List)inputMapping, (List)outputMapping, (Object)standardObject, (Long)this.orgId);
                standardResult = standardObject;
            }
            Object reduceResult = this.reduceResult(apipurpose, outputMapping, load, standardResult, params, isFree);
            return reduceResult;
        }
        catch (Exception e) {
            log.warn("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            HashMap<String, Object> result = new HashMap<String, Object>(8);
            result.put("success", false);
            result.put("message", e.getMessage());
            this.buildCallLog(e.getMessage(), null, "A", result);
            return result;
        }
    }

    private Map<String, Object> buildCallParams(String apipurpose, List<ParseFieldMapping> inputMapping) {
        Map<String, Object> params = this.buildCallParams(inputMapping);
        Map<String, Object> executeInputPlugin = this.executeInputPlugin(this.dy, this.model, apipurpose);
        log.info("\u8c03\u7528\u63d2\u4ef6\u8fd4\u56de\u53c2\u6570params={}", (Object)SerializationUtils.toJsonString(executeInputPlugin));
        if (!CollectionUtils.isEmpty(executeInputPlugin)) {
            params.putAll(executeInputPlugin);
        }
        if (CollectionUtils.isEmpty(params)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u5bf9\u5e94\u7684\u89c4\u5219\u914d\u7f6e\u4e2d\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u901a\u8fc7\u4e1a\u52a1\u8c03\u7528\u65b9\u6848\u914d\u7f6e\u3002", (String)"StandardApiService_2", (String)"scm-pbd-mservice", (Object[])new Object[0]));
        }
        return params;
    }

    private Object reduceResult(String apipurpose, List<ParseFieldMapping> outputMapping, DynamicObject load, Object standardResult, Map<String, Object> params, String isFree) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        this.buildCallLog(standardResult, params, isFree, result);
        switch (apipurpose) {
            case "B": {
                Map<String, Object> executeOutputPlugin;
                Map resultMapping = PbdServiceHandlerHelper.fieldMappingToDy((DynamicObject)this.dy, (Object)standardResult, outputMapping, (String)this.model.getApipurpose());
                if (!CollectionUtils.isEmpty((Map)resultMapping)) {
                    result.putAll(resultMapping);
                    log.info("\u76ee\u6807\u5b57\u6bb5\u586b\u5145\u8fd4\u56de={}", (Object)SerializationUtils.toJsonString((Object)resultMapping));
                }
                if (CollectionUtils.isEmpty(executeOutputPlugin = this.executeOutputPlugin(this.dy, this.model, apipurpose, standardResult))) break;
                result.putAll(executeOutputPlugin);
                break;
            }
            case "C": {
                HashMap<String, Object> data = new HashMap<String, Object>(8);
                if (load != null) {
                    Object pkValue = load.getPkValue();
                    data.put("pkid", pkValue);
                    data.put("standardBillKey", this.model.getStandardBillKey());
                }
                result.put("success", true);
                String platformApiNumber = this.model.getPlatformApiNumber();
                if (BaseInfo.contains(platformApiNumber)) {
                    data.put("isBillView", true);
                }
                data.put("entityKeys", this.model.getStandardEntityKeys());
                result.put("data", data);
                log.info("\u5c55\u793a\u7c7b\u8fd4\u56de={}", (Object)SerializationUtils.toJsonString(result));
                break;
            }
            case "E": {
                result.put("success", true);
                result.put("data", standardResult);
                result.put("sysnumber", this.model.getSyssourceNumber());
                log.info("\u67e5\u8be2\u7c7b\u8fd4\u56de={}", (Object)SerializationUtils.toJsonString(result));
                break;
            }
            case "A": {
                boolean checkFlag = PbdServiceHandlerHelper.fieldRuleCheckToDy((DynamicObject)this.dy, (Object)standardResult, outputMapping);
                if (!checkFlag) {
                    result.put("success", false);
                    result.put("message", "check error");
                } else {
                    result.put("success", true);
                    result.put("message", "ok");
                }
                log.info("\u76ee\u6807\u5b57\u6bb5\u6620\u5c04checkFlag={}", (Object)SerializationUtils.toJsonString((Object)checkFlag));
                Map<String, Object> executeOutputPluginA = this.executeOutputPlugin(this.dy, this.model, apipurpose, standardResult);
                if (CollectionUtils.isEmpty(executeOutputPluginA)) break;
                result.putAll(executeOutputPluginA);
                break;
            }
            default: {
                result.put("success", false);
                result.put("message", "error apipurpose");
            }
        }
        return result;
    }

    private void buildCallLog(Object standardResult, Map<String, Object> params, String isFree, Map<String, Object> result) {
        try {
            PbdServiceCalllogEntity calllogEntity = PbdServiceCalllogUtils.buildPbdServiceCalllogEntity((Long)this.model.getStandardapi(), (Long)this.model.getPlatformapi(), (String)isFree, params, (Object)standardResult);
            result.put("calllogEntity", calllogEntity);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    private Map<String, Object> executeInputPlugin(DynamicObject dy, ProgrammeParserModel model, String apipurpose) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        List<PluginModel> plugins = this.getPlugin(model, apipurpose);
        if (CollectionUtils.isEmpty(plugins)) {
            return map;
        }
        for (PluginModel plugin : plugins) {
            Class<?> pluginClass = this.getPluginClass(plugin);
            IBusinessRulesRequestParseService requestPlugin = null;
            try {
                Map assembelRequest;
                Object newInstance = pluginClass.newInstance();
                if (!(newInstance instanceof IBusinessRulesRequestParseService) || CollectionUtils.isEmpty((Map)(assembelRequest = (requestPlugin = (IBusinessRulesRequestParseService)newInstance).assembelRequest(dy)))) continue;
                map.putAll(assembelRequest);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
                throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8c03\u7528\u63d2\u4ef6\u5f02\u5e38\uff1a%s\u3002", (String)"StandardApiService_7", (String)"scm-pbd-mservice", (Object[])new Object[0]), (String)"StandardApiService_7", (String)"scm-pbd-mservice", (Object[])new Object[]{e.getMessage()}));
            }
        }
        return map;
    }

    private Map<String, Object> executeOutputPlugin(DynamicObject dy, ProgrammeParserModel model, String apipurpose, Object standardResult) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        List<PluginModel> plugins = this.getPlugin(model, apipurpose);
        if (CollectionUtils.isEmpty(plugins)) {
            return map;
        }
        for (PluginModel plugin : plugins) {
            Map assembelRequest;
            Object newInstance;
            IBusinessRulesCheckParseService requestPlugin;
            Class<?> pluginClass = this.getPluginClass(plugin);
            if ("A".equals(apipurpose)) {
                requestPlugin = null;
                try {
                    newInstance = pluginClass.newInstance();
                    if (!(newInstance instanceof IBusinessRulesCheckParseService) || CollectionUtils.isEmpty((Map)(assembelRequest = (requestPlugin = (IBusinessRulesCheckParseService)newInstance).checkDyByResult(dy, standardResult)))) continue;
                    map.putAll(assembelRequest);
                    continue;
                }
                catch (Exception e) {
                    log.warn((Throwable)e);
                    throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8c03\u7528\u63d2\u4ef6\u5f02\u5e38\uff1a%s\u3002", (String)"StandardApiService_7", (String)"scm-pbd-mservice", (Object[])new Object[0]), (String)"StandardApiService_7", (String)"scm-pbd-mservice", (Object[])new Object[]{e.getMessage()}));
                }
            }
            if (!"B".equals(apipurpose)) continue;
            requestPlugin = null;
            try {
                newInstance = pluginClass.newInstance();
                if (!(newInstance instanceof IBusinessRulesFillParseService) || CollectionUtils.isEmpty((Map)(assembelRequest = (requestPlugin = (IBusinessRulesFillParseService)newInstance).fillDyByResult(dy, standardResult)))) continue;
                map.putAll(assembelRequest);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
                throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8c03\u7528\u63d2\u4ef6\u5f02\u5e38\uff1a%s\u3002", (String)"StandardApiService_7", (String)"scm-pbd-mservice", (Object[])new Object[0]), (String)"StandardApiService_7", (String)"scm-pbd-mservice", (Object[])new Object[]{e.getMessage()}));
            }
        }
        return map;
    }

    private Class<?> getPluginClass(PluginModel plugin) {
        String pluginName = plugin.getPlclassname();
        Class<?> pluginClass = null;
        try {
            pluginClass = Class.forName(pluginName);
        }
        catch (ClassNotFoundException e) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u63d2\u4ef6%s\u4e0d\u5b58\u5728\u3002", (String)"StandardApiService_8", (String)"scm-pbd-mservice", (Object[])new Object[0]), (String)"StandardApiService_8", (String)"scm-pbd-mservice", (Object[])new Object[]{pluginName}));
        }
        return pluginClass;
    }

    private List<PluginModel> getPlugin(ProgrammeParserModel model, String apipurpose) {
        ArrayList<PluginModel> pluginEnables = new ArrayList<PluginModel>(8);
        ArrayList plugins = new ArrayList(8);
        if ("A".equals(apipurpose)) {
            List pluginPolicyRule = model.getPluginPolicyRule();
            if (!CollectionUtils.isEmpty((Collection)pluginPolicyRule)) {
                plugins.addAll(model.getPluginPolicyRule());
            }
        } else {
            List pluginPolicyField = model.getPluginPolicyField();
            if (!CollectionUtils.isEmpty((Collection)pluginPolicyField)) {
                plugins.addAll(model.getPluginPolicyField());
            }
        }
        for (PluginModel plugin : plugins) {
            Boolean plisenable = plugin.getPlisenable();
            if (!plisenable.booleanValue()) continue;
            pluginEnables.add(plugin);
        }
        return pluginEnables;
    }

    private Map<String, Object> buildCallParams(List<ParseFieldMapping> inputMapping) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        for (ParseFieldMapping inputField : inputMapping) {
            String thirdField = inputField.getThirdField();
            String fieldtype = inputField.getFieldtype();
            if ("0".equals(fieldtype)) {
                Object thirdValue = inputField.getThirdValue();
                params.put(thirdField, thirdValue);
                continue;
            }
            if (!"3".equals(fieldtype)) continue;
            String targetconstant = inputField.getTargetconstant();
            if (thirdField.contains("url") && !targetconstant.startsWith("http")) {
                String urlCosmic = UrlService.getDomainContextUrl();
                targetconstant = urlCosmic + "/kapi" + targetconstant;
            }
            params.put(thirdField, targetconstant);
        }
        return params;
    }
}

