/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.common.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pbd.common.enums.AddressMatchEnum;

public class AddressTreeNode {
    private long id;
    private long parentId;
    private String name;
    private String longnumber;
    private int level;
    private List<AddressTreeNode> childAddressList;
    private String matchStatus;
    private long matchAddressId;
    private String matchLongnumber;
    private boolean specialAddress;
    private boolean newVersion;

    public AddressTreeNode(long id, long parentId, String name, String longnumber, int level) {
        this.id = id;
        this.parentId = parentId;
        this.name = name;
        this.longnumber = longnumber;
        this.level = level;
        this.matchStatus = AddressMatchEnum.NO_MATCH.getVal();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLongnumber() {
        return this.longnumber;
    }

    public void setLongnumber(String longnumber) {
        this.longnumber = longnumber;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public List<AddressTreeNode> getChildAddressList() {
        return this.childAddressList;
    }

    public void setChildAddressList(List<AddressTreeNode> childAddressList) {
        this.childAddressList = childAddressList;
    }

    public boolean isSpecialAddress() {
        return this.specialAddress;
    }

    public void setSpecialAddress(boolean specialAddress) {
        this.specialAddress = specialAddress;
    }

    public String getMatchLongnumber() {
        return this.matchLongnumber;
    }

    public void setMatchLongnumber(String matchLongnumber) {
        this.matchLongnumber = matchLongnumber;
    }

    public boolean isNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(boolean newVersion) {
        this.newVersion = newVersion;
    }

    public void addChildAddress(AddressTreeNode child) {
        if (this.childAddressList == null) {
            this.childAddressList = new ArrayList<AddressTreeNode>(16);
        }
        this.childAddressList.add(child);
    }

    public void addAllChilds(List<AddressTreeNode> childs) {
        if (this.childAddressList == null) {
            this.childAddressList = new ArrayList<AddressTreeNode>(16);
        }
        this.childAddressList.addAll(childs);
    }

    public void removeAllChilds() {
        if (this.childAddressList != null) {
            this.childAddressList.clear();
        }
    }

    public Map<Long, AddressTreeNode> childs2Map() {
        HashMap<Long, AddressTreeNode> resMap = new HashMap<Long, AddressTreeNode>(16);
        if (this.childAddressList != null) {
            for (AddressTreeNode node : this.childAddressList) {
                resMap.put(node.getId(), node);
            }
        }
        return resMap;
    }

    public boolean hasChilds() {
        return !CollectionUtils.isEmpty(this.childAddressList);
    }

    public String getMatchStatus() {
        return this.matchStatus;
    }

    public void setMatchStatus(String matchStatus) {
        this.matchStatus = matchStatus;
    }

    public long getMatchAddressId() {
        return this.matchAddressId;
    }

    public void setMatchAddressId(long matchAddressId) {
        this.matchAddressId = matchAddressId;
    }

    public boolean isMatch(AddressTreeNode o) {
        if (null == o || StringUtils.isBlank((CharSequence)o.getName()) || StringUtils.isBlank((CharSequence)this.name) || this.level != o.getLevel()) {
            return false;
        }
        if ((this.name.indexOf(o.getName()) >= 0 || o.getName().indexOf(this.name) >= 0) && this.level == o.getLevel()) {
            return true;
        }
        if (this.level == 2 && this.startCharMatch(this.name, o.getName())) {
            return true;
        }
        if (this.level == 3) {
            if (this.newVersion) {
                return this.calJaccard(this.name, o.getName()) >= 0.8f;
            }
            return this.calJaccard(this.name, o.getName()) > 0.6f || this.startCharMatch(this.name, o.getName());
        }
        return this.level == 4 && this.calJaccard(this.name, o.getName()) > 0.5f;
    }

    private boolean startCharMatch(String str1, String str2) {
        if (str1.length() >= 2 && str2.length() >= 2) {
            return str1.charAt(0) == str2.charAt(0) && str1.charAt(1) == str2.charAt(1);
        }
        return false;
    }

    private float calJaccard(String str1, String str2) {
        HashSet<Character> s1 = new HashSet<Character>(str1.length());
        HashSet<Character> s2 = new HashSet<Character>(str2.length());
        for (int i = 0; i < str1.length(); ++i) {
            s1.add(Character.valueOf(str1.charAt(i)));
        }
        for (int j = 0; j < str2.length(); ++j) {
            s2.add(Character.valueOf(str2.charAt(j)));
        }
        float mergeNum = 0.0f;
        float commonNum = 0.0f;
        for (Character ch1 : s1) {
            for (Character ch2 : s2) {
                if (!ch1.equals(ch2)) continue;
                commonNum += 1.0f;
            }
        }
        mergeNum = (float)(s1.size() + s2.size()) - commonNum;
        float jaccard = commonNum / mergeNum;
        return jaccard;
    }

    public String toString() {
        return "AddressTreeNode [id=" + this.id + ", parentId=" + this.parentId + ", name=" + this.name + ", longnumber=" + this.longnumber + ", level=" + this.level + ", childAddressList=" + this.childAddressList + ", matchStatus=" + this.matchStatus + ", matchAddressId=" + this.matchAddressId + ", matchLongnumber=" + this.matchLongnumber + ", specialAddress=" + this.specialAddress + ", newVersion=" + this.newVersion + "]";
    }
}

