/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pbd.common.entity.ParseFieldMapping;
import kd.scm.pbd.common.utils.FieldTypeUtil;
import kd.scm.pbd.common.utils.PbdDynamicObjectUtils;

public class PbdServiceHandlerHelper {
    private static Log log = LogFactory.getLog(PbdServiceHandlerHelper.class);

    public static Map<String, Object> fieldMappingToDy(DynamicObject dy, Object standardResult, List<ParseFieldMapping> outputMapping, String apipurpose) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        log.info("PbdServiceHandlerHelper.fieldMappingToDy() standardResult:{}", standardResult);
        Map<String, Object> targetResult = PbdServiceHandlerHelper.parseResultToTargetBillKey(outputMapping, standardResult);
        log.info("PbdServiceHandlerHelper.fieldMappingToDy() targetResult:{}", targetResult);
        if (targetResult != null) {
            if (dy == null) {
                result.put("success", false);
                result.put("message", "DynamicObject can not null");
                return result;
            }
            try {
                PbdServiceHandlerHelper.saveStandardDy(dy, null, "bill", targetResult, apipurpose);
                result.put("success", true);
                return result;
            }
            catch (Exception e) {
                result.put("success", false);
                result.put("message", e.getMessage());
                return result;
            }
        }
        result.put("success", false);
        result.put("message", "no data");
        return result;
    }

    private static void saveStandardDy(DynamicObject load, DynamicObject entityKeyDy, String entryKey, Object targetResult, String apipurpose) {
        log.info("PbdServiceHandlerHelper.fieldMappingToDy() targetResult:{}", targetResult);
        Map map = (Map)targetResult;
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                List list = (List)value;
                PbdServiceHandlerHelper.saveStandardEntity(load, entityKeyDy, key, list, apipurpose);
                continue;
            }
            PbdDynamicObjectUtils.setValue(load, entityKeyDy, key, value);
        }
    }

    private static void saveStandardEntity(DynamicObject load, DynamicObject entityKeyDy, String key, List<Map<String, Object>> list, String apipurpose) {
        if (load.containsProperty(key)) {
            DynamicObjectCollection dynamicObjectCollection = load.getDynamicObjectCollection(key);
            if (!"D".equals(apipurpose)) {
                dynamicObjectCollection.clear();
            }
            for (Map<String, Object> mapentity : list) {
                DynamicObject entityKeyDy0 = dynamicObjectCollection.addNew();
                PbdServiceHandlerHelper.saveStandardDy(load, entityKeyDy0, key, mapentity, apipurpose);
            }
        } else {
            PbdDynamicObjectUtils.setValue(load, entityKeyDy, key, list);
        }
    }

    public static Map<String, Object> parseResultToTargetBillKey(List<ParseFieldMapping> outputFields, Object standardResult) {
        Map<String, Object> mapAll = new HashMap<String, Object>(8);
        if (standardResult instanceof Map) {
            mapAll = PbdServiceHandlerHelper.parseMapToTarget(outputFields, standardResult);
        }
        return mapAll;
    }

    public static Map<String, Object> parseMoreEntryResultToTargetBillKey(List<ParseFieldMapping> outputFields, String targetField, Object result) {
        HashMap<String, Object> mapAll = new HashMap<String, Object>(8);
        if (result instanceof List) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
            List listApi = (List)result;
            for (Object obj : listApi) {
                if (!(obj instanceof Map)) {
                    mapAll.put(targetField, listApi);
                    return mapAll;
                }
                Map mapApi = (Map)obj;
                if (CollectionUtils.isEmpty((Map)mapApi)) continue;
                Map<String, Object> map = PbdServiceHandlerHelper.parseMapToTarget(outputFields, mapApi);
                list.add(map);
            }
            Optional<ParseFieldMapping> findFirst = outputFields.stream().filter(out -> out.getTargetTopEntry() != null).findFirst();
            if (findFirst.isPresent()) {
                ParseFieldMapping parseFieldMapping = findFirst.get();
                String targetTopEntry = parseFieldMapping.getTargetTopEntry();
                if (StringUtils.isEmpty((String)targetField)) {
                    targetField = targetTopEntry;
                }
                mapAll.put(targetField, list);
                return mapAll;
            }
            if (!CollectionUtils.isEmpty(list)) {
                mapAll.putAll((Map)list.get(0));
                return mapAll;
            }
            return mapAll;
        }
        if (result instanceof Map) {
            mapAll = PbdServiceHandlerHelper.parseMapToTarget(outputFields, result);
            return mapAll;
        }
        mapAll.put(targetField, result);
        return mapAll;
    }

    private static Map<String, Object> parseMapToTarget(List<ParseFieldMapping> outputFields, Object result) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        Map mapApi = (Map)result;
        for (Map.Entry entrySet : mapApi.entrySet()) {
            String sourceField = (String)entrySet.getKey();
            Object object = entrySet.getValue();
            List outputsFields = outputFields.stream().filter(out -> sourceField.equals(out.getSourceField())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(outputsFields)) continue;
            for (ParseFieldMapping outputsField : outputsFields) {
                Map<String, Object> tarMap;
                String targetField = outputsField.getTargetField();
                if (object instanceof List) {
                    tarMap = PbdServiceHandlerHelper.parseMoreEntryResultToTargetBillKey(outputFields, targetField, object);
                    map.putAll(tarMap);
                    continue;
                }
                if (object instanceof Map) {
                    tarMap = PbdServiceHandlerHelper.parseMoreEntryResultToTargetBillKey(outputFields, targetField, object);
                    map.putAll(tarMap);
                    continue;
                }
                map.put(targetField, object);
            }
        }
        return map;
    }

    public static boolean fieldRuleCheckToDy(DynamicObject dy, Object standardResult, List<ParseFieldMapping> outputMapping) {
        Map<String, Object> result = PbdServiceHandlerHelper.parseResultToTargetBillKey(outputMapping, standardResult);
        if (!CollectionUtils.isEmpty(result)) {
            Map<String, Object> map = result;
            for (ParseFieldMapping output : outputMapping) {
                Object object;
                Object sourceValue;
                String key = output.getTargetField();
                String sourceDatatype = output.getSourceDatatype();
                if (!StringUtils.isNotEmpty((String)key)) continue;
                Object value = map.get(key);
                if (!dy.containsProperty(key) || value.equals(sourceValue = FieldTypeUtil.transferFieldValue(sourceDatatype, object = dy.get(key)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

