/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.common.helper;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.scm.common.util.CodeRuleUtil;
import kd.scm.pbd.common.entity.FieldProp;
import kd.scm.pbd.common.entity.ParseFieldMapping;
import kd.scm.pbd.common.entity.ProgrammeParserModel;
import kd.scm.pbd.common.utils.FieldPropUtils;
import kd.scm.pbd.common.utils.FieldTypeUtil;
import kd.scm.pbd.common.utils.PbdBussinessInfoUtils;
import kd.scm.pbd.common.utils.PbdDynamicObjectUtils;

public class PbdStandardApiMapperHelper {
    private static Log log = LogFactory.getLog(PbdStandardApiMapperHelper.class);

    public static List<ParseFieldMapping> inputFieldMapping(DynamicObject standardDy, Long entryEntityId, List<ParseFieldMapping> fieldMapping) {
        DynamicObjectCollection inputsentityDys = standardDy.getDynamicObjectCollection("inputsentity");
        if (CollectionUtils.isEmpty((Collection)inputsentityDys)) {
            return new ArrayList<ParseFieldMapping>(8);
        }
        List<FieldProp> inputList = PbdStandardApiMapperHelper.transforInputDyToObject(entryEntityId, inputsentityDys);
        for (ParseFieldMapping field : fieldMapping) {
            String sourceField = field.getSourceField();
            Optional<FieldProp> findFirst = inputList.stream().filter(in -> sourceField.equals(in.getKey())).findFirst();
            if (!findFirst.isPresent()) continue;
            FieldProp fieldProp = findFirst.get();
            String thirdDatatype = fieldProp.getThirdfieldtype();
            String dataType = fieldProp.getDataType();
            Object targetValue = field.getTargetValue();
            Object sourceValue = FieldTypeUtil.transferFieldValue(dataType, targetValue);
            field.setSourceValue(sourceValue);
            field.setSourceDatatype(dataType);
            Object thirdFieldValue = FieldTypeUtil.transferThirdFieldValue(dataType, targetValue);
            field.setThirdField(fieldProp.getThirdfieldid());
            field.setThirdValue(thirdFieldValue);
            field.setThirdDatatype(thirdDatatype);
        }
        return fieldMapping;
    }

    public static List<ParseFieldMapping> outputFieldMapping(DynamicObject standardDy, Long entryEntityId, List<ParseFieldMapping> fieldMapping) {
        DynamicObjectCollection entityDys = standardDy.getDynamicObjectCollection("outputsentity");
        if (CollectionUtils.isEmpty((Collection)entityDys)) {
            return new ArrayList<ParseFieldMapping>(8);
        }
        ArrayList<ParseFieldMapping> lists = new ArrayList<ParseFieldMapping>(8);
        List<FieldProp> fieldList = PbdStandardApiMapperHelper.transforOutputDyToObject(entryEntityId, entityDys);
        for (FieldProp field : fieldList) {
            String sourceField = field.getKey();
            List fieldProps = fieldMapping.stream().filter(field0 -> field0.getSourceField().equals(sourceField)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(fieldProps)) {
                for (ParseFieldMapping field02 : fieldProps) {
                    PbdStandardApiMapperHelper.setOutputFieldMapping(lists, field, field02);
                }
                continue;
            }
            ParseFieldMapping field03 = new ParseFieldMapping();
            String sourceFieldNew = FieldPropUtils.updateKeyIncludeParentKey(fieldList, field, sourceField);
            PbdStandardApiMapperHelper.setSourceField(sourceFieldNew, field03);
            PbdStandardApiMapperHelper.setOutputFieldMapping(lists, field, field03);
        }
        return lists;
    }

    private static void setOutputFieldMapping(List<ParseFieldMapping> lists, FieldProp field, ParseFieldMapping field0) {
        String thirdDatatype = field.getThirdfieldtype();
        String dataType = field.getDataType();
        field0.setSourceDatatype(dataType);
        field0.setThirdField(field.getThirdfieldid());
        field0.setThirdDatatype(thirdDatatype);
        lists.add(field0);
    }

    private static void setSourceField(String sourcefield, ParseFieldMapping parseFieldMapping) {
        String[] sourceSplit = sourcefield.split("\\.");
        if (sourceSplit.length == 1) {
            parseFieldMapping.setSourceField(sourcefield);
        } else {
            parseFieldMapping.setSourceField(sourceSplit[sourceSplit.length - 1]);
            parseFieldMapping.setSourceEntry(sourceSplit[sourceSplit.length - 2]);
            parseFieldMapping.setSourceTopEntry(sourceSplit[0]);
        }
    }

    private static List<FieldProp> transforInputDyToObject(Long entryEntityId, DynamicObjectCollection inputsentityDys) {
        ArrayList<FieldProp> inputList = new ArrayList<FieldProp>(8);
        for (DynamicObject dy : inputsentityDys) {
            Long inputsentryentityid = dy.getLong("inputsentryentityid");
            if (!entryEntityId.equals(inputsentryentityid)) continue;
            FieldProp prop = new FieldProp();
            Long id = dy.getLong("id");
            Long pid = dy.getLong("pid");
            String inputsfieldid = dy.getString("inputsfieldid");
            String inputsfieldname = dy.getString("inputsfieldname");
            String inputsfieldtype = dy.getString("inputsfieldtype");
            String inputsthirdfieldid = dy.getString("inputsthirdfieldid");
            String inputsthirdfieldname = dy.getString("inputsthirdfieldname");
            String inputsthirdfieldtype = dy.getString("inputsthirdfieldtype");
            prop.setId(id.toString());
            prop.setParentId(pid.toString());
            prop.setEntityKey("inputsentity");
            prop.setEntryentityid(inputsentryentityid.toString());
            prop.setKey(inputsfieldid);
            prop.setName(inputsfieldname);
            prop.setDataType(inputsfieldtype);
            prop.setThirdfieldid(inputsthirdfieldid);
            prop.setThirdfieldname(inputsthirdfieldname);
            prop.setThirdfieldtype(inputsthirdfieldtype);
            inputList.add(prop);
        }
        return inputList;
    }

    public static List<FieldProp> transforOutputDyToObject(Long entryEntityId, DynamicObjectCollection outputsentityDys) {
        ArrayList<FieldProp> outputList = new ArrayList<FieldProp>(8);
        for (DynamicObject dy : outputsentityDys) {
            Long inputsentryentityid = dy.getLong("outputsentryentityid");
            if (!entryEntityId.equals(inputsentryentityid)) continue;
            FieldProp prop = new FieldProp();
            Long id = dy.getLong("id");
            Long pid = dy.getLong("pid");
            String inputsfieldid = dy.getString("outputsfieldid");
            String inputsfieldname = dy.getString("outputsfieldname");
            String inputsfieldtype = dy.getString("outputsfieldtype");
            String inputsthirdfieldid = dy.getString("outputsthirdfieldid");
            String inputsthirdfieldname = dy.getString("outputsthirdfieldname");
            String inputsthirdfieldtype = dy.getString("outputsthirdfieldtype");
            prop.setId(id.toString());
            prop.setParentId(pid.toString());
            prop.setEntityKey("outputsentity");
            prop.setEntryentityid(inputsentryentityid.toString());
            prop.setKey(inputsfieldid);
            prop.setName(inputsfieldname);
            prop.setDataType(inputsfieldtype);
            prop.setThirdfieldid(inputsthirdfieldid);
            prop.setThirdfieldname(inputsthirdfieldname);
            prop.setThirdfieldtype(inputsthirdfieldtype);
            outputList.add(prop);
        }
        return outputList;
    }

    public static DynamicObject parseResultToStandardDy(DynamicObject load, ProgrammeParserModel model, List<ParseFieldMapping> inputMapping, List<ParseFieldMapping> outputFields, Object standardObject, Long orgId) {
        if (standardObject == null) {
            return null;
        }
        List<String> entityKeyList = model.getStandardEntityKeys();
        String standardBillKey = model.getStandardBillKey();
        if (StringUtils.isNotBlank((CharSequence)standardBillKey)) {
            if (load == null) {
                load = BusinessDataServiceHelper.newDynamicObject((String)standardBillKey);
                if (load.containsProperty("org")) {
                    load.set("org", (Object)orgId);
                }
                Long genGlobalLongId = DBServiceHelper.genGlobalLongId();
                load.set("id", (Object)genGlobalLongId);
                String codeRule = CodeRuleUtil.getCodeRule((String)standardBillKey);
                load.set("billno", (Object)codeRule);
                load.set("billstatus", (Object)"C");
            }
            String apipurpose = model.getApipurpose();
            if (standardObject instanceof Map) {
                if (entityKeyList.contains("bill")) {
                    PbdStandardApiMapperHelper.setStandardDy(load, null, outputFields, "bill", standardObject, entityKeyList, apipurpose);
                } else {
                    for (String entryKey : entityKeyList) {
                        DynamicObjectCollection dynamicObjectCollection = load.getDynamicObjectCollection(entryKey);
                        if (!"D".equals(apipurpose)) {
                            dynamicObjectCollection.clear();
                        }
                        DynamicObject entityKeyDy0 = dynamicObjectCollection.addNew();
                        PbdStandardApiMapperHelper.setStandardDy(load, entityKeyDy0, outputFields, entryKey, standardObject, entityKeyList, apipurpose);
                    }
                }
            }
            for (ParseFieldMapping inputField : inputMapping) {
                String sourceField = inputField.getSourceField();
                Object sourceValue = inputField.getSourceValue();
                if (sourceField == null || sourceValue == null || !load.containsProperty(sourceField)) continue;
                load.set(sourceField, sourceValue);
            }
            PbdBussinessInfoUtils.save(load);
        }
        return load;
    }

    public static Object parseResultToStandardBillKey(ProgrammeParserModel model, List<ParseFieldMapping> outputFields, Object result) {
        Map<Object, Object> mapAll = new HashMap(8);
        if (result instanceof List) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
            List listApi = (List)result;
            for (Object obj : listApi) {
                Map mapApi;
                if (!(obj instanceof Map) || CollectionUtils.isEmpty((Map)(mapApi = (Map)obj))) continue;
                Map<String, Object> map = PbdStandardApiMapperHelper.parseMapToStandard(model, outputFields, mapApi);
                list.add(map);
            }
            Optional<ParseFieldMapping> findFirst = outputFields.stream().filter(out -> out.getSourceTopEntry() != null).findFirst();
            if (findFirst.isPresent()) {
                ParseFieldMapping parseFieldMapping = findFirst.get();
                mapAll.put(parseFieldMapping.getSourceTopEntry(), list);
                return mapAll;
            }
            return list;
        }
        if (result instanceof Map) {
            mapAll = PbdStandardApiMapperHelper.parseMapToStandard(model, outputFields, result);
            return mapAll;
        }
        return null;
    }

    public static Map<String, Object> parseMoreEntryResultToStandardBillKey(ProgrammeParserModel model, String sourceField, List<ParseFieldMapping> outputFields, Object result) {
        HashMap<String, Object> mapAll = new HashMap<String, Object>(8);
        if (result instanceof List) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
            List listApi = (List)result;
            for (Object obj : listApi) {
                if (!(obj instanceof Map)) {
                    mapAll.put(sourceField, listApi);
                    return mapAll;
                }
                Map mapApi = (Map)obj;
                if (CollectionUtils.isEmpty((Map)mapApi)) continue;
                Map<String, Object> map = PbdStandardApiMapperHelper.parseMapToStandard(model, outputFields, mapApi);
                list.add(map);
            }
            Optional<ParseFieldMapping> findFirst = outputFields.stream().filter(out -> out.getSourceTopEntry() != null).findFirst();
            if (findFirst.isPresent()) {
                mapAll.put(sourceField, list);
            } else if (!CollectionUtils.isEmpty(list)) {
                mapAll.put(sourceField, list.get(0));
            }
        } else if (result instanceof Map) {
            Map<String, Object> map = PbdStandardApiMapperHelper.parseMapToStandard(model, outputFields, result);
            mapAll.put(sourceField, map);
        } else {
            mapAll.put(sourceField, result);
        }
        return mapAll;
    }

    private static Map<String, Object> parseMapToStandard(ProgrammeParserModel model, List<ParseFieldMapping> outputFields, Object result) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        Map mapApi = (Map)result;
        for (Map.Entry entrySet : mapApi.entrySet()) {
            String thirdField = (String)entrySet.getKey();
            Object object = entrySet.getValue();
            List parseFieldMappings = outputFields.stream().filter(out -> thirdField.equals(out.getThirdField())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(parseFieldMappings)) {
                for (ParseFieldMapping outputsField : parseFieldMappings) {
                    Map<String, Object> standardObject;
                    String sourceField = outputsField.getSourceField();
                    String sourceDatatype = outputsField.getSourceDatatype();
                    if (object instanceof List) {
                        standardObject = PbdStandardApiMapperHelper.parseMoreEntryResultToStandardBillKey(model, sourceField, outputFields, object);
                        map.putAll(standardObject);
                        continue;
                    }
                    if (object instanceof Map) {
                        standardObject = PbdStandardApiMapperHelper.parseMoreEntryResultToStandardBillKey(model, sourceField, outputFields, object);
                        map.putAll(standardObject);
                        continue;
                    }
                    Object sourceValue = FieldTypeUtil.transferFieldValue(sourceDatatype, object);
                    map.put(sourceField, sourceValue);
                }
                continue;
            }
            map.put(thirdField, object);
        }
        return map;
    }

    private static void setStandardDy(DynamicObject load, DynamicObject entityKeyDy, List<ParseFieldMapping> outputFields, String entryKey, Object standardObject, List<String> entityKeyList, String apipurpose) {
        if (standardObject instanceof Map) {
            Map map = (Map)standardObject;
            Set entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Optional<ParseFieldMapping> findFirst = outputFields.stream().filter(out -> key.equals(out.getSourceField())).findFirst();
                if (!findFirst.isPresent()) continue;
                if (value instanceof List) {
                    List list = (List)value;
                    boolean isMap = false;
                    for (Object o : list) {
                        if (!(o instanceof Map)) continue;
                        isMap = true;
                        break;
                    }
                    if (isMap) {
                        PbdStandardApiMapperHelper.saveStandardEntity(load, entityKeyDy, outputFields, key, list, entityKeyList, apipurpose);
                        continue;
                    }
                    PbdDynamicObjectUtils.setValue(load, entityKeyDy, key, value);
                    continue;
                }
                PbdDynamicObjectUtils.setValue(load, entityKeyDy, key, value);
            }
            if ("bill".equals(entryKey)) {
                if (!CollectionUtils.isEmpty(entityKeyList) && entityKeyList.size() == 1) {
                    load.set("updatetime", (Object)Timestamp.valueOf(LocalDateTime.now()));
                }
            } else {
                String updatetimeField = entryKey + "updatetime";
                if (entityKeyDy != null && entityKeyDy.containsProperty(updatetimeField)) {
                    entityKeyDy.set(updatetimeField, (Object)Timestamp.valueOf(LocalDateTime.now()));
                }
            }
        }
    }

    private static void saveStandardEntity(DynamicObject load, DynamicObject entityKeyDy0, List<ParseFieldMapping> outputFields, String key, List<Map<String, Object>> list, List<String> entityKeyList, String apipurpose) {
        if (load.containsProperty(key)) {
            DynamicObjectCollection dynamicObjectCollection = load.getDynamicObjectCollection(key);
            if (!"D".equals(apipurpose)) {
                dynamicObjectCollection.clear();
            }
            for (Map<String, Object> mapentity : list) {
                entityKeyDy0 = dynamicObjectCollection.addNew();
                PbdStandardApiMapperHelper.setStandardDy(load, entityKeyDy0, outputFields, key, mapentity, entityKeyList, apipurpose);
            }
        } else {
            PbdDynamicObjectUtils.setValue(load, entityKeyDy0, key, list);
        }
    }

    public static Map<String, Object> parseDyToObjectResult(DynamicObject load, ProgrammeParserModel model, List<ParseFieldMapping> outputMapping) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        List<String> entityKeyList = model.getStandardEntityKeys();
        if (!CollectionUtils.isEmpty(entityKeyList)) {
            for (String entityKey : entityKeyList) {
                if ("bill".equals(entityKey)) continue;
                List collect = outputMapping.stream().filter(out -> entityKey.equals(out.getSourceEntry())).collect(Collectors.toList());
                if (!load.containsProperty(entityKey)) continue;
                ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(8);
                DynamicObjectCollection dynamicObjectCollection = load.getDynamicObjectCollection(entityKey);
                for (DynamicObject dy : dynamicObjectCollection) {
                    IDataEntityType entryDataEntityType = dy.getDataEntityType();
                    DataEntityPropertyCollection entryProperties = entryDataEntityType.getProperties();
                    HashMap<String, Object> item = new HashMap<String, Object>(8);
                    for (ParseFieldMapping outputsField : collect) {
                        String sourceField = outputsField.getSourceField();
                        PbdStandardApiMapperHelper.putSourceValue(dy, item, entryProperties, sourceField);
                    }
                    list.add(item);
                }
                map.put(entityKey, list);
            }
        }
        List collect = outputMapping.stream().filter(out -> out.getSourceEntry() == null).collect(Collectors.toList());
        IDataEntityType loadDataEntityType = load.getDataEntityType();
        DataEntityPropertyCollection loadProperties = loadDataEntityType.getProperties();
        for (ParseFieldMapping outputsField : collect) {
            String sourceField = outputsField.getSourceField();
            if (!CollectionUtils.isEmpty(entityKeyList) && entityKeyList.contains(sourceField)) continue;
            PbdStandardApiMapperHelper.putSourceValue(load, map, loadProperties, sourceField);
        }
        return map;
    }

    private static void putSourceValue(DynamicObject dy, Map<String, Object> map, DataEntityPropertyCollection loadProperties, String sourceField) {
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)loadProperties.get((Object)sourceField);
        if (iDataEntityProperty instanceof LargeTextProp) {
            Object object = dy.get(sourceField + "_tag");
            map.put(sourceField, object);
        } else {
            Object sourceValue = dy.get(sourceField);
            map.put(sourceField, sourceValue);
        }
    }
}

