/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.common.utils;

import java.util.Collection;
import java.util.Date;
import kd.bos.config.client.util.StringUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.util.CodeRuleUtil;
import kd.scm.pbd.common.entity.PbdServiceCalllogEntity;
import kd.scm.pbd.common.entity.ProgrammeParserModel;

public class PbdServiceCalllogUtils {
    private static final String PBD_SERVICE_CALLLOG = "pbd_service_calllog";

    public static DynamicObject getCalResult(ProgrammeParserModel req) {
        StringBuilder sb = new StringBuilder();
        sb.append("id,billno,calluser,calldatetime,billentity,triggertype,operator,org,programme,link,").append("entryentity").append(".").append("standardapi").append(",").append("entryentity").append(".").append("platformapi").append(",").append("entryentity").append(".").append("source").append(",").append("entryentity").append(".").append("request").append(",").append("entryentity").append(".").append("result");
        QFilter filters = new QFilter("programme", "=", (Object)req.getId());
        filters.and("calldatetime", "=", (Object)req.getDateTime());
        Long orgId = PbdServiceCalllogUtils.getOrgId();
        filters.and("org", "=", (Object)orgId);
        DynamicObject load = BusinessDataServiceHelper.loadSingle((String)PBD_SERVICE_CALLLOG, (String)sb.toString(), (QFilter[])new QFilter[]{filters});
        return load;
    }

    public static PbdServiceCalllogEntity buildPbdServiceCalllogEntity(Long standardapi, Long platformapi, String source, Object request, Object result) {
        PbdServiceCalllogEntity entity = new PbdServiceCalllogEntity();
        Date now = KDDateUtils.now();
        entity.setCalltime(now);
        entity.setStandardapi(standardapi);
        entity.setPlatformapi(platformapi);
        entity.setSource(source);
        if (request != null) {
            entity.setRequest(SerializationUtils.toJsonString((Object)request));
        }
        if (result != null) {
            entity.setResult(SerializationUtils.toJsonString((Object)result));
        }
        return entity;
    }

    public static DynamicObject buildCallLog(ProgrammeParserModel req, DynamicObject dy, PbdServiceCalllogEntity entity) {
        if (dy == null && (dy = PbdServiceCalllogUtils.getCalResult(req)) == null) {
            dy = BusinessDataServiceHelper.newDynamicObject((String)PBD_SERVICE_CALLLOG);
            String billno = dy.getString("billno");
            if (StringUtils.isEmpty((String)billno)) {
                String codeRule = CodeRuleUtil.getCodeRule((String)PBD_SERVICE_CALLLOG);
                dy.set("billno", (Object)codeRule);
            }
            dy.set("billstatus", (Object)"C");
            dy.set("programme", (Object)req.getId());
            dy.set("calldatetime", (Object)req.getDateTime());
            dy.set("createtime", (Object)req.getDateTime());
            dy.set("modifytime", (Object)req.getDateTime());
            dy.set("auditdate", (Object)req.getDateTime());
            Long orgId = PbdServiceCalllogUtils.getOrgId();
            dy.set("org", (Object)orgId);
            dy.set("calluser", (Object)RequestContext.get().getCurrUserId());
            dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dy.set("creator", (Object)RequestContext.get().getCurrUserId());
            dy.set("auditor", (Object)RequestContext.get().getCurrUserId());
            dy.set("billentity", (Object)req.getBillentity());
            dy.set("triggertype", (Object)req.getTriggertype());
            dy.set("operator", (Object)req.getOperator());
            dy.set("link", (Object)req.getLink());
        }
        DynamicObject dyEntity = null;
        DynamicObjectCollection dyc = dy.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)dyc)) {
            dyEntity = dyc.addNew();
        } else {
            dyEntity = PbdServiceCalllogUtils.getEntryEntity(req, dyc);
            if (dyEntity == null) {
                dyEntity = dyc.addNew();
            }
        }
        PbdServiceCalllogUtils.setEntryEntity(entity, dyEntity);
        return dy;
    }

    private static Long getOrgId() {
        Long orgId = RequestContext.get().getOrgId();
        if (orgId == 0L) {
            orgId = OrgUnitServiceHelper.getRootOrgId();
        }
        return orgId;
    }

    private static DynamicObject getEntryEntity(ProgrammeParserModel req, DynamicObjectCollection dyc) {
        Long standardapiPkId = req.getStandardapi();
        for (DynamicObject dy0 : dyc) {
            Long pkValue;
            Long pkValue2;
            DynamicObject standardapi;
            Object standardapiObj = dy0.get("standardapi");
            if (!(standardapiObj instanceof DynamicObject ? (standardapi = dy0.getDynamicObject("standardapi")) != null && standardapiPkId.equals(pkValue2 = (Long)standardapi.getPkValue()) : standardapiObj instanceof Long && standardapiPkId.equals(pkValue = (Long)standardapiObj))) continue;
            return dy0;
        }
        return null;
    }

    private static void setEntryEntity(PbdServiceCalllogEntity entity, DynamicObject addNew) {
        if (addNew == null) {
            return;
        }
        if (entity == null) {
            return;
        }
        addNew.set("standardapi", (Object)entity.getStandardapi());
        addNew.set("platformapi", (Object)entity.getPlatformapi());
        addNew.set("source", (Object)entity.getSource());
        addNew.set("request_tag", (Object)entity.getRequest());
        PbdServiceCalllogUtils.setLargeTextTag(addNew, "request", entity.getRequest());
        addNew.set("result_tag", (Object)entity.getResult());
        PbdServiceCalllogUtils.setLargeTextTag(addNew, "result", entity.getResult());
        addNew.set("calltime", (Object)entity.getCalltime());
    }

    private static void setLargeTextTag(DynamicObject addNew, String tagField, String result) {
        int maxLenth = 100;
        if (StringUtils.isNotEmpty((String)result)) {
            if (result.length() >= maxLenth) {
                String resultTag = result.substring(0, maxLenth);
                addNew.set(tagField, (Object)resultTag);
            } else {
                addNew.set(tagField, (Object)result);
            }
        }
    }
}

