/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.usernumber.CreateUserStrategyEnum;
import kd.sdk.scm.common.extpoint.ICreateUserNumberSupport;

public final class PbdBillParamPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog((String)PbdBillParamPlugin.class.getName());

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initPlugin();
    }

    private void initPlugin() {
        HashSet<String> bizapplids = new HashSet<String>(8);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("bindformid");
        if (!StringUtils.isBlank((CharSequence)formId)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)formId);
            AppInfo appInfoByNumber = AppMetadataCache.getAppInfoByNumber((String)mainType.getBizAppNumber());
            if (appInfoByNumber != null) {
                bizapplids.add(appInfoByNumber.getId());
            }
            bizapplids.add("eae607fb000143ac");
            bizapplids.add("eae607fb000152ac");
            this.initDefaultPluginData(formId);
            this.initDefaultStrategy(formId);
        } else {
            bizapplids.add("eae607fb000143ac");
            bizapplids.add("eae607fb000152ac");
            bizapplids.add("XV1IC150UR4");
            bizapplids.add("UUPIH+47DAK");
            bizapplids.add("SE7SAP7HR2N");
            bizapplids.add("SE7/UZFDVIE");
        }
        HashSet<Long> bizextcaseIds = new HashSet<Long>(56);
        String traceId = RequestContext.get().getTraceId();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)traceId, (String)"bos_bizextcase", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizapp", "in", bizapplids)}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                bizextcaseIds.add(row.getLong("id"));
            }
        }
        if (!bizextcaseIds.isEmpty()) {
            ComboEdit connecterpAp = (ComboEdit)this.getControl("createuserextplugin");
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
            ComboItem property = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)traceId, (String)"bos_bizextplugin", (String)"billno,remark", (QFilter[])new QFilter[]{new QFilter("bizextcase", "in", bizextcaseIds)}, (String)"id");){
                ICreateUserNumberSupport userNumberSupport = null;
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    String billno = row.getString("billno");
                    if (billno == null) continue;
                    try {
                        userNumberSupport = (ICreateUserNumberSupport)TypesContainer.createInstance((String)billno);
                        if (userNumberSupport == null) continue;
                        property = new ComboItem(new LocaleString(row.getString("remark") + "(" + billno + ")"), billno);
                        comboItemList.add(property);
                    }
                    catch (Exception exception) {
                        log.info(String.valueOf(exception.getMessage()));
                    }
                }
            }
            if (connecterpAp != null) {
                connecterpAp.setComboItems(comboItemList);
            }
        }
    }

    private void initDefaultStrategy(String formId) {
        List comboItems;
        ComboEdit connecterpAp = (ComboEdit)this.getControl("createuserstrategy");
        MainEntityType purParam = EntityMetadataCache.getDataEntityType((String)"pur_param");
        DynamicProperty connecterpPro = purParam.getProperty("createuserstrategy");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        ComboItem property = null;
        if (connecterpPro != null && (comboItems = ((ComboProp)connecterpPro).getComboItems()) != null) {
            for (ValueMapItem valueMapItem : comboItems) {
                property = new ComboItem(valueMapItem.getName(), valueMapItem.getValue());
                comboItemList.add(property);
            }
        }
        if (connecterpAp != null) {
            connecterpAp.setComboItems(comboItemList);
        }
        this.setDefaultValue("createuserstrategy", CreateUserStrategyEnum.ISCPROXYUSER.getValue());
    }

    private void initDefaultPluginData(String formId) {
        String createuserextplugin = this.getModel().getDataEntity().getString("createuserextplugin");
        if (createuserextplugin == null || createuserextplugin.isEmpty()) {
            switch (formId) {
                case "pur_order": {
                    this.setDefaultValue("createuserextplugin", "kd.scm.pur.business.sdk.OrderCreateUserNumberStd");
                    break;
                }
                case "scp_saloutstock": {
                    this.setDefaultValue("createuserextplugin", "kd.scm.scp.business.sdk.AutoCreateStockUserNumberStd");
                    break;
                }
            }
        }
    }

    private void setDefaultValue(String proName, Object defalultValue) {
        Object value = this.getModel().getValue(proName);
        if (value == null) {
            this.getModel().setValue(proName, defalultValue);
        }
    }
}

