/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.service.botp.BotpService;
import kd.scm.common.service.botp.entity.BotpRule;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.pbd.business.PbdSystemJointBotpServiceHelper;

public class PbdCommonBotpPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog((String)PbdCommonBotpPlugin.class.getName());
    public static final String RULE = "botpdata";
    protected static final String BOTPERRORCODE = "500";
    protected static final String GETRULERETURN = "[]";

    public void afterCreateNewData(EventObject e) {
        Object visibleObj;
        Object invisibleObj;
        boolean isGoodsBizType;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.isEmpty()) {
            return;
        }
        log.info("\u4f20\u9012\u8fc7\u6765\u7684\u53c2\u6570\u4e3acustomParams={}", (Object)JSON.toJSONString((Object)customParams));
        Object sourceEntity = customParams.get("sourceentity");
        Object targetEntity = customParams.get("targetentity");
        Object replenishtype = customParams.get("replenishtype");
        Object jointchanneldata = customParams.get("jointchanneldata");
        DynamicObject jointCacheData = null;
        if (jointchanneldata == null) {
            jointchanneldata = SystemJointChannelHelper.getDefaultJointChannelId();
        }
        if (jointchanneldata != null) {
            jointCacheData = SystemJointChannelHelper.getJointChannelData((String)String.valueOf(jointchanneldata));
        }
        if (StringUtils.isBlank(sourceEntity) || StringUtils.isBlank(targetEntity)) {
            this.getView().showMessage("parmam error");
            return;
        }
        Map customParam = (Map)customParams.get("customParams");
        String jointsystemtype = null;
        boolean isRepcType = false;
        boolean bl = isGoodsBizType = customParam != null && customParam.get("isGoodsBizType") != null && Boolean.parseBoolean((String)customParam.get("isGoodsBizType"));
        if (jointCacheData != null) {
            jointsystemtype = jointCacheData.getString("jointchanneltype.jointsystemtype");
            String jointsystemtypeNumber = jointCacheData.getString("number");
            if ("constellationrepcscm".equals(jointsystemtypeNumber)) {
                isRepcType = true;
            }
            if (isGoodsBizType) {
                jointsystemtype = "self";
            }
        }
        this.setRule(jointCacheData, sourceEntity.toString(), targetEntity.toString(), customParam, isRepcType);
        if ("self".equals(jointsystemtype) && !isRepcType || isGoodsBizType) {
            this.getModel().setValue("sourceentity", (Object)EntityMetadataCache.getDataEntityType((String)sourceEntity.toString()).getDisplayName().getLocaleValue());
            this.getModel().setValue("targetentity", (Object)EntityMetadataCache.getDataEntityType((String)targetEntity.toString()).getDisplayName().getLocaleValue());
        } else if ("eas".equals(jointsystemtype) || "xkcloud".equals(jointsystemtype)) {
            Object sourceEntityName = Optional.ofNullable(customParams.get("sourceentityname")).orElse(sourceEntity);
            Object targetEntityName = Optional.ofNullable(customParams.get("targetentityname")).orElse(targetEntity);
            this.getModel().setValue("sourceentity", sourceEntityName);
            this.getModel().setValue("targetentity", targetEntityName);
        }
        if (replenishtype != null) {
            this.getModel().setValue("replenishtype", replenishtype);
        }
        if ((invisibleObj = customParams.get("invisible")) != null) {
            List invisibles = (List)invisibleObj;
            if (CollectionUtils.isEmpty((Collection)invisibles)) {
                return;
            }
            for (String invisible : invisibles) {
                this.getView().setVisible(Boolean.FALSE, new String[]{invisible});
            }
        }
        if ((visibleObj = customParams.get("visible")) != null) {
            List visibles = (List)visibleObj;
            if (CollectionUtils.isEmpty((Collection)visibles)) {
                return;
            }
            for (String visible : visibles) {
                this.getView().setVisible(Boolean.TRUE, new String[]{visible});
            }
        }
    }

    private void noBotpTips(ComboEdit ruleCombo, List<ComboItem> ruleItems) {
        ComboItem ruleItem = new ComboItem();
        ruleItem.setValue(BOTPERRORCODE);
        ruleItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u7528\u8f6c\u6362\u89c4\u5219\u3002", (String)"PbdCommonBotpPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0])));
        ruleItems.add(ruleItem);
        ruleCombo.setComboItems(ruleItems);
        this.getModel().setValue(RULE, (Object)ruleItems.get(0).getValue());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok"});
    }

    private void setRule(DynamicObject jointCacheData, String sourceEntity, String targetEntity, Map<String, Object> customParam, boolean isRepcType) {
        ComboItem comboItem;
        Object botprule;
        ComboEdit ruleCombo = (ComboEdit)this.getControl(RULE);
        ArrayList<ComboItem> ruleItems = new ArrayList<ComboItem>();
        ComboItem defaultRuleItem = new ComboItem();
        boolean isGoodsBizType = customParam != null && customParam.get("isGoodsBizType") != null && Boolean.parseBoolean((String)customParam.get("isGoodsBizType"));
        String jointsystemtype = null;
        if (jointCacheData != null) {
            jointsystemtype = jointCacheData.getString("jointchanneltype.jointsystemtype");
            if (isGoodsBizType) {
                jointsystemtype = "self";
            }
            DynamicObject iscLink = SystemJointChannelHelper.getJointDataIscLink((DynamicObject)jointCacheData);
            String iscLinkNumber = null;
            if (iscLink != null) {
                iscLinkNumber = iscLink.getString("number");
            }
            if (customParam != null) {
                customParam.put("isclinknumber", iscLinkNumber);
            }
        }
        BotpService botpService = null;
        if (jointsystemtype != null) {
            botpService = PbdSystemJointBotpServiceHelper.getJointSystemBotpService((String)jointsystemtype, (Boolean)isRepcType);
        }
        ArrayList ruleList = new ArrayList(16);
        if (botpService != null) {
            ruleList.addAll(botpService.getRuleList(sourceEntity, targetEntity, customParam));
        }
        if (!ruleList.isEmpty()) {
            for (BotpRule rule : ruleList) {
                if (rule.isEnabled() && rule.isDefRule()) {
                    defaultRuleItem.setValue(rule.getId());
                    defaultRuleItem.setCaption(rule.getName());
                    ruleItems.add(defaultRuleItem);
                    continue;
                }
                if (!rule.isEnabled()) continue;
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(rule.getId());
                ruleItem.setCaption(rule.getName());
                ruleItems.add(ruleItem);
            }
        } else if (customParam != null && (botprule = customParam.get("botprule")) != null && (comboItem = (ComboItem)JSONObject.toJavaObject((JSON)((JSON)botprule), ComboItem.class)) != null) {
            ruleItems.add(comboItem);
        }
        if (ruleItems.isEmpty()) {
            this.noBotpTips(ruleCombo, ruleItems);
            ruleCombo.setComboItems(ruleItems);
            return;
        }
        ruleCombo.setComboItems(ruleItems);
        if (defaultRuleItem.getValue() != null) {
            this.getModel().setValue(RULE, (Object)defaultRuleItem.getValue());
        }
        if (defaultRuleItem.getValue() == null && !ruleItems.isEmpty()) {
            this.getModel().setValue(RULE, (Object)((ComboItem)ruleItems.get(0)).getValue());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control srcCtrl = (Control)evt.getSource();
        switch (srcCtrl.getKey()) {
            case "btnok": {
                Object botpdata = this.getModel().getValue(RULE);
                if (botpdata != null && !BOTPERRORCODE.equals(botpdata)) {
                    HashMap<String, Object> returnData = new HashMap<String, Object>(8);
                    Map customParams = this.getView().getFormShowParameter().getCustomParams();
                    if (customParams.isEmpty()) break;
                    String sourceEntity = customParams.get("sourceentity").toString();
                    String targetEntity = customParams.get("targetentity").toString();
                    returnData.put("sourceentity", sourceEntity);
                    returnData.put("targetentity", targetEntity);
                    returnData.put(RULE, botpdata);
                    this.getView().returnDataToParent(returnData);
                    this.getView().close();
                    break;
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u7528\u8f6c\u6362\u89c4\u5219\u3002", (String)"PbdCommonBotpPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }
}

