/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;

public class PbdGroupClassStandardListPlugin
extends StandardTreeListPlugin {
    private static final Log logger = LogFactory.getLog(PbdGroupClassStandardListPlugin.class);
    private static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String PROP_STANDARDLST = "cmbstandardlst";
    private static final String GOODS_STANDARDLST = "bd_goodsclassstandard";
    private static final String GOODS_CLASSLST = "mdr_goodsclass";
    private static final String MALL_GOODS = "pbd_mallgoods";
    private static final String CLASSSTANDARDID_JD = "944842054167432192";
    private static final String CLASSSTANDARDID_SN = "944842143380409344";
    private static final String CLASSSTANDARDID_DL = "944842210522696704";
    private static final String CLASSSTANDARDID_XY = "1046877181285874688";
    private static final String CLASSSTANDARDID_CG = "1082516039700689920";
    private static final String CLASSSTANDARDID_JDPRO = "1368845073734704128";
    private static final String PROP_ID = "id";
    private static final String PROP_PARENT = "parent";
    private static final String PROP_GROUP = "group";
    private static final String PROP_LONGNUMBER = "longnumber";
    private static final String OP_OPEN = "btn_open";
    private static final String CP_GROUPSTANDARD = "groupStandard";
    private static final String GOODS_STANDARD_PARM = "id,number,name,ispreset";
    private static final String PARM_QUERY = "id,number,name,parent,longnumber,isleaf";
    private static final String PARM_NAME = "name";
    private static final String PARM_NUMBER = "number";
    private static final String PARM_ISPRESET = "ispreset";
    private static final String PARM_ZERO = "0";
    private static final String PARM_ONE = "1";
    private static final String PARM_ENABLE = "enable";
    private static final String PARM_SOURCE = "source";
    private static final String PARM_STANDARD = "standard";
    private static final String PARM_ISLEAF = "isleaf";
    private static final String PARM_ISOPEN_ALL = "isOpenAll";

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
    }

    public void afterBindData(EventObject e) {
        if (this.getModel().getValue(PROP_STANDARDLST) == null) {
            ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
            List<Map<String, Object>> standardLists = this.getComData();
            this.setComboEdit(standardLists);
            String groupStandard = "";
            if (param.getCustomParam(CP_GROUPSTANDARD) != null && StringUtils.isNotBlank((CharSequence)param.getCustomParam(CP_GROUPSTANDARD).toString())) {
                groupStandard = param.getCustomParam(CP_GROUPSTANDARD).toString();
            }
            String defGroupStandard = CLASSSTANDARDID_JD;
            ArrayList<String> standardIds = new ArrayList<String>(standardLists.size());
            if (standardLists.size() > 0) {
                for (Map<String, Object> standardMap : standardLists) {
                    standardIds.add(standardMap.get(PROP_ID).toString());
                }
            }
            if (standardIds.size() == 0) {
                TreeNode root = this.getTreeModel().createRootNode();
                if (root == null) {
                    this.treeListView.refreshTreeView();
                } else {
                    this.treeListView.getTreeView().deleteAllNodes();
                }
                return;
            }
            if (!standardIds.contains(defGroupStandard)) {
                groupStandard = (String)standardIds.get(0);
            }
            if (!StringUtils.isBlank((CharSequence)groupStandard)) {
                this.getModel().setValue(PROP_STANDARDLST, (Object)groupStandard);
            } else {
                this.getModel().setValue(PROP_STANDARDLST, (Object)defGroupStandard);
            }
            this.getView().updateView(PROP_STANDARDLST);
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
        }
    }

    private String getSource(Object classStandardId) {
        return PbdGroupClassStandardListPlugin.getStandardPlatformMap().getOrDefault(String.valueOf(classStandardId), EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    private QFilter genRefreshFilter(String nodeId) {
        Object classStandardId = this.getModel().getValue(PROP_STANDARDLST);
        if (null == classStandardId) {
            return new QFilter(PROP_ID, "=", (Object)0L);
        }
        if (ROOTNODEID.equals(nodeId)) {
            return new QFilter(PARM_SOURCE, "=", (Object)this.getSource(classStandardId));
        }
        QFilter qFilter = null;
        QFilter[] qFilters = null;
        if (null != nodeId && !PARM_ZERO.equals(nodeId)) {
            List<Long> groupIds = this.queryGroupsByGroupId(GOODS_CLASSLST, classStandardId, nodeId);
            QFilter f2 = new QFilter(PROP_GROUP, "in", groupIds);
            qFilters = new QFilter[]{f2};
        } else {
            qFilters = new QFilter[]{new QFilter(PARM_SOURCE, "=", (Object)this.getSource(classStandardId))};
        }
        DynamicObjectCollection itemDynObjColl = QueryServiceHelper.query((String)MALL_GOODS, (String)PROP_ID, (QFilter[])qFilters);
        HashSet<Long> itemIdSets = new HashSet<Long>(itemDynObjColl.size());
        for (DynamicObject itemDynObj : itemDynObjColl) {
            itemIdSets.add(itemDynObj.getLong(PROP_ID));
        }
        qFilter = PARM_ZERO.equals(nodeId) ? new QFilter(PROP_ID, "not in", itemIdSets).and(new QFilter(PARM_SOURCE, "=", (Object)this.getSource(classStandardId))) : new QFilter(PROP_ID, "in", itemIdSets);
        return qFilter;
    }

    private List<Long> queryGroupsByGroupId(String entity, Object standardId, Object id) {
        if (id == null) {
            return null;
        }
        Long pk = Long.valueOf(String.valueOf(id));
        ArrayList<Long> list = new ArrayList<Long>(1);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)entity, (String)"longnumber,isleaf", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "=", (Object)pk)});
        if (!ObjectUtils.isEmpty((Object)queryOne) && queryOne.getBoolean(PARM_ISLEAF)) {
            list.add(pk);
            return list;
        }
        String longnumber = queryOne.getString(PROP_LONGNUMBER);
        QFilter f1 = new QFilter(PROP_LONGNUMBER, "like", (Object)(longnumber + "%"));
        QFilter f2 = new QFilter(PARM_STANDARD, "=", (Object)Long.valueOf(String.valueOf(standardId)));
        QFilter[] qFilters = new QFilter[]{f1, f2};
        ORM ormOV = ORM.create();
        DataSet ds = ormOV.queryDataSet(((Object)((Object)this)).getClass().getName(), entity, PROP_ID, qFilters);
        if (null != ds) {
            for (Row row : ds) {
                if (row.getString(PROP_ID) == null) continue;
                list.add(row.getLong(PROP_ID));
            }
            ds.close();
        }
        return list;
    }

    private List<Map<String, Object>> getComData() {
        QFilter[] qfilers = new QFilter[]{new QFilter(PARM_ENABLE, "=", (Object)PARM_ONE)};
        Map bizMap = BusinessDataServiceHelper.loadFromCache((String)GOODS_STANDARDLST, (String)GOODS_STANDARD_PARM, (QFilter[])qfilers);
        if (bizMap == null || bizMap.isEmpty()) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> listStandard = new ArrayList<Map<String, Object>>(bizMap.size());
        Set<String> standards = PbdGroupClassStandardListPlugin.getMallGoodsStandardS();
        for (Map.Entry entry : bizMap.entrySet()) {
            DynamicObject dyStandard = (DynamicObject)entry.getValue();
            HashMap<String, String> map = new HashMap<String, String>(bizMap.size());
            if (!standards.contains(dyStandard.get(PROP_ID).toString())) continue;
            listStandard.add(map);
            map.put(PROP_ID, dyStandard.get(PROP_ID).toString());
            map.put(PARM_NAME, dyStandard.get(PARM_NAME).toString());
            map.put(PARM_ISPRESET, dyStandard.getBoolean(PARM_ISPRESET) ? PARM_ONE : PARM_ZERO);
        }
        return listStandard;
    }

    private void setComboEdit(List<Map<String, Object>> orgDataList) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(PROP_STANDARDLST);
        this.setComboValue(combo, this.setComboItems(orgDataList));
    }

    private void setComboValue(ComboEdit comboEdit, Map<String, LocaleString> value) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (Map.Entry<String, LocaleString> entry : value.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(entry.getValue());
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    private Map<String, LocaleString> setComboItems(List<Map<String, Object>> orgModelList) {
        HashMap<String, LocaleString> comboItems = new HashMap<String, LocaleString>(16);
        if (orgModelList != null && orgModelList.size() > 0) {
            boolean isPreset = false;
            Object standardId = 1;
            for (Map<String, Object> map : orgModelList) {
                if (!PARM_ONE.equals((String)map.get(PARM_ISPRESET))) continue;
                standardId = map.get(PROP_ID);
                isPreset = true;
                break;
            }
            for (Map<String, Object> map : orgModelList) {
                String id = (String)map.get(PROP_ID);
                String fName = (String)map.get(PARM_NAME);
                comboItems.put(id, new LocaleString(fName));
            }
            if (!isPreset) {
                standardId = orgModelList.get(0).get(PROP_ID);
            }
            this.getModel().setValue(PROP_STANDARDLST, standardId);
        }
        return comboItems;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null || rootNode.getTreeNode(nodeId, 20) == null) {
            return;
        }
        if (PARM_ZERO.equals(nodeId)) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{OP_OPEN});
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.initTree();
    }

    private void initTree() {
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            logger.info("\u5206\u7c7b\u6807\u51c6\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        ITreeModel treeModel;
        String nodeId = e.getNodeId().toString();
        if (PARM_ZERO.equalsIgnoreCase(nodeId)) {
            e.setChildNodes(new ArrayList());
            return;
        }
        String isOpenAll = this.getPageCache().get(PARM_ISOPEN_ALL);
        boolean flag = false;
        if (Boolean.TRUE.toString().equals(isOpenAll)) {
            flag = true;
        }
        String textFormat = "";
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null && (treeModel = treeView.getTreeModel()) instanceof TreeListModel) {
            TreeListModel treeListModel = (TreeListModel)treeModel;
            textFormat = treeListModel.getTextFormat();
        }
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId, flag, flag, textFormat);
        if (nodeId.equals(this.getTreeModel().getRoot().getId())) {
            TreeNode noOrgNode = new TreeNode(nodeId, PARM_ZERO, ResManager.loadKDString((String)"\u672a\u5206\u7c7b", (String)"PbdGroupClassStandardListPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]), false);
            treeNodes.add(noOrgNode);
        }
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId, boolean isGetAllSub, boolean isOpen, String textFormat) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        Object value = this.getModel().getValue(PROP_STANDARDLST);
        if (null == value && null == this.getModel().getValue(PROP_STANDARDLST)) {
            value = PARM_ONE;
        }
        if (ROOTNODEID.equals(nodeId)) {
            nodeId = PARM_ZERO;
        }
        QFilter qFilter = new QFilter(PARM_STANDARD, "=", (Object)Long.valueOf((String)value));
        QFilter qFilter2 = new QFilter(PROP_PARENT, "=", (Object)Long.valueOf(nodeId));
        DynamicObjectCollection groups = QueryServiceHelper.query((String)GOODS_CLASSLST, (String)PARM_QUERY, (QFilter[])new QFilter[]{qFilter, qFilter2});
        for (DynamicObject group : groups) {
            if (group.getString(PROP_ID) == null) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getString(PROP_ID));
            treeNode.setParentid(group.get(PROP_PARENT) != null ? group.getString(PROP_PARENT) : ROOTNODEID);
            String name = group.getString(PARM_NAME);
            String number = group.getString(PARM_NUMBER);
            if (StringUtils.isBlank((CharSequence)name)) {
                name = group.getString(PARM_NAME);
            }
            String text = "";
            if (StringUtils.isNotBlank((CharSequence)textFormat)) {
                text = textFormat.replace("{name}", StringUtils.isBlank((CharSequence)name) ? "" : name).replace("{code}", StringUtils.isBlank((CharSequence)number) ? "" : number);
            }
            if (StringUtils.isBlank((CharSequence)text)) {
                treeNode.setText(name);
            } else {
                treeNode.setText(text);
            }
            treeNode.setLongNumber(group.getString(PROP_LONGNUMBER));
            Object parentNode = group.get(PARM_ISLEAF);
            if (parentNode != null && !((Boolean)parentNode).booleanValue()) {
                if (isGetAllSub) {
                    treeNode.addChildren(this.getTreeChildren(group.getString(PROP_ID), isGetAllSub, isOpen, textFormat));
                } else {
                    treeNode.addChildren(new ArrayList());
                }
            }
            if (isOpen) {
                treeNode.setIsOpened(isOpen);
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    public void expendTreeNode(TreeNodeEvent e) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        String nodeId = (String)e.getNodeId();
        if ((rootNode == null || StringUtils.isBlank((CharSequence)nodeId) ? null : rootNode.getTreeNode(nodeId, 20)) == null) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        if (node == null) {
            return;
        }
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctr = (Control)evt.getSource();
        if (ctr == null) {
            return;
        }
        String itemkey = ctr.getKey();
        if (!OP_OPEN.equals(itemkey)) {
            return;
        }
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "btn_open": {
                TreeView treeView = this.getTreeListView().getTreeView();
                String oldFocusNodeId = treeView.getTreeState().getFocusNodeId();
                TreeNode root = this.getTreeModel().createRootNode();
                if (root == null) {
                    this.treeListView.refreshTreeView();
                    break;
                }
                this.getPageCache().put(PARM_ISOPEN_ALL, "true");
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                this.treeListView.getTreeView().queryTreeNodeChildren(root.getParentid(), root.getId());
                if (oldFocusNodeId != null && !ROOTNODEID.equals(oldFocusNodeId)) {
                    this.getPageCache().put(PARM_ISOPEN_ALL, "true");
                    treeView.treeNodeClick("", oldFocusNodeId);
                }
                this.getPageCache().remove(PARM_ISOPEN_ALL);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        List qFilters = e.getQFilters();
        QFilter filter = this.genRefreshFilter(nodeId);
        if (filter != null) {
            qFilters.add(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (PROP_STANDARDLST.equals(propertyName)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.clearPageCache();
        }
    }

    private void clearPageCache() {
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        this.getPageCache().remove(searchNodesCacheKey);
        this.getPageCache().remove(matchNodesCacheKey);
        this.getPageCache().remove(oldSearchTextCacheKey);
        this.getPageCache().remove(searchIndexCacheKey);
    }

    private static Set<String> getMallGoodsStandardS() {
        return PbdGroupClassStandardListPlugin.getStandardPlatformMap().keySet();
    }

    private static Map<String, String> getStandardPlatformMap() {
        HashMap<String, String> mallGoodsStandardMap = new HashMap<String, String>();
        QFilter qFilter = new QFilter(PARM_ENABLE, "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        DynamicObjectCollection ecadmitDyns = QueryServiceHelper.query((String)"pmm_ecadmit", (String)"id,number,name,platform,standard.id,standard.number,standard.name", (QFilter[])new QFilter[]{qFilter}, (String)"platform desc");
        for (DynamicObject ecadmitDyn : ecadmitDyns) {
            mallGoodsStandardMap.put(ecadmitDyn.getString("standard.id"), ecadmitDyn.getString("platform"));
        }
        return mallGoodsStandardMap;
    }
}

