/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.exception.EcApiException;
import kd.scm.common.ecapi.jd.JDAccessTokenUtil;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.kuaidi100.impl.kuaidiQueryHelper;
import kd.scm.common.kuaidi100.util.KuaidiUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.GenericLogisticsInfoQueryUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PbdLogisticsPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public static final String LOGISTICS_TYPE = "LOGISTICS_TYPE";
    public static final String LOGISTICS_TYPE_VALUE = "invoice";
    public static final String ECCHILDORDERIDS = "ecChildOrderids";
    public static final String JDCHILDORDERIDS = "JDCHILDORDERIDS";
    public static final String PLATFORM = "platform";
    private static final Log log = LogFactory.getLog(PbdLogisticsPlugin.class);
    private static final Long LOGISTICSJD = 457L;
    private static final Long LOGISTICSSN = 815L;
    private static final Long SUPPLIER_JD = 486095512240421888L;
    private static final Long SUPPLIER_SN = 968563370657601536L;
    private static final String[] rightSelectFields = new String[]{"childOrderId jdchildid", "childOrderId logisticsno"};
    private static final String[] leftSelectFields = new String[]{"billno", "platform", "cfmstatus", "id", "supplier", "logisticssupplier", "rcvorg", "jdparentid", "erpbillnumber", "settleorg"};

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String logisticsTypeName = (String)formShowParameter.getCustomParam(LOGISTICS_TYPE);
        if (LOGISTICS_TYPE_VALUE.equals(logisticsTypeName)) {
            this.showInvoiceLogisticsData();
        } else {
            this.showOrderLogisticsData();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.selectRows(0);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    private void showInvoiceLogisticsData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String source = (String)formShowParameter.getCustomParam(PLATFORM);
        if (StringUtils.isEmpty((CharSequence)source)) {
            log.info("\u754c\u9762\u53c2\u6570platfrom\u7f3a\u5931\u3002");
            return;
        }
        List ecChildOrderIds = (List)formShowParameter.getCustomParam(ECCHILDORDERIDS);
        this.getView().setVisible(Boolean.FALSE, new String[]{"logisticsdate", "logisticsdelidate", "logisticsnote", "ftime", "logisticssupplier"});
        this.fillEntryentity(this.getInvoiceLogisticData(source, ecChildOrderIds), source);
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", 0);
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u7269\u6d41\u4fe1\u606f\u3002", (String)"PbdLogisticsPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showInvoiceLogisticDetail(dynamicObject);
    }

    private void showOrderLogisticsData() {
        this.showLogisticsData();
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", 0);
        if (null != dynamicObject) {
            this.showLogDetailData(dynamicObject);
        }
    }

    private void showLogisticsData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billno = (String)formShowParameter.getCustomParam("billno");
        String source = (String)formShowParameter.getCustomParam(PLATFORM);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        List jdChildOrderIds = (List)formShowParameter.getCustomParam(JDCHILDORDERIDS);
        DynamicObjectCollection malOrderEntityCol = this.queryMalOrderEntity(billno, jdChildOrderIds, source);
        if (!malOrderEntityCol.isEmpty()) {
            source = ((DynamicObject)malOrderEntityCol.get(0)).getString(PLATFORM);
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"jdchildid", "jdparentid"});
                dynamicObjects.addAll(this.map2LogisticsDynamicColl(malOrderEntityCol));
            } else if (this.judgeSource(source)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"logisticsdate", "logisticsdelidate", "logisticsnote", "ftime"});
                dynamicObjects.addAll((Collection<DynamicObject>)this.getJdGoodsLogisticData(billno));
            }
            this.fillEntryentity(dynamicObjects, billno, source);
        }
    }

    private DataSet getInvoiceLogisticData(String platform, List<String> childOrderIds) {
        String selectFields = "billno,platform,cfmstatus,entryentity.supplier supplier,entryentity.note logisticssupplier,rcvorg rcvorg,settleorg settleorg,jdorderid jdparentid,entryentity.id,entryentity.erpbillnumber erpbillnumber, entryentity.order orderid, entryentity.jdorder jdorderid";
        DataSet ecOrder = MalOrderUtil.isJD((String)platform) || StringUtils.equals((CharSequence)platform, (CharSequence)EcPlatformEnum.ECPLATFORM_JDPRO.getVal()) ? QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pbd_jdorder", (String)"id, number childOrderId", (QFilter[])new QFilter[]{new QFilter("number", "in", childOrderIds)}, null) : QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)MalNewOrderUtils.getPlatformId((String)platform), (String)"id, orderId childOrderId", (QFilter[])new QFilter[]{new QFilter("orderid", "in", childOrderIds)}, null);
        if (ecOrder == null || ecOrder.isEmpty()) {
            return null;
        }
        DataSet malOrderSet = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "mal_order", selectFields, new QFilter[0]);
        JoinDataSet join = malOrderSet.join(ecOrder, JoinType.INNER);
        if (MalOrderUtil.getDefaultMalVersion()) {
            return join.on("orderid", "id").select(leftSelectFields, rightSelectFields).finish();
        }
        return join.on("jdorderid", "id").select(leftSelectFields, rightSelectFields).finish();
    }

    public DynamicObjectCollection packageJdData(QFilter[] qFilters) {
        String selectFields = "billno,platform,cfmstatus,entryentity.supplier supplier,entryentity.note logisticssupplier,rcvorg rcvorg,jdorderid jdparentid,entryentity.id,entryentity.erpbillnumber erpbillnumber,entryentity.jdorder.number jdchildid,entryentity.jdorder.number logisticsno";
        DynamicObjectCollection col = QueryServiceHelper.query((String)"mal_order", (String)selectFields, (QFilter[])qFilters);
        for (DynamicObject dyn : col) {
            DynamicObject scpOrderDyn;
            dyn.set("supplier", (Object)Long.valueOf("486095512240421888"));
            dyn.set("logisticssupplier", (Object)LOGISTICSJD);
            String erpBillNumber = dyn.getString("erpbillnumber");
            if (!StringUtils.isNotEmpty((CharSequence)erpBillNumber) || (scpOrderDyn = QueryServiceHelper.queryOne((String)"scp_order", (String)"id,rcvorg", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)erpBillNumber)})) == null) continue;
            dyn.set("rcvorg", (Object)scpOrderDyn.getString("rcvorg"));
        }
        return col;
    }

    public DynamicObjectCollection queryMalOrderEntity(String billno, List<String> ecChildOrderIds, String platform) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        String selectProperties = "billno,platform,cfmstatus,entryentity.erpbillnumber erpbillnumber,jdorderid, ecorderid,rcvorg revorg";
        QFilter[] qFilters = new QFilter[2];
        QFilter billNoFilter = null;
        if (StringUtils.isNotBlank((CharSequence)billno)) {
            qFilters[0] = billNoFilter = new QFilter("billno", "=", (Object)billno);
        }
        QFilter childOrderidFilter = null;
        if (!MalOrderUtil.getDefaultMalVersion()) {
            if (null != ecChildOrderIds && !ecChildOrderIds.isEmpty()) {
                qFilters[1] = childOrderidFilter = new QFilter("entryentity.jdorder.number", "in", ecChildOrderIds);
            }
        } else if (ecChildOrderIds != null && !ecChildOrderIds.isEmpty()) {
            qFilters[1] = childOrderidFilter = new QFilter("entryentity.order", "in", (Object)MalNewOrderUtils.getEcOrderPks((String)platform, new HashSet<String>(ecChildOrderIds)));
        }
        if (null != billNoFilter || null != childOrderidFilter) {
            result = QueryServiceHelper.query((String)"mal_order", (String)selectProperties, (QFilter[])qFilters);
        }
        return result;
    }

    public void fillEntryentity(DataSet ds, String platform) {
        if (ds == null || ds.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u7269\u6d41\u4fe1\u606f\u3002", (String)"PbdLogisticsPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        HashSet<String> lognumSet = new HashSet<String>();
        int index = 0;
        while (ds.hasNext()) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            Row row = ds.next();
            if (!lognumSet.contains(row.getString("logisticsno"))) {
                String logisticsNo;
                Map<String, List<Map<String, String>>> childOrderIdAndInfo;
                List<Map<String, String>> logisticsInfo;
                DynamicObject scpOrderDyn;
                lognumSet.add(row.getString("logisticsno"));
                String erpBillNumber = row.getString("erpbillnumber");
                vs.set("erpbillnumber", (Object)erpBillNumber, index);
                vs.set("supplier", (Object)Long.valueOf(row.getString("supplier")), index);
                if (StringUtils.isNotEmpty((CharSequence)row.getString("erpbillnumber")) && (scpOrderDyn = QueryServiceHelper.queryOne((String)"scp_order", (String)"id,rcvorg", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)erpBillNumber)})) != null) {
                    vs.set("rcvorg", (Object)scpOrderDyn.getString("rcvorg"), index);
                }
                if (MalOrderUtil.isJD((String)platform) || StringUtils.equals((CharSequence)platform, (CharSequence)EcPlatformEnum.ECPLATFORM_JDPRO.getVal())) {
                    vs.set("supplier", (Object)SUPPLIER_JD, index);
                    vs.set("logisticssupplier", (Object)LOGISTICSJD, index);
                } else if (MalOrderUtil.isSN((String)platform)) {
                    vs.set("supplier", (Object)SUPPLIER_SN, index);
                    vs.set("logisticssupplier", (Object)LOGISTICSSN, index);
                }
                vs.set("billno", (Object)row.getString("billno"), index);
                vs.set("jdchildid", (Object)row.getString("jdchildid"), index);
                vs.set("jdparentid", (Object)row.getString("jdparentid"), index);
                vs.set("settleorg", (Object)row.getLong("settleorg"), index);
                if (defaultMalVersion && !CollectionUtils.isEmpty(logisticsInfo = (childOrderIdAndInfo = this.requestInvoiceLogistics(row.getString("jdchildid"), platform, row.getString("settleorg"))).get(platform)) && StringUtils.isNotBlank((CharSequence)(logisticsNo = logisticsInfo.get(0).get("logisticsNo")))) {
                    vs.set("logisticsno", (Object)logisticsNo, index);
                }
                ++index;
            }
            model.batchCreateNewEntryRow("entryentity", vs);
        }
    }

    public void fillEntryentity(ArrayList<DynamicObject> dynamicObjects, String billno, String source) {
        if (dynamicObjects.size() > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            HashSet<String> lognumSet = new HashSet<String>();
            int index = 0;
            for (DynamicObject dyn : dynamicObjects) {
                if (!this.judgeSource(source)) {
                    if (lognumSet.contains(dyn.getString("logbillno"))) continue;
                    lognumSet.add(dyn.getString("logbillno"));
                    vs.set("erpbillnumber", (Object)dyn.getString("billno"), index);
                    vs.set("supplier", (Object)Long.valueOf(dyn.getString("supplier")), index);
                    vs.set("rcvorg", (Object)dyn.getString("rcvorg"), index);
                    vs.set("logisticssupplier", (Object)Long.valueOf(dyn.getString("logsupplier")), index);
                    vs.set("logisticsno", (Object)dyn.getString("logbillno"), index);
                    String pattern = "yyyy-MM-dd";
                    vs.set("logisticsdate", (Object)DateUtil.string2date((String)dyn.getString("logdate"), (String)pattern), index);
                    vs.set("logisticsdelidate", (Object)DateUtil.string2date((String)dyn.getString("logdelidate"), (String)pattern), index);
                    vs.set("logisticsnote", (Object)dyn.getString("lognote"), index);
                    vs.set("billno", (Object)billno, index);
                    ++index;
                    continue;
                }
                if (lognumSet.contains(dyn.getString("logisticsno"))) continue;
                lognumSet.add(dyn.getString("logisticsno"));
                vs.set("erpbillnumber", (Object)dyn.getString("erpbillnumber"), index);
                vs.set("supplier", (Object)Long.valueOf(dyn.getString("supplier")), index);
                vs.set("rcvorg", (Object)dyn.getString("rcvorg"), index);
                vs.set("logisticssupplier", (Object)Long.valueOf(dyn.getString("logisticssupplier")), index);
                vs.set("logisticsno", (Object)dyn.getString("logisticsno"), index);
                vs.set("billno", (Object)dyn.getString("billno"), index);
                vs.set("jdchildid", (Object)dyn.getString("jdchildid"), index);
                vs.set("logisticsno", (Object)dyn.getString("jdchildid"), index);
                vs.set("jdparentid", (Object)dyn.getString("jdparentid"), index);
                ++index;
            }
            model.batchCreateNewEntryRow("entryentity", vs);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u7269\u6d41\u4fe1\u606f\u3002", (String)"PbdLogisticsPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
    }

    public DynamicObjectCollection getJdGoodsLogisticData(String billno) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billno);
        QFilter[] qFilters = new QFilter[]{qFilter};
        return this.packageJdData(qFilters);
    }

    private ArrayList<DynamicObject> map2LogisticsDynamicColl(DynamicObjectCollection malOrderEntityCol) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        HashSet<String> set = new HashSet<String>();
        for (DynamicObject malOrderEntity : malOrderEntityCol) {
            String erpBillNumber = malOrderEntity.getString("erpbillnumber");
            if (set.contains(erpBillNumber)) continue;
            set.add(erpBillNumber);
            QFilter qFilter = new QFilter("billno", "=", (Object)erpBillNumber);
            QFilter[] qFilters = new QFilter[]{qFilter};
            if (!StringUtils.isNotEmpty((CharSequence)erpBillNumber)) continue;
            QFilter[] scpQFilters = new QFilter[2];
            QFilter billNoQFilter = new QFilter("billno", "=", (Object)erpBillNumber);
            QFilter lognoQFilter = new QFilter("logentryentity.logbillno", "is not null", (Object)"");
            scpQFilters[0] = billNoQFilter;
            scpQFilters[1] = lognoQFilter;
            GenericLogisticsInfoQueryUtil genericLogisticsInfoQueryUtil = new GenericLogisticsInfoQueryUtil();
            List data = genericLogisticsInfoQueryUtil.queryDynamicObjectDataForMall(erpBillNumber);
            for (DynamicObject dynamicObject : data) {
                dynamicObject.set("billno", (Object)erpBillNumber);
            }
            dynamicObjects.addAll(data);
        }
        return dynamicObjects;
    }

    public void entryRowClick(RowClickEvent evt) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String logisticsTypeName = (String)formShowParameter.getCustomParam(LOGISTICS_TYPE);
        int rowIndex = evt.getRow();
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        if (LOGISTICS_TYPE_VALUE.equals(logisticsTypeName) && null != dynamicObject) {
            this.showInvoiceLogisticDetail(dynamicObject);
        } else if (null != dynamicObject) {
            this.showLogDetailData(dynamicObject);
        }
    }

    private void showLogDetailData(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u7269\u6d41\u4fe1\u606f\u3002", (String)"PbdLogisticsPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> queryLogMap = new HashMap<String, Object>();
        DynamicObject logisticSupplierDyn = dynamicObject.getDynamicObject("logisticssupplier");
        if (logisticSupplierDyn == null) {
            log.info(ResManager.loadKDString((String)"\u7269\u6d41\u4f9b\u5e94\u5546\u4e3a\u7a7a\u3002", (String)"PbdLogisticsPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (logisticSupplierDyn.getLong("id") == LOGISTICSJD.longValue()) {
            String jdChildId = dynamicObject.getString("jdchildid");
            log.info("jdChildId\uff1a" + jdChildId);
            if (StringUtils.isNotBlank((CharSequence)jdChildId)) {
                this.showJDlogisticDetail(jdChildId);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7269\u6d41\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u3002", (String)"PbdLogisticsPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            }
        } else {
            queryLogMap.put("com", dynamicObject.getDynamicObject("logisticssupplier").get("number"));
            queryLogMap.put("num", dynamicObject.get("logisticsno"));
            if (KuaidiUtil.IsExistAccount()) {
                this.allotLogDynamicData(this.queryLogData(queryLogMap));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u9700\u8981\u914d\u7f6e\u5feb\u9012100\u8d26\u53f7\u624d\u80fd\u67e5\u8be2\u7269\u6d41\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"PbdLogisticsPlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Deprecated
    public void showInvoiceLogisticDetail(String childOrderId, String platform) {
        this.showInvoiceLogisticDetail(null);
    }

    private void showInvoiceLogisticDetail(DynamicObject dynamicObject) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (dynamicObject == null) {
            dynamicObject = model.getEntryRowEntity("entryentity", 0);
        }
        String platform = (String)this.getView().getFormShowParameter().getCustomParam(PLATFORM);
        String childOrderId = dynamicObject.getString("jdchildid");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.deleteEntryData("entryentity1");
        if (MalOrderUtil.getDefaultMalVersion()) {
            Map<String, List<Map<String, String>>> childOrderIdAndInfo = this.requestInvoiceLogistics(childOrderId, platform, dynamicObject.getString("settleorg_id"));
            List<Map<String, String>> platformRes = childOrderIdAndInfo.get(platform);
            if (platformRes != null) {
                int index = 0;
                for (int i = platformRes.size() - 1; i >= 0; --i) {
                    vs.set("time", (Object)platformRes.get(i).get("operateTime"), index);
                    vs.set("context", (Object)platformRes.get(i).get("operateState"), index++);
                }
                model.batchCreateNewEntryRow("entryentity1", vs);
            }
        } else {
            JSONArray ja = JdApiUtil.queryDeliveryNo((String)childOrderId);
            int index = 0;
            for (int i = ja.size() - 1; i >= 0; --i) {
                JSONObject jo = (JSONObject)ja.get(i);
                vs.set("time", (Object)jo.getString("opeTime"), index);
                vs.set("context", (Object)jo.getString("opeRemark"), index++);
            }
            model.batchCreateNewEntryRow("entryentity1", vs);
        }
    }

    private Map<String, List<Map<String, String>>> requestInvoiceLogistics(String childOrderId, String platform, String companyOrgID) {
        HashMap<String, List<Map<String, String>>> res = new HashMap();
        try {
            Map<String, Object> param = this.getRequestParam(childOrderId, platform, companyOrgID);
            res = EcGroupApiUtil.queryInvoicelogist(param);
        }
        catch (EcApiException e) {
            log.info(ExceptionUtil.getStackTrace((Throwable)e));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u8fd0\u5355\u4fe1\u606f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PbdLogisticsPlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
        return res;
    }

    private Map<String, Object> getRequestParam(String childOrderId, String platform, String companyOrgID) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        HashMap<String, String> platformParam = new HashMap<String, String>(4);
        if (MalOrderUtil.isJD((String)platform) || StringUtils.equals((CharSequence)platform, (CharSequence)EcPlatformEnum.ECPLATFORM_JDPRO.getVal())) {
            String token = JDAccessTokenUtil.getValidToken((String)companyOrgID, (String)platform);
            if (StringUtils.isNotBlank((CharSequence)token)) {
                platformParam.put("token", token);
            }
            platformParam.put("jdOrderId", childOrderId);
            param.put(platform, platformParam);
        } else if (MalOrderUtil.isSN((String)platform)) {
            platformParam.put("type", "2");
            platformParam.put("parameter", childOrderId);
            param.put(platform, platformParam);
        } else if (!MalOrderUtil.isXY((String)platform)) {
            if (MalOrderUtil.isCG((String)platform)) {
                DynamicObject ecOrderDyn = MalNewOrderUtils.getEcOrderDynByEcOrderId((String)childOrderId, (String)platform);
                platformParam.put("invoiceNo", ecOrderDyn.getString("invoiceid"));
                platformParam.put("invoiceCode", ecOrderDyn.getString("invoicecode"));
                param.put(platform, platformParam);
            } else if (StringUtils.equals((CharSequence)platform, (CharSequence)EcPlatformEnum.ECPLATFORM_ZKH.getVal())) {
                DynamicObject ecOrderDyn = MalNewOrderUtils.getEcOrderDynByEcOrderId((String)childOrderId, (String)platform);
                platformParam.put("markId", ecOrderDyn.getString("markid"));
                param.put(platform, platformParam);
            }
        }
        return param;
    }

    private void showJDlogisticDetail(String jdchildid) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.deleteEntryData("entryentity1");
        JSONArray ja = JdApiUtil.getOrderTrack((String)jdchildid);
        int index = 0;
        for (int i = ja.size() - 1; i >= 0; --i) {
            JSONObject jo = (JSONObject)ja.get(i);
            vs.set("time", (Object)jo.getString("msgTime"), index);
            vs.set("context", (Object)jo.getString("content"), index++);
        }
        model.batchCreateNewEntryRow("entryentity1", vs);
    }

    public void allotLogDynamicData(List<Map<String, Object>> mapList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.deleteEntryData("entryentity1");
        int rowCount = 0;
        for (Map<String, Object> object : mapList) {
            if (object instanceof Map) {
                for (Map.Entry<String, Object> entry : object.entrySet()) {
                    switch (entry.getKey()) {
                        case "time": {
                            vs.set(entry.getKey(), entry.getValue(), rowCount);
                            break;
                        }
                        case "ftime": {
                            vs.set(entry.getKey(), entry.getValue(), rowCount);
                            break;
                        }
                        case "context": {
                            vs.set(entry.getKey(), entry.getValue(), rowCount);
                            break;
                        }
                    }
                }
            } else if (object instanceof String) {
                vs.set("context", object, rowCount);
            } else {
                vs.set("context", (Object)ResManager.loadKDString((String)"\u9519\u8bef", (String)"PbdLogisticsPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]), rowCount);
            }
            ++rowCount;
        }
        model.batchCreateNewEntryRow("entryentity1", vs);
    }

    public List<Map<String, Object>> queryLogData(Map<String, Object> queryLogMap) {
        kuaidiQueryHelper httpRequestService = new kuaidiQueryHelper();
        Map resultMap = new HashMap();
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        try {
            if (!KuaidiUtil.IsExistAccount()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u9700\u8981\u914d\u7f6e\u5feb\u9012100\u8d26\u53f7\u624d\u80fd\u67e5\u8be2\u7269\u6d41\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"PbdLogisticsPlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                return mapList;
            }
            resultMap = httpRequestService.executeApi(queryLogMap);
            if ("false".equals(String.valueOf(resultMap.get("result")))) {
                KuaidiUtil.setVerify(resultMap, (IFormView)this.getView());
                log.info("resultMap:queryLogData" + resultMap);
                return mapList;
            }
            List dataList = (List)resultMap.get("data");
            if (dataList != null) {
                mapList.addAll(dataList);
            }
        }
        catch (Exception e) {
            log.debug(ExceptionUtil.getStackTrace((Throwable)e));
        }
        return mapList;
    }

    private boolean judgeSource(String source) {
        return EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source);
    }
}

