/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.control.Button;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.common.helper.scdatahandle.entity.ScDataHandleInfo;
import kd.scm.pbd.formplugin.ScHandleDataIsvUtil;

public class PbdScDataHandleParamConfigPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && !customParams.isEmpty()) {
            Object handleconfig;
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            Object scdatahandle = customParams.get("scdatahandle");
            if (scdatahandle != null) {
                model.setValue("scdatahandle", scdatahandle);
            }
            if ((handleconfig = customParams.get("handleconfig")) != null) {
                String valueProperty;
                String handleValues;
                String handleProperty;
                String filterValue;
                ScDataHandleInfo scDataHandleInfo = (ScDataHandleInfo)SerializationUtils.fromJsonString((String)handleconfig.toString(), ScDataHandleInfo.class);
                String entityKey = scDataHandleInfo.getEntityKey();
                if (entityKey != null) {
                    this.initValueProperty(entityKey, "handleproperty");
                    this.initValueProperty(entityKey, "valueproperty");
                }
                if ((filterValue = scDataHandleInfo.getFilterValue()) != null) {
                    this.getModel().setValue("filtervalue", (Object)filterValue);
                }
                if ((handleProperty = scDataHandleInfo.getHandleProperty()) != null) {
                    this.getModel().setValue("handleproperty", (Object)handleProperty);
                }
                if (entityKey != null && handleProperty != null) {
                    this.initPropertyValues("handlevalues", entityKey, handleProperty);
                    this.initPropertyValues("filtervalue", entityKey, handleProperty);
                }
                if ((handleValues = scDataHandleInfo.getHandleValues()) != null) {
                    this.getModel().setValue("handlevalues", (Object)handleValues);
                }
                if ((valueProperty = scDataHandleInfo.getValueProperty()) != null) {
                    this.getModel().setValue("valueproperty", (Object)valueProperty);
                }
            } else {
                Object scdatahandleentity = customParams.get("scdatahandleentity");
                if (scdatahandleentity != null) {
                    this.initValueProperty(scdatahandleentity.toString(), "handleproperty");
                    this.initValueProperty(scdatahandleentity.toString(), "valueproperty");
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && !customParams.isEmpty()) {
            String isv = String.valueOf(customParams.get("isv"));
            if (isv != null && !isv.isEmpty()) {
                Map<String, Object> handleDataIsvCheck = ScHandleDataIsvUtil.handleDataIsvCheck(isv);
                if (!((Boolean)handleDataIsvCheck.get("succed")).booleanValue()) {
                    this.getView().showErrorNotification((String)handleDataIsvCheck.get("message"));
                    this.setEnableFromIsv(false);
                } else {
                    this.setEnableFromIsv(true);
                }
            } else {
                this.setEnableFromIsv(false);
            }
        } else {
            this.setEnableFromIsv(false);
        }
    }

    private void setEnableFromIsv(Boolean isEnable) {
        this.getView().setEnable(isEnable, new String[]{"filtervalue", "handleproperty", "handlevalues"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"handleproperty")) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String scdatahandleentity = dataEntity.getDynamicObject("scdatahandle").getDynamicObject("entity").getString("id");
            String handlepropertyKey = dataEntity.getString(e.getProperty().getName());
            if (scdatahandleentity != null && handlepropertyKey != null) {
                this.initPropertyValues("handlevalues", scdatahandleentity, handlepropertyKey);
                this.initPropertyValues("filtervalue", scdatahandleentity, handlepropertyKey);
            }
        }
    }

    public void click(EventObject evt) {
        Button button;
        super.click(evt);
        Object evtSource = evt.getSource();
        if (evtSource instanceof Button && StringUtils.equals((CharSequence)(button = (Button)evtSource).getKey(), (CharSequence)"btnok")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject scdatahandle = dataEntity.getDynamicObject("scdatahandle");
            if (scdatahandle != null) {
                ScDataHandleInfo scDataHandleInfo = new ScDataHandleInfo();
                scDataHandleInfo.setHandleId(scdatahandle.getString("id"));
                scDataHandleInfo.setHandleClass(scdatahandle.getString("handleclass"));
                scDataHandleInfo.setIsv(scdatahandle.getString("isv"));
                scDataHandleInfo.setEntityKey(scdatahandle.getDynamicObject("entity").getString("id"));
                String handleProperty = dataEntity.getString("handleproperty");
                scDataHandleInfo.setHandleProperty(handleProperty);
                String valueProperty = dataEntity.getString("valueproperty");
                if (valueProperty != null && !valueProperty.contains(handleProperty)) {
                    valueProperty = valueProperty.endsWith(",") ? valueProperty + handleProperty : valueProperty + "," + handleProperty;
                }
                scDataHandleInfo.setValueProperty(valueProperty);
                scDataHandleInfo.setHandleValues(dataEntity.getString("handlevalues"));
                scDataHandleInfo.setFilterValue(dataEntity.getString("filtervalue"));
                String handleValues = dataEntity.getString("handlevalues");
                if (handleValues != null) {
                    String[] verifyKeys = handleValues.split(",");
                    HashSet<String> valuesKeys = new HashSet<String>(verifyKeys.length);
                    for (String v : verifyKeys) {
                        if (v == null || v.isEmpty()) continue;
                        valuesKeys.add(v);
                    }
                    scDataHandleInfo.setHandleValuesSet(valuesKeys);
                }
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)scDataHandleInfo));
            }
            this.getView().close();
        }
    }

    private void initValueProperty(String serviceEntity, String propertyKey) {
        ComboEdit valueproperty = (ComboEdit)this.getControl(propertyKey);
        if (serviceEntity != null && !serviceEntity.trim().isEmpty()) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)serviceEntity);
            valueproperty.setComboItems(this.assembleProperty(mainEntityType, ""));
        }
    }

    private void initPropertyValues(String propertyKey, String serviceEntity, String handleproperty) {
        MainEntityType mainEntityType;
        DynamicProperty handlepropertyType;
        ComboEdit valueproperty = (ComboEdit)this.getControl(propertyKey);
        if (valueproperty != null && (handlepropertyType = (mainEntityType = EntityMetadataCache.getDataEntityType((String)serviceEntity)).getProperty(handleproperty)) != null) {
            if (handlepropertyType instanceof ComboProp) {
                valueproperty.setComboItems(this.assembleHandleValues((ComboProp)handlepropertyType));
            } else if (handlepropertyType instanceof DecimalProp) {
                // empty if block
            }
        }
    }

    private List<ComboItem> assembleProperty(MainEntityType mainEntityType, String suffix) {
        ComboItem property = null;
        Map typeAllFields = mainEntityType.getAllFields();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(typeAllFields.size());
        for (Map.Entry entry : typeAllFields.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.endsWith(suffix)) continue;
            IDataEntityProperty value = (IDataEntityProperty)entry.getValue();
            if (value.getParent() instanceof EntryType) {
                key = value.getParent().getName() + "." + key;
            }
            property = new ComboItem(new LocaleString(value.getDisplayName() + "(" + key + ")"), key);
            comboItems.add(property);
        }
        return comboItems;
    }

    private List<ComboItem> assembleHandleValues(ComboProp comboProp) {
        List comboItems;
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        ComboItem property = null;
        if (comboProp != null && (comboItems = comboProp.getComboItems()) != null) {
            for (ValueMapItem valueMapItem : comboItems) {
                property = new ComboItem(new LocaleString(valueMapItem.getName() + "(" + valueMapItem.getValue() + ")"), valueMapItem.getValue());
                comboItemList.add(property);
            }
        }
        return comboItemList;
    }

    private List<ComboItem> assembleHandleValues(DecimalProp comboProp) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        Object property = null;
        return comboItemList;
    }
}

