/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.apiconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;

public class PbdSelectFieldEditPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    public static final String CUSTPARAMKEY_TREENODES = "treenodes";
    public static final String CUSTPARAMKEY_ROW = "$row";
    public static final String CUSTPARAMKEY_ISMULTI = "ismulti";
    public static final String CUSTPARAMKEY_SELECTEDNODEIDS = "nodeids";
    private static final String CACHEKEY_SELECTE_KEY = "key";
    private static final String CACHEKEY_SELECTE_ROW = "$row";
    public static final String KEY_BTNOK = "btnok";
    public static final String KEY_BTNCANCEL = "btncancel";
    public static final String KEY_TREEVIEW = "tv_fields";
    public static final String KEY_SEARCHFIELD = "searchfield";
    private static final String BILLHEAD = "billhead";
    private static final String POINT = ".";
    private static final String ISMULTI = "true";
    private static final Integer HASH_SIZE = 8;
    private static final Integer NODE_DEEP = 5;
    private static final Integer SPLIT_SIZE = 2;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL});
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search search = (Search)this.getView().getControl(KEY_SEARCHFIELD);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_TREENODES);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else {
            this.addTreeRootNode();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "btnok": {
                String currNodeId = this.getPageCache().get(CACHEKEY_SELECTE_KEY);
                Object row = this.getView().getFormShowParameter().getCustomParam("$row");
                if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                    HashMap<String, Object> data = new HashMap<String, Object>(HASH_SIZE);
                    data.put(CACHEKEY_SELECTE_KEY, currNodeId);
                    data.put("$row", row);
                    this.getView().returnDataToParent(data);
                } else {
                    this.getView().returnDataToParent((Object)"");
                }
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if (BILLHEAD.equals(currNodeId)) {
            currNodeId = "";
        }
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            return;
        }
        this.getPageCache().put(CACHEKEY_SELECTE_KEY, currNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        StringBuilder cacheNodeIds = new StringBuilder();
        TreeView treeView = (TreeView)e.getSource();
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds != null) {
            for (String checkedNode : checkedNodeIds) {
                cacheNodeIds.append(checkedNode).append(",");
            }
        }
        if (cacheNodeIds.length() > 0) {
            cacheNodeIds.deleteCharAt(cacheNodeIds.length() - 1);
        }
        this.getPageCache().put(CACHEKEY_SELECTE_KEY, cacheNodeIds.toString());
    }

    private void fillTreeNodes(String strJson) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.addNode(rootNode);
        if (rootNode != null) {
            String id = rootNode.getId();
            tree.expand(id);
            this.expand(rootNode, tree);
            if (this.isMultiSelected()) {
                this.multiSelect(tree, rootNode);
            }
        }
    }

    private void expand(TreeNode rootNode, TreeView tree) {
        List children = rootNode.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            String id = rootNode.getId();
            tree.expand(id);
            for (TreeNode t : children) {
                this.expand(t, tree);
            }
        }
    }

    private void multiSelect(TreeView tree, TreeNode rootNode) {
        tree.setMulti(true);
        String cacheNodeIds = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_SELECTEDNODEIDS);
        if (StringUtils.isNotBlank((CharSequence)cacheNodeIds)) {
            this.getPageCache().put(CACHEKEY_SELECTE_KEY, cacheNodeIds);
            String[] arr = StringUtils.split((String)cacheNodeIds, (String)",");
            ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>(8);
            for (String nodeId : arr) {
                String curNodeId;
                TreeNode curNode;
                TreeNode node = rootNode.getTreeNode(nodeId, NODE_DEEP.intValue());
                if (node != null) {
                    selectedNodes.add(node);
                    continue;
                }
                String[] split = nodeId.split("\\.", SPLIT_SIZE);
                if (split.length <= 1 || (curNode = rootNode.getTreeNode(curNodeId = split[1], NODE_DEEP.intValue())) == null) continue;
                selectedNodes.add(curNode);
            }
            if (selectedNodes.size() > 0) {
                tree.checkNodes(selectedNodes);
            }
        }
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5b57\u6bb5\u5217\u8868", (String)"PbdSelectFieldEditPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.addNode(root);
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_ISMULTI);
        if (StringUtils.isBlank((CharSequence)isMulti)) {
            return false;
        }
        return isMulti.equalsIgnoreCase(ISMULTI) || isMulti.equalsIgnoreCase(POINT);
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCHFIELD, (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_TREENODES);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            if (StringUtils.isNotBlank((CharSequence)searchText) && !CollectionUtils.isEmpty((Collection)rootNode.getChildren())) {
                rootNode.setChildren(this.getContains(rootNode.getChildren(), searchText));
            }
            tree.updateNode(rootNode);
            if (rootNode != null) {
                String id = rootNode.getId();
                tree.expand(id);
                if (this.isMultiSelected()) {
                    this.multiSelect(tree, rootNode);
                }
            }
        }
    }

    private List<TreeNode> getContains(List<TreeNode> childrens, String searchText) {
        Iterator<TreeNode> iterator = childrens.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
                treeNode.setChildren(this.getContains(treeNode.getChildren(), searchText));
            }
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren()) || treeNode.getText().contains(searchText)) continue;
            iterator.remove();
        }
        return childrens;
    }
}

