/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.apiconfig;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.scm.pbd.common.entity.FieldProp;
import kd.scm.pbd.common.utils.FieldPropUtils;
import kd.scm.pbd.common.utils.PbdCreditUtils;
import kd.scm.pbd.formplugin.util.PbdCreditPluginUtils;

public class PbdStandardApiEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final int INITIAL_SIZE = 8;
    private static Log log = LogFactory.getLog(PbdStandardApiEditPlugin.class);
    private static final String ROW = "$row";
    private static final String KEY = "key";
    private static final String OUTPUTSFIELDID_CALLBACK = "OUTPUTSFIELDID_CALLBACK";
    private static final String INPUTSFIELDID_CALLBACK = "INPUTSFIELDID_CALLBACK";
    private static final String OUTPUTSTHIRDFIELDID_CALLBACK = "OUTPUTSTHIRDFIELDID_CALLBACK";
    private static final String INPUTSTHIRDFIELDID_CALLBACK = "INPUTSTHIRDFIELDID_CALLBACK";
    private static final String PID = "pid";
    private static final String SOURCE = "source";
    protected static String platform_data = "pbd_standard_api_platform_data_%S_%S";
    protected static String standard_data = "pbd_standard_api_standard_data_%S_%S";
    protected static String third_entity_data_id = "pbd_standard_api_entityId_%S";
    protected static String third_entity_alldata = "pbd_standard_api_alldata_%S_%S";
    protected static String check_data_change = "pbd_standard_api_CheckDataChange";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"inputsthirdfieldid", "outputsthirdfieldid", "inputsfieldid", "outputsfieldid"});
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit source = (BasedataEdit)this.getView().getControl(SOURCE);
        source.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit platformapi = (BasedataEdit)this.getView().getControl("platformapi");
        platformapi.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String fieldKey = args.getProperty().getName();
        if (SOURCE.equals(fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
            showParameter.setShowApproved(false);
        } else if ("platformapi".equals(fieldKey)) {
            List types = PbdCreditUtils.creditTypes();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
            QFilter qFilter = new QFilter("systype", "in", (Object)types);
            qFilterList.add(qFilter);
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pbd_extsys", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (loads != null && loads.length > 0) {
                ArrayList<Object> source = new ArrayList<Object>(8);
                for (DynamicObject load : loads) {
                    source.add(load.getPkValue());
                }
                QFilter qFilter0 = new QFilter("group", "in", source);
                ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
                showParameter.getTreeFilterParameter().setQFilters(qFilterList);
                showParameter.getListFilterParameter().setFilter(qFilter0);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.selectRows(0);
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        DynamicObject source = model.getDataEntity().getDynamicObject(SOURCE);
        this.createCacheStandardData(model, source, true);
        List<DynamicObject> entryEntity = this.getSelectedData("entryentity");
        if (!CollectionUtils.isEmpty(entryEntity)) {
            DynamicObject dynamicObject = entryEntity.get(0);
            this.cacheThirdDataByPlatform(dynamicObject);
        }
        DynamicObjectCollection inputEntrys = model.getEntryEntity("inputsentity");
        DynamicObjectCollection outputEntrys = model.getEntryEntity("outputsentity");
        if (CollectionUtils.isEmpty((Collection)inputEntrys) && CollectionUtils.isEmpty((Collection)outputEntrys)) {
            this.putCurEntryEntityCache(pageCache, entryEntity.get(0));
            this.updateInputOutputModel(model, pageCache, Boolean.TRUE, "true", true);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.selectRows(0);
        List<DynamicObject> entryEntity = this.getSelectedData("entryentity");
        if (!CollectionUtils.isEmpty(entryEntity)) {
            this.putCurEntryEntityCache(pageCache, entryEntity.get(0));
        }
        model.beginInit();
        DynamicObjectCollection outputEntrys = model.getEntryEntity("outputsentity");
        DynamicObjectCollection inputEntrys = model.getEntryEntity("inputsentity");
        this.refreshStandardApiFieldPropCache(model, pageCache, inputEntrys, outputEntrys);
        this.updateInputOutputModel(model, pageCache, Boolean.TRUE, "true", true);
        model.endInit();
        this.setCollapse();
    }

    private void putCurEntryEntityCache(IPageCache pageCache, DynamicObject entryEntity) {
        String cacheKey = String.format(third_entity_data_id, this.getView().getPageId());
        if (entryEntity != null) {
            if ((Long)entryEntity.getPkValue() == 0L) {
                Long genGlobalLongId = DBServiceHelper.genGlobalLongId();
                entryEntity.set("id", (Object)genGlobalLongId);
            }
            pageCache.put(cacheKey, String.valueOf(entryEntity.getPkValue()));
        }
    }

    private void setCollapse() {
        TreeEntryGrid outputsTreeGrid = (TreeEntryGrid)this.getControl("outputsentity");
        outputsTreeGrid.setCollapse(false);
        TreeEntryGrid intputsTreeGrid = (TreeEntryGrid)this.getControl("inputsentity");
        intputsTreeGrid.setCollapse(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        switch (key) {
            case "save": {
                Boolean checkRepeactPlatform = this.checkRepeactPlatform();
                if (checkRepeactPlatform.booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6765\u6e90\u7b2c\u4e09\u65b9\u5e73\u53f0\u3002", (String)"PbdStandardApiEditPlugin_8", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                model.beginInit();
                DynamicObjectCollection outputEntrys = model.getEntryEntity("outputsentity");
                DynamicObjectCollection inputEntrys = model.getEntryEntity("inputsentity");
                this.refreshStandardApiFieldPropCache(model, pageCache, inputEntrys, outputEntrys);
                this.updateInputOutputModel(model, pageCache, Boolean.FALSE, "true", true);
                model.endInit();
                break;
            }
            case "deleteentryinputs": 
            case "deleteentryoutputs": {
                List<DynamicObject> entryEntity2 = this.getSelectedData("entryentity");
                if (!CollectionUtils.isEmpty(entryEntity2)) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u5173\u8054\u7b2c\u4e09\u65b9\u63a5\u53e3\u624d\u80fd\u5220\u9664\u3002", (String)"PbdStandardApiEditPlugin_11", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean noDataChange;
        super.beforeClosed(e);
        IPageCache pageCache = this.getPageCache();
        String checkDataChange = pageCache.get(check_data_change);
        boolean bl = noDataChange = StringUtils.isNotEmpty((String)checkDataChange) && "true".equalsIgnoreCase(checkDataChange);
        if (noDataChange) {
            e.setCheckDataChange(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": {
                model.beginInit();
                this.updateInputOutputModel(model, pageCache, Boolean.TRUE, "true", true);
                this.setCollapse();
                model.endInit();
                break;
            }
            case "deleteentry": {
                List<DynamicObject> entryEntity1 = this.getSelectedData("entryentity");
                if (CollectionUtils.isEmpty(entryEntity1)) {
                    EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                    entryGrid.selectRows(0);
                    entryEntity1 = this.getSelectedData("entryentity");
                }
                if (!CollectionUtils.isEmpty(entryEntity1)) {
                    model.beginInit();
                    this.putCurEntryEntityCache(pageCache, entryEntity1.get(0));
                    this.cacheThirdDataByPlatform(entryEntity1.get(0));
                    this.updateInputOutputModel(model, pageCache, Boolean.TRUE, "false", true);
                    model.endInit();
                    this.setCollapse();
                }
                this.getView().updateView("outputsentity");
                this.getView().updateView("inputsentity");
                break;
            }
            case "newentry": {
                List<DynamicObject> entryEntity3 = this.getSelectedData("entryentity");
                this.clearInputOutPutData(pageCache, entryEntity3.get(0));
                break;
            }
            case "deleteentryinputs": 
            case "deleteentryoutputs": {
                DynamicObjectCollection inputEntrys = model.getEntryEntity("inputsentity");
                DynamicObjectCollection outputEntrys = model.getEntryEntity("outputsentity");
                this.refreshStandardApiFieldPropCache(model, pageCache, inputEntrys, outputEntrys);
                this.setCollapse();
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IPageCache pageCache = this.getPageCache();
        EntryProp entryProp = e.getEntryProp();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        String name = entryProp.getName();
        Long curEntryEntityId = this.getCurEntryEntityId(pageCache);
        switch (name) {
            case "inputsentity": {
                for (RowDataEntity rowData : rowDataEntities) {
                    int insertRow = rowData.getRowIndex();
                    this.getModel().setValue("inputsentryentityid", (Object)curEntryEntityId, insertRow);
                }
                break;
            }
            case "outputsentity": {
                for (RowDataEntity rowData : rowDataEntities) {
                    int insertRow = rowData.getRowIndex();
                    this.getModel().setValue("outputsentryentityid", (Object)curEntryEntityId, insertRow);
                }
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        ChangeData[] changeSets = e.getChangeSet();
        switch (propertyName) {
            case "source": {
                model.beginInit();
                DynamicObject source = model.getDataEntity().getDynamicObject(SOURCE);
                this.createCacheStandardData(model, source, Boolean.FALSE);
                this.setCollapse();
                model.endInit();
                view.updateView("inputsentity");
                view.updateView("outputsentity");
                break;
            }
            case "platformapi": {
                for (ChangeData changeData : changeSets) {
                    int rowCur = changeData.getRowIndex();
                    DynamicObject entryentityCur = (DynamicObject)model.getEntryEntity("entryentity").get(rowCur);
                    DynamicObject platformapiCur = entryentityCur.getDynamicObject("platformapi");
                    if (platformapiCur == null) continue;
                    Boolean checkRepeactPlatform = this.checkRepeactPlatform();
                    if (checkRepeactPlatform.booleanValue()) {
                        entryentityCur.set("platformapi", null);
                        view.updateView("entryentity", rowCur);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6765\u6e90\u7b2c\u4e09\u65b9\u5e73\u53f0\u3002", (String)"PbdStandardApiEditPlugin_8", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    }
                    this.cacheThirdDataByPlatform(entryentityCur);
                    DynamicObjectCollection outputEntrys = model.getEntryEntity("outputsentity");
                    DynamicObjectCollection inputEntrys = model.getEntryEntity("inputsentity");
                    this.refreshStandardApiFieldPropCache(model, pageCache, inputEntrys, outputEntrys);
                    this.updateInputOutputModel(model, pageCache, Boolean.TRUE, "true", false);
                    this.setCollapse();
                }
                break;
            }
            case "inputsfieldid": {
                PbdCreditPluginUtils.doClearFieldValue(model, "inputsfieldname", changeSets);
                PbdCreditPluginUtils.doClearFieldValue(model, "inputsfieldtype", changeSets);
                break;
            }
            case "inputsthirdfieldid": {
                PbdCreditPluginUtils.doClearFieldValue(model, "inputsthirdfieldname", changeSets);
                PbdCreditPluginUtils.doClearFieldValue(model, "inputsthirdfieldtype", changeSets);
                break;
            }
            case "outputsfieldid": {
                PbdCreditPluginUtils.doClearFieldValue(model, "outputsfieldname", changeSets);
                PbdCreditPluginUtils.doClearFieldValue(model, "outputsfieldtype", changeSets);
                break;
            }
            case "outputsthirdfieldid": {
                PbdCreditPluginUtils.doClearFieldValue(model, "outputsthirdfieldname", changeSets);
                PbdCreditPluginUtils.doClearFieldValue(model, "outputsthirdfieldtype", changeSets);
                break;
            }
        }
        this.getPageCache().put(check_data_change, "false");
    }

    private Boolean checkRepeactPlatform() {
        ArrayList<Long> list = new ArrayList<Long>(8);
        DynamicObjectCollection col = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)col) && col.size() > 1) {
            for (DynamicObject dy : col) {
                DynamicObject group;
                DynamicObject platformapi = dy.getDynamicObject("platformapi");
                if (platformapi == null || (group = platformapi.getDynamicObject("group")) == null) continue;
                list.add((Long)group.getPkValue());
            }
        }
        if (!CollectionUtils.isEmpty(list) && list.size() > 1) {
            HashSet set = new HashSet(list);
            if (list.size() != set.size()) {
                return true;
            }
        }
        return false;
    }

    private void createCacheStandardData(IDataModel model, DynamicObject source, boolean isload) {
        DynamicObjectCollection outputsEntitySource;
        if (source == null) {
            model.deleteEntryData("inputsentity");
            model.deleteEntryData("outputsentity");
            String inputsentityCacheKey = String.format(standard_data, "inputsentity", this.getView().getPageId());
            this.getPageCache().remove(inputsentityCacheKey);
            String outputsentityCacheKey = String.format(standard_data, "outputsentity", this.getView().getPageId());
            this.getPageCache().remove(outputsentityCacheKey);
            String inputCacheKey = String.format(third_entity_alldata, "inputsentity", this.getView().getPageId());
            this.getPageCache().remove(inputCacheKey);
            String outputCacheKey = String.format(third_entity_alldata, "outputsentity", this.getView().getPageId());
            this.getPageCache().remove(outputCacheKey);
            return;
        }
        Long pkValue = (Long)source.getPkValue();
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pbd_struct");
        DynamicObjectCollection inputsEntitySource = loadSingle.getDynamicObjectCollection("inputsentity");
        if (!inputsEntitySource.isEmpty()) {
            if (!isload) {
                this.createStandardData(model, inputsEntitySource, "inputsentity");
            } else {
                this.cacheStandardData(inputsEntitySource, "inputsentity");
            }
        }
        if (!(outputsEntitySource = loadSingle.getDynamicObjectCollection("outputsentity")).isEmpty()) {
            if (!isload) {
                this.createStandardData(model, outputsEntitySource, "outputsentity");
            } else {
                this.cacheStandardData(outputsEntitySource, "outputsentity");
            }
        }
    }

    private void createStandardData(IDataModel model, DynamicObjectCollection entitySource, String entryentity) {
        List<FieldProp> fieldProps = this.cacheStandardData(entitySource, entryentity);
        model.deleteEntryData(entryentity);
        Long entryEntityId = this.getCurEntryEntityId(this.getPageCache());
        this.updateEntryEntityModel(model, entryentity, fieldProps, 0, entryEntityId, true);
    }

    private void updateEntryEntityModel(IDataModel model, String entryentity, List<FieldProp> fieldProps, int rowIndex, Long entryEntityId, Boolean isPlatformApiUpdate) {
        HashMap<Long, Integer> pkIds = new HashMap<Long, Integer>(8);
        if (CollectionUtils.isEmpty(fieldProps)) {
            return;
        }
        for (FieldProp prop : fieldProps) {
            this.setStardardData(model, entryentity, fieldProps, entryEntityId, pkIds, prop, isPlatformApiUpdate);
        }
    }

    private void setStardardData(IDataModel model, String entryentity, List<FieldProp> fieldProps, Long entryEntityId, Map<Long, Integer> pkIds, FieldProp prop, Boolean isPlatformApiUpdate) {
        Long id = Long.parseLong(prop.getId());
        Long pid = Long.parseLong(prop.getParentId());
        if (pid != 0L) {
            Optional<FieldProp> findAny = fieldProps.stream().filter(f -> f.getId().equals(prop.getParentId())).findAny();
            if (findAny.isPresent()) {
                int rowIndex;
                FieldProp parent = findAny.get();
                if (pkIds.containsKey(pid)) {
                    rowIndex = pkIds.get(pid);
                } else {
                    rowIndex = model.createNewEntryRow(entryentity);
                    this.setStandardData(model, rowIndex, parent, pkIds, entryEntityId, isPlatformApiUpdate);
                }
                rowIndex = model.insertEntryRow(entryentity, rowIndex);
                this.setStandardData(model, rowIndex, prop, pkIds, entryEntityId, isPlatformApiUpdate);
            }
        } else {
            if (pkIds.containsKey(id)) {
                return;
            }
            int rowIndex = model.createNewEntryRow(entryentity);
            this.setStandardData(model, rowIndex, prop, pkIds, entryEntityId, isPlatformApiUpdate);
        }
    }

    private List<FieldProp> cacheStandardData(DynamicObjectCollection entitySource, String entryentity) {
        ArrayList<FieldProp> fieldProps = new ArrayList<FieldProp>(8);
        for (DynamicObject dy : entitySource) {
            Long id = (Long)dy.getPkValue();
            Long pid = dy.getLong(PID);
            FieldProp prop = new FieldProp();
            prop.setId(String.valueOf(id));
            prop.setParentId(String.valueOf(pid));
            prop.setEntityKey(entryentity);
            String fieldid = "";
            String fieldname = "";
            String fieldtype = "";
            if (entryentity.equals("inputsentity")) {
                fieldid = dy.getString("inputsfieldid");
                fieldname = dy.getString("inputsfieldname");
                fieldtype = dy.getString("inputsfieldtype");
            } else if (entryentity.equals("outputsentity")) {
                fieldid = dy.getString("outputsfieldid");
                fieldname = dy.getString("outputsfieldname");
                fieldtype = dy.getString("outputsfieldtype");
            }
            prop.setKey(fieldid);
            prop.setName(fieldname);
            prop.setDataType(fieldtype);
            fieldProps.add(prop);
        }
        List<FieldProp> sortedFieldProps = fieldProps.stream().sorted(Comparator.comparing(FieldProp::getParentId, Comparator.reverseOrder())).collect(Collectors.toList());
        String cacheKey = String.format(standard_data, entryentity, this.getView().getPageId());
        this.getPageCache().put(cacheKey, JSON.toJSONString(sortedFieldProps));
        return sortedFieldProps;
    }

    private void setStandardData(IDataModel model, int rowIndex, FieldProp prop, Map<Long, Integer> pkIds, Long entryEntityId, Boolean isPlatformApiUpdate) {
        if (prop == null) {
            return;
        }
        Long id = Long.parseLong(prop.getId());
        pkIds.put(id, rowIndex);
        String entryentity = prop.getEntityKey();
        String key = prop.getKey();
        String name = prop.getName();
        String dataType = prop.getDataType();
        if (entryentity.equals("inputsentity")) {
            model.setValue("inputsfieldid", (Object)key, rowIndex);
            model.setValue("inputsfieldname", (Object)name, rowIndex);
            model.setValue("inputsfieldtype", (Object)dataType, rowIndex);
            model.setValue("inputsentryentityid", (Object)entryEntityId, rowIndex);
            if (isPlatformApiUpdate.booleanValue()) {
                model.setValue("inputsthirdfieldid", (Object)prop.getThirdfieldid(), rowIndex);
                model.setValue("inputsthirdfieldname", (Object)prop.getThirdfieldname(), rowIndex);
                model.setValue("inputsthirdfieldtype", (Object)prop.getThirdfieldtype(), rowIndex);
            }
        } else if (entryentity.equals("outputsentity")) {
            model.setValue("outputsfieldid", (Object)key, rowIndex);
            model.setValue("outputsfieldname", (Object)name, rowIndex);
            model.setValue("outputsfieldtype", (Object)dataType, rowIndex);
            model.setValue("outputsentryentityid", (Object)entryEntityId, rowIndex);
            if (isPlatformApiUpdate.booleanValue()) {
                model.setValue("outputsthirdfieldid", (Object)prop.getThirdfieldid(), rowIndex);
                model.setValue("outputsthirdfieldname", (Object)prop.getThirdfieldname(), rowIndex);
                model.setValue("outputsthirdfieldtype", (Object)prop.getThirdfieldtype(), rowIndex);
            }
        }
    }

    public List<DynamicObject> getSelectedData(String entryKey) {
        EntryGrid grid = (EntryGrid)this.getControl(entryKey);
        ArrayList<DynamicObject> selectDynaObj = new ArrayList<DynamicObject>(8);
        DynamicObjectCollection col = this.getModel().getEntryEntity(entryKey);
        int[] selectedIndexs = grid.getEntryState().getSelectedRows();
        for (int i = 0; i < selectedIndexs.length; ++i) {
            int j = selectedIndexs[i];
            if (CollectionUtils.isEmpty((Collection)col) || col.size() <= j) continue;
            selectDynaObj.add((DynamicObject)col.get(selectedIndexs[i]));
        }
        return selectDynaObj;
    }

    public void click(EventObject evt) {
        String fieldKey;
        super.click(evt);
        String pageId = this.getView().getPageId();
        IPageCache pageCache = this.getPageCache();
        Control ctlSource = (Control)evt.getSource();
        switch (fieldKey = ctlSource.getKey()) {
            case "inputsfieldid": 
            case "outputsfieldid": 
            case "inputsthirdfieldid": 
            case "outputsthirdfieldid": {
                List<DynamicObject> entryEntity = this.getSelectedData("entryentity");
                if (CollectionUtils.isEmpty(entryEntity)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u5173\u8054\u7b2c\u4e09\u65b9\u63a5\u53e3\u624d\u80fd\u6620\u5c04\u3002", (String)"PbdStandardApiEditPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    break;
                }
                DynamicObject dynamicObject = entryEntity.get(0);
                if ((Long)dynamicObject.getPkValue() == 0L) {
                    this.putCurEntryEntityCache(pageCache, dynamicObject);
                }
                if ("inputsthirdfieldid".equals(fieldKey)) {
                    List<FieldProp> inputsFieldProps = this.getCacheFieldProp(pageCache, platform_data, "inputs", pageId);
                    if (CollectionUtils.isEmpty(inputsFieldProps)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e\u3002", (String)"PbdStandardApiEditPlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    String title = ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570", (String)"PbdStandardApiEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                    int row = this.getModel().getEntryCurrentRowIndex("inputsentity");
                    this.showSelectFieldForm(inputsFieldProps, null, INPUTSTHIRDFIELDID_CALLBACK, row, title);
                    break;
                }
                if ("outputsthirdfieldid".equals(fieldKey)) {
                    List<FieldProp> outputsFieldProps = this.getCacheFieldProp(pageCache, platform_data, "outputs", pageId);
                    if (CollectionUtils.isEmpty(outputsFieldProps)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e\u3002", (String)"PbdStandardApiEditPlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    String title = ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570", (String)"PbdStandardApiEditPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                    int row = this.getModel().getEntryCurrentRowIndex("outputsentity");
                    this.showSelectFieldForm(outputsFieldProps, null, OUTPUTSTHIRDFIELDID_CALLBACK, row, title);
                    break;
                }
                if ("inputsfieldid".equals(fieldKey)) {
                    List<FieldProp> inputsFieldProps = this.getCacheFieldProp(pageCache, standard_data, "inputsentity", pageId);
                    if (CollectionUtils.isEmpty(inputsFieldProps)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e\u3002", (String)"PbdStandardApiEditPlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    String title = ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570", (String)"PbdStandardApiEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                    int row = this.getModel().getEntryCurrentRowIndex("inputsentity");
                    List<String> curFieldIds = PbdCreditPluginUtils.getCurFieldIds(this.getModel(), "inputsentity", "inputsfieldid");
                    this.showSelectFieldForm(inputsFieldProps, curFieldIds, INPUTSFIELDID_CALLBACK, row, title);
                    break;
                }
                List<FieldProp> outputsFieldProps = this.getCacheFieldProp(pageCache, standard_data, "outputsentity", pageId);
                if (CollectionUtils.isEmpty(outputsFieldProps)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e\u3002", (String)"PbdStandardApiEditPlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    break;
                }
                String title = ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570", (String)"PbdStandardApiEditPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                int row = this.getModel().getEntryCurrentRowIndex("outputsentity");
                List<String> curFieldIds = PbdCreditPluginUtils.getCurFieldIds(this.getModel(), "outputsentity", "outputsfieldid");
                this.showSelectFieldForm(outputsFieldProps, curFieldIds, OUTPUTSFIELDID_CALLBACK, row, title);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        String pageId = this.getView().getPageId();
        IPageCache pageCache = this.getPageCache();
        if (returnData != null) {
            String returnDataStr = returnData.toString();
            if (StringUtils.isEmpty((String)returnDataStr)) {
                return;
            }
            Map data = (Map)returnData;
            String actionId = e.getActionId();
            IDataModel model = this.getModel();
            switch (actionId) {
                case "INPUTSTHIRDFIELDID_CALLBACK": {
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    Integer row0 = Optional.ofNullable(data.get(ROW)).orElse(0);
                    FieldProp fieldProp = this.getCheckedFieldProp(pageCache, data, platform_data, "inputs", pageId);
                    if (fieldProp == null) break;
                    DynamicObject entryentity0 = (DynamicObject)model.getEntryEntity("inputsentity").get(row0.intValue());
                    entryentity0.set("inputsthirdfieldid", (Object)fieldProp.getKey());
                    entryentity0.set("inputsthirdfieldname", (Object)fieldProp.getName());
                    entryentity0.set("inputsthirdfieldtype", (Object)fieldProp.getDataType());
                    Long entryEntityId = this.getCurEntryEntityId(pageCache);
                    entryentity0.set("inputsentryentityid", (Object)entryEntityId);
                    this.setCollapse();
                    this.getView().updateView("inputsentity", row0.intValue());
                    pageCache.put(check_data_change, "false");
                    break;
                }
                case "OUTPUTSTHIRDFIELDID_CALLBACK": {
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    Integer row0 = Optional.ofNullable(data.get(ROW)).orElse(0);
                    FieldProp fieldProp = this.getCheckedFieldProp(pageCache, data, platform_data, "outputs", pageId);
                    if (fieldProp == null) break;
                    DynamicObject entryentity0 = (DynamicObject)model.getEntryEntity("outputsentity").get(row0.intValue());
                    entryentity0.set("outputsthirdfieldid", (Object)fieldProp.getKey());
                    entryentity0.set("outputsthirdfieldname", (Object)fieldProp.getName());
                    entryentity0.set("outputsthirdfieldtype", (Object)fieldProp.getDataType());
                    Long entryEntityId = this.getCurEntryEntityId(pageCache);
                    entryentity0.set("outputsentryentityid", (Object)entryEntityId);
                    this.setCollapse();
                    this.getView().updateView("outputsentity", row0.intValue());
                    pageCache.put(check_data_change, "false");
                    break;
                }
                case "INPUTSFIELDID_CALLBACK": {
                    String key;
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    Integer row0 = Optional.ofNullable(data.get(ROW)).orElse(0);
                    List<String> curFieldIds = PbdCreditPluginUtils.getCurFieldIds(this.getModel(), "inputsentity", "inputsfieldid");
                    if (curFieldIds.contains(key = (String)data.get(KEY))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PbdStandardApiEditPlugin_9", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    FieldProp fieldProp = this.getCheckedFieldProp(pageCache, data, standard_data, "inputsentity", pageId);
                    if (fieldProp == null) break;
                    List<FieldProp> fieldProps = this.getCacheFieldProp(pageCache, standard_data, "inputsentity", pageId);
                    Map<Long, Integer> pkIds = PbdStandardApiEditPlugin.getPkIds(model, fieldProps, "inputsentity", "inputsfieldid");
                    Long originEntryEntityID = this.getCurEntryEntityId(pageCache);
                    model.beginInit();
                    model.deleteEntryRow("inputsentity", row0.intValue());
                    this.setStardardData(model, "inputsentity", fieldProps, originEntryEntityID, pkIds, fieldProp, false);
                    this.setCollapse();
                    model.endInit();
                    this.getView().updateView("inputsentity");
                    pageCache.put(check_data_change, "false");
                    break;
                }
                case "OUTPUTSFIELDID_CALLBACK": {
                    String key;
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    Integer row0 = Optional.ofNullable(data.get(ROW)).orElse(0);
                    List<String> curFieldIds = PbdCreditPluginUtils.getCurFieldIds(this.getModel(), "outputsentity", "outputsfieldid");
                    if (curFieldIds.contains(key = (String)data.get(KEY))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PbdStandardApiEditPlugin_9", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    FieldProp fieldProp = this.getCheckedFieldProp(pageCache, data, standard_data, "outputsentity", pageId);
                    if (fieldProp == null) break;
                    List<FieldProp> fieldProps = this.getCacheFieldProp(pageCache, standard_data, "outputsentity", pageId);
                    Map<Long, Integer> pkIds = PbdStandardApiEditPlugin.getPkIds(model, fieldProps, "outputsentity", "outputsfieldid");
                    Long originEntryEntityID = this.getCurEntryEntityId(pageCache);
                    model.beginInit();
                    model.deleteEntryRow("outputsentity", row0.intValue());
                    this.setStardardData(model, "outputsentity", fieldProps, originEntryEntityID, pkIds, fieldProp, false);
                    this.setCollapse();
                    model.endInit();
                    this.getView().updateView("outputsentity");
                    pageCache.put(check_data_change, "false");
                    break;
                }
            }
        }
    }

    private Long getCurEntryEntityId(IPageCache pageCache) {
        String cacheKey = String.format(third_entity_data_id, this.getView().getPageId());
        String originEntryEntityStr = pageCache.get(cacheKey);
        Long originEntryEntityID = 0L;
        if (StringUtils.isNotBlank((String)originEntryEntityStr)) {
            originEntryEntityID = Long.parseLong(originEntryEntityStr);
        }
        return originEntryEntityID;
    }

    public static Map<Long, Integer> getPkIds(IDataModel model, List<FieldProp> fieldProps, String entityKey, String key) {
        HashMap<Long, Integer> pkids = new HashMap<Long, Integer>(8);
        DynamicObjectCollection entryEntity2 = model.getEntryEntity(entityKey);
        int startRowIndex = entryEntity2.getStartRowIndex();
        if (!CollectionUtils.isEmpty((Collection)entryEntity2)) {
            for (DynamicObject dy : entryEntity2) {
                String fieldKey = dy.getString(key);
                FieldProp fieldProp = FieldPropUtils.findCheckedField(null, (Object)fieldKey, fieldProps);
                if (fieldProp != null) {
                    pkids.put(Long.valueOf(fieldProp.getId()), startRowIndex);
                }
                ++startRowIndex;
            }
        }
        return pkids;
    }

    private void showSelectFieldForm(List<FieldProp> fieldProps, List<String> excludeKeys, String callback, Integer row, String title) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_select_prop");
        String nodesJson = PbdCreditPluginUtils.bulidNodesJson(fieldProps, title, excludeKeys, "id");
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put(ROW, row);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callback));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        switch (entryKey) {
            case "entryentity": {
                List<DynamicObject> entryEntity = this.getSelectedData("entryentity");
                if (CollectionUtils.isEmpty(entryEntity)) break;
                DynamicObject dynamicObject = entryEntity.get(0);
                model.beginInit();
                DynamicObject platformapi = dynamicObject.getDynamicObject("platformapi");
                if (platformapi == null) {
                    this.clearInputOutPutData(pageCache, dynamicObject);
                } else {
                    this.putCurEntryEntityCache(pageCache, dynamicObject);
                    this.cacheThirdDataByPlatform(dynamicObject);
                    DynamicObjectCollection outputEntrys = model.getEntryEntity("outputsentity");
                    DynamicObjectCollection inputEntrys = model.getEntryEntity("inputsentity");
                    this.refreshStandardApiFieldPropCache(model, pageCache, inputEntrys, outputEntrys);
                    this.updateInputOutputModel(model, pageCache, Boolean.TRUE, "false", true);
                }
                model.endInit();
                this.setCollapse();
                this.getView().updateView("inputsentity");
                this.getView().updateView("outputsentity");
                break;
            }
        }
    }

    private void clearInputOutPutData(IPageCache pageCache, DynamicObject entryEntity) {
        String inputCacheKey = String.format(platform_data, "inputs", this.getView().getPageId());
        this.getPageCache().remove(inputCacheKey);
        String outputCacheKey = String.format(platform_data, "outputs", this.getView().getPageId());
        this.getPageCache().remove(outputCacheKey);
        this.putCurEntryEntityCache(pageCache, entryEntity);
        DynamicObjectCollection outputEntrys = this.getModel().getEntryEntity("outputsentity");
        DynamicObjectCollection inputEntrys = this.getModel().getEntryEntity("inputsentity");
        this.refreshStandardApiFieldPropCache(this.getModel(), pageCache, inputEntrys, outputEntrys);
        this.updateInputOutputModel(this.getModel(), pageCache, Boolean.TRUE, "true", false);
    }

    private void updateInputOutputModel(IDataModel model, IPageCache pageCache, Boolean isLoadAll, String checkDataChange, Boolean isPlatformApiUpdate) {
        String pageId = pageCache.getPageId();
        Long entryEntityId = this.getCurEntryEntityId(pageCache);
        ArrayList<Long> entryEntityIds = new ArrayList<Long>(8);
        DynamicObjectCollection entryEntity2 = model.getEntryEntity("entryentity");
        for (DynamicObject dy : entryEntity2) {
            Long pkValue = (Long)dy.getPkValue();
            if (pkValue == 0L) continue;
            entryEntityIds.add(pkValue);
        }
        String inputCacheKey = String.format(third_entity_alldata, "inputsentity", this.getView().getPageId());
        Map<Long, List<FieldProp>> inputPropMap = this.getLoadModel(pageCache, isLoadAll, entryEntityIds, entryEntityId, inputCacheKey);
        if (CollectionUtils.isEmpty(inputPropMap)) {
            List<FieldProp> inputsFieldProps = this.getCacheFieldProp(pageCache, standard_data, "inputsentity", pageId);
            model.deleteEntryData("inputsentity");
            this.updateEntryEntityModel(model, "inputsentity", inputsFieldProps, 0, entryEntityId, isPlatformApiUpdate);
        } else {
            model.deleteEntryData("inputsentity");
            int rowIndex = 0;
            for (Map.Entry<Long, List<FieldProp>> entry : inputPropMap.entrySet()) {
                if (entry.getKey() == 0L) continue;
                this.updateEntryEntityModel(model, "inputsentity", entry.getValue(), rowIndex, entry.getKey(), isPlatformApiUpdate);
                rowIndex += entry.getValue().size();
            }
        }
        String outputcacheKey = String.format(third_entity_alldata, "outputsentity", this.getView().getPageId());
        Map<Long, List<FieldProp>> outputPropMap = this.getLoadModel(pageCache, isLoadAll, entryEntityIds, entryEntityId, outputcacheKey);
        if (CollectionUtils.isEmpty(outputPropMap)) {
            List<FieldProp> outputsFieldProps = this.getCacheFieldProp(pageCache, standard_data, "outputsentity", pageId);
            model.deleteEntryData("outputsentity");
            this.updateEntryEntityModel(model, "outputsentity", outputsFieldProps, 0, entryEntityId, isPlatformApiUpdate);
        } else {
            model.deleteEntryData("outputsentity");
            int rowIndex = 0;
            for (Map.Entry<Long, List<FieldProp>> entry : outputPropMap.entrySet()) {
                if (entry.getKey() == 0L) continue;
                this.updateEntryEntityModel(model, "outputsentity", entry.getValue(), rowIndex, entry.getKey(), isPlatformApiUpdate);
                rowIndex += entry.getValue().size();
            }
        }
        pageCache.put(check_data_change, checkDataChange);
    }

    private Map<Long, List<FieldProp>> getLoadModel(IPageCache pageCache, Boolean isLoadAll, List<Long> entryEntityIds, Long entryEntityId, String outputcacheKey) {
        HashMap<Long, List<FieldProp>> map = new HashMap<Long, List<FieldProp>>(8);
        String outputCacheStr = pageCache.get(outputcacheKey);
        JSONObject outputMap = JSONObject.parseObject((String)outputCacheStr);
        if (CollectionUtils.isEmpty((Map)outputMap)) {
            return map;
        }
        if (isLoadAll.booleanValue()) {
            Optional<String> findOutput = outputMap.keySet().stream().filter(k -> k.equals(String.valueOf(entryEntityId))).findFirst();
            if (findOutput.isPresent()) {
                String key = findOutput.get();
                Object value = outputMap.get(key);
                List parseArray = JSONArray.parseArray((String)JSON.toJSONString(value), FieldProp.class);
                map.put(Long.valueOf(key), parseArray);
            }
        } else {
            for (Map.Entry entry : outputMap.entrySet()) {
                Object value = entry.getValue();
                Long key = Long.valueOf((String)entry.getKey());
                if (!entryEntityIds.contains(key)) continue;
                List parseArray = JSONArray.parseArray((String)JSON.toJSONString(value), FieldProp.class);
                map.put(key, parseArray);
            }
            pageCache.put(outputcacheKey, JSONObject.toJSONString(map));
        }
        return map;
    }

    private void cacheThirdDataByPlatform(DynamicObject dynamicObject) {
        DynamicObjectCollection outputsEntitySource;
        if (dynamicObject == null) {
            return;
        }
        DynamicObject platformapi = dynamicObject.getDynamicObject("platformapi");
        if (platformapi == null) {
            return;
        }
        Long pkValue = (Long)platformapi.getPkValue();
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pbd_extsys_api");
        DynamicObjectCollection inputsEntitySource = loadSingle.getDynamicObjectCollection("inputs");
        if (!inputsEntitySource.isEmpty()) {
            this.cacheThirdData(inputsEntitySource, "inputs");
        }
        if (!(outputsEntitySource = loadSingle.getDynamicObjectCollection("outputs")).isEmpty()) {
            this.cacheThirdData(outputsEntitySource, "outputs");
        }
    }

    private void refreshStandardApiFieldPropCache(IDataModel model, IPageCache pageCache, DynamicObjectCollection inputEntrys, DynamicObjectCollection outputEntrys) {
        String inputCacheKey = String.format(third_entity_alldata, "inputsentity", this.getView().getPageId());
        String inputCacheStr = pageCache.get(inputCacheKey);
        JSONObject inputMapObject = JSONObject.parseObject((String)inputCacheStr);
        HashMap<Long, List> inputMap = new HashMap<Long, List>(8);
        if (!CollectionUtils.isEmpty((Map)inputMapObject)) {
            for (Map.Entry entry : inputMapObject.entrySet()) {
                String string = (String)entry.getKey();
                Object value = entry.getValue();
                List propList = JSONArray.parseArray((String)JSON.toJSONString(value), FieldProp.class);
                inputMap.put(Long.valueOf(string), propList);
            }
        }
        Map<Object, List<DynamicObject>> inputEntryMap = inputEntrys.stream().collect(Collectors.groupingBy(e -> e.getString("inputsentryentityid")));
        for (Map.Entry<Object, List<DynamicObject>> entry : inputEntryMap.entrySet()) {
            ArrayList<FieldProp> inputList = new ArrayList<FieldProp>(8);
            Object key = entry.getKey();
            if (key.equals("0")) continue;
            List<DynamicObject> value = entry.getValue();
            Iterator<DynamicObject> iterator = value.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = iterator.next();
                FieldProp prop = new FieldProp();
                Long id = dynamicObject.getLong("id");
                Long pid = dynamicObject.getLong(PID);
                String inputsfieldid = dynamicObject.getString("inputsfieldid");
                String inputsfieldname = dynamicObject.getString("inputsfieldname");
                String inputsfieldtype = dynamicObject.getString("inputsfieldtype");
                String inputsthirdfieldid = dynamicObject.getString("inputsthirdfieldid");
                String inputsthirdfieldname = dynamicObject.getString("inputsthirdfieldname");
                String inputsthirdfieldtype = dynamicObject.getString("inputsthirdfieldtype");
                Long inputsentryentityid = dynamicObject.getLong("inputsentryentityid");
                prop.setId(id.toString());
                prop.setParentId(pid.toString());
                prop.setEntryentityid(inputsentryentityid.toString());
                prop.setEntityKey("inputsentity");
                prop.setKey(inputsfieldid);
                prop.setName(inputsfieldname);
                prop.setDataType(inputsfieldtype);
                prop.setThirdfieldid(inputsthirdfieldid);
                prop.setThirdfieldname(inputsthirdfieldname);
                prop.setThirdfieldtype(inputsthirdfieldtype);
                inputList.add(prop);
            }
            inputMap.put(Long.parseLong(key.toString()), inputList);
        }
        pageCache.put(inputCacheKey, JSONObject.toJSONString(inputMap));
        String string = String.format(third_entity_alldata, "outputsentity", this.getView().getPageId());
        String string2 = pageCache.get(string);
        JSONObject outputMapObject = JSONObject.parseObject((String)string2);
        HashMap<Long, List> outputMap = new HashMap<Long, List>(8);
        if (!CollectionUtils.isEmpty((Map)outputMapObject)) {
            for (Map.Entry entry : outputMapObject.entrySet()) {
                String string3 = (String)entry.getKey();
                Object value = entry.getValue();
                List propList = JSONArray.parseArray((String)JSON.toJSONString(value), FieldProp.class);
                outputMap.put(Long.valueOf(string3), propList);
            }
        }
        Map<Object, List<DynamicObject>> outputEntryMap = outputEntrys.stream().collect(Collectors.groupingBy(e -> e.getString("outputsentryentityid")));
        for (Map.Entry<Object, List<DynamicObject>> entry : outputEntryMap.entrySet()) {
            ArrayList<FieldProp> outputList = new ArrayList<FieldProp>(8);
            Object key = entry.getKey();
            if (key.equals("0")) continue;
            List<DynamicObject> value = entry.getValue();
            for (DynamicObject dy : value) {
                FieldProp prop = new FieldProp();
                Long id = dy.getLong("id");
                Long pid = dy.getLong(PID);
                String inputsfieldid = dy.getString("outputsfieldid");
                String inputsfieldname = dy.getString("outputsfieldname");
                String inputsfieldtype = dy.getString("outputsfieldtype");
                String inputsthirdfieldid = dy.getString("outputsthirdfieldid");
                String inputsthirdfieldname = dy.getString("outputsthirdfieldname");
                String inputsthirdfieldtype = dy.getString("outputsthirdfieldtype");
                Long inputsentryentityid = dy.getLong("outputsentryentityid");
                prop.setId(id.toString());
                prop.setParentId(pid.toString());
                prop.setEntryentityid(inputsentryentityid.toString());
                prop.setEntityKey("outputsentity");
                prop.setKey(inputsfieldid);
                prop.setName(inputsfieldname);
                prop.setDataType(inputsfieldtype);
                prop.setThirdfieldid(inputsthirdfieldid);
                prop.setThirdfieldname(inputsthirdfieldname);
                prop.setThirdfieldtype(inputsthirdfieldtype);
                outputList.add(prop);
            }
            outputMap.put(Long.parseLong(key.toString()), outputList);
        }
        pageCache.put(string, JSONObject.toJSONString(outputMap));
    }

    private List<FieldProp> cacheThirdData(DynamicObjectCollection entitySource, String entryentity) {
        ArrayList<FieldProp> fieldProps = new ArrayList<FieldProp>(8);
        for (DynamicObject dy : entitySource) {
            Long id = (Long)dy.getPkValue();
            Long pid = 0L;
            FieldProp prop = new FieldProp();
            prop.setId(String.valueOf(id));
            prop.setParentId(String.valueOf(pid));
            prop.setEntityKey(entryentity);
            String fieldid = "";
            String fieldname = "";
            String fieldtype = "";
            if (entryentity.equals("inputs")) {
                fieldid = dy.getString("input_field");
                fieldname = dy.getString("input_description");
                fieldtype = dy.getString("input_data_type");
            } else if (entryentity.equals("outputs")) {
                fieldid = dy.getString("output_field");
                fieldname = dy.getString("output_description");
                fieldtype = dy.getString("output_data_type");
            }
            prop.setKey(fieldid);
            prop.setName(fieldname);
            prop.setDataType(fieldtype);
            fieldProps.add(prop);
        }
        List<FieldProp> sortedFieldProps = fieldProps.stream().sorted(Comparator.comparing(FieldProp::getParentId, Comparator.reverseOrder())).collect(Collectors.toList());
        String cacheKey = String.format(platform_data, entryentity, this.getView().getPageId());
        this.getPageCache().put(cacheKey, JSON.toJSONString(sortedFieldProps));
        return sortedFieldProps;
    }

    private FieldProp getCheckedFieldProp(IPageCache cache, Map<String, Object> data, String platform_data, String entityKey, String pageId) {
        Object key = data.get(KEY);
        List<FieldProp> fieldProps = this.getCacheFieldProp(cache, platform_data, entityKey, pageId);
        FieldProp fieldProp = FieldPropUtils.findCheckedField(null, (Object)key, fieldProps);
        return fieldProp;
    }

    private List<FieldProp> getCacheFieldProp(IPageCache cache, String platform_data, String entitykey, String pageId) {
        String inputsCacheKey = String.format(platform_data, entitykey, pageId);
        String inputsCache = cache.get(inputsCacheKey);
        List inputsFieldProps = JSONArray.parseArray((String)inputsCache, FieldProp.class);
        return inputsFieldProps;
    }
}

