/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.digitalcredit;

import java.util.Collection;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pbd.common.enums.DigitalCreditOpenStatusEnum;
import kd.scm.pbd.common.enums.DigitalCreditPlatformEnum;
import kd.scm.pbd.common.utils.PbdCreditUtils;
import kd.scm.pbd.formplugin.util.PbdDigitalCreditLinkUtils;

public class PbdDigitalCreditLinkEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String USER = "user";
    private static final String PUBLICKEY = "publickey";
    private static final String JINGWEIPUBLICKEY = "jingweipublickey";
    private static final String CLIENTID = "clientid";
    private static final String CLIENTSECRET = "clientsecret";
    private static final String TOKEN = "token";
    private static final String ORGENTITY = "orgentity";
    private static final String COMPANYORG = "companyorg";
    private static final String WHOLEGROUP = "wholegroup";
    private static final String PLATFORM = "platform";
    private static final String PBD_NEEDS_TO_KNOW = "PBD_NEEDS_TO_KNOW";
    private static final String STOP_COMFIRM = "STOP_COMFIRM";
    private static Log log = LogFactory.getLog(PbdDigitalCreditLinkEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit platform = (BasedataEdit)this.getView().getControl(PLATFORM);
        platform.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject platform = this.getModel().getDataEntity().getDynamicObject(PLATFORM);
        this.setVisiable(platform);
    }

    private void lockOrgEntity() {
        Boolean wholegroup = this.getModel().getDataEntity().getBoolean(WHOLEGROUP);
        if (wholegroup.booleanValue()) {
            this.getModel().deleteEntryData(ORGENTITY);
        } else {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ORGENTITY);
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                this.getModel().createNewEntryRow(ORGENTITY);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String fieldKey = args.getProperty().getName();
        if (PLATFORM.equals(fieldKey)) {
            PbdCreditUtils.platformF7Select((BeforeF7SelectEvent)args);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSets = e.getChangeSet();
        DynamicObject platform = this.getModel().getDataEntity().getDynamicObject(PLATFORM);
        block6 : switch (propertyName) {
            case "wholegroup": {
                this.lockOrgEntity();
                break;
            }
            case "platform": {
                this.setVisiable(platform);
                break;
            }
            case "companyorg": 
            case "includesuborg": {
                if (platform == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"PbdDigitalCreditLinkEditPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (ChangeData changeData : changeSets) {
                    DynamicObject org;
                    Boolean includesuborg;
                    int entryCurrentRowIndex = changeData.getRowIndex();
                    DynamicObject curOrgEntity = (DynamicObject)this.getModel().getEntryEntity(ORGENTITY).get(entryCurrentRowIndex);
                    if ("includesuborg".equals(propertyName) ? (includesuborg = Boolean.valueOf(curOrgEntity.getBoolean("includesuborg"))) == false : COMPANYORG.equals(propertyName) && (org = curOrgEntity.getDynamicObject(COMPANYORG)) == null) break block6;
                    DynamicObject dataEntity = this.getModel().getDataEntity();
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ORGENTITY);
                    boolean valid = PbdDigitalCreditLinkUtils.validOrg(dataEntity, entryEntity, entryCurrentRowIndex);
                    String platformName = platform.getString("name");
                    if (valid) continue;
                    if ("includesuborg".equals(propertyName)) {
                        this.getModel().setValue("includesuborg", (Object)false, entryCurrentRowIndex);
                    } else if (COMPANYORG.equals(propertyName)) {
                        this.getModel().setValue(COMPANYORG, null, entryCurrentRowIndex);
                    }
                    this.getView().showTipNotification(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u7ec4\u7ec7\u5df2\u5173\u8054\u4e86%1\u7684\u914d\u7f6e\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"PbdDigitalCreditLinkEditPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdDigitalCreditLinkPlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[]{platformName}));
                    return;
                }
                break;
            }
        }
    }

    private void setVisiable(DynamicObject platform) {
        if (platform == null) {
            return;
        }
        String platformSystype = platform.getString("systype");
        String defaultLinkNumber = DigitalCreditPlatformEnum.fromVal((String)platformSystype).getCode();
        if (DigitalCreditPlatformEnum.CREDITPLATFORM_TYC.getCode().equals(defaultLinkNumber)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TOKEN});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{USER});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CLIENTID});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CLIENTSECRET});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{JINGWEIPUBLICKEY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PUBLICKEY});
        } else if (DigitalCreditPlatformEnum.CREDITPLATFORM_TYCMONITOR.getCode().equals(defaultLinkNumber)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TOKEN});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{USER});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CLIENTID});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CLIENTSECRET});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{JINGWEIPUBLICKEY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PUBLICKEY});
        } else if (DigitalCreditPlatformEnum.CREDITPLATFORM_KDCLOUD.getCode().equals(defaultLinkNumber) || DigitalCreditPlatformEnum.CREDITPLATFORM_QCC.getCode().equals(defaultLinkNumber) || DigitalCreditPlatformEnum.CREDITPLATFORM_QIXINBAO.getCode().equals(defaultLinkNumber)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TOKEN});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{USER});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CLIENTID});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CLIENTSECRET});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{JINGWEIPUBLICKEY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PUBLICKEY});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TOKEN});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{USER});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CLIENTID});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CLIENTSECRET});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{JINGWEIPUBLICKEY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PUBLICKEY});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dataEntity = model.getDataEntity();
        switch (key) {
            case "save": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ORGENTITY);
                Boolean wholegroup = dataEntity.getBoolean(WHOLEGROUP);
                if (!wholegroup.booleanValue() && CollectionUtils.isEmpty((Collection)entryEntity)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u542f\u7528\u96c6\u56e2\u7edf\u4e00\u65f6\uff0c\u7ec4\u7ec7\u542f\u7528\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PbdDigitalCreditLinkEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                boolean flag = false;
                if (!wholegroup.booleanValue() && !CollectionUtils.isEmpty((Collection)entryEntity)) {
                    for (DynamicObject dy : entryEntity) {
                        DynamicObject companyorg = dy.getDynamicObject(COMPANYORG);
                        if (companyorg == null) continue;
                        flag = true;
                        break;
                    }
                }
                if (!wholegroup.booleanValue() && !flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u542f\u7528\u96c6\u56e2\u7edf\u4e00\u65f6\uff0c\u7ec4\u7ec7\u542f\u7528\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PbdDigitalCreditLinkEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                boolean valid = PbdDigitalCreditLinkUtils.validOrg(dataEntity, entryEntity, null);
                DynamicObject platform = this.getModel().getDataEntity().getDynamicObject(PLATFORM);
                if (platform == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e73\u53f0\u3002", (String)"PbdDigitalCreditLinkEditPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String platformName = platform.getString("name");
                if (!valid) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u7ec4\u7ec7\u5df2\u5173\u8054\u4e86%1\u7684\u914d\u7f6e\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"PbdDigitalCreditLinkEditPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdDigitalCreditLinkPlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[]{platformName}));
                    args.setCancel(true);
                    break;
                }
                PbdCreditUtils.updateApplyOrg((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "open": {
                String openstatus = dataEntity.getString("openstatus");
                if (!openstatus.equals(DigitalCreditOpenStatusEnum.OPENSTATUS_2.getVal())) break;
                view.showTipNotification(ResManager.loadKDString((String)"\u4f60\u5df2\u5f00\u901a\u8d26\u53f7\u3002", (String)"PbdDigitalCreditLinkEditPlugin_4", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dataEntity = model.getDataEntity();
        switch (key) {
            case "open": {
                PbdDigitalCreditLinkUtils.showNeedsToknow(view, dataEntity, new CloseCallBack((IFormPlugin)this, PBD_NEEDS_TO_KNOW));
                break;
            }
            case "save": {
                Object syssource = dataEntity.get("syssource");
                if (syssource instanceof DynamicObject) {
                    DynamicObject dy = (DynamicObject)syssource;
                    model.setValue("syssource", dy.getPkValue());
                } else {
                    model.setValue("syssource", syssource);
                }
                model.setValue(CLIENTID, (Object)"");
                model.setValue(CLIENTSECRET, (Object)"");
                model.setValue(TOKEN, (Object)"");
                this.getView().updateView();
                break;
            }
            case "stop": {
                DynamicObject platform = dataEntity.getDynamicObject(PLATFORM);
                String name = platform.getString("name");
                this.getView().showConfirm(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4e0e%1\u7684\u8fde\u63a5\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u505c\u7528\u540e\u5219\u65e0\u6cd5\u8c03\u7528\u7b2c\u4e09\u65b9\u6570\u636e\uff0c\u786e\u8ba4\u8981\u505c\u7528\u5417\uff1f", (String)"PbdDigitalCreditLinkEditPlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdDigitalCreditLinkPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[]{name}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(STOP_COMFIRM));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        String callBackId = arg0.getCallBackId();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (STOP_COMFIRM.equals(callBackId) && arg0.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            DynamicObject dataEntity = model.getDataEntity(true);
            PbdDigitalCreditLinkUtils.stop(view, dataEntity);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData != null) {
            String actionId;
            switch (actionId = e.getActionId()) {
                case "PBD_NEEDS_TO_KNOW": {
                    IDataModel model = this.getModel();
                    IFormView view = this.getView();
                    PbdDigitalCreditLinkUtils.open(view, model.getDataEntity(true));
                    break;
                }
            }
        }
    }
}

