/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.digitalcredit;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.BillFormUtil;
import kd.scm.pbd.business.IscSchemaImUtils;
import kd.scm.pbd.common.enums.DigitalCreditOpenStatusEnum;
import kd.scm.pbd.formplugin.util.PbdDigitalCreditLinkUtils;

public class PbdDigitalCreditLinkListPlugin
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(PbdDigitalCreditLinkListPlugin.class);
    private static final String PBD_NEEDS_TO_KNOW = "PBD_NEEDS_TO_KNOW";
    private static final String STOP_COMFIRM = "STOP_COMFIRM";
    private static final String ORGENTITY = "orgentity";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listcoll = args.getListSelectedData();
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.isEmpty()) {
            args.setCancel(true);
            return;
        }
        if (!this.validData(args, key)) {
            return;
        }
        switch (key) {
            case "open": {
                Object[] primaryKeyValues = listcoll.getPrimaryKeyValues();
                DynamicObject[] dataEntitys = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pbd_credit_link"));
                if (dataEntitys == null || dataEntitys.length == 0) {
                    args.setCancel(true);
                    return;
                }
                DynamicObject dataEntity = dataEntitys[0];
                DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection(ORGENTITY);
                boolean valid = PbdDigitalCreditLinkUtils.validOrg(dataEntity, entryEntity, null);
                DynamicObject platform = dataEntity.getDynamicObject("platform");
                String platformName = platform.getString("name");
                if (valid) break;
                this.getView().showTipNotification(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u7ec4\u7ec7\u5df2\u5173\u8054\u4e86%1\u7684\u914d\u7f6e\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"PbdDigitalCreditLinkListPlugin_12", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdDigitalCreditLinkPlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[]{platformName}));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.isEmpty()) {
            return;
        }
        IFormView view = this.getView();
        switch (key) {
            case "open": {
                DynamicObject selectData = BillFormUtil.getSelectData((IFormView)view, (String)"pbd_credit_link");
                PbdDigitalCreditLinkUtils.showNeedsToknow(view, selectData, new CloseCallBack((IFormPlugin)this, PBD_NEEDS_TO_KNOW));
                break;
            }
            case "stop": {
                DynamicObject selectData1 = BillFormUtil.getSelectData((IFormView)view, (String)"pbd_credit_link");
                DynamicObject platform = selectData1.getDynamicObject("platform");
                String name = platform.getString("name");
                this.getView().showConfirm(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4e0e%1\u7684\u8fde\u63a5\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u505c\u7528\u540e\u5219\u65e0\u6cd5\u8c03\u7528\u7b2c\u4e09\u65b9\u6570\u636e\uff0c\u786e\u8ba4\u8981\u505c\u7528\u5417\uff1f", (String)"PbdDigitalCreditLinkListPlugin_13", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdDigitalCreditLinkListPlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[]{name}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(STOP_COMFIRM));
                break;
            }
        }
        view.updateView();
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        String callBackId = arg0.getCallBackId();
        IFormView view = this.getView();
        if (STOP_COMFIRM.equals(callBackId) && arg0.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            DynamicObject dataEntity = BillFormUtil.getSelectData((IFormView)view, (String)"pbd_credit_link");
            PbdDigitalCreditLinkUtils.stop(view, dataEntity);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validData(BeforeDoOperationEventArgs e, String tbType) {
        String openstatus;
        DynamicObject dataEntity;
        boolean flag = true;
        ListSelectedRowCollection listSelectedData = e.getListSelectedData();
        IFormView view = this.getView();
        HashSet<Long> set = new HashSet<Long>(8);
        for (ListSelectedRow row : listSelectedData) {
            Long primaryKeyValue = (Long)row.getPrimaryKeyValue();
            set.add(primaryKeyValue);
        }
        if (set.size() > 1) {
            if ("open".equals(tbType)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f00\u901a\u64cd\u4f5c\u53ea\u5141\u8bb8\u5f00\u901a\u4e00\u6761\u3002", (String)"PbdDigitalCreditLinkListPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                return this.setCancel(e);
            }
            if (!"stop".equals(tbType)) return flag;
            view.showTipNotification(ResManager.loadKDString((String)"\u505c\u7528\u64cd\u4f5c\u53ea\u5141\u8bb8\u505c\u7528\u4e00\u6761\u3002", (String)"PbdDigitalCreditLinkListPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return this.setCancel(e);
        }
        if ("open".equals(tbType)) {
            dataEntity = BillFormUtil.getSelectData((IFormView)view, (String)"pbd_credit_link");
            if (dataEntity == null) {
                return this.setCancel(e);
            }
            openstatus = dataEntity.getString("openstatus");
            if (openstatus.equals(DigitalCreditOpenStatusEnum.OPENSTATUS_2.getVal())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5f00\u901a\u72b6\u6001\u4e3a\u5f85\u5f00\u901a\u548c\u505c\u7528\u7684\u65b9\u6848\u3002", (String)"PbdDigitalCreditLinkListPlugin_14", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                return this.setCancel(e);
            }
            Object syssource = dataEntity.get("syssource");
            if (syssource instanceof DynamicObject) {
                DynamicObject dy = (DynamicObject)syssource;
                String number = dy.getString("number");
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"testConnection", (Object[])new Object[]{number});
                if (Parser.toBoolean(result.get("success"))) return flag;
                String server_ip = "";
                DynamicObject dblink = dy.getDynamicObject("dblink");
                if (dblink != null) {
                    DynamicObject dblinkSingle = BusinessDataServiceHelper.loadSingleFromCache((Object)dblink.getPkValue(), (String)"isc_database_link");
                    server_ip = dblinkSingle.getString("server_ip");
                }
                view.showTipNotification(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u65e0\u6cd5\u8bbf\u95ee\u57df\u540d\uff1a{0},\u8bf7\u68c0\u67e5\u96c6\u6210\u4e91-\u8fde\u63a5\u914d\u7f6e\u4e2d\u201c\u91d1\u8776\u4e91\u5e73\u53f0\u201d\u662f\u5426\u8fde\u63a5\u6b63\u5e38\u3002", (String)"PbdDigitalCreditLinkListPlugin_15", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdDigitalCreditLinkListPlugin_15", (String)"scm-pbd-formplugin", (Object[])new Object[]{server_ip}));
                return this.setCancel(e);
            }
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\uff0c\u751f\u6210\u6570\u636e\u6e90\u3002", (String)"PbdDigitalCreditLinkListPlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return this.setCancel(e);
        }
        if (!"stop".equals(tbType)) return flag;
        dataEntity = BillFormUtil.getSelectData((IFormView)view, (String)"pbd_credit_link");
        if (dataEntity == null) {
            return this.setCancel(e);
        }
        openstatus = dataEntity.getString("openstatus");
        if (openstatus.equals(DigitalCreditOpenStatusEnum.OPENSTATUS_2.getVal())) return flag;
        view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u505c\u7528\u8fd0\u884c\u4e2d\u7684\u6570\u636e\u3002", (String)"PbdDigitalCreditLinkListPlugin_11", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        return this.setCancel(e);
    }

    private boolean setCancel(BeforeDoOperationEventArgs e) {
        e.setCancel(true);
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData != null) {
            String actionId;
            switch (actionId = e.getActionId()) {
                case "PBD_NEEDS_TO_KNOW": {
                    IFormView view = this.getView();
                    DynamicObject selectData = BillFormUtil.getSelectData((IFormView)view, (String)"pbd_credit_link");
                    String filePath = "TYC.zip";
                    try {
                        DynamicObject platform = selectData.getDynamicObject("platform");
                        if (platform != null) {
                            String number = platform.getString("number");
                            filePath = number + ".zip";
                        }
                        IscSchemaImUtils util = new IscSchemaImUtils();
                        util.decompressionFileAndImport(filePath);
                    }
                    catch (Exception e0) {
                        log.error("\u4e0a\u4f20\u96c6\u6210\u5bf9\u8c61\u5931\u8d25", (Throwable)e0);
                    }
                    PbdDigitalCreditLinkUtils.open(view, selectData);
                    break;
                }
            }
        }
    }
}

