/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.digitalcredit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pbd.common.utils.PbdCreditUtils;
import kd.scm.pbd.formplugin.util.PbdCreditPluginUtils;

public class PbdServiceProgrammeEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(PbdServiceProgrammeEditPlugin.class);
    private static final String RULECONFIG_COMFIRM = "ruleconfig_comfirm";
    private static final String PBD_SERVICE_RULE_CALLBACK = "PBD_SERVICE_RULE_CALLBACK";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"apiassosettingbarap", "ruleconfig"});
        BasedataEdit platformapi = (BasedataEdit)this.getView().getControl("platformapi");
        platformapi.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit platform = (BasedataEdit)this.getView().getControl("companyorg");
        platform.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit standardapi = (BasedataEdit)this.getView().getControl("standardapi");
        standardapi.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit link = (BasedataEdit)this.getView().getControl("link");
        link.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String fieldKey = args.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if ("platformapi".equals(fieldKey)) {
            DynamicObject platform;
            DynamicObjectCollection plaformDy;
            DynamicObject link = dataEntity.getDynamicObject("link");
            if (link == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8fde\u63a5\u914d\u7f6e\u3002", (String)"PbdServiceProgrammeEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<DynamicObject> entryEntity = this.getSelectedData("apiassosettingentity");
            DynamicObject dynamicObject = entryEntity.get(0);
            DynamicObject standardapi = dynamicObject.getDynamicObject("standardapi");
            ArrayList<Object> types = new ArrayList<Object>(8);
            if (standardapi != null && !CollectionUtils.isEmpty((Collection)(plaformDy = standardapi.getDynamicObjectCollection("entryentity")))) {
                for (DynamicObject dy : plaformDy) {
                    DynamicObject platformapiDy = dy.getDynamicObject("platformapi");
                    if (platformapiDy == null) continue;
                    types.add(platformapiDy.getPkValue());
                }
            }
            QFilter qFilter = new QFilter("1", "=", (Object)1);
            if (!CollectionUtils.isEmpty(types)) {
                qFilter.and("id", "in", types);
            }
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
            if (link != null && (platform = link.getDynamicObject("platform")) != null) {
                qFilter.and("group", "=", platform.getPkValue());
                QFilter qFilter0 = new QFilter("id", "=", platform.getPkValue());
                qFilterList.add(qFilter0);
            }
            ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
            showParameter.getTreeFilterParameter().setQFilters(qFilterList);
            showParameter.setShowApproved(false);
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if ("companyorg".equals(fieldKey)) {
            DynamicObject link = dataEntity.getDynamicObject("link");
            if (link == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8fde\u63a5\u914d\u7f6e\u3002", (String)"PbdServiceProgrammeEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Set entrySubordinateOrgs = new HashSet(8);
            DynamicObjectCollection companyorgDys = link.getDynamicObjectCollection("orgentity");
            if (!CollectionUtils.isEmpty((Collection)companyorgDys)) {
                HashMap<Long, Boolean> entryOrgIdIncludeSubOrgMap = new HashMap<Long, Boolean>(8);
                for (DynamicObject dy : companyorgDys) {
                    Boolean includesuborg = dy.getBoolean("includesuborg");
                    DynamicObject companyorgDy = dy.getDynamicObject("companyorg");
                    if (companyorgDy == null) continue;
                    entryOrgIdIncludeSubOrgMap.put((Long)companyorgDy.getPkValue(), includesuborg);
                }
                entrySubordinateOrgs = PbdCreditUtils.getAllSubordinateOrgs(entryOrgIdIncludeSubOrgMap, (Boolean)Boolean.FALSE);
            }
            QFilter qFilter = new QFilter("1", "=", (Object)1);
            if (!CollectionUtils.isEmpty(entrySubordinateOrgs)) {
                qFilter.and("id", "in", entrySubordinateOrgs);
            }
            ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if ("standardapi".equals(fieldKey) || "link".equals(fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
            showParameter.setShowApproved(false);
        }
    }

    public List<DynamicObject> getSelectedData(String entryKey) {
        EntryGrid grid = (EntryGrid)this.getControl(entryKey);
        ArrayList<DynamicObject> selectDynaObj = new ArrayList<DynamicObject>(8);
        DynamicObjectCollection col = this.getModel().getEntryEntity(entryKey);
        int[] selectedIndexs = grid.getEntryState().getSelectedRows();
        for (int i = 0; i < selectedIndexs.length; ++i) {
            selectDynaObj.add((DynamicObject)col.get(selectedIndexs[i]));
        }
        return selectDynaObj;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        this.setOperator(model, view, Boolean.TRUE);
        this.orgVisiable(this.getModel(), this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (key) {
            case "save": {
                DynamicObjectCollection orgentitys = model.getEntryEntity("orgentity");
                DynamicObject dataEntity = model.getDataEntity();
                Integer valid = this.checkOrg(dataEntity, orgentitys, null);
                if (valid != 0) {
                    if (valid == 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"PbdServiceProgrammeEditPlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    } else if (valid == 2) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8fde\u63a5\u914d\u7f6e\u3002", (String)"PbdServiceProgrammeEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    } else if (valid == 3) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u4e0d\u652f\u6301\u5305\u542b\u4e0b\u7ea7\u7684\u4e1a\u52a1\u65b9\u6848\u3002", (String)"PbdServiceProgrammeEditPlugin_8", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    }
                    args.setCancel(true);
                    break;
                }
                Boolean wholegroup = model.getDataEntity().getBoolean("wholegroup");
                if (!wholegroup.booleanValue()) {
                    if (CollectionUtils.isEmpty((Collection)orgentitys)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PbdServiceProgrammeEditPlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        break;
                    }
                    boolean flag = true;
                    for (DynamicObject dy : orgentitys) {
                        DynamicObject companyorg = dy.getDynamicObject("companyorg");
                        if (companyorg != null) continue;
                        flag = false;
                    }
                    if (!flag) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PbdServiceProgrammeEditPlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        break;
                    }
                }
                PbdCreditUtils.updateApplyOrg((IDataModel)model, (IFormView)view);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        ChangeData[] changeSets = e.getChangeSet();
        switch (propertyName) {
            case "wholegroup": {
                this.wholegroupCheck(model, view);
                break;
            }
            case "link": {
                this.loadLinkData(model, view);
                view.updateView("orgentity");
                view.updateView("wholegroup");
                break;
            }
            case "billentity": {
                this.setOperator(model, view, false);
                view.updateView("operator");
                break;
            }
            case "triggertype": {
                this.setOperator(model, view, false);
                view.updateView("operator");
                break;
            }
            case "operator": {
                this.setOperatorName(model, view);
                view.updateView("operatorname");
                break;
            }
            case "companyorg": 
            case "includesuborg": {
                for (ChangeData changeData : changeSets) {
                    int orgEntryCurrentRowIndex = changeData.getRowIndex();
                    DynamicObjectCollection orgentitys = model.getEntryEntity("orgentity");
                    DynamicObject dataEntity = model.getDataEntity();
                    Integer valid = this.checkOrg(dataEntity, orgentitys, orgEntryCurrentRowIndex);
                    if (valid == 0) continue;
                    if (valid == 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"PbdServiceProgrammeEditPlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    } else if (valid == 2) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8fde\u63a5\u914d\u7f6e\u3002", (String)"PbdServiceProgrammeEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    } else if (valid == 3) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u4e0d\u652f\u6301\u5305\u542b\u4e0b\u7ea7\u7684\u4e1a\u52a1\u65b9\u6848\u3002", (String)"PbdServiceProgrammeEditPlugin_8", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    }
                    if ("includesuborg".equals(propertyName)) {
                        this.getModel().setValue("includesuborg", (Object)false, orgEntryCurrentRowIndex);
                        continue;
                    }
                    if (!"companyorg".equals(propertyName)) continue;
                    this.getModel().setValue("companyorg", null, orgEntryCurrentRowIndex);
                }
                break;
            }
            case "standardapi": {
                for (ChangeData changeData : changeSets) {
                    int orgEntryCurrentRowIndex = changeData.getRowIndex();
                    Boolean checkRepeatStandardApi = this.checkRepeatStandardApi(model, orgEntryCurrentRowIndex);
                    if (checkRepeatStandardApi.booleanValue()) {
                        this.setPlatformapi(model, view, orgEntryCurrentRowIndex);
                        continue;
                    }
                    model.setValue("standardapi", null, orgEntryCurrentRowIndex);
                    view.showTipNotification(ResManager.loadKDString((String)"\u6807\u51c6\u63a5\u53e3\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"PbdServiceProgrammeEditPlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                }
                view.updateView("apiassosettingentity");
                break;
            }
        }
    }

    private void setPlatformapi(IDataModel model, IFormView view, int entryCurrentRowIndex) {
        DynamicObject dynamicObject;
        DynamicObject standardapi;
        DynamicObject dataEntity = model.getDataEntity();
        Long platformId = 0L;
        DynamicObject link = dataEntity.getDynamicObject("link");
        if (link == null) {
            return;
        }
        DynamicObject platform = link.getDynamicObject("platform");
        if (platform != null) {
            platformId = (Long)platform.getPkValue();
        }
        if ((standardapi = (dynamicObject = (DynamicObject)model.getEntryEntity("apiassosettingentity").get(entryCurrentRowIndex)).getDynamicObject("standardapi")) == null) {
            model.setValue("platformapi", null, entryCurrentRowIndex);
            return;
        }
        DynamicObjectCollection plaformDy = standardapi.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)plaformDy)) {
            return;
        }
        boolean isInsert = false;
        for (DynamicObject dy : plaformDy) {
            DynamicObject platformDy;
            Object pkValue;
            DynamicObject loadSingle;
            DynamicObject platformapiDy = dy.getDynamicObject("platformapi");
            if (platformapiDy == null || (loadSingle = BusinessDataServiceHelper.loadSingleFromCache((Object)(pkValue = platformapiDy.getPkValue()), (String)"pbd_extsys_api")) == null || !platformId.equals((platformDy = loadSingle.getDynamicObject("group")).getPkValue())) continue;
            model.setValue("platformapi", platformapiDy.getPkValue(), entryCurrentRowIndex);
            isInsert = true;
            break;
        }
        if (!isInsert) {
            model.setValue("platformapi", (Object)0L, entryCurrentRowIndex);
        }
    }

    private Boolean checkRepeatStandardApi(IDataModel model, int entryCurrentRowIndex) {
        DynamicObject dynamicObject = (DynamicObject)model.getEntryEntity("apiassosettingentity").get(entryCurrentRowIndex);
        if (dynamicObject == null) {
            return true;
        }
        ArrayList<Long> list = new ArrayList<Long>(8);
        DynamicObjectCollection entryEntity = model.getEntryEntity("apiassosettingentity");
        for (DynamicObject dy : entryEntity) {
            DynamicObject standardapiDy = dy.getDynamicObject("standardapi");
            if (standardapiDy == null) continue;
            Long curStandardapiId = (Long)standardapiDy.getPkValue();
            list.add(curStandardapiId);
        }
        HashSet set = new HashSet(list);
        if (list.size() != set.size()) {
            return false;
        }
        return true;
    }

    private Integer checkOrg(DynamicObject dataEntity, DynamicObjectCollection orgentitys, Integer entryCurrentRowIndex) {
        if (CollectionUtils.isEmpty((Collection)orgentitys)) {
            return 0;
        }
        HashMap<Long, Boolean> entryOrgIdIncludeSubOrgMap = new HashMap<Long, Boolean>(8);
        HashMap<Long, Boolean> curOrgIdIncludeSubOrgMap = new HashMap<Long, Boolean>(8);
        Set curSubordinateOrgs = new HashSet(8);
        DynamicObject orgentity = null;
        if (entryCurrentRowIndex != null) {
            orgentity = (DynamicObject)orgentitys.get(entryCurrentRowIndex.intValue());
        }
        if (orgentity != null) {
            Long orgId;
            Boolean linkIncludeSubOrg;
            boolean flag;
            Boolean includesuborg = orgentity.getBoolean("includesuborg");
            DynamicObject curOrg = orgentity.getDynamicObject("companyorg");
            if (curOrg == null) {
                return 0;
            }
            curOrgIdIncludeSubOrgMap.put((Long)curOrg.getPkValue(), includesuborg);
            curSubordinateOrgs = PbdCreditUtils.getAllSubordinateOrgs(curOrgIdIncludeSubOrgMap, (Boolean)Boolean.FALSE);
            int startRowIndex = orgentitys.getStartRowIndex();
            Set entrySubordinateOrgs = new HashSet(8);
            for (DynamicObject dy : orgentitys) {
                DynamicObject companyorg = dy.getDynamicObject("companyorg");
                if (entryCurrentRowIndex != null && curOrg.equals(companyorg) && startRowIndex == entryCurrentRowIndex) {
                    ++startRowIndex;
                    continue;
                }
                Boolean includesuborg1 = dy.getBoolean("includesuborg");
                if (companyorg != null) {
                    entryOrgIdIncludeSubOrgMap.put((Long)companyorg.getPkValue(), includesuborg1);
                }
                ++startRowIndex;
            }
            entrySubordinateOrgs = PbdCreditUtils.getAllSubordinateOrgs(entryOrgIdIncludeSubOrgMap, (Boolean)Boolean.FALSE);
            if (!CollectionUtils.isEmpty(curSubordinateOrgs) && !(flag = Collections.disjoint(curSubordinateOrgs, entrySubordinateOrgs))) {
                return 1;
            }
            if (!includesuborg.booleanValue()) {
                return 0;
            }
            DynamicObject source = dataEntity.getDynamicObject("link");
            DynamicObject linkSource = PbdCreditPluginUtils.getLinkSource(source);
            if (linkSource == null) {
                return 2;
            }
            Map entryOrgIdIncludeSubOrgMapLink = PbdCreditUtils.getOrgEntityMap((DynamicObject)linkSource);
            DynamicObject companyorgDy = orgentity.getDynamicObject("companyorg");
            if (companyorgDy != null && (linkIncludeSubOrg = (Boolean)entryOrgIdIncludeSubOrgMapLink.get(orgId = (Long)companyorgDy.getPkValue())) != null && !linkIncludeSubOrg.booleanValue()) {
                return 3;
            }
        }
        return 0;
    }

    private void wholegroupCheck(IDataModel model, IFormView view) {
        DynamicObject dataEntity = model.getDataEntity();
        Boolean wholegroup = dataEntity.getBoolean("wholegroup");
        DynamicObject source = dataEntity.getDynamicObject("link");
        DynamicObject linkSource = PbdCreditPluginUtils.getLinkSource(source);
        if (wholegroup.booleanValue()) {
            if (linkSource == null) {
                this.getModel().setValue("wholegroup", (Object)(wholegroup == false ? 1 : 0));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8fde\u63a5\u914d\u7f6e\u3002", (String)"PbdServiceProgrammeEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean wholegroupLink = linkSource.getBoolean("wholegroup");
            if (wholegroup.booleanValue() && !wholegroupLink.booleanValue()) {
                this.getModel().setValue("wholegroup", (Object)false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u4e0d\u652f\u6301\u96c6\u56e2\u7edf\u4e00\u7684\u4e1a\u52a1\u65b9\u6848\u3002", (String)"PbdServiceProgrammeEditPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.orgVisiable(model, view);
        view.updateView("orgentity");
    }

    private void orgVisiable(IDataModel model, IFormView view) {
        Boolean wholegroup = model.getDataEntity().getBoolean("wholegroup");
        if (wholegroup.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pl_orgentity"});
            model.deleteEntryData("orgentity");
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"pl_orgentity"});
        }
    }

    private void setOperator(IDataModel model, IFormView view, boolean isinit) {
        DynamicObject dy = model.getDataEntity();
        if (isinit) {
            String operator = dy.getString("operator");
            PbdCreditPluginUtils.setBillOpratorItems(view, model, dy, operator);
        } else {
            PbdCreditPluginUtils.setBillOpratorItems(view, model, dy, null);
        }
    }

    private void setOperatorName(IDataModel model, IFormView view) {
        DynamicObject dy = model.getDataEntity();
        DynamicObject billentity = dy.getDynamicObject("billentity");
        if (null == billentity) {
            return;
        }
        String entityName = billentity.getString("number");
        List<ComboItem> combList = PbdCreditPluginUtils.getOpertorConList(dy, entityName);
        if (!CollectionUtils.isEmpty(combList)) {
            String operator = dy.getString("operator");
            Optional<ComboItem> findFirst = combList.stream().filter(c -> c.getValue().equals(operator)).findFirst();
            if (findFirst.isPresent()) {
                model.setValue("operatorname", (Object)findFirst.get().getCaption().getLocaleValue());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operationKey;
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        switch (operationKey = args.getOperateKey()) {
            case "ruleconfig": {
                DynamicObject dy = model.getDataEntity();
                boolean ispreinsdata = dy.getBoolean("ispreinsdata");
                if (ispreinsdata) {
                    this.openServiceRule(model, view);
                    break;
                }
                view.showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u518d\u8fdb\u884c\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e\u3002", (String)"PbdServiceProgrammeEditPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(RULECONFIG_COMFIRM));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        String callBackId = arg0.getCallBackId();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (RULECONFIG_COMFIRM.equals(callBackId) && arg0.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.openServiceRule(model, view);
        }
    }

    private void openServiceRule(IDataModel model, IFormView view) {
        EntryGrid grid = (EntryGrid)view.getControl("apiassosettingentity");
        int[] selectRows = grid.getSelectRows();
        DynamicObject entityDy = null;
        if (selectRows != null && selectRows.length > 0) {
            int row = selectRows[0];
            DynamicObjectCollection entryEntitys = model.getEntryEntity("apiassosettingentity");
            entityDy = (DynamicObject)entryEntitys.get(row);
        }
        CloseCallBack callback = new CloseCallBack((IFormPlugin)this, PBD_SERVICE_RULE_CALLBACK);
        DynamicObject dy = model.getDataEntity();
        ArrayList<Object> billids = new ArrayList<Object>(8);
        billids.add(dy.getPkValue());
        PbdCreditPluginUtils.toServiceRule(view, billids, entityDy, callback);
    }

    private void loadLinkData(IDataModel model, IFormView view) {
        DynamicObject source = model.getDataEntity().getDynamicObject("link");
        if (source == null) {
            model.deleteEntryData("orgentity");
            return;
        }
        Long pkValue = (Long)source.getPkValue();
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pbd_credit_link");
        if (loadSingle == null) {
            model.deleteEntryData("orgentity");
            return;
        }
        model.beginInit();
        Boolean wholegroup = loadSingle.getBoolean("wholegroup");
        model.setValue("wholegroup", (Object)wholegroup);
        if (wholegroup.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pl_orgentity"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"pl_orgentity"});
        }
        DynamicObjectCollection orgentity = loadSingle.getDynamicObjectCollection("orgentity");
        if (!orgentity.isEmpty()) {
            model.deleteEntryData("orgentity");
            for (DynamicObject dy : orgentity) {
                DynamicObject companyorg = dy.getDynamicObject("companyorg");
                Boolean includesuborg = dy.getBoolean("includesuborg");
                int row = model.createNewEntryRow("orgentity");
                if (companyorg != null) {
                    model.setValue("companyorg", companyorg.getPkValue(), row);
                }
                if (includesuborg == null) continue;
                model.setValue("includesuborg", (Object)includesuborg, row);
            }
        }
        model.endInit();
    }
}

