/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.digitalcredit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ITreeListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pbd.common.utils.PbdCreditUtils;
import kd.scm.pbd.formplugin.util.PbdCreditPluginUtils;

public class PbdServiceProgrammeListPlugin
extends AbstractListPlugin {
    private static final String PBD_SERVICE_RULE_CALLBACK = "PBD_SERVICE_RULE_CALLBACK";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String operationKey = evt.getOperationKey();
        if ("new".equals(operationKey)) {
            ListView listView = (ListView)this.getView();
            ITreeListView treeListView = listView.getTreeListView();
            TreeListModel treeListModel = (TreeListModel)treeListView.getTreeModel();
            Object nodeid = treeListModel.getCurrentNodeId();
            String rootid = treeListModel.getRoot().getId();
            if (nodeid == null || nodeid.equals(rootid)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5de6\u6811\u9009\u62e9\u5408\u9002\u7684\u4e1a\u52a1\u573a\u666f\uff0c\u518d\u65b0\u589e\u3002", (String)"PbdServiceProgrammeListPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (!this.validData(args, key)) {
            return;
        }
        switch (key) {
            case "ruleconfig": {
                ListSelectedRowCollection listcoll = args.getListSelectedData();
                CloseCallBack callback = new CloseCallBack((IFormPlugin)this, PBD_SERVICE_RULE_CALLBACK);
                HashSet<Object> billids = new HashSet<Object>(8);
                for (int i = 0; i < listcoll.size(); ++i) {
                    billids.add(listcoll.get(i).getPrimaryKeyValue());
                }
                PbdCreditPluginUtils.toServiceRule(this.getView(), new ArrayList<Object>(billids), null, callback);
                break;
            }
        }
    }

    private boolean validData(BeforeDoOperationEventArgs e, String tbType) {
        boolean flag = true;
        ListSelectedRowCollection listSelectedData = e.getListSelectedData();
        if ("enable".equals(tbType)) {
            Integer valid;
            HashSet<Long> set = new HashSet<Long>(8);
            for (ListSelectedRow row : listSelectedData) {
                Long primaryKeyValue = (Long)row.getPrimaryKeyValue();
                set.add(primaryKeyValue);
            }
            IFormView view = this.getView();
            if (set.size() > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u64cd\u4f5c\u53ea\u5141\u8bb8\u542f\u7528\u4e00\u6761\u3002", (String)"PbdServiceProgrammeListPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                flag = false;
            }
            if ((valid = this.checkLink(listSelectedData)) != 0) {
                if (valid == 2) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u8fd0\u884c\u4e2d\u7684\u8fde\u63a5\u914d\u7f6e\u3002", (String)"PbdServiceProgrammeListPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                } else if (valid == 3) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u4e0d\u652f\u6301\u96c6\u56e2\u7edf\u4e00\u7684\u4e1a\u52a1\u65b9\u6848\u3002", (String)"PbdServiceProgrammeListPlugin_4", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                } else if (valid == 4) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u9002\u7528\u7ec4\u7ec7\u4e0d\u5305\u542b\u4e1a\u52a1\u65b9\u6848\u9002\u7528\u7ec4\u7ec7\u3002", (String)"PbdServiceProgrammeListPlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                }
                e.setCancel(true);
                flag = false;
            }
        }
        return flag;
    }

    private Integer checkLink(ListSelectedRowCollection listSelectedData) {
        Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
        DynamicObject[] dataEntitys = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pbd_service_programme"));
        if (dataEntitys == null) {
            return 1;
        }
        for (DynamicObject dataEntity : dataEntitys) {
            boolean flag;
            DynamicObject source = dataEntity.getDynamicObject("link");
            DynamicObject linkSource = PbdCreditPluginUtils.getLinkSource(source);
            if (linkSource == null) {
                return 2;
            }
            String openstatus = linkSource.getString("openstatus");
            if (!"2".equals(openstatus)) {
                return 2;
            }
            Boolean linkwholegroup = linkSource.getBoolean("wholegroup");
            Set entrySubordinateOrgsLink = PbdCreditUtils.getLinkCompanyOrgIds((DynamicObject)linkSource);
            Boolean wholegroup = dataEntity.getBoolean("wholegroup");
            if (!linkwholegroup.booleanValue() && wholegroup.booleanValue()) {
                return 3;
            }
            if (linkwholegroup.booleanValue()) {
                return 0;
            }
            if (CollectionUtils.isEmpty((Collection)entrySubordinateOrgsLink)) {
                return 4;
            }
            Set<Long> entrySubordinateOrgs = PbdCreditPluginUtils.getProgrammeCompanyOrgIds(dataEntity);
            if (CollectionUtils.isEmpty(entrySubordinateOrgs) || (flag = entrySubordinateOrgsLink.containsAll(entrySubordinateOrgs))) continue;
            return 4;
        }
        return 0;
    }
}

