/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.digitalcredit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.CodeRuleUtil;
import kd.scm.common.util.MutexUtil;
import kd.scm.pbd.common.entity.FieldProp;
import kd.scm.pbd.common.utils.FieldPropUtils;
import kd.scm.pbd.formplugin.util.MetadataUtils;
import kd.scm.pbd.formplugin.util.PbdCreditPluginUtils;

public class PbdServiceRulePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener {
    private static final Log log = LogFactory.getLog((String)PbdServiceRulePlugin.class.getName());
    protected static String poped_flag = "pbd_service_rule_%S_%S";
    protected static String standard_data = "pbd_service_rule_standard_data_%S_%S_%S";
    protected static String standard_class = "pbd_service_rule_standard_class_%S_%S_%S";
    protected static String billentity_field = "pbd_service_rule_%S_%S";
    protected static String ispreinsdata = "pbd_service_rule_ispreinsdata_%S_%S";
    private static final String KEY = "key";
    private static final String ROW = "$row";
    private static final String BILL = "bill";
    private static final String RULETYPECHANGE_COMFIRM = "RULETYPECHANGE_COMFIRM";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getView().getControl("tv_rules");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"tbmain", "baritemap"});
        this.addClickListeners(new String[]{"inputsourcefielddesc", "inputtargetfieldname", "outputsourcefielddesc", "outputtargetfieldname", "inputsrcrulefielddesc", "inputtarrulefieldname", "outputsrcrulefielddesc", "outputtarrulefieldname"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || !customParams.containsKey("billid")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u89c4\u5219\u3002", (String)"PbdServiceRulePlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
        List billIds = (List)customParams.get("billid");
        if (billIds == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u89c4\u5219\u3002", (String)"PbdServiceRulePlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
        List<DynamicObject> loads = this.getServiceProgrammes(billIds);
        if (CollectionUtils.isEmpty(loads)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u89c4\u5219\u3002", (String)"PbdServiceRulePlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Object> billIdMutexs = new ArrayList<Object>(8);
        for (DynamicObject load : loads) {
            billIdMutexs.add(load.getPkValue());
            boolean request = MutexUtil.request((String)load.getPkValue().toString(), (String)"pbd_service_programme", (String)"ruleconfig");
            if (request) continue;
            String name = load.getString("name");
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"%1\u6b63\u5728\u8fdb\u884c\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PbdServiceRulePlugin_11", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdServiceRulePlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[]{name}));
        }
        this.getPageCache().put("billid", JSONArray.toJSONString((Object)billIds));
        String billIdCacheKey = String.format(poped_flag, "billId", this.getView().getPageId());
        cache.put(billIdCacheKey, JSON.toJSONString(billIdMutexs));
        Object entityId = customParams.get("entryid");
        this.buildTree(cache, loads, entityId, customParams);
        if (entityId == null) {
            entityId = customParams.get("entryid");
        }
        this.loadData(cache, model, view, loads, entityId);
        if (entityId != null) {
            String curEntityIdCacheKey = String.format(poped_flag, "curEntityId", this.getView().getPageId());
            cache.put(curEntityIdCacheKey, String.valueOf(entityId));
            this.loadEntityData(entityId);
            this.setDisableBtn(cache, entityId);
        }
        view.updateView();
    }

    private void setDisableBtn(IPageCache cache, Object entityId) {
        String ispreinsdataCacheKey = String.format(ispreinsdata, entityId, this.getView().getPageId());
        String ispreinsdataStr = cache.get(ispreinsdataCacheKey);
        if ("true".equals(ispreinsdataStr)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"baritemap"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"newentry_fin"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"deleteentry_fin"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"newentry_fout"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"deleteentry_fout"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"newentry_plug"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"deleteentry_plug"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"newentry_fincheck"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"deleteentry_fincheck"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"newentry_foutcheck"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"deleteentry_foutcheck"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"newentry_plugrule"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"deleteentry_plugrule"});
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        String billIds = this.getPageCache().get("billid");
        if (StringUtils.isNotEmpty((String)billIds)) {
            this.getPageCache().remove(billIds);
            List billIdList = JSONArray.parseArray((String)billIds, Object.class);
            if (billIdList != null) {
                for (Object billId : billIdList) {
                    MutexUtil.release((String)billId.toString(), (String)"pbd_service_programme", (String)"ruleconfig");
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSets = e.getChangeSet();
        switch (propertyName) {
            case "inputsrcrulefielddesc": {
                this.doClearFieldValue("inputsrcrulefield", changeSets);
                this.doClearFieldValue("inputpaltrulefielddesc", changeSets);
                break;
            }
            case "outputsrcrulefielddesc": {
                this.doClearFieldValue("outputsrcrulefield", changeSets);
                this.doClearFieldValue("outputpaltrulefielddesc", changeSets);
                break;
            }
            case "inputsourcefielddesc": {
                this.doClearFieldValue("inputsourcefield", changeSets);
                this.doClearFieldValue("inputplatfielddesc", changeSets);
                break;
            }
            case "outputsourcefielddesc": {
                this.doClearFieldValue("outputsourcefield", changeSets);
                this.doClearFieldValue("outputplatfielddesc", changeSets);
                break;
            }
            case "inputtarrulefieldname": {
                this.doClearFieldValue("inputtarrulefield", changeSets);
                break;
            }
            case "outputtarrulefieldname": {
                this.doClearFieldValue("outputtarrulefield", changeSets);
                break;
            }
            case "inputtargetfieldname": {
                this.doClearFieldValue("inputtargetfield", changeSets);
                break;
            }
            case "outputtargetfieldname": {
                this.doClearFieldValue("outputtargetfield", changeSets);
                break;
            }
            case "outputfieldformuladesc": {
                this.doClearFieldValue("outputfieldformula", changeSets);
                break;
            }
        }
    }

    private void doClearFieldValue(String key, ChangeData[] changeDatas) {
        for (ChangeData changeData : changeDatas) {
            Object newValue = changeData.getNewValue();
            if (newValue != null && !StringUtils.isEmpty((String)changeData.getNewValue().toString())) continue;
            this.getModel().setValue(key, null, changeData.getRowIndex());
        }
    }

    private void ruletypeChange(IFormView view, IDataModel model, IPageCache pageCache, Boolean isReLoad) {
        String ruletype = model.getDataEntity().getString("ruletype");
        if (!"C".equals(ruletype)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap_outfieldmap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap_outfieldmap"});
        }
        String pageId = view.getPageId();
        if (this.isCheckRule(ruletype)) {
            model.deleteEntryData("inputscheckdata");
            model.deleteEntryData("outputscheckdata");
            model.deleteEntryData("pluginpolicyrule");
            view.setEnable(Boolean.valueOf(true), new String[]{"tbpage_fieldmap"});
            view.setEnable(Boolean.valueOf(false), new String[]{"tbpage_checkdata"});
            Tab tbpage_fieldmap = (Tab)view.getControl("tbctrl_design");
            tbpage_fieldmap.activeTab("tbpage_fieldmap");
            if (isReLoad.booleanValue()) {
                model.deleteEntryData("pluginpolicyfield");
                this.fillData(model, pageCache, pageId, "inputsfieldmap", "outputsfieldmap", ruletype);
            }
        } else if (!this.isCheckRule(ruletype)) {
            model.deleteEntryData("inputsfieldmap");
            model.deleteEntryData("outputsfieldmap");
            model.deleteEntryData("pluginpolicyfield");
            view.setEnable(Boolean.valueOf(false), new String[]{"tbpage_fieldmap"});
            view.setEnable(Boolean.valueOf(true), new String[]{"tbpage_checkdata"});
            Tab tbpage_checkdata = (Tab)view.getControl("tbctrl_design");
            tbpage_checkdata.activeTab("tbpage_checkdata");
            if (isReLoad.booleanValue()) {
                model.deleteEntryData("pluginpolicyrule");
                this.fillData(model, pageCache, pageId, "inputscheckdata", "outputscheckdata", ruletype);
            }
        }
    }

    private boolean isCheckRule(String ruletype) {
        return "B".equals(ruletype) || "C".equals(ruletype) || "D".equals(ruletype) || "E".equals(ruletype);
    }

    private void fillData(IDataModel model, IPageCache pageCache, String pageId, String inEntityKey, String outEntityKey, String ruletype) {
        model.deleteEntryData(inEntityKey);
        List<FieldProp> inputsFieldProps = this.getCacheFieldProp(pageCache, "inputsentity", pageId);
        this.updateEntryEntityModel(model, inEntityKey, inputsFieldProps, 0);
        model.deleteEntryData(outEntityKey);
        if ("B".equals(ruletype) || "D".equals(ruletype)) {
            List<FieldProp> outputsFieldProps = this.getCacheFieldProp(pageCache, "outputsentity", pageId);
            this.updateEntryEntityModel(model, outEntityKey, outputsFieldProps, 0);
        }
    }

    private void updateEntryEntityModel(IDataModel model, String entryentity, List<FieldProp> fieldProps, int rowIndex) {
        ArrayList<Long> pkIds = new ArrayList<Long>(8);
        if (CollectionUtils.isEmpty(fieldProps)) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowCount = 0;
        for (FieldProp prop : fieldProps) {
            String fieldKey = FieldPropUtils.updateKeyIncludeParentKey(fieldProps, (FieldProp)prop, (String)prop.getKey());
            prop.setKey(fieldKey);
            Long id = Long.parseLong(prop.getId());
            Long pid = Long.parseLong(prop.getParentId());
            if (pid != 0L) {
                Optional<FieldProp> findAny = fieldProps.stream().filter(f -> f.getId().equals(prop.getParentId())).findAny();
                if (!findAny.isPresent()) continue;
                FieldProp parent = findAny.get();
                if (pkIds.contains(pid)) {
                    this.setStandardData(vs, entryentity, prop, pkIds, rowCount);
                    ++rowCount;
                    continue;
                }
                this.setStandardData(vs, entryentity, parent, pkIds, rowCount);
                this.setStandardData(vs, entryentity, prop, pkIds, ++rowCount);
                ++rowCount;
                continue;
            }
            if (pkIds.contains(id)) continue;
            this.setStandardData(vs, entryentity, prop, pkIds, rowCount);
            ++rowCount;
        }
        AbstractFormDataModel model1 = (AbstractFormDataModel)model;
        model1.batchCreateNewEntryRow(entryentity, vs);
    }

    private void setStandardData(TableValueSetter vs, String entryentity, FieldProp prop, List<Long> pkIds, int rowCount) {
        if (prop == null) {
            return;
        }
        Long id = Long.parseLong(prop.getId());
        pkIds.add(id);
        String key = prop.getKey();
        String name = prop.getName();
        String thirdfieldname = prop.getThirdfieldname();
        if (entryentity.equals("inputsfieldmap")) {
            vs.set("inputsourcefield", (Object)key, rowCount);
            vs.set("inputsourcefielddesc", (Object)name, rowCount);
            vs.set("inputfieldtype", (Object)"0", rowCount);
            vs.set("inputplatfielddesc", (Object)thirdfieldname, rowCount);
        } else if (entryentity.equals("outputsfieldmap")) {
            vs.set("outputsourcefield", (Object)key, rowCount);
            vs.set("outputsourcefielddesc", (Object)name, rowCount);
            vs.set("outputfieldtype", (Object)"0", rowCount);
            vs.set("outputplatfielddesc", (Object)thirdfieldname, rowCount);
        } else if (entryentity.equals("inputscheckdata")) {
            vs.set("inputsrcrulefield", (Object)key, rowCount);
            vs.set("inputsrcrulefielddesc", (Object)name, rowCount);
            vs.set("inputruletype", (Object)"0", rowCount);
            vs.set("inputpaltrulefielddesc", (Object)thirdfieldname, rowCount);
        } else if (entryentity.equals("outputscheckdata")) {
            vs.set("outputsrcrulefield", (Object)key, rowCount);
            vs.set("outputsrcrulefielddesc", (Object)name, rowCount);
            vs.set("outputruletype", (Object)"0", rowCount);
            vs.set("outputpaltrulefielddesc", (Object)thirdfieldname, rowCount);
        }
    }

    private void buildTree(IPageCache cache, List<DynamicObject> loads, Object entityId, Map<String, Object> customParams) {
        TreeNode treeNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"PbdServiceRulePlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]), true);
        TreeNode curNode = null;
        int rowindex = 0;
        for (DynamicObject load : loads) {
            DynamicObjectCollection apiassosettingentitys = load.getDynamicObjectCollection("apiassosettingentity");
            if (CollectionUtils.isEmpty((Collection)apiassosettingentitys)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u89c4\u5219\u3002", (String)"PbdServiceRulePlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            }
            DynamicObject group = load.getDynamicObject("group");
            String groupName = group.getString("name");
            DynamicObject billentity = load.getDynamicObject("billentity");
            String billEntityName = billentity.getString("name");
            String operator = load.getString("operatorname");
            String name = load.getString("name");
            for (DynamicObject dy : apiassosettingentitys) {
                DynamicObject platformapi;
                DynamicObject standardapi;
                if (rowindex == 0 && entityId == null) {
                    entityId = dy.getPkValue();
                    customParams.put("entryid", String.valueOf(dy.getPkValue()));
                }
                if ((standardapi = dy.getDynamicObject("standardapi")) == null || (platformapi = dy.getDynamicObject("platformapi")) == null) continue;
                this.cacheStandardData(standardapi, platformapi, String.valueOf(dy.getPkValue()));
                String standardapiName = standardapi.getString("name");
                String treeTitle = groupName + "_" + name + "_" + billEntityName + "_" + operator + "_" + standardapiName;
                TreeNode childNode = new TreeNode("0", String.valueOf(dy.getPkValue()), treeTitle);
                treeNode.addChild(childNode);
                if (dy.getPkValue().equals(entityId)) {
                    curNode = childNode;
                }
                String entityIdCacheKey = String.format(poped_flag, String.valueOf(dy.getPkValue()), this.getView().getPageId());
                cache.put(entityIdCacheKey, String.valueOf(load.getPkValue()));
                String ispreinsdataCacheKey = String.format(ispreinsdata, dy.getPkValue(), this.getView().getPageId());
                boolean ispreinsdata = load.getBoolean("ispreinsdata");
                this.getPageCache().put(ispreinsdataCacheKey, String.valueOf(ispreinsdata));
                ++rowindex;
            }
        }
        TreeView tree = (TreeView)this.getView().getControl("tv_rules");
        tree.addNode(treeNode);
        tree.expand("0");
        if (curNode != null) {
            tree.focusNode(curNode);
        }
    }

    private void loadData(IPageCache cache, IDataModel model, IFormView view, List<DynamicObject> loads, Object entityId) {
        model.beginInit();
        if (entityId == null) {
            DynamicObject load = loads.get(0);
            DynamicObjectCollection apiassosettingentitys = load.getDynamicObjectCollection("apiassosettingentity");
            if (!CollectionUtils.isEmpty((Collection)apiassosettingentitys)) {
                DynamicObject apiassosettingentitydy = (DynamicObject)apiassosettingentitys.get(0);
                this.setData(model, view, load, apiassosettingentitydy);
                this.putBillEntityFieldCache(load.getDynamicObject("billentity"));
            }
        } else {
            Optional<DynamicObject> findCurDy;
            DynamicObject load = null;
            String entityIdCacheKey = String.format(poped_flag, entityId, this.getView().getPageId());
            String billId = cache.get(entityIdCacheKey);
            load = billId == null ? loads.get(0) : ((findCurDy = loads.stream().filter(a -> String.valueOf(a.getPkValue()).equals(billId)).findFirst()).isPresent() ? findCurDy.get() : loads.get(0));
            DynamicObjectCollection apiassosettingentitys = load.getDynamicObjectCollection("apiassosettingentity");
            Optional<DynamicObject> findCur = apiassosettingentitys.stream().filter(a -> String.valueOf(a.getPkValue()).equals(String.valueOf(entityId))).findFirst();
            DynamicObject apiassosettingentitydy = null;
            if (findCur.isPresent()) {
                apiassosettingentitydy = findCur.get();
            }
            this.setData(model, view, load, apiassosettingentitydy);
            this.putBillEntityFieldCache(load.getDynamicObject("billentity"));
        }
        model.endInit();
    }

    private void setData(IDataModel model, IFormView view, DynamicObject load, DynamicObject apiassosettingentitydy) {
        DynamicObject billentity = load.getDynamicObject("billentity");
        String operatorname = load.getString("operatorname");
        String operator = load.getString("operator");
        String triggertype = load.getString("triggertype");
        if (billentity != null) {
            model.setValue("billentity", billentity.getPkValue());
        }
        model.setValue("triggertype", (Object)triggertype);
        model.setValue("operatorname", (Object)operatorname);
        PbdCreditPluginUtils.setBillOpratorItems(view, model, load, operator);
        if (apiassosettingentitydy != null) {
            DynamicObject standardapi = apiassosettingentitydy.getDynamicObject("standardapi");
            DynamicObject platformapi = apiassosettingentitydy.getDynamicObject("platformapi");
            if (standardapi != null) {
                model.setValue("standardapi", standardapi.getPkValue());
            }
            if (platformapi != null) {
                model.setValue("platformapi", platformapi.getPkValue());
            }
            String apipurpose = apiassosettingentitydy.getString("apipurpose");
            model.setValue("ruletype", (Object)apipurpose);
        }
    }

    private void putBillEntityFieldCache(DynamicObject billentity) {
        String entityKey = billentity.getString("number");
        FormMetadata formmeta = MetadataUtils.getFormMetaData(entityKey);
        List<FieldProp> entityAps = MetadataUtils.getEntityAp(formmeta);
        ArrayList<String> asList = new ArrayList<String>(8);
        asList.add(BILL);
        for (FieldProp entity : entityAps) {
            asList.add(entity.getKey());
        }
        Map<String, List<ControlAp<?>>> proAllEntitykey = MetadataUtils.getProEntitykey(formmeta, asList);
        List<FieldProp> allFieldProps = MetadataUtils.getProItemMap(proAllEntitykey);
        allFieldProps.addAll(entityAps);
        String fieldCacheKey = String.format(billentity_field, "billentityfield", this.getView().getPageId());
        log.info("\u4e1a\u52a1\u8c03\u7528\u65b9\u6848\u5355\u636e\u6216\u7ec4\u4ef6\u5bf9\u5e94\u7684\u7f13\u5b58key:{},\u7f13\u5b58\u503c={}", (Object)fieldCacheKey, (Object)JSON.toJSONString(allFieldProps));
        this.getPageCache().put(fieldCacheKey, JSON.toJSONString(allFieldProps));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operationKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        switch (operationKey = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey()) {
            case "save": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.save(view, model, cache);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PbdServiceRulePlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void save(IFormView view, IDataModel model, IPageCache cache) {
        DynamicObject dy = model.getDataEntity();
        String curEntityIdCacheKey = String.format(poped_flag, "curEntityId", view.getPageId());
        String curEntryId = cache.get(curEntityIdCacheKey);
        if (StringUtils.isBlank((String)curEntryId) || "0".equals(curEntryId)) {
            return;
        }
        String entityIdCacheKey = String.format(poped_flag, curEntryId, view.getPageId());
        String curBillId = cache.get(entityIdCacheKey);
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])new Object[]{curEntryId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pbd_service_rule_config"));
        DynamicObject saveDynamicObject = null;
        saveDynamicObject = loads == null || loads.length == 0 ? BusinessDataServiceHelper.newDynamicObject((String)"pbd_service_rule_config") : loads[0];
        this.setBill(dy, curEntryId, curBillId, saveDynamicObject);
        String ruletype = dy.getString("ruletype");
        if (this.isCheckRule(ruletype)) {
            DynamicObjectCollection inputsfieldmap = model.getEntryEntity("inputsfieldmap");
            this.setInputsFieldMap(inputsfieldmap, model, saveDynamicObject);
            DynamicObjectCollection outputsfieldmap = model.getEntryEntity("outputsfieldmap");
            this.setOutputsFieldMap(outputsfieldmap, model, saveDynamicObject);
            DynamicObjectCollection loadPluginpolicy = model.getEntryEntity("pluginpolicyfield");
            this.setPluginPolicyField(loadPluginpolicy, this.getModel(), saveDynamicObject);
        } else if (!this.isCheckRule(ruletype)) {
            DynamicObjectCollection inputscheckdata = model.getEntryEntity("inputscheckdata");
            this.setInputsCheckData(inputscheckdata, model, saveDynamicObject);
            DynamicObjectCollection outputscheckdata = model.getEntryEntity("outputscheckdata");
            this.setOutputsCheckData(outputscheckdata, model, saveDynamicObject);
            DynamicObjectCollection loadPluginpolicy = model.getEntryEntity("pluginpolicyrule");
            this.setPluginPolicyRule(loadPluginpolicy, this.getModel(), saveDynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDynamicObject});
    }

    private void setBill(DynamicObject dy, String curEntryId, String curBillId, DynamicObject newDynamicObject) {
        String operator;
        String triggertype;
        DynamicObject billentityDy;
        DynamicObject platformapiDy;
        newDynamicObject.set("id", (Object)curEntryId);
        DynamicObject standardapiDy = dy.getDynamicObject("standardapi");
        if (standardapiDy != null) {
            newDynamicObject.set("standardapi", standardapiDy.getPkValue());
        }
        if ((platformapiDy = dy.getDynamicObject("platformapi")) != null) {
            newDynamicObject.set("platformapi", platformapiDy.getPkValue());
        }
        if ((billentityDy = dy.getDynamicObject("billentity")) != null) {
            newDynamicObject.set("billentity", billentityDy.getPkValue());
        }
        if ((triggertype = dy.getString("triggertype")) != null) {
            newDynamicObject.set("triggertype", (Object)triggertype);
        }
        if ((operator = dy.getString("operator")) != null) {
            newDynamicObject.set("operator", (Object)operator);
        }
        newDynamicObject.set("billid", (Object)curBillId);
        newDynamicObject.set("entryid", (Object)curEntryId);
        newDynamicObject.set("billstatus", (Object)"C");
        String billno = dy.getString("billno");
        if (StringUtils.isNotEmpty((String)billno)) {
            newDynamicObject.set("billno", (Object)billno);
        } else {
            String codeRule = CodeRuleUtil.getCodeRule((String)"pbd_service_rule_config");
            newDynamicObject.set("billno", (Object)codeRule);
        }
        String ruletype = dy.getString("ruletype");
        if (StringUtils.isNotEmpty((String)ruletype)) {
            newDynamicObject.set("ruletype", (Object)ruletype);
        }
    }

    private void setPluginPolicyField(DynamicObjectCollection pluginpolicy, IDataModel model, DynamicObject saveBillDy) {
        if (pluginpolicy != null) {
            DynamicObjectCollection saveEntityDy = null;
            if (saveBillDy != null) {
                saveEntityDy = saveBillDy.getDynamicObjectCollection("pluginpolicyfield");
                saveEntityDy.clear();
            }
            for (DynamicObject plugindy : pluginpolicy) {
                if (StringUtils.isEmpty((String)plugindy.getString("plclassnamefield"))) continue;
                DynamicObject addNew = this.getDynamicObject(model, saveEntityDy, plugindy, "pluginpolicyfield", "plfentityid");
                addNew.set("plclassnamefield", plugindy.get("plclassnamefield"));
                addNew.set("pldisplaynamefield", plugindy.get("pldisplaynamefield"));
                addNew.set("plisenablefield", plugindy.get("plisenablefield"));
                addNew.set("pldescriptionfield", plugindy.get("pldescriptionfield"));
                if (saveBillDy == null) {
                    addNew.set("plfieldfentityid", plugindy.getPkValue());
                    continue;
                }
                addNew.set("id", plugindy.get("plfieldfentityid"));
            }
        }
    }

    private void setPluginPolicyRule(DynamicObjectCollection pluginpolicy, IDataModel model, DynamicObject saveBillDy) {
        if (pluginpolicy != null) {
            DynamicObjectCollection saveEntityDy = null;
            if (saveBillDy != null) {
                saveEntityDy = saveBillDy.getDynamicObjectCollection("pluginpolicyrule");
                saveEntityDy.clear();
            }
            for (DynamicObject plugindy : pluginpolicy) {
                if (StringUtils.isEmpty((String)plugindy.getString("plclassnamerule"))) continue;
                DynamicObject addNew = this.getDynamicObject(model, saveEntityDy, plugindy, "pluginpolicyrule", "plfentityid");
                addNew.set("plclassnamerule", plugindy.get("plclassnamerule"));
                addNew.set("pldisplaynamerule", plugindy.get("pldisplaynamerule"));
                addNew.set("plisenablerule", plugindy.get("plisenablerule"));
                addNew.set("pldescriptionrule", plugindy.get("pldescriptionrule"));
                if (saveBillDy == null) {
                    addNew.set("plrulefentityid", plugindy.getPkValue());
                    continue;
                }
                addNew.set("id", plugindy.get("plrulefentityid"));
            }
        }
    }

    private void setOutputsCheckData(DynamicObjectCollection outputscheckdata, IDataModel model, DynamicObject saveBillDy) {
        if (outputscheckdata != null) {
            DynamicObjectCollection saveEntityDy = null;
            if (saveBillDy != null) {
                saveEntityDy = saveBillDy.getDynamicObjectCollection("outputscheckdata");
                saveEntityDy.clear();
            }
            IPageCache pageCache = this.getPageCache();
            List<FieldProp> fieldProps = this.getCacheFieldProp(pageCache, "outputsentity", pageCache.getPageId());
            for (DynamicObject outputsdy : outputscheckdata) {
                if (StringUtils.isEmpty((String)outputsdy.getString("outputsrcrulefield"))) continue;
                DynamicObject addNew = this.getDynamicObject(model, saveEntityDy, outputsdy, "outputscheckdata", "outputsrcrulefentityid");
                addNew.set("outputsrcrulefield", outputsdy.get("outputsrcrulefield"));
                addNew.set("outputsrcrulefielddesc", outputsdy.get("outputsrcrulefielddesc"));
                addNew.set("outputruletype", outputsdy.get("outputruletype"));
                addNew.set("outputtarrulefield", outputsdy.get("outputtarrulefield"));
                addNew.set("outputtarrulefieldname", outputsdy.get("outputtarrulefieldname"));
                addNew.set("outputtarruletconstant", outputsdy.get("outputtarruletconstant"));
                addNew.set("outputruleremark", outputsdy.get("outputruleremark"));
                if (saveBillDy == null) {
                    addNew.set("outputsrcrulefentityid", outputsdy.getPkValue());
                    Object value = outputsdy.get("outputsrcrulefield");
                    this.setThirdFieldName(fieldProps, addNew, value, "outputpaltrulefielddesc");
                    continue;
                }
                addNew.set("id", outputsdy.get("outputsrcrulefentityid"));
            }
        }
    }

    private void setThirdFieldName(List<FieldProp> fieldProps, DynamicObject addNew, Object value, String paltrulefielddesc) {
        if (value != null) {
            FieldProp fieldProp;
            String[] split = value.toString().split("\\.");
            String key = value.toString();
            if (split.length > 1) {
                key = split[split.length - 1];
            }
            if ((fieldProp = FieldPropUtils.findCheckedField(null, (Object)key, fieldProps)) != null) {
                addNew.set(paltrulefielddesc, (Object)fieldProp.getThirdfieldname());
            }
        }
    }

    private void setInputsCheckData(DynamicObjectCollection inputscheckdata, IDataModel model, DynamicObject saveBillDy) {
        if (inputscheckdata != null) {
            DynamicObjectCollection saveEntityDy = null;
            if (saveBillDy != null) {
                saveEntityDy = saveBillDy.getDynamicObjectCollection("inputscheckdata");
                saveEntityDy.clear();
            }
            IPageCache pageCache = this.getPageCache();
            List<FieldProp> fieldProps = this.getCacheFieldProp(pageCache, "inputsentity", pageCache.getPageId());
            for (DynamicObject inputsdy : inputscheckdata) {
                if (StringUtils.isEmpty((String)inputsdy.getString("inputsrcrulefield"))) continue;
                DynamicObject addNew = this.getDynamicObject(model, saveEntityDy, inputsdy, "inputscheckdata", "inputsourcerulefentityid");
                addNew.set("inputsrcrulefield", inputsdy.get("inputsrcrulefield"));
                addNew.set("inputsrcrulefielddesc", inputsdy.get("inputsrcrulefielddesc"));
                addNew.set("inputruletype", inputsdy.get("inputruletype"));
                addNew.set("inputtarrulefield", inputsdy.get("inputtarrulefield"));
                addNew.set("inputtarrulefieldname", inputsdy.get("inputtarrulefieldname"));
                addNew.set("inputruleremark", inputsdy.get("inputruleremark"));
                addNew.set("inputtarruletconstant", inputsdy.get("inputtarruletconstant"));
                if (saveBillDy == null) {
                    addNew.set("inputsourcerulefentityid", inputsdy.getPkValue());
                    Object value = inputsdy.get("inputsrcrulefield");
                    this.setThirdFieldName(fieldProps, addNew, value, "inputpaltrulefielddesc");
                    continue;
                }
                addNew.set("id", inputsdy.get("inputsourcerulefentityid"));
            }
        }
    }

    private void setOutputsFieldMap(DynamicObjectCollection outputsfieldmap, IDataModel model, DynamicObject saveBillDy) {
        if (outputsfieldmap != null) {
            DynamicObjectCollection saveEntityDy = null;
            if (saveBillDy != null) {
                saveEntityDy = saveBillDy.getDynamicObjectCollection("outputsfieldmap");
                saveEntityDy.clear();
            }
            IPageCache pageCache = this.getPageCache();
            List<FieldProp> fieldProps = this.getCacheFieldProp(pageCache, "outputsentity", pageCache.getPageId());
            for (DynamicObject outputsdy : outputsfieldmap) {
                if (StringUtils.isEmpty((String)outputsdy.getString("outputsourcefield"))) continue;
                DynamicObject addNew = this.getDynamicObject(model, saveEntityDy, outputsdy, "outputsfieldmap", "outputsrcfieldfentityid");
                addNew.set("outputsourcefield", outputsdy.get("outputsourcefield"));
                addNew.set("outputsourcefielddesc", outputsdy.get("outputsourcefielddesc"));
                addNew.set("outputfieldtype", outputsdy.get("outputfieldtype"));
                addNew.set("outputtargetfield", outputsdy.get("outputtargetfield"));
                addNew.set("outputtargetfieldname", outputsdy.get("outputtargetfieldname"));
                addNew.set("outputfieldformula", outputsdy.get("outputfieldformula"));
                addNew.set("outputfieldformuladesc", outputsdy.get("outputfieldformuladesc"));
                if (saveBillDy == null) {
                    addNew.set("outputsrcfieldfentityid", outputsdy.getPkValue());
                    Object value = outputsdy.get("outputsourcefield");
                    this.setThirdFieldName(fieldProps, addNew, value, "outputplatfielddesc");
                    continue;
                }
                addNew.set("id", outputsdy.get("outputsrcfieldfentityid"));
            }
        }
    }

    private void setInputsFieldMap(DynamicObjectCollection inputsfieldmap, IDataModel model, DynamicObject saveBillDy) {
        if (inputsfieldmap != null) {
            DynamicObjectCollection saveEntityDy = null;
            if (saveBillDy != null) {
                saveEntityDy = saveBillDy.getDynamicObjectCollection("inputsfieldmap");
                saveEntityDy.clear();
            }
            IPageCache pageCache = this.getPageCache();
            List<FieldProp> fieldProps = this.getCacheFieldProp(pageCache, "inputsentity", pageCache.getPageId());
            for (DynamicObject inputsdy : inputsfieldmap) {
                if (StringUtils.isEmpty((String)inputsdy.getString("inputsourcefield"))) continue;
                DynamicObject addNew = this.getDynamicObject(model, saveEntityDy, inputsdy, "inputsfieldmap", "inputsourcefieldfentityid");
                addNew.set("inputsourcefield", inputsdy.get("inputsourcefield"));
                addNew.set("inputsourcefielddesc", inputsdy.get("inputsourcefielddesc"));
                addNew.set("inputfieldtype", inputsdy.get("inputfieldtype"));
                addNew.set("inputtargetfield", inputsdy.get("inputtargetfield"));
                addNew.set("inputtargetfieldname", inputsdy.get("inputtargetfieldname"));
                addNew.set("inputtargetconstant", inputsdy.get("inputtargetconstant"));
                addNew.set("inputremark", inputsdy.get("inputremark"));
                if (saveBillDy == null) {
                    addNew.set("inputsourcefieldfentityid", inputsdy.getPkValue());
                    Object value = inputsdy.get("inputsourcefield");
                    this.setThirdFieldName(fieldProps, addNew, value, "inputplatfielddesc");
                    continue;
                }
                addNew.set("id", inputsdy.get("inputsourcefieldfentityid"));
            }
        }
    }

    private DynamicObject getDynamicObject(IDataModel model, DynamicObjectCollection saveEntityDy, DynamicObject outputsdy, String entryEntity, String fieldId) {
        DynamicObject addNew = null;
        if (saveEntityDy == null) {
            String pkVal = String.valueOf(outputsdy.getPkValue());
            DynamicObjectCollection newFieldMapDy = model.getEntryEntity(entryEntity);
            Optional<DynamicObject> findFirst = newFieldMapDy.stream().filter(d -> pkVal.equals(String.valueOf(d.getPkValue()))).findFirst();
            if (findFirst.isPresent()) {
                addNew = findFirst.get();
            } else {
                DynamicObject entryRowEntity;
                int createNewEntryRow = model.createNewEntryRow(entryEntity);
                addNew = entryRowEntity = model.getEntryRowEntity(entryEntity, createNewEntryRow);
            }
        } else {
            addNew = saveEntityDy.addNew();
        }
        return addNew;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String pageId = this.getView().getPageId();
        IPageCache pageCache = this.getPageCache();
        IDataModel model = this.getModel();
        Control ctlSource = (Control)evt.getSource();
        String fieldKey = ctlSource.getKey();
        String inputstitle = ResManager.loadKDString((String)"\u6620\u5c04\u5b57\u6bb5", (String)"PbdServiceRulePlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
        String curEntityIdCacheKey = String.format(poped_flag, "curEntityId", this.getView().getPageId());
        String curEntityId = pageCache.get(curEntityIdCacheKey);
        if (StringUtils.isBlank((String)curEntityId) || curEntityId.equals("0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5de6\u6811\u518d\u64cd\u4f5c\u3002", (String)"PbdServiceRulePlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (fieldKey) {
            case "inputsourcefielddesc": {
                int inputsfieldrow = this.getModel().getEntryCurrentRowIndex("inputsfieldmap");
                List<FieldProp> inputsFieldProps = this.getCacheFieldProp(pageCache, "inputsentity", pageId);
                List<String> curInputsFields = PbdCreditPluginUtils.getCurFieldIds(model, "inputsfieldmap", "inputsourcefield");
                String nodesJson = PbdCreditPluginUtils.bulidNodesJson(inputsFieldProps, inputstitle, curInputsFields, "id");
                this.showSelectFieldForm(fieldKey, inputsfieldrow, nodesJson);
                break;
            }
            case "inputsrcrulefielddesc": {
                int inputsCdrow = this.getModel().getEntryCurrentRowIndex("inputscheckdata");
                List<FieldProp> inputsCdFieldProps = this.getCacheFieldProp(pageCache, "inputsentity", pageId);
                List<String> curInputsCdFields = PbdCreditPluginUtils.getCurFieldIds(model, "inputscheckdata", "inputsrcrulefield");
                String inputsCdNodesJson = PbdCreditPluginUtils.bulidNodesJson(inputsCdFieldProps, inputstitle, curInputsCdFields, "id");
                this.showSelectFieldForm(fieldKey, inputsCdrow, inputsCdNodesJson);
                break;
            }
            case "outputsourcefielddesc": {
                int outputsfieldrow = this.getModel().getEntryCurrentRowIndex("outputsfieldmap");
                List<FieldProp> outputsFieldProps = this.getCacheFieldProp(pageCache, "outputsentity", pageId);
                List<String> curOutputsFields = PbdCreditPluginUtils.getCurFieldIds(model, "outputsfieldmap", "outputsourcefield");
                String outputsNodesJson = PbdCreditPluginUtils.bulidNodesJson(outputsFieldProps, inputstitle, curOutputsFields, "id");
                this.showSelectFieldForm(fieldKey, outputsfieldrow, outputsNodesJson);
                break;
            }
            case "outputsrcrulefielddesc": {
                int outputscheckrow = this.getModel().getEntryCurrentRowIndex("outputscheckdata");
                List<FieldProp> outputsCdFieldProps = this.getCacheFieldProp(pageCache, "outputsentity", pageId);
                List<String> curOutputsCdFields = PbdCreditPluginUtils.getCurFieldIds(model, "outputscheckdata", "outputsrcrulefield");
                String outputsCdNodesJson = PbdCreditPluginUtils.bulidNodesJson(outputsCdFieldProps, inputstitle, curOutputsCdFields, "id");
                this.showSelectFieldForm(fieldKey, outputscheckrow, outputsCdNodesJson);
                break;
            }
            case "inputtargetfieldname": {
                int inputstarrow = this.getModel().getEntryCurrentRowIndex("inputsfieldmap");
                String inputtargetfield = (String)model.getValue("inputsourcefield", inputstarrow);
                this.showSelectFieldForm(fieldKey, inputstarrow, model, null);
                break;
            }
            case "inputtarrulefieldname": {
                int inputschecktarrow = this.getModel().getEntryCurrentRowIndex("inputscheckdata");
                String inputtarrulefield = (String)model.getValue("inputsrcrulefield", inputschecktarrow);
                this.showSelectFieldForm(fieldKey, inputschecktarrow, model, null);
                break;
            }
            case "outputtargetfieldname": {
                int outputstarrow = this.getModel().getEntryCurrentRowIndex("outputsfieldmap");
                String outputtargetfield = (String)model.getValue("outputsourcefield", outputstarrow);
                this.showSelectFieldForm(fieldKey, outputstarrow, model, null);
                break;
            }
            case "outputtarrulefieldname": {
                int outputschecktarrow = this.getModel().getEntryCurrentRowIndex("outputscheckdata");
                String outputtarrulefield = (String)model.getValue("outputsrcrulefield", outputschecktarrow);
                this.showSelectFieldForm(fieldKey, outputschecktarrow, model, null);
                break;
            }
        }
    }

    private Class<?> getClassesType(IPageCache pageCache, IDataModel model, String curEntityId, String value, String entityKey) {
        Class<?> classes = null;
        String classCacheKey = String.format(standard_class, curEntityId, entityKey, this.getView().getPageId());
        String classCache = pageCache.get(classCacheKey);
        if (!StringUtils.isEmpty((String)classCache)) {
            JSONObject parseObject = JSON.parseObject((String)classCache);
            try {
                String[] split = value.split("\\.");
                String str = (String)parseObject.get((Object)split[split.length - 1]);
                classes = Class.forName(str);
            }
            catch (Exception e) {
                return null;
            }
        }
        return classes;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        String pageId = this.getView().getPageId();
        IPageCache pageCache = this.getPageCache();
        if (returnData != null) {
            String returnDataStr = returnData.toString();
            if (StringUtils.isEmpty((String)returnDataStr)) {
                return;
            }
            Map data = (Map)returnData;
            String actionId = e.getActionId();
            IDataModel model = this.getModel();
            switch (actionId) {
                case "inputsourcefielddesc": {
                    String key;
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    List<String> curInputsFields = PbdCreditPluginUtils.getCurFieldIds(model, "inputsfieldmap", "inputsourcefield");
                    if (curInputsFields.contains(key = (String)data.get(KEY))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PbdServiceRulePlugin_4", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    FieldProp fieldProp = this.getCheckedFieldProp(pageCache, key, "inputsentity", pageId);
                    this.updateEntity(data, model, fieldProp, "inputsfieldmap", "inputsourcefield", "inputsourcefielddesc", "inputplatfielddesc");
                    break;
                }
                case "inputsrcrulefielddesc": {
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    String key = (String)data.get(KEY);
                    FieldProp fieldProp = this.getCheckedFieldProp(pageCache, key, "inputsentity", pageId);
                    List<String> curInputsCdFields = PbdCreditPluginUtils.getCurFieldIds(model, "inputscheckdata", "inputsrcrulefield");
                    if (curInputsCdFields.contains(key)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PbdServiceRulePlugin_4", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.updateEntity(data, model, fieldProp, "inputscheckdata", "inputsrcrulefield", "inputsrcrulefielddesc", "inputpaltrulefielddesc");
                    break;
                }
                case "outputsourcefielddesc": {
                    String key;
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    List<String> curOutputsFields = PbdCreditPluginUtils.getCurFieldIds(model, "outputsfieldmap", "outputsourcefield");
                    if (curOutputsFields.contains(key = (String)data.get(KEY))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PbdServiceRulePlugin_4", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    FieldProp fieldProp = this.getCheckedFieldProp(pageCache, key, "outputsentity", pageId);
                    this.updateEntity(data, model, fieldProp, "outputsfieldmap", "outputsourcefield", "outputsourcefielddesc", "outputplatfielddesc");
                    break;
                }
                case "outputsrcrulefielddesc": {
                    String key;
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    List<String> curOutputsCdFields = PbdCreditPluginUtils.getCurFieldIds(model, "outputscheckdata", "outputsrcrulefield");
                    if (curOutputsCdFields.contains(key = (String)data.get(KEY))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PbdServiceRulePlugin_4", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    FieldProp fieldProp = this.getCheckedFieldProp(pageCache, key, "outputsentity", pageId);
                    this.updateEntity(data, model, fieldProp, "outputscheckdata", "outputsrcrulefield", "outputsrcrulefielddesc", "outputpaltrulefielddesc");
                    break;
                }
                case "inputtargetfieldname": {
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    Object key = data.get(KEY);
                    FieldProp fieldProp = this.getCheckBillEntryField(pageCache, key, pageId);
                    this.updateEntity(data, model, fieldProp, "inputsfieldmap", "inputtargetfield", "inputtargetfieldname", null);
                    break;
                }
                case "inputtarrulefieldname": {
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    Object key = data.get(KEY);
                    FieldProp fieldProp = this.getCheckBillEntryField(pageCache, key, pageId);
                    this.updateEntity(data, model, fieldProp, "inputscheckdata", "inputtarrulefield", "inputtarrulefieldname", null);
                    break;
                }
                case "outputtargetfieldname": {
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    Object key = data.get(KEY);
                    FieldProp fieldProp = this.getCheckBillEntryField(pageCache, key, pageId);
                    this.updateEntity(data, model, fieldProp, "outputsfieldmap", "outputtargetfield", "outputtargetfieldname", null);
                    break;
                }
                case "outputtarrulefieldname": {
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    Object key = data.get(KEY);
                    FieldProp fieldProp = this.getCheckBillEntryField(pageCache, key, pageId);
                    this.updateEntity(data, model, fieldProp, "outputscheckdata", "outputtarrulefield", "outputtarrulefieldname", null);
                    break;
                }
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        OperationResult invokeOperation;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        Object entityId = evt.getNodeId();
        if ("0".equals(entityId)) {
            this.focusNode(evt, view, cache);
            return;
        }
        this.setDisableBtn(cache, entityId);
        String ispreinsdataCacheKey = String.format(ispreinsdata, entityId, this.getView().getPageId());
        String ispreinsdataStr = cache.get(ispreinsdataCacheKey);
        if (!"true".equals(ispreinsdataStr) && !(invokeOperation = this.getView().invokeOperation("save")).isSuccess()) {
            evt.setCancel(true);
            this.focusNode(evt, view, cache);
            return;
        }
        String curEntityIdCacheKey = String.format(poped_flag, "curEntityId", view.getPageId());
        cache.put(curEntityIdCacheKey, String.valueOf(entityId));
        String billIdCacheKey = String.format(poped_flag, "billId", view.getPageId());
        String billIdsStr = cache.get(billIdCacheKey);
        List billIds = JSONArray.parseArray((String)billIdsStr, Object.class);
        List<DynamicObject> loads = this.getServiceProgrammes(billIds);
        this.loadData(cache, model, view, loads, entityId);
        this.loadEntityData(entityId);
        view.updateView();
    }

    private void focusNode(TreeNodeEvent evt, IFormView view, IPageCache cache) {
        String curEntityIdCacheKey = String.format(poped_flag, "curEntityId", view.getPageId());
        String curEntityId = cache.get(curEntityIdCacheKey);
        TreeNode childNode = new TreeNode("0", curEntityId, "");
        TreeView tree = (TreeView)evt.getSource();
        tree.focusNode(childNode);
    }

    private List<DynamicObject> getServiceProgrammes(List<Object> billIds) {
        ArrayList<DynamicObject> loads = new ArrayList<DynamicObject>(8);
        Map loadMaps = BusinessDataServiceHelper.loadFromCache((Object[])billIds.toArray(), (String)"pbd_service_programme");
        for (Map.Entry entry : loadMaps.entrySet()) {
            loads.add((DynamicObject)entry.getValue());
        }
        return loads;
    }

    public void treeNodeCheck(TreeNodeCheckEvent var1) {
    }

    private void updateEntity(Map<String, Object> data, IDataModel model, FieldProp fieldProp, String entryEntity, String field, String fieldName, String paltrulefielddesc) {
        Integer row0 = (Integer)Optional.ofNullable(data.get(ROW)).orElse(0);
        DynamicObject entryentity0 = (DynamicObject)model.getEntryEntity(entryEntity).get(row0.intValue());
        if (fieldProp != null) {
            entryentity0.set(field, (Object)fieldProp.getKey());
            entryentity0.set(fieldName, (Object)fieldProp.getName());
            if (StringUtils.isNotBlank((String)paltrulefielddesc)) {
                entryentity0.set(paltrulefielddesc, (Object)fieldProp.getThirdfieldname());
            }
            this.getView().updateView(entryEntity);
        }
    }

    private void showSelectFieldForm(String callback, Integer row, String nodesJson) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_select_prop");
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put(ROW, row);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callback));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showSelectFieldForm(String callback, Integer row, IDataModel model, Class<?> propertiesClass) {
        DynamicObject entryentity = model.getDataEntity();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_select_prop");
        String nodesJson = MetadataUtils.bulidNodesJson(entryentity, "billentity", Boolean.TRUE, propertiesClass);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put(ROW, row);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callback));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void cacheStandardData(DynamicObject standardapi, DynamicObject platformapi, String entityId) {
        if (standardapi == null) {
            return;
        }
        if (platformapi == null) {
            return;
        }
        Long platformapiId = (Long)platformapi.getPkValue();
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingleFromCache((Object)standardapi.getPkValue(), (String)"pbd_standard_api");
        if (loadSingle == null) {
            return;
        }
        DynamicObject source = loadSingle.getDynamicObject("source");
        if (source == null) {
            return;
        }
        String type = source.getString("type");
        ArrayList list = new ArrayList(8);
        if ("1".equals(type)) {
            DynamicObject bill = source.getDynamicObject("source");
            if (bill == null) {
                return;
            }
            String billNumber = (String)bill.getPkValue();
            Iterator formMetaData = MetadataUtils.getFormMetaData(billNumber);
            List items = formMetaData.getItems();
            list.addAll(items);
        }
        Long entryentityId = 0L;
        DynamicObjectCollection entryEntitys = loadSingle.getDynamicObjectCollection("entryentity");
        for (DynamicObject dy : entryEntitys) {
            DynamicObject platformapiDy = dy.getDynamicObject("platformapi");
            if (platformapiDy == null || !platformapiId.equals((Long)platformapiDy.getPkValue())) continue;
            entryentityId = (Long)dy.getPkValue();
            break;
        }
        DynamicObjectCollection inputsEntitySource = loadSingle.getDynamicObjectCollection("inputsentity");
        this.cacheFieldProp(list, inputsEntitySource, entityId, entryentityId, "inputsentity", "inputsfieldid", "inputsfieldname", "inputsfieldtype", "inputsthirdfieldid", "inputsthirdfieldname", "inputsentryentityid");
        DynamicObjectCollection outputsEntitySource = loadSingle.getDynamicObjectCollection("outputsentity");
        this.cacheFieldProp(list, outputsEntitySource, entityId, entryentityId, "outputsentity", "outputsfieldid", "outputsfieldname", "outputsfieldtype", "outputsthirdfieldid", "outputsthirdfieldname", "outputsentryentityid");
    }

    private void cacheFieldProp(List<ControlAp<?>> list, DynamicObjectCollection inputsEntitySource, String entityId, Long entryentityId, String entryentity, String fieldidprop, String fieldnameprop, String fieldtypeprop, String thirdfieldidprop, String thirdfieldnameprop, String entryentityIdProp) {
        ArrayList<FieldProp> fieldProps = new ArrayList<FieldProp>(8);
        HashMap map = new HashMap(8);
        if (!inputsEntitySource.isEmpty()) {
            for (DynamicObject dy : inputsEntitySource) {
                ControlAp controlAp;
                Optional<ControlAp> findFirst;
                Long inputsentryentityid = dy.getLong(entryentityIdProp);
                if (!inputsentryentityid.equals(entryentityId)) continue;
                Long id = (Long)dy.getPkValue();
                Long pid = dy.getLong("pid");
                FieldProp prop = new FieldProp();
                prop.setId(String.valueOf(id));
                prop.setParentId(String.valueOf(pid));
                prop.setEntityKey(entryentity);
                String fieldid = dy.getString(fieldidprop);
                String fieldname = dy.getString(fieldnameprop);
                String fieldtype = dy.getString(fieldtypeprop);
                String thirdfieldid = dy.getString(thirdfieldidprop);
                String thirdfieldname = dy.getString(thirdfieldnameprop);
                prop.setKey(fieldid);
                prop.setName(fieldname);
                prop.setDataType(fieldtype);
                prop.setThirdfieldid(thirdfieldid);
                prop.setThirdfieldname(thirdfieldname);
                if (!CollectionUtils.isEmpty(list) && (findFirst = list.stream().filter(c -> c.getKey().equals(fieldid)).findFirst()).isPresent() && (controlAp = findFirst.get()) instanceof FieldAp) {
                    FieldAp ap1 = (FieldAp)controlAp;
                    Field field = ap1.getField();
                    map.put(fieldid, field.getClass());
                }
                fieldProps.add(prop);
            }
        }
        List sortedFieldProps = fieldProps.stream().sorted(Comparator.comparing(FieldProp::getParentId, Comparator.reverseOrder())).collect(Collectors.toList());
        String cacheKey = String.format(standard_data, entityId, entryentity, this.getView().getPageId());
        log.info("\u4e1a\u52a1\u8c03\u7528\u65b9\u6848\u5206\u5f55\u5bf9\u5e94entityId={},\u7f13\u5b58key:{},\u7f13\u5b58\u503c={}", new Object[]{entityId, cacheKey, JSON.toJSONString(sortedFieldProps)});
        this.getPageCache().put(cacheKey, JSON.toJSONString(sortedFieldProps));
        String classCacheKey = String.format(standard_class, entityId, entryentity, this.getView().getPageId());
        this.getPageCache().put(classCacheKey, JSON.toJSONString(map));
    }

    private FieldProp getCheckedFieldProp(IPageCache cache, Object key, String entryentity, String pageId) {
        List<FieldProp> fieldProps = this.getCacheFieldProp(cache, entryentity, pageId);
        FieldProp fieldProp = FieldPropUtils.findCheckedField(null, (Object)key, fieldProps);
        String fieldKey = FieldPropUtils.updateKeyIncludeParentKey(fieldProps, (FieldProp)fieldProp, (String)fieldProp.getKey());
        fieldProp.setKey(fieldKey);
        return fieldProp;
    }

    private FieldProp getCheckBillEntryField(IPageCache cache, Object key, String pageId) {
        String fieldCacheKey = String.format(billentity_field, "billentityfield", pageId);
        String fieldCache = cache.get(fieldCacheKey);
        List fieldProps = JSONArray.parseArray((String)fieldCache, FieldProp.class);
        FieldProp fieldProp = FieldPropUtils.findCheckedField(null, (Object)key, (List)fieldProps);
        String fieldKey = FieldPropUtils.updateKeyIncludeParentKey((List)fieldProps, (FieldProp)fieldProp, (String)fieldProp.getKey());
        fieldProp.setKey(fieldKey);
        return fieldProp;
    }

    private List<FieldProp> getCacheFieldProp(IPageCache cache, String entryentity, String pageId) {
        String curEntityIdCacheKey = String.format(poped_flag, "curEntityId", pageId);
        String curEntryId = cache.get(curEntityIdCacheKey);
        String cacheKey = String.format(standard_data, curEntryId, entryentity, pageId);
        String cacheValue = cache.get(cacheKey);
        List fieldProps = JSONArray.parseArray((String)cacheValue, FieldProp.class);
        if (CollectionUtils.isEmpty((Collection)fieldProps)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u4e1a\u52a1\u89c4\u5219\u4e2d\u7684\u6807\u51c6\u63a5\u53e3\u5e76\u4fdd\u5b58\u3002", (String)"PbdServiceRulePlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
        return fieldProps;
    }

    private void loadEntityData(Object entityId) {
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])new Object[]{entityId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pbd_service_rule_config"));
        if (loads == null || loads.length == 0) {
            this.ruletypeChange(this.getView(), this.getModel(), this.getPageCache(), Boolean.TRUE);
            return;
        }
        DynamicObject load = loads[0];
        String billno = load.getString("billno");
        this.getModel().setValue("billno", (Object)billno);
        String ruletype = this.getModel().getDataEntity().getString("ruletype");
        String ruletypeLoad = load.getString("ruletype");
        if (!ruletypeLoad.equals(ruletype)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u63a5\u53e3\u7528\u9014\u53d1\u751f\u53d8\u5316\uff0c\u9700\u8981\u91cd\u65b0\u914d\u7f6e\u4e1a\u52a1\u89c4\u5219\uff0c\u5982\u4e0d\u9700\u8981\uff0c\u8bf7\u9000\u51fa\u4fee\u6539\u63a5\u53e3\u7528\u9014\u540e\u518d\u6b21\u914d\u7f6e\u3002", (String)"PbdServiceRulePlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(RULETYPECHANGE_COMFIRM));
        } else {
            this.loadEntityData(load, ruletype);
        }
    }

    private void loadEntityData(DynamicObject load, String ruletype) {
        if (this.isCheckRule(ruletype)) {
            DynamicObjectCollection loadInputsfieldmap = load.getDynamicObjectCollection("inputsfieldmap");
            this.getModel().deleteEntryData("inputsfieldmap");
            if (!CollectionUtils.isEmpty((Collection)loadInputsfieldmap)) {
                this.setInputsFieldMap(loadInputsfieldmap, this.getModel(), null);
            }
            DynamicObjectCollection loadOutputsfieldmap = load.getDynamicObjectCollection("outputsfieldmap");
            this.getModel().deleteEntryData("outputsfieldmap");
            if (!CollectionUtils.isEmpty((Collection)loadOutputsfieldmap)) {
                this.setOutputsFieldMap(loadOutputsfieldmap, this.getModel(), null);
            }
            DynamicObjectCollection loadPluginpolicy = load.getDynamicObjectCollection("pluginpolicyfield");
            this.getModel().deleteEntryData("pluginpolicyfield");
            if (!CollectionUtils.isEmpty((Collection)loadPluginpolicy)) {
                this.setPluginPolicyField(loadPluginpolicy, this.getModel(), null);
            }
        } else if (!this.isCheckRule(ruletype)) {
            DynamicObjectCollection loadInputscheckdata = load.getDynamicObjectCollection("inputscheckdata");
            this.getModel().deleteEntryData("inputscheckdata");
            if (!CollectionUtils.isEmpty((Collection)loadInputscheckdata)) {
                this.setInputsCheckData(loadInputscheckdata, this.getModel(), null);
            }
            DynamicObjectCollection loadOutputscheckdata = load.getDynamicObjectCollection("outputscheckdata");
            this.getModel().deleteEntryData("outputscheckdata");
            if (!CollectionUtils.isEmpty((Collection)loadOutputscheckdata)) {
                this.setOutputsCheckData(loadOutputscheckdata, this.getModel(), null);
            }
            DynamicObjectCollection loadPluginpolicy = load.getDynamicObjectCollection("pluginpolicyrule");
            this.getModel().deleteEntryData("pluginpolicyrule");
            if (!CollectionUtils.isEmpty((Collection)loadPluginpolicy)) {
                this.setPluginPolicyRule(loadPluginpolicy, this.getModel(), null);
            }
        }
        this.ruletypeChange(this.getView(), this.getModel(), this.getPageCache(), Boolean.FALSE);
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        String callBackId = arg0.getCallBackId();
        if (RULETYPECHANGE_COMFIRM.equals(callBackId) && arg0.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.ruletypeChange(this.getView(), this.getModel(), this.getPageCache(), Boolean.TRUE);
        } else if (RULETYPECHANGE_COMFIRM.equals(callBackId) && arg0.getResult().compareTo((Enum)MessageBoxResult.Cancel) == 0) {
            this.getView().close();
        }
    }
}

