/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.digitalcredit;

import com.alibaba.fastjson.JSONArray;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pbd.common.helper.PbdSupplierMonitorHelper;

public class PbdSupplierMonitorEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String ENTRYENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        }
    }

    public void afterBindData(EventObject e) {
        Boolean ischangeMonitor;
        super.afterBindData(e);
        String billstatus = this.getModel().getDataEntity().getString("billstatus");
        if (BillStatusEnum.AUDIT.getVal().equals(billstatus)) {
            this.setEnable(false);
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Map)customParams) && !customParams.containsKey("entryPrimaryKeyValues")) {
            return;
        }
        JSONArray entryPrimaryKeyValues = (JSONArray)customParams.get("entryPrimaryKeyValues");
        if (CollectionUtils.isEmpty((Collection)entryPrimaryKeyValues)) {
            return;
        }
        Object changeMonitorObj = customParams.get("changemonitor");
        if (changeMonitorObj != null && (ischangeMonitor = (Boolean)changeMonitorObj).booleanValue()) {
            this.setEnable(true);
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        int index = 0;
        ArrayList<Integer> selectRows = new ArrayList<Integer>(8);
        for (DynamicObject dy : entryentity) {
            Object entryPrimaryKey = dy.getPkValue();
            if (entryPrimaryKeyValues.contains(entryPrimaryKey)) {
                selectRows.add(index);
            }
            ++index;
        }
        if (!CollectionUtils.isEmpty(selectRows)) {
            int[] selectRowArrays = selectRows.stream().mapToInt(Integer::intValue).toArray();
            entryGrid.selectRows(selectRowArrays, selectRowArrays[selectRowArrays.length - 1]);
        }
    }

    private void setEnable(Boolean bool) {
        this.getView().setEnable(bool, new String[]{ENTRYENTITY});
        this.getView().setEnable(bool, new String[]{"bar_save"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "delmonitor", "addmonitor"});
        BasedataEdit link = (BasedataEdit)this.getView().getControl("supplier");
        link.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String fieldKey = args.getProperty().getName();
        if ("supplier".equals(fieldKey)) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba1\u6279\u7ec4\u7ec7\u3002", (String)"PbdSupplierMonitorEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> supplierIds = new ArrayList<Long>(8);
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            QFilter qFilter0 = new QFilter("id", "<>", pkValue);
            DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"pbd_supplier_monitor", (String)"entryentity.supplier", (QFilter[])new QFilter[]{qFilter0});
            for (DynamicObject dy : suppliers) {
                Long supplierId = dy.getLong("entryentity.supplier");
                supplierIds.add(supplierId);
            }
            if (!CollectionUtils.isEmpty(supplierIds)) {
                QFilter qFilter = new QFilter("id", "not in", supplierIds);
                qFilter.and("createorg", "=", (Object)((Long)org.getPkValue()));
                ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        ChangeData[] changeSets = e.getChangeSet();
        block5 : switch (propertyName) {
            case "supplier": {
                this.setSupplierName(model, view, changeSets);
                break;
            }
            case "monitoraftertime": {
                for (ChangeData changeData : changeSets) {
                    int entryCurrentRowIndex = changeData.getRowIndex();
                    DynamicObjectCollection entryentity = model.getEntryEntity(ENTRYENTITY);
                    DynamicObject dataEntity = (DynamicObject)entryentity.get(entryCurrentRowIndex);
                    Date monitorbeforetime = dataEntity.getDate("monitorbeforetime");
                    Object monitoraftertimeNew = changeData.getNewValue();
                    if (monitoraftertimeNew == null) break block5;
                    if (monitorbeforetime == null || monitorbeforetime.compareTo((Date)monitoraftertimeNew) <= 0) continue;
                    Object oldValue = changeData.getOldValue();
                    model.setValue("monitoraftertime", oldValue, entryCurrentRowIndex);
                    view.showTipNotification(ResManager.loadKDString((String)"\u201c\u76d1\u63a7\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u76d1\u63a7\u7ed3\u675f\u65f6\u95f4\u201d\u3002", (String)"PbdSupplierMonitorEditPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    break block5;
                }
                break;
            }
            case "group": {
                DynamicObject group = this.getModel().getDataEntity().getDynamicObject("group");
                if (group == null) {
                    this.getModel().setValue("groupstr", (Object)"");
                } else {
                    this.getModel().setValue("groupstr", (Object)group.getString("group"));
                }
                this.getView().updateView("groupstr");
                break;
            }
        }
    }

    private void setSupplierName(IDataModel model, IFormView view, ChangeData[] changeSets) {
        for (ChangeData changeData : changeSets) {
            int entryCurrentRowIndex = changeData.getRowIndex();
            DynamicObjectCollection entryentity = model.getEntryEntity(ENTRYENTITY);
            DynamicObject dataEntity = (DynamicObject)entryentity.get(entryCurrentRowIndex);
            DynamicObject supplier = dataEntity.getDynamicObject("supplier");
            if (supplier == null) continue;
            String suppliername = supplier.getString("name");
            this.getModel().setValue("suppliername", (Object)suppliername, entryCurrentRowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] rowIndexs = entryGrid.getSelectRows();
        switch (key) {
            case "addmonitor": {
                if (rowIndexs != null && rowIndexs.length != 0) {
                    Set<Long> selectRows = this.getSelectRowIds(dataEntity, rowIndexs, "addmonitor");
                    if (CollectionUtils.isEmpty(selectRows)) {
                        return;
                    }
                    String addMonitor = PbdSupplierMonitorHelper.addMonitor((DynamicObject)dataEntity, selectRows, (String)"addmonitor");
                    if (addMonitor == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u5165\u76d1\u63a7\u4f01\u4e1a\u5931\u8d25\u3002", (String)"PbdSupplierMonitorEditPlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.getView().showSuccessNotification(addMonitor);
                    this.getView().updateView(ENTRYENTITY);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u5206\u5f55\u518d\u64cd\u4f5c\u3002", (String)"PbdSupplierMonitorEditPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "delmonitor": {
                if (rowIndexs != null && rowIndexs.length != 0) {
                    Set<Long> selectRows = this.getSelectRowIds(dataEntity, rowIndexs, "delmonitor");
                    if (CollectionUtils.isEmpty(selectRows)) {
                        return;
                    }
                    String removeMonitor = PbdSupplierMonitorHelper.removeMonitor((DynamicObject)dataEntity, selectRows, (String)"delmonitor");
                    if (removeMonitor == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u9664\u76d1\u63a7\u4f01\u4e1a\u5931\u8d25\u3002", (String)"PbdSupplierMonitorEditPlugin_10", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.getView().showSuccessNotification(removeMonitor);
                    this.getView().updateView(ENTRYENTITY);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u5206\u5f55\u518d\u64cd\u4f5c\u3002", (String)"PbdSupplierMonitorEditPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private Set<Long> getSelectRowIds(DynamicObject dataEntity, int[] rowIndexs, String operator) {
        HashSet<Long> selectRows = new HashSet<Long>(8);
        StringBuilder sb = new StringBuilder();
        ArrayList<Integer> checkRowIndexs = new ArrayList<Integer>(rowIndexs.length);
        for (int row : rowIndexs) {
            DynamicObject dynamicObject = (DynamicObject)dataEntity.getDynamicObjectCollection(ENTRYENTITY).get(row);
            boolean check = true;
            if ("delmonitor".equals(operator)) {
                check = PbdSupplierMonitorHelper.removeMonitorCheck((DynamicObject)dynamicObject);
            } else if ("addmonitor".equals(operator)) {
                check = PbdSupplierMonitorHelper.addMonitorCheck((DynamicObject)dynamicObject);
            }
            if (!check) {
                String message = "";
                if ("delmonitor".equals(operator)) {
                    message = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u76d1\u63a7\u72b6\u6001\u4e3a\u76d1\u63a7\u4e2d\u624d\u80fd\u79fb\u9664\u76d1\u63a7\u3002\r\n", (String)"PbdSupplierMonitorEditPlugin_12", (String)"scm-pbd-formplugin", (Object[])new Object[0]), row + 1);
                } else if ("addmonitor".equals(operator)) {
                    message = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u76d1\u63a7\u72b6\u6001\u4e3a\u76d1\u63a7\u4e2d\u6216\u8005\u4e0d\u5728\u76d1\u63a7\u5468\u671f\u5185\u4e0d\u80fd\u52a0\u5165\u76d1\u63a7\u3002\r\n", (String)"PbdSupplierMonitorEditPlugin_13", (String)"scm-pbd-formplugin", (Object[])new Object[0]), row + 1);
                }
                sb.append(message);
                continue;
            }
            checkRowIndexs.add(row);
        }
        if (CollectionUtils.isEmpty(checkRowIndexs)) {
            int lines = this.getLines(sb);
            if (lines <= 1) {
                this.getView().showTipNotification(sb.toString());
            } else {
                String title = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u5931\u8d25", (String)"PbdSupplierMonitorEditPlugin_9", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(title, sb.toString(), MessageTypes.Default);
            }
            return selectRows;
        }
        return this.getSelectRowIds(checkRowIndexs);
    }

    private int getLines(StringBuilder sb) {
        if (sb == null) {
            return 0;
        }
        Pattern p = Pattern.compile("\n");
        Matcher m = p.matcher(sb.toString());
        int j = 0;
        while (m.find()) {
            ++j;
        }
        return j;
    }

    private Set<Long> getSelectRowIds(List<Integer> rowIndexs) {
        HashSet<Long> selectRows = new HashSet<Long>(8);
        ListSelectedRowCollection listSelectedRowCollection = this.getListSelectedRowCollection(ENTRYENTITY, rowIndexs);
        Object[] entryPrimaryKeyValues = listSelectedRowCollection.getEntryPrimaryKeyValues();
        if (entryPrimaryKeyValues != null) {
            Arrays.stream(entryPrimaryKeyValues).forEach(row -> selectRows.add(Long.valueOf(row.toString())));
        }
        return selectRows;
    }

    private ListSelectedRowCollection getListSelectedRowCollection(String entryEntityKey, List<Integer> rowIndexs) {
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Object pkValue = dataEntity.getPkValue();
        for (int rowIndex : rowIndexs) {
            DynamicObject entryRow = this.getView().getModel().getEntryRowEntity(entryEntityKey, rowIndex);
            ListSelectedRow listSelectedRow = new ListSelectedRow(pkValue);
            listSelectedRow.setEntryEntityKey(entryEntityKey);
            listSelectedRow.setEntryPrimaryKeyValue(entryRow.getPkValue());
            listSelectedRows.add((Object)listSelectedRow);
        }
        return listSelectedRows;
    }
}

