/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.portal.util.LoginMCServiceUtil;
import kd.bos.url.UrlService;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.pbd.common.utils.PbdRegCommonUtils;

public class PbdAccessRegisterEditPlugin
extends AbstractFormPlugin {
    protected IAppCache verifyCodeExpire = AppCache.get((String)"verifyCodeExpire");
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("SCM_PBD_LOGIN_DATA");

    public void initialize() {
        PbdRegCommonUtils.addOnProgressListener((AbstractFormPlugin)this, (String)"progressbarap", (String)"getmsg", (String)"htmlap");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setStatusVisible(true);
        Map customParams = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        Object agree = customParams.get("agree");
        if (Objects.nonNull(agree) && "true".equals(agree.toString())) {
            this.getView().getModel().setValue("isagreed", agree);
            this.getView().setEnable(Boolean.FALSE, new String[]{"isagreed"});
        }
    }

    private void setStatusVisible(boolean isInit) {
        if (isInit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"namefail", "namesuccess", "nofail", "nosuccess", "htmlap", "progressbarap"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setLogo();
    }

    private void setLogo() {
        try {
            String value = LoginMCServiceUtil.getMcData((String)"_tenant_login_config_values_");
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                HashMap resultMap = (HashMap)SerializationUtils.fromJsonString((String)value, HashMap.class);
                if (resultMap == null) {
                    return;
                }
                FileService imageFileService = FileServiceFactory.getImageFileService();
                String realPath = imageFileService.getRealPath((String)resultMap.get("lefttoplogoimg"));
                if (StringUtils.isNotBlank((CharSequence)realPath)) {
                    realPath = UrlService.getImageFullUrl((String)realPath);
                    Image imageap = (Image)this.getControl("imageap");
                    if (imageap != null) {
                        imageap.setUrl(realPath);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u7528\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5931\u8d25\uff0c\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"PbdAccessRegisterEditPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"agreement", "close"});
        Button getMsg = (Button)this.getView().getControl("getmsg");
        getMsg.addClickListener((ClickListener)this);
        PbdRegCommonUtils.addOnProgressListener((AbstractFormPlugin)this, (String)"progressbarap", (String)"getmsg", (String)"htmlap");
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"getmsg", (CharSequence)source.getKey())) {
            this.validateInfo((EventObject)evt);
        }
    }

    private void validateInfo(EventObject evt) {
        boolean isFail = true;
        String number = this.getModel().getValue("number").toString();
        String resMsg = "";
        Map resMap = null;
        if (StringUtils.isEmail((String)number) || StringUtils.isPhoneNumberValid((String)number) || ((Boolean)(resMap = PbdRegCommonUtils.isPhone((String)number)).get("succed")).booleanValue()) {
            if (this.isRegisterPhoneBusy(number) && evt instanceof BeforeClickEvent) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PbdAccessRegisterEditPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                ((BeforeClickEvent)evt).setCancel(true);
                return;
            }
            Map<String, Object> resultMap = PbdAccessRegisterEditPlugin.getMsgValid(number, this.verifyCodeExpire);
            if (((Boolean)resultMap.get("success")).booleanValue()) {
                isFail = false;
            } else {
                this.getView().showMessage(resultMap.get("msg").toString());
            }
        } else {
            resMsg = resMap.get("message").toString();
            this.getView().showTipNotification(resMsg);
        }
        if (evt instanceof BeforeClickEvent) {
            ((BeforeClickEvent)evt).setCancel(isFail);
        } else if (evt instanceof BeforeDoOperationEventArgs) {
            ((BeforeDoOperationEventArgs)evt).setCancel(isFail);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"getmsg")) {
            String selectBaseDataFieldsForm = "adm_getverifycodeimg";
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)selectBaseDataFieldsForm, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "verifycode"));
        }
    }

    public static Map<String, Object> getMsgValid(String account, IAppCache verifyCodeExpire) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("success", true);
        StringBuilder msg = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)account)) {
            if (account.contains("+86")) {
                account = account.substring(3, 14);
            }
            if (StringUtils.isEmail((String)account) || StringUtils.isPhoneNumberValid((String)account) || account.contains("-")) {
                if (verifyCodeExpire == null) {
                    msg.append(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4ecd\u6709\u6548\uff0c\u65e0\u9700\u518d\u6b21\u83b7\u53d6\u3002", (String)"PbdAccessRegisterEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    resultMap.put("success", false);
                    resultMap.put("msg", msg);
                }
            } else {
                msg.append(ResManager.loadKDString((String)"\u624b\u673a\u53f7/\u90ae\u7bb1\u8f93\u5165\u9519\u8bef\u3002", (String)"PbdAccessRegisterEditPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                resultMap.put("success", false);
                resultMap.put("msg", msg);
            }
        } else {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u624b\u673a\u53f7/\u90ae\u7bb1\u3002", (String)"PbdAccessRegisterEditPlugin_4", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            resultMap.put("success", false);
            resultMap.put("msg", msg);
        }
        return resultMap;
    }

    private boolean isRegisterPhoneBusy(String phone) {
        String tenantId = RequestContext.get().getTenantId();
        String key = tenantId + phone;
        String value = (String)cache.get(key);
        if (StringUtils.isNotBlank((CharSequence)value) && StringUtils.isNumeric((CharSequence)value)) {
            int time = Integer.parseInt(value);
            if (++time > 6) {
                return true;
            }
            cache.put(key, (Object)("" + time), 180);
        } else {
            cache.put(key, (Object)"1", 180);
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("verifycode".equals(closedCallBackEvent.getActionId())) {
            String number = this.getModel().getValue("number").toString();
            String tenantId = RequestContext.get().getTenantId();
            String key = tenantId + number;
            String value = (String)cache.get(key);
            if (StringUtils.isNotBlank((CharSequence)value) && StringUtils.isNumeric((CharSequence)value)) {
                int time = Integer.parseInt(value);
                if (++time > 6) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PbdAccessRegisterEditPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                } else {
                    cache.put(key, (Object)("" + time), 180);
                    Object returnData = closedCallBackEvent.getReturnData();
                    if (Objects.nonNull(returnData)) {
                        PbdRegCommonUtils.getMsg((AbstractFormPlugin)this, (IAppCache)this.verifyCodeExpire, (String)ResManager.loadKDString((String)"\u6ce8\u518c", (String)"PbdAccessRegisterEditPlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationArgs) {
        String operateKey;
        super.beforeDoOperation(beforeDoOperationArgs);
        switch (operateKey = ((AbstractOperate)beforeDoOperationArgs.getSource()).getOperateKey()) {
            case "submit": {
                String number;
                String name = this.getModel().getValue("name").toString();
                if (StringUtils.equalsIgnoreCase((CharSequence)"administrator", (CharSequence)name)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6ce8\u518c\u7528\u6237\u540d\u4e3a\u201cadministrator\u201d\u7684\u7528\u6237\u3002", (String)"PbdAccessRegisterEditPlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object numberobj = this.getModel().getValue("number");
                if (numberobj != null) {
                    this.getModel().setValue("number", (Object)numberobj.toString().replace(" ", ""));
                }
                if (!(StringUtils.isBlank((CharSequence)(number = this.getModel().getValue("number").toString())) || StringUtils.isEmail((String)number) || StringUtils.isPhoneNumberValid((String)number))) {
                    this.formatPhone();
                }
                boolean isSucced = true;
                if (StringUtils.isNotBlank((CharSequence)number)) {
                    if (number.contains("+86")) {
                        number = number.substring(3, 14);
                    }
                    if (StringUtils.isEmail((String)number)) {
                        isSucced = true;
                    } else if (StringUtils.isPhoneNumberValid((String)number)) {
                        isSucced = true;
                    } else {
                        this.formatPhone();
                        if (((Boolean)PbdRegCommonUtils.isPhone((String)this.getModel().getValue("number").toString()).get("succed")).booleanValue()) {
                            isSucced = true;
                        } else {
                            this.getView().showMessage(PbdRegCommonUtils.isPhone((String)this.getModel().getValue("number").toString()).get("message").toString());
                            isSucced = false;
                        }
                    }
                }
                if (number == null || number.trim().equals("")) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PbdAccessRegisterEditPlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    isSucced = false;
                }
                StringBuilder msg = new StringBuilder();
                String validate = this.getModel().getValue("validate").toString();
                String info = PbdRegCommonUtils.validateVerycode((String)((String)this.verifyCodeExpire.get(number, String.class)), (String)validate);
                if (StringUtils.isNotBlank((CharSequence)info)) {
                    isSucced = false;
                    this.getView().showMessage(info);
                }
                if (!isSucced) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002", (String)"PbdAccessRegisterEditPlugin_8", (String)"scm-pbd-formplugin", (Object[])new Object[0]), msg.toString(), MessageTypes.Permission);
                }
                if (isSucced) break;
                beforeDoOperationArgs.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    private void formatPhone() {
        String number = this.getModel().getValue("number").toString();
        if (StringUtils.isNotBlank((CharSequence)number)) {
            String[] split;
            int i;
            int charnum = 0;
            for (i = 0; i < number.length(); ++i) {
                if (number.charAt(i) != '-') continue;
                ++charnum;
            }
            if (charnum != 0 && (split = number.split("-", 2))[0].equals("86")) {
                number = number.substring(3);
                --charnum;
            }
            for (i = 0; i < charnum - 1; ++i) {
                int index = number.indexOf(45);
                number = number.substring(0, index) + number.substring(index + 1);
            }
            this.getModel().setValue("number", (Object)number);
            this.getView().updateView("number");
        }
    }
}

