/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.DynamicFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pbd.business.AddressServiceHelper;
import kd.scm.pbd.formplugin.util.PbdMalUtil;

public class PbdEmalAddressEdit
extends AbstractFormPlugin {
    private static final String ENTITY = "pbd_emaladdress";
    private static final String ENTRYENTITY = "entryentity";
    private static final String EMAL_TYPE = "emaltype";
    private static final String KEY_CONFIRM = "confirm";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.allotInitDynamicData();
    }

    public String getEmalType() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map params = parameter.getCustomParams();
        return (String)params.get(EMAL_TYPE);
    }

    public String getCurrentNodeId() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map params = parameter.getCustomParams();
        String res = (String)params.get("currentNodeId");
        return StringUtils.isEmpty((CharSequence)res) ? "0" : res;
    }

    public void allotInitDynamicData() {
        DynamicObject currentNode;
        String emalType = this.getEmalType();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        EcPlatformEnum platformEnum = EcPlatformEnum.fromVal((String)emalType);
        Label lablePre = (Label)this.getView().getControl("lablepre");
        String text = String.format(ResManager.loadKDString((String)"\u5c06\u53d6%s", (String)"PbdEmalAddressEdit_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]), platformEnum.getName());
        lablePre.setText(text);
        Label lableCnt = (Label)this.getView().getControl("labelcnt");
        QFilter filter = new QFilter(EMAL_TYPE, "=", (Object)emalType);
        String admindivisionFields = "id,longnumber";
        String currentNodeId = this.getCurrentNodeId();
        if (!PbdMalUtil.isRootId(currentNodeId) && (currentNode = QueryServiceHelper.queryOne((String)"pbd_maladdressrel", (String)admindivisionFields, (QFilter[])new QFilter[]{new QFilter("addressid", "=", (Object)Long.valueOf(currentNodeId)), filter})) != null) {
            String ecLongNumber = currentNode.getString("longnumber");
            if (StringUtils.isEmpty((CharSequence)ecLongNumber)) {
                filter.and("level", "=", (Object)1);
            } else {
                filter.and("longnumber", "like", (Object)(ecLongNumber + "%"));
            }
        }
        String selectFields = "id emaladdress";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY, (String)selectFields, (QFilter[])new QFilter[]{filter});
        lableCnt.setText("" + dynamicObjects.size());
        if (dynamicObjects.size() > 0) {
            EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)ENTRYENTITY);
            List propertyList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)entryProp.getItemType());
            TableValueSetter vs = DynamicFormUtil.batchBindData((DynamicObjectCollection)dynamicObjects, (List)propertyList, (String)"");
            model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)KEY_CONFIRM, (CharSequence)formOperate.getOperateKey())) {
            this.handleMatch();
        }
    }

    public void handleMatch() {
        String currentNodeId = this.getCurrentNodeId();
        AddressServiceHelper helper = new AddressServiceHelper();
        Map matchResultMap = helper.matchAddressByEcType(currentNodeId, this.getEmalType());
        this.getView().returnDataToParent((Object)matchResultMap);
        this.getView().close();
    }
}

