/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.pbd.domain.model.esconfig.EsConfig;

public class PbdEsConfigEdit
extends AbstractBasePlugIn {
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String INDEXENTITY = "indexentity";
    private static final String FILTERCONDITION = "filtercondition";
    private static final String INDEXKEY = "indexkey";
    private static final String ESMAPPING = "esmapping";
    private static final String TESTSEARCH = "testsearch";
    private static final String ENTRYENTITY = "entryentity";
    private static final String DATA_SYNC_TRIGGER = "data_sync_trigger";

    private EsConfig getEsConfig() {
        return new EsConfig(this.getModel().getDataEntity());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit esMappingEdit = (BasedataEdit)this.getControl(ESMAPPING);
        esMappingEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Object indexEntityDyn = this.getModel().getValue(INDEXENTITY);
            if (indexEntityDyn == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7d22\u5f15\u5b9e\u4f53\u3002", (String)"PbdEsConfigEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("indexentity.id", "=", ((DynamicObject)indexEntityDyn).getPkValue());
            beforeF7SelectEvent.addCustomQFilter(filter);
        });
        BasedataEdit esAggregationEdit = (BasedataEdit)this.getControl("esaggregation");
        esAggregationEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Object indexEntityDyn = this.getModel().getValue(INDEXENTITY);
            if (indexEntityDyn == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7d22\u5f15\u5b9e\u4f53\u3002", (String)"PbdEsConfigEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("indexentity.id", "=", ((DynamicObject)indexEntityDyn).getPkValue());
            beforeF7SelectEvent.addCustomQFilter(filter);
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initFilterGrid();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindFilterGrid();
    }

    private void bindFilterGrid() {
        String filterConditonJson = (String)this.getModel().getValue(FILTERCONDITION);
        if (StringUtils.isBlank((CharSequence)filterConditonJson)) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditonJson, FilterCondition.class);
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        filterGrid.SetValue(filterCondition);
    }

    private void initFilterGrid() {
        EsConfig esConfig = this.getEsConfig();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        MainEntityType mainType = this.getSrcMainType(esConfig.getIndexEntityNumber());
        if (mainType == null) {
            return;
        }
        FilterFieldBuildOption option = new FilterFieldBuildOption();
        option.setCompatibleProductMode(true);
        List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)mainType, (FilterFieldBuildOption)option);
        filterGrid.setEntityNumber(esConfig.getIndexEntityNumber());
        filterGrid.setFilterColumns(cols);
    }

    private MainEntityType getSrcMainType(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return null;
        }
        return EntityMetadataCache.getDataEntityType((String)entityNumber);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals(INDEXENTITY) && e.getChangeSet()[0].getNewValue() != null) {
            this.initFilterGrid();
            this.getModel().setValue(INDEXKEY, (Object)this.getEsConfig().getIndexEntityNumber());
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey)) {
            this.fillFilterConditon();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (TESTSEARCH.equals(afterDoOperationEventArgs.getOperateKey())) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("pbd_escheck");
            fsp.setCustomParam("esConfigId", this.getModel().getDataEntity().getPkValue());
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
        if (DATA_SYNC_TRIGGER.equals(afterDoOperationEventArgs.getOperateKey())) {
            QFilter filter = new QFilter("esconfig.id", "=", this.getModel().getDataEntity().getPkValue());
            OpenFormUtil.openListPage((IFormView)this.getView(), (String)"pbd_data_sync_trigger", (ShowType)ShowType.MainNewTabPage, null, (QFilter)filter, null);
        }
    }

    private void fillFilterConditon() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        this.getModel().setValue(FILTERCONDITION, (Object)SerializationUtils.toJsonString((Object)filterCondition));
    }
}

