/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.malcore.domain.LadderPriceInfo;

public class PbdLadderPriceEdit
extends AbstractFormPlugin {
    private static final String QTYFROM = "qtyfrom";
    private static final String QTYTO = "qtyto";
    private static final String PRICE = "price";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEntry();
        this.initBtn();
        this.setEnableFiled();
    }

    private void initBtn() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object status = customParams.get("status");
        if ("0".equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"close"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"cancel", "confirm", "advcontoolbarap"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"entryentity"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cancel", "confirm", "advcontoolbarap"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"close"});
        }
    }

    private void initEntry() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object subentrys = customParams.get("ladderPrices");
        List LadderPriceInfos = (List)SerializationUtils.fromJsonString((String)String.valueOf(subentrys), List.class);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int index = 0;
        for (Map info : LadderPriceInfos) {
            vs.set(QTYFROM, (Object)new BigDecimal(String.valueOf(info.get(QTYFROM))), index);
            vs.set(QTYTO, (Object)new BigDecimal(String.valueOf(info.get(QTYTO))), index);
            vs.set(PRICE, (Object)new BigDecimal(String.valueOf(info.get("ladprice"))), index);
            vs.set("cur_id", (Object)Long.parseLong(String.valueOf(info.get("currId"))), index);
            ++index;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"cancel", "confirm", "advcontoolbarap"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        this.getModel().beginInit();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String msg;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        DynamicObjectCollection entryentityCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if ("insertentry".equals(operateKey)) {
            if (entryentityCol.size() == 50) {
                e.setCancel(true);
                String msg2 = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u8bbe\u7f6e50\u884c\u4ee5\u5185\u7684\u9636\u68af\u4ef7\u7b97\u6cd5\u3002", (String)"PbdLadderPriceEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg2);
                return;
            }
            boolean isInsert = false;
            int[] nArray = selectRows;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int index = nArray[i];
                if (index != 0) continue;
                isInsert = true;
                break;
            }
            if (isInsert) {
                e.setCancel(true);
                msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u9996\u884c\u6570\u636e\u8fdb\u884c\u63d2\u5165\u3002", (String)"PbdLadderPriceEdit_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            if (selectRows.length > 1) {
                e.setCancel(true);
                msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u591a\u884c\u6570\u636e\u8fdb\u884c\u63d2\u5165\u3002", (String)"PbdLadderPriceEdit_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
        }
        if ("deleteentry".equals(operateKey)) {
            for (int index : selectRows) {
                if (index != 0 && index != entryentityCol.size() - 1) continue;
                e.setCancel(true);
                String msg3 = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u81f3\u5c11\u9700\u8981\u8bbe\u7f6e\u4e24\u4e2a\u533a\u95f4\uff0c\u9996\u5c3e\u4e24\u884c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PbdLadderPriceEdit_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg3);
                return;
            }
        }
        if ("confirm".equals(operateKey)) {
            ArrayList<String> errorList = new ArrayList<String>(1024);
            if (entryentityCol.size() > 50) {
                e.setCancel(true);
                msg = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u8bbe\u7f6e50\u884c\u4ee5\u5185\u7684\u9636\u68af\u4ef7\u7b97\u6cd5\u3002", (String)"PbdLadderPriceEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            for (int i = 0; i < entryentityCol.size(); ++i) {
                DynamicObject beforeRow;
                BigDecimal beforeQtyto;
                String msg4;
                DynamicObject row = (DynamicObject)entryentityCol.get(i);
                int seq = row.getInt("seq");
                BigDecimal qtyfrom = row.getBigDecimal(QTYFROM);
                BigDecimal qtyto = row.getBigDecimal(QTYTO);
                BigDecimal price = row.getBigDecimal(PRICE);
                if (seq != 1 && qtyfrom.compareTo(BigDecimal.ZERO) == 0 || price.compareTo(BigDecimal.ZERO) == 0) {
                    msg4 = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6570\u636e\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5\u3002", (String)"PbdLadderPriceEdit_4", (String)"scm-pbd-formplugin", (Object[])new Object[]{seq});
                    errorList.add(msg4);
                    continue;
                }
                if (i != entryentityCol.size() - 1 && qtyto.compareTo(BigDecimal.ZERO) == 0) {
                    msg4 = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6570\u636e\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5\u3002", (String)"PbdLadderPriceEdit_4", (String)"scm-pbd-formplugin", (Object[])new Object[]{seq});
                    errorList.add(msg4);
                    continue;
                }
                if (i != entryentityCol.size() - 1 && qtyto.compareTo(qtyfrom) < 0) {
                    msg4 = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6570\u91cf\u81f3\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u6570\u91cf\u4ece,\u8bf7\u68c0\u67e5\u3002", (String)"PbdLadderPriceEdit_5", (String)"scm-pbd-formplugin", (Object[])new Object[]{seq});
                    errorList.add(msg4);
                    continue;
                }
                if (i <= 0 || (beforeQtyto = (beforeRow = (DynamicObject)entryentityCol.get(i - 1)).getBigDecimal(QTYTO)).compareTo(qtyfrom) == 0) continue;
                String msg5 = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6570\u636e\u4ece\u4e0d\u7b49\u4e8e\u4e0a\u4e00\u884c\u6570\u636e\u81f3,\u8bf7\u68c0\u67e5\u3002", (String)"PbdLadderPriceEdit_6", (String)"scm-pbd-formplugin", (Object[])new Object[]{seq});
                errorList.add(msg5);
            }
            if (errorList.size() > 0) {
                e.setCancel(true);
                if (errorList.size() == 1) {
                    this.getView().showErrorNotification((String)errorList.get(0));
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String msg6 : errorList) {
                        stringBuilder.append(msg6).append('\n');
                    }
                    String msg7 = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"PbdLadderPriceEdit_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                    this.getView().showMessage(msg7, stringBuilder.toString(), MessageTypes.Default);
                }
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        if (QTYTO.equals(name)) {
            BigDecimal qtyto = new BigDecimal(String.valueOf(newValue));
            BigDecimal oldQtyto = new BigDecimal(String.valueOf(oldValue));
            Object qtyfromObj = model.getValue(QTYFROM, rowIndex);
            BigDecimal qtyfrom = new BigDecimal(String.valueOf(qtyfromObj));
            if (qtyto.compareTo(BigDecimal.ZERO) == 0 && oldQtyto.compareTo(qtyfrom) < 0) {
                return;
            }
            if (null != this.getPageCache().get("oldValue")) {
                this.getPageCache().remove("oldValue");
                return;
            }
            if (null == newValue || qtyto.compareTo(qtyfrom) <= 0) {
                String msg = ResManager.loadKDString((String)"\u201c\u6570\u91cf\u81f3\u201d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u201c\u6570\u91cf\u4ece\u201d\u3002", (String)"PbdLadderPriceEdit_8", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                this.getPageCache().put("oldValue", String.valueOf(oldValue));
                model.setValue(name, oldValue, rowIndex);
            } else {
                model.setValue(QTYFROM, (Object)qtyto, rowIndex + 1);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.setEnableFiled();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int curIndex = e.getInsertRow();
        if (curIndex < 1) {
            this.setEnableFiled();
            return;
        }
        int beforeIndex = curIndex - 1;
        IDataModel model = this.getModel();
        BigDecimal newQtyto = BigDecimal.ZERO;
        if (null != model.getValue(QTYTO, beforeIndex)) {
            newQtyto = new BigDecimal(String.valueOf(model.getValue(QTYTO, beforeIndex)));
        }
        model.setValue(QTYFROM, (Object)newQtyto, curIndex);
        DynamicObjectCollection entryentity = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        model.setValue("cur", model.getValue("cur", entryentity.size() - 1), curIndex);
        this.setEnableFiled();
    }

    private void setEnableFiled() {
        DynamicObjectCollection entryentityCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        this.getView().setEnable(Boolean.FALSE, entryentityCol.size() - 1, new String[]{QTYTO});
        for (int i = 1; i < entryentityCol.size() - 1; ++i) {
            this.getView().setEnable(Boolean.TRUE, i, new String[]{QTYTO});
            this.getView().setEnable(Boolean.TRUE, i, new String[]{QTYFROM});
        }
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{QTYFROM});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("confirm".equals(operateKey)) {
            DynamicObjectCollection entryentityCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            ArrayList<LadderPriceInfo> ladderPriceInfos = new ArrayList<LadderPriceInfo>(1024);
            for (DynamicObject row : entryentityCol) {
                LadderPriceInfo info = new LadderPriceInfo(row.getBigDecimal(QTYFROM), row.getBigDecimal(QTYTO), row.getBigDecimal(PRICE), null);
                ladderPriceInfos.add(info);
            }
            HashMap<String, ArrayList<LadderPriceInfo>> returnData = new HashMap<String, ArrayList<LadderPriceInfo>>(8);
            returnData.put("entry", ladderPriceInfos);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

